//
//  HWMSDKFilePathManager.h
//  HWMNativeSDK
//
//  Created by guomeng on 2021/5/20.
//

#import <Foundation/Foundation.h>
#import "HWMFilePathManager.h"

extern NSString * _Nonnull const HWMSDKDebugInfoFileNameKey;

NS_ASSUME_NONNULL_BEGIN

@interface HWMSDKFilePathManager : NSObject
/// 设置总体日志的路径(文件夹，开放性使用）
+ (void)setLogPath:(NSString *)logDir;

/// 总体的日志路径(文件夹）
+ (NSString *)logPath;


/// 登录相关的日志路径(文件夹）
+ (NSString *)loginLogPath;

/// 日志收集的路径(文件夹）
+ (NSString *)collectionLogPath;

/// 会议相关的日志路径(文件夹）
+ (NSString *)confLogPath;

/// DB日志路径(文件夹)
+ (NSString *)dbLogPath;

/// kmc日志文件路径 kmc不一样 若传递文件夹 日志直接写在最外面 需要文件路径
+ (NSString *)kmcLogPath;

/// 数据库的路径(文件夹）
+ (NSString *)dataBasePath;

/// 用户头像的缓存文件夹路径
+ (NSString *)userAvatorCachePath;

/// 缓存的视频资源
+ (NSString *)videoCachePath;

/// 资源文件夹路径(若没有不自动创建）
+ (NSString *)resourcePath;

/// ca证书文件夹路径
+ (NSString *)caPath;

/// 隐私声明文件夹路径
+ (NSString *)privacyPath;

/// 开源及第三方声明文件夹路径
+ (NSString *)opensourceNoticePath;

/// kmc文件夹路径
+ (NSString *)kmcPath;

/// Cache缓存路径
+ (NSString *)cachePath;

/// 崩溃信息存储路径 （外面自己创建文件夹）
+ (NSString *)crashPath;

/// 崩溃信息上传时候的一个中间临时文件夹 (文件夹）
+ (NSString *)crashTempPath;

/// UISDK日志路径(文件夹）
+ (NSString *)uisdkLogPath;

/// IM日志路径(文件夹）
+ (NSString *)IMLogPath;

///ideashar日志（文件夹）
+ (NSString *)ideaShareSDKPath;

///本地录制文件路径
+ (NSString *)localRecordPath;

/// 虚拟背景文件路径
+ (NSString *)virtualBackgroundPath;

/**
 @permission 权限 可以设置为如HWMFilePermissionType
 @filePath 文件/目录 路径
 @return 更新结果信息
 */
+ (NSError *)updateHWMFilePermission:(HWMFilePermissionType)permission filePath:(NSString *)filePath;
/**
 @path 权限 给资源设置权限，迭代深入处理
 */
+ (void)traverseAllResourceSetBusinessPermission:(NSString *)path;

@end



NS_ASSUME_NONNULL_END
