//
//  HWMJSOpenSDK.mm
//  HWMSDKSDK
//
//  Automatically generated file. DO NOT MODIFY!!!
//

#import <Foundation/Foundation.h>
#import "HWMJSOpenSDK.h"
#import "modelConverter/HWMUISDKAllJsonModelConvertIndex.h"

#import <Cocoa/Cocoa.h>
#import "JSNotifyData.h"
#import "JSConfSettingData.h"
#import "JSOpenUtils.h"
#import "HWMJSCmdDefine.h"
#import "HWMJSAdapterService.h"

NS_ASSUME_NONNULL_BEGIN

/// 全局通知
extern void onReceiveNotify(int cmd,id paramsObject);


/// 全局回调转接口回调:数据结构定义
/// 全局回调转接口回调:事件分发
/// 通用方法
@interface HWMJSOpenSDK ()<HWMUISDKLoginNotify, HWMUISDKConfCtrlNotify, HWMUISDKConfMgrNotify, HWMUISDKCallNotify, HWMUISDKConfigNotify, HWMUISDKUIConfigNotify, HWMUISDKPrivateMeetingNotify>
@property (nonatomic, retain) NSMutableArray<JSNotifyData *> *notifyDataArr;
@property (nonatomic, retain) NSRecursiveLock *dataLock;
@property (nonatomic, retain) JSConfSettingData *confSettingData;
@property (nonatomic, retain) JSConfSettingData *callSettingData;
@end

@implementation HWMJSOpenSDK

static id jsOpenSDKInstance  = nil;
+ (instancetype)shareInstance {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        jsOpenSDKInstance = [[HWMJSOpenSDK alloc] init];
    });
    return jsOpenSDKInstance;
}
- (instancetype)init {
	if (self = [super init]) {
		self.notifyDataArr = [NSMutableArray new];
		self.dataLock = [[NSRecursiveLock alloc] init];
	}
	return self;
}

- (NSString *)startCtdConf:(NSString *)param {
	HWMUISDKCtdConfInfoModel *model = [HWMUISDKCtdConfInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] startCtdConfWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)enableCAVerification:(NSString *)param {
	BOOL  model = [[JSOpenUtils getJsonObject:param] boolValue];
	HWMUISDKSDKERR result = [[HWMUISDKPrivateMeetingService shareInstance] enableCAVerification:model];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"result"] = @(result);
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = dataDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getSSOAuthorizeUrl:(NSString *)param {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] getSSOAuthorizeUrlWithDomain:param callback:^(NSError * _Nullable error, NSString * ssoAuthorizeUrl) {
			if (!error) {
				NSString *ssoAuthorizeUrlData = ssoAuthorizeUrl;
				NSString *ssoAuthorizeUrlDict = ssoAuthorizeUrlData;
				responseDict[@"data"] = ssoAuthorizeUrlDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (ssoAuthorizeUrl) {
					NSString *ssoAuthorizeUrlData = ssoAuthorizeUrl;
					NSString *ssoAuthorizeUrlDict = ssoAuthorizeUrlData;
					responseDict[@"data"] = ssoAuthorizeUrlDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getProxy {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] getProxyWithCallback:^(NSError * _Nullable error, HWMUISDKProxyInfoModel * proxyInfo) {
			if (!error) {
				NSString *proxyInfoData = [HWMUISDKJsonProxyInfoModelConverter jsonFromModel:proxyInfo];
				NSDictionary *proxyInfoDict = [JSOpenUtils getJsonObject:proxyInfoData];
				responseDict[@"data"] = proxyInfoDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (proxyInfo) {
					NSString *proxyInfoData = [HWMUISDKJsonProxyInfoModelConverter jsonFromModel:proxyInfo];
					NSDictionary *proxyInfoDict = [JSOpenUtils getJsonObject:proxyInfoData];
					responseDict[@"data"] = proxyInfoDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)loginByToken:(NSString *)param {
	HWMUISDKAccountAndTokenAuthInfoModel *model = [HWMUISDKAccountAndTokenAuthInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] loginByTokenWithInfo:model callback:^(NSError * _Nullable error, HWMUISDKLoginByTokenResultModel * loginByTokenResult) {
			if (!error) {
				NSString *loginByTokenResultData = [HWMUISDKJsonLoginByTokenResultModelConverter jsonFromModel:loginByTokenResult];
				NSDictionary *loginByTokenResultDict = [JSOpenUtils getJsonObject:loginByTokenResultData];
				responseDict[@"data"] = loginByTokenResultDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (loginByTokenResult) {
					NSString *loginByTokenResultData = [HWMUISDKJsonLoginByTokenResultModelConverter jsonFromModel:loginByTokenResult];
					NSDictionary *loginByTokenResultDict = [JSOpenUtils getJsonObject:loginByTokenResultData];
					responseDict[@"data"] = loginByTokenResultDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)login:(NSString *)param {
	HWMUISDKThirdUserInfoModel *model = [HWMUISDKThirdUserInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] loginWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)joinConfByLink:(NSString *)param {
	HWMUISDKJoinConfByLinkInfoModel *model = [HWMUISDKJoinConfByLinkInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] joinConfByLinkWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setCorpDepartmentInfo:(NSString *)param {
	HWMUISDKSetCorpDepartmentInfoListModel *model = [HWMUISDKSetCorpDepartmentInfoListModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] setCorpDepartmentInfoWithCorpDepartInfoList:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setEnableRtc:(NSString *)param {
	BOOL  model = [[JSOpenUtils getJsonObject:param] boolValue];
	HWMUISDKSDKERR result = [[HWMUISDKPrivateMeetingService shareInstance] setEnableRtc:model];
	NSString *response = [NSString stringWithFormat:@"%ld", (long)result];
	return response;
}

- (NSString *)applyObsJsonConfigFromDB {
	HWMUISDKSDKERR result = [[HWMUISDKPrivateMeetingService shareInstance] applyObsJsonConfigFromDB];
	NSString *response = [NSString stringWithFormat:@"%ld", (long)result];
	return response;
}

- (NSString *)breakPairLink:(NSString *)param {
	HWMUISDKPairLinkInfoModel *model = [HWMUISDKPairLinkInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKPrivateMeetingService shareInstance] breakPairLinkWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)modifyPairLinkMode:(NSString *)param {
	HWMUISDKPairLinkInfoModel *model = [HWMUISDKPairLinkInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKPrivateMeetingService shareInstance] modifyPairLinkModeWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)sendCustomMsgToPairLink:(NSString *)param {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKPrivateMeetingService shareInstance] sendCustomMsgToPairLinkWithCustomMsg:param];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)stopRefreshPairVerifyCode {
	HWMUISDKSDKERR result = [[HWMUISDKPrivateMeetingService shareInstance] stopRefreshPairVerifyCode];
	NSString *response = [NSString stringWithFormat:@"%ld", (long)result];
	return response;
}

- (NSString *)endProjection:(NSString *)param {
	HWMUISDKEndProjectionParamModel *model = [HWMUISDKEndProjectionParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] endProjectionWithParam:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)switchProjectionToConf {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] switchProjectionToConfWithCallback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)updateExternalInviteesList:(NSString *)param {
	HWMUISDKExternalInviteesInfoModel *model = [HWMUISDKExternalInviteesInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] updateExternalInviteesList:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)startPlayAudioFile:(NSString *)param {
	HWMUISDKStartPlayAudioFileParamModel *model = [HWMUISDKStartPlayAudioFileParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] startPlayAudioFileWithParam:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)stopPlayAudioFile {
	HWMUISDKSDKERR result = [[HWMUISDKPrivateMeetingService shareInstance] stopPlayAudioFile];
	NSString *response = [NSString stringWithFormat:@"%ld", (long)result];
	return response;
}

- (NSString *)setOtherNumber:(NSString *)param {
	HWMUISDKOtherNumberInfoModel *model = [HWMUISDKOtherNumberInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] setOtherNumberWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setDeployInfo:(NSString *)param {
	HWMUISDKDeployInfoModel *model = [HWMUISDKDeployInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] setDeployInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setInnerHttpProxyInfo:(NSString *)param {
	HWMUISDKInnerHttpProxyInfoModel *model = [HWMUISDKInnerHttpProxyInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] setInnerHttpProxyInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setMeetingCustomInfo:(NSString *)param {
	HWMUISDKMeetingCustomInfoModel *model = [HWMUISDKMeetingCustomInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKPrivateMeetingService shareInstance] setMeetingCustomInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getJwtToken {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKJwtTokenInfoModel * jwtTokenInfo = [[HWMUISDKPrivateMeetingService shareInstance] getJwtToken];
	NSString *jwtTokenInfoData = [HWMUISDKJsonJwtTokenInfoModelConverter jsonFromModel:jwtTokenInfo];
	NSDictionary *jwtTokenInfoDict = [JSOpenUtils getJsonObject:jwtTokenInfoData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = jwtTokenInfoDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}


- (NSString *)loginByAccount:(NSString *)param {
	HWMUISDKAccountAuthInfoModel *model = [HWMUISDKAccountAuthInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKLoginService shareInstance] loginWithAccountAuthInfo:model callback:^(NSError * _Nullable error, HWMUISDKLoginResultModel * loginResult) {
			if (!error) {
				NSString *loginResultData = [HWMUISDKJsonLoginResultModelConverter jsonFromModel:loginResult];
				NSDictionary *loginResultDict = [JSOpenUtils getJsonObject:loginResultData];
				responseDict[@"data"] = loginResultDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (loginResult) {
					NSString *loginResultData = [HWMUISDKJsonLoginResultModelConverter jsonFromModel:loginResult];
					NSDictionary *loginResultDict = [JSOpenUtils getJsonObject:loginResultData];
					responseDict[@"data"] = loginResultDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)loginByAppId:(NSString *)param {
	HWMUISDKAppIdAuthInfoModel *model = [HWMUISDKAppIdAuthInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKLoginService shareInstance] loginWithAppIdAuthInfo:model callback:^(NSError * _Nullable error, HWMUISDKLoginResultModel * loginResult) {
			if (!error) {
				NSString *loginResultData = [HWMUISDKJsonLoginResultModelConverter jsonFromModel:loginResult];
				NSDictionary *loginResultDict = [JSOpenUtils getJsonObject:loginResultData];
				responseDict[@"data"] = loginResultDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (loginResult) {
					NSString *loginResultData = [HWMUISDKJsonLoginResultModelConverter jsonFromModel:loginResult];
					NSDictionary *loginResultDict = [JSOpenUtils getJsonObject:loginResultData];
					responseDict[@"data"] = loginResultDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)loginBySSO:(NSString *)param {
	HWMUISDKSSOAuthInfoModel *model = [HWMUISDKSSOAuthInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKLoginService shareInstance] loginWithSsoAuthInfo:model callback:^(NSError * _Nullable error, HWMUISDKLoginResultModel * loginResult) {
			if (!error) {
				NSString *loginResultData = [HWMUISDKJsonLoginResultModelConverter jsonFromModel:loginResult];
				NSDictionary *loginResultDict = [JSOpenUtils getJsonObject:loginResultData];
				responseDict[@"data"] = loginResultDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (loginResult) {
					NSString *loginResultData = [HWMUISDKJsonLoginResultModelConverter jsonFromModel:loginResult];
					NSDictionary *loginResultDict = [JSOpenUtils getJsonObject:loginResultData];
					responseDict[@"data"] = loginResultDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)logout {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKLoginService shareInstance] logoutWithCallback:^(NSError * _Nullable error, HWMUISDKLogoutResultModel * logoutResult) {
			if (!error) {
				NSString *logoutResultData = [HWMUISDKJsonLogoutResultModelConverter jsonFromModel:logoutResult];
				NSDictionary *logoutResultDict = [JSOpenUtils getJsonObject:logoutResultData];
				responseDict[@"data"] = logoutResultDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (logoutResult) {
					NSString *logoutResultData = [HWMUISDKJsonLogoutResultModelConverter jsonFromModel:logoutResult];
					NSDictionary *logoutResultDict = [JSOpenUtils getJsonObject:logoutResultData];
					responseDict[@"data"] = logoutResultDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setNetworkMode:(NSString *)param {
	HWMUISDKNetWorkModeInfoModel *model = [HWMUISDKNetWorkModeInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKLoginService shareInstance] setNetworkModeWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)uploadSelfAvatar:(NSString *)param {
	HWMUISDKSelfAvatarInfoModel *model = [HWMUISDKSelfAvatarInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKLoginService shareInstance] uploadSelfAvatarWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setGuaranteedIpAddresses:(NSString *)param {
	NSString * model = param;
	HWMUISDKSDKERR result = [[HWMUISDKLoginService shareInstance] setGuaranteedIpAddresses:model];
	NSString *response = [NSString stringWithFormat:@"%ld", (long)result];
	return response;
}

- (NSString *)setGlobalGuaranteedIpAddresses:(NSString *)param {
	HWMUISDKGuaranteedIpAddressesParamModel *model = [HWMUISDKGuaranteedIpAddressesParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKLoginService shareInstance] setGlobalGuaranteedIpAddressesWithParam:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setServerAddress:(NSString *)param {
	HWMUISDKServerInfoModel *model = [HWMUISDKServerInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKLoginService shareInstance] setServerAddressWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setProxy:(NSString *)param {
	HWMUISDKProxyInfoModel *model = [HWMUISDKProxyInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKLoginService shareInstance] setProxyWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setCAVerifyInfo:(NSString *)param {
	HWMUISDKCAVerifyInfoModel *model = [HWMUISDKCAVerifyInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKLoginService shareInstance] setCAVerifyInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getLoginState {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKLoginStateInfoModel * loginStateInfo = [[HWMUISDKLoginService shareInstance] getLoginState];
	NSString *loginStateInfoData = [HWMUISDKJsonLoginStateInfoModelConverter jsonFromModel:loginStateInfo];
	NSDictionary *loginStateInfoDict = [JSOpenUtils getJsonObject:loginStateInfoData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = loginStateInfoDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getLoginToken {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKLoginTokenInfoModel * loginTokenInfo = [[HWMUISDKLoginService shareInstance] getLoginToken];
	NSString *loginTokenInfoData = [HWMUISDKJsonLoginTokenInfoModelConverter jsonFromModel:loginTokenInfo];
	NSDictionary *loginTokenInfoDict = [JSOpenUtils getJsonObject:loginTokenInfoData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = loginTokenInfoDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}


- (NSString *)createConf:(NSString *)param {
	HWMUISDKCreateConfInfoModel *model = [HWMUISDKCreateConfInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] createConfWithInfo:model callback:^(NSError * _Nullable error, HWMUISDKCreateConfResultModel * createConfResult) {
			if (!error) {
				NSString *createConfResultData = [HWMUISDKJsonCreateConfResultModelConverter jsonFromModel:createConfResult];
				NSDictionary *createConfResultDict = [JSOpenUtils getJsonObject:createConfResultData];
				responseDict[@"data"] = createConfResultDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (createConfResult) {
					NSString *createConfResultData = [HWMUISDKJsonCreateConfResultModelConverter jsonFromModel:createConfResult];
					NSDictionary *createConfResultDict = [JSOpenUtils getJsonObject:createConfResultData];
					responseDict[@"data"] = createConfResultDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)startP2pConf:(NSString *)param {
	HWMUISDKStartCallInfoModel *model = [HWMUISDKStartCallInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] startP2pConfWithInfo:model callback:^(NSError * _Nullable error, HWMUISDKCreateConfResultModel * createConfResult) {
			if (!error) {
				NSString *createConfResultData = [HWMUISDKJsonCreateConfResultModelConverter jsonFromModel:createConfResult];
				NSDictionary *createConfResultDict = [JSOpenUtils getJsonObject:createConfResultData];
				responseDict[@"data"] = createConfResultDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (createConfResult) {
					NSString *createConfResultData = [HWMUISDKJsonCreateConfResultModelConverter jsonFromModel:createConfResult];
					NSDictionary *createConfResultDict = [JSOpenUtils getJsonObject:createConfResultData];
					responseDict[@"data"] = createConfResultDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)joinConfById:(NSString *)param {
	HWMUISDKJoinConfByIdInfoModel *model = [HWMUISDKJoinConfByIdInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] joinConfByIdWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)joinConfByRandom:(NSString *)param {
	HWMUISDKJoinConfByRandomInfoModel *model = [HWMUISDKJoinConfByRandomInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] joinConfByRandomWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)addAttendee:(NSString *)param {
	HWMUISDKAddAttendeeInfoModel *model = [HWMUISDKAddAttendeeInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] addAttendeeWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)leaveConf {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] leaveConfWithCallback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)endConf {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] endConfWithCallback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)startShare:(NSString *)param {
	HWMUISDKStartShareInfoModel *model = [HWMUISDKStartShareInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] startShareWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)stopShare {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKConfCtrlService shareInstance] stopShare];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getAttendeeList {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKAttendeeListInfoModel * attendeeList = [[HWMUISDKConfCtrlService shareInstance] getAttendeeList];
	NSString *attendeeListData = [HWMUISDKJsonAttendeeListInfoModelConverter jsonFromModel:attendeeList];
	NSDictionary *attendeeListDict = [JSOpenUtils getJsonObject:attendeeListData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = attendeeListDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getAudienceList {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKAttendeeListInfoModel * audidenceList = [[HWMUISDKConfCtrlService shareInstance] getAudienceList];
	NSString *audidenceListData = [HWMUISDKJsonAttendeeListInfoModelConverter jsonFromModel:audidenceList];
	NSDictionary *audidenceListDict = [JSOpenUtils getJsonObject:audidenceListData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = audidenceListDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getUserState {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKUserState  userState = [[HWMUISDKConfCtrlService shareInstance] getUserState];
	NSString *userStateData = [NSString stringWithFormat:@"%ld", (HWMUISDKUserState)userState];
	NSDictionary *userStateDict = [JSOpenUtils getJsonObject:userStateData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = userStateDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getSelfRole {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKConfRole  selfRole = [[HWMUISDKConfCtrlService shareInstance] getSelfRole];
	NSString *selfRoleData = [NSString stringWithFormat:@"%ld", (HWMUISDKConfRole)selfRole];
	NSDictionary *selfRoleDict = [JSOpenUtils getJsonObject:selfRoleData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = selfRoleDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)renameSelf:(NSString *)param {
	HWMUISDKRenameSelfInfoModel *model = [HWMUISDKRenameSelfInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] renameSelfWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)startProjection:(NSString *)param {
	HWMUISDKStartProjectionParamModel *model = [HWMUISDKStartProjectionParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] startProjectionWithParam:model callback:^(NSError * _Nullable error, HWMUISDKStartProjectionResultModel * startProjectionResult) {
			if (!error) {
				NSString *startProjectionResultData = [HWMUISDKJsonStartProjectionResultModelConverter jsonFromModel:startProjectionResult];
				NSDictionary *startProjectionResultDict = [JSOpenUtils getJsonObject:startProjectionResultData];
				responseDict[@"data"] = startProjectionResultDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (startProjectionResult) {
					NSString *startProjectionResultData = [HWMUISDKJsonStartProjectionResultModelConverter jsonFromModel:startProjectionResult];
					NSDictionary *startProjectionResultDict = [JSOpenUtils getJsonObject:startProjectionResultData];
					responseDict[@"data"] = startProjectionResultDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)acceptConf:(NSString *)param {
	HWMUISDKAcceptConfParamModel *model = [HWMUISDKAcceptConfParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] acceptConfWithParam:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)rejectConf {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] rejectConfWithCallback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getSelfShareState {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKSelfShareStateInfoModel * selfShareStateInfo = [[HWMUISDKConfCtrlService shareInstance] getSelfShareState];
	NSString *selfShareStateInfoData = [HWMUISDKJsonSelfShareStateInfoModelConverter jsonFromModel:selfShareStateInfo];
	NSDictionary *selfShareStateInfoDict = [JSOpenUtils getJsonObject:selfShareStateInfoData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = selfShareStateInfoDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)openSubtitle:(NSString *)param {
	BOOL model = [[JSOpenUtils getJsonObject:param] boolValue];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] openSubtitle:model callback:^(NSError * _Nullable error, BOOL  isOpen) {
			if (!error) {
				NSString *isOpenData = [NSString stringWithFormat:@"%ld", (BOOL)isOpen];
				NSString *isOpenDict = isOpenData;
				responseDict[@"data"] = isOpenDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (isOpen) {
					NSString *isOpenData = [NSString stringWithFormat:@"%ld", (BOOL)isOpen];
					NSString *isOpenDict = isOpenData;
					responseDict[@"data"] = isOpenDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)openWaitingRoom:(NSString *)param {
	BOOL model = [[JSOpenUtils getJsonObject:param] boolValue];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] openWaitingRoom:model callback:^(NSError * _Nullable error, BOOL  isOpen) {
			if (!error) {
				NSString *isOpenData = [NSString stringWithFormat:@"%ld", (BOOL)isOpen];
				NSString *isOpenDict = isOpenData;
				responseDict[@"data"] = isOpenDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (isOpen) {
					NSString *isOpenData = [NSString stringWithFormat:@"%ld", (BOOL)isOpen];
					NSString *isOpenDict = isOpenData;
					responseDict[@"data"] = isOpenDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)operateLocalRecord:(NSString *)param {
	HWMUISDKLocalRecordOperateType model = (HWMUISDKLocalRecordOperateType)[param intValue];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] operateLocalRecordWithType:model callback:^(NSError * _Nullable error, HWMUISDKLocalRecordOperateType  type) {
			if (!error) {
				NSString *typeData = [NSString stringWithFormat:@"%ld", (HWMUISDKLocalRecordOperateType)type];
				NSString *typeDict = typeData;
				responseDict[@"data"] = typeDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (type) {
					NSString *typeData = [NSString stringWithFormat:@"%ld", (HWMUISDKLocalRecordOperateType)type];
					NSString *typeDict = typeData;
					responseDict[@"data"] = typeDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)openVirtualBackgroundSettingPage {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] openVirtualBackgroundSettingPageWithCallback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getConfLocalRecordStatus {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] getConfLocalRecordStatusWithCallback:^(NSError * _Nullable error, HWMUISDKLocalRecordStatusInfoModel * state) {
			if (!error) {
				NSString *stateData = [HWMUISDKJsonLocalRecordStatusInfoModelConverter jsonFromModel:state];
				NSDictionary *stateDict = [JSOpenUtils getJsonObject:stateData];
				responseDict[@"data"] = stateDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (state) {
					NSString *stateData = [HWMUISDKJsonLocalRecordStatusInfoModelConverter jsonFromModel:state];
					NSDictionary *stateDict = [JSOpenUtils getJsonObject:stateData];
					responseDict[@"data"] = stateDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getSelfHasLocalRecordPermission {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] getSelfHasLocalRecordPermissionWithCallback:^(NSError * _Nullable error, HWMUISDKLocalRecordPermissionInfoModel * permission) {
			if (!error) {
				NSString *permissionData = [HWMUISDKJsonLocalRecordPermissionInfoModelConverter jsonFromModel:permission];
				NSDictionary *permissionDict = [JSOpenUtils getJsonObject:permissionData];
				responseDict[@"data"] = permissionDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (permission) {
					NSString *permissionData = [HWMUISDKJsonLocalRecordPermissionInfoModelConverter jsonFromModel:permission];
					NSDictionary *permissionDict = [JSOpenUtils getJsonObject:permissionData];
					responseDict[@"data"] = permissionDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)requestLocalRecordPermission {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] requestLocalRecordPermissionWithCallback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)applyHostRole:(NSString *)param {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] applyHostRoleWithPassword:param callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getSubtitlePageOpened {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	BOOL  isOpen = [[HWMUISDKConfCtrlService shareInstance] getSubtitlePageOpened];
	NSString *isOpenData = [NSString stringWithFormat:@"%ld", (BOOL)isOpen];
	NSDictionary *isOpenDict = [JSOpenUtils getJsonObject:isOpenData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = isOpenDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getWaitingRoomOpened {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	BOOL  isOpen = [[HWMUISDKConfCtrlService shareInstance] getWaitingRoomOpened];
	NSString *isOpenData = [NSString stringWithFormat:@"%ld", (BOOL)isOpen];
	NSDictionary *isOpenDict = [JSOpenUtils getJsonObject:isOpenData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = isOpenDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getVirtualBackgroundSettingPageOpened {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	BOOL  isOpen = [[HWMUISDKConfCtrlService shareInstance] getVirtualBackgroundSettingPageOpened];
	NSString *isOpenData = [NSString stringWithFormat:@"%ld", (BOOL)isOpen];
	NSDictionary *isOpenDict = [JSOpenUtils getJsonObject:isOpenData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = isOpenDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)subscribeSubtitleLanguage:(NSString *)param {
	HWMUISDKTargetLanguageType model = (HWMUISDKTargetLanguageType)[param intValue];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] subscribeSubtitleLanguageWithType:model callback:^(NSError * _Nullable error, HWMUISDKTargetLanguageType  targetLanguageType) {
			if (!error) {
				NSString *targetLanguageTypeData = [NSString stringWithFormat:@"%ld", (HWMUISDKTargetLanguageType)targetLanguageType];
				NSString *targetLanguageTypeDict = targetLanguageTypeData;
				responseDict[@"data"] = targetLanguageTypeDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (targetLanguageType) {
					NSString *targetLanguageTypeData = [NSString stringWithFormat:@"%ld", (HWMUISDKTargetLanguageType)targetLanguageType];
					NSString *targetLanguageTypeDict = targetLanguageTypeData;
					responseDict[@"data"] = targetLanguageTypeDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)subscribeSubtitle:(NSString *)param {
	BOOL model = [[JSOpenUtils getJsonObject:param] boolValue];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfCtrlService shareInstance] subscribeSubtitle:model callback:^(NSError * _Nullable error, BOOL  isSubscirbe) {
			if (!error) {
				NSString *isSubscirbeData = [NSString stringWithFormat:@"%ld", (BOOL)isSubscirbe];
				NSString *isSubscirbeDict = isSubscirbeData;
				responseDict[@"data"] = isSubscirbeDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (isSubscirbe) {
					NSString *isSubscirbeData = [NSString stringWithFormat:@"%ld", (BOOL)isSubscirbe];
					NSString *isSubscirbeDict = isSubscirbeData;
					responseDict[@"data"] = isSubscirbeDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getSubtitleSupportLanguage {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKTargetLanguageTypeListModel * targetLanguageTypeList = [[HWMUISDKConfCtrlService shareInstance] getSubtitleSupportLanguage];
	NSString *targetLanguageTypeListData = [HWMUISDKJsonTargetLanguageTypeListModelConverter jsonFromModel:targetLanguageTypeList];
	NSDictionary *targetLanguageTypeListDict = [JSOpenUtils getJsonObject:targetLanguageTypeListData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = targetLanguageTypeListDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}


- (NSString *)bookConf:(NSString *)param {
	HWMUISDKBookConfParamModel *model = [HWMUISDKBookConfParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfMgrService shareInstance] bookConfWithParam:model callback:^(NSError * _Nullable error, HWMUISDKConfDetailModel * confDetail) {
			if (!error) {
				NSString *confDetailData = [HWMUISDKJsonConfDetailModelConverter jsonFromModel:confDetail];
				NSDictionary *confDetailDict = [JSOpenUtils getJsonObject:confDetailData];
				responseDict[@"data"] = confDetailDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (confDetail) {
					NSString *confDetailData = [HWMUISDKJsonConfDetailModelConverter jsonFromModel:confDetail];
					NSDictionary *confDetailDict = [JSOpenUtils getJsonObject:confDetailData];
					responseDict[@"data"] = confDetailDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)cancelConf:(NSString *)param {
	HWMUISDKCancelConfParamModel *model = [HWMUISDKCancelConfParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfMgrService shareInstance] cancelConfWithParam:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)editConf:(NSString *)param {
	HWMUISDKEditConfParamModel *model = [HWMUISDKEditConfParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfMgrService shareInstance] editConfWithParam:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getVmrList {
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfMgrService shareInstance] getVmrListWithCallback:^(NSError * _Nullable error, HWMUISDKVmrListInfoModel * vmrListInfo) {
			if (!error) {
				NSString *vmrListInfoData = [HWMUISDKJsonVmrListInfoModelConverter jsonFromModel:vmrListInfo];
				NSDictionary *vmrListInfoDict = [JSOpenUtils getJsonObject:vmrListInfoData];
				responseDict[@"data"] = vmrListInfoDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (vmrListInfo) {
					NSString *vmrListInfoData = [HWMUISDKJsonVmrListInfoModelConverter jsonFromModel:vmrListInfo];
					NSDictionary *vmrListInfoDict = [JSOpenUtils getJsonObject:vmrListInfoData];
					responseDict[@"data"] = vmrListInfoDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getConfDetail:(NSString *)param {
	HWMUISDKGetConfDetailParamModel *model = [HWMUISDKGetConfDetailParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfMgrService shareInstance] getConfDetailWithParam:model callback:^(NSError * _Nullable error, HWMUISDKConfDetailModel * confDetail) {
			if (!error) {
				NSString *confDetailData = [HWMUISDKJsonConfDetailModelConverter jsonFromModel:confDetail];
				NSDictionary *confDetailDict = [JSOpenUtils getJsonObject:confDetailData];
				responseDict[@"data"] = confDetailDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (confDetail) {
					NSString *confDetailData = [HWMUISDKJsonConfDetailModelConverter jsonFromModel:confDetail];
					NSDictionary *confDetailDict = [JSOpenUtils getJsonObject:confDetailData];
					responseDict[@"data"] = confDetailDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)changeVmrInfo:(NSString *)param {
	HWMUISDKChangeVmrInfoParamModel *model = [HWMUISDKChangeVmrInfoParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfMgrService shareInstance] changeVmrInfoWithParam:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getConfList {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKConfListInfoModel * confListInfo = [[HWMUISDKConfMgrService shareInstance] getConfList];
	NSString *confListInfoData = [HWMUISDKJsonConfListInfoModelConverter jsonFromModel:confListInfo];
	NSDictionary *confListInfoDict = [JSOpenUtils getJsonObject:confListInfoData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = confListInfoDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)bookCycleConf:(NSString *)param {
	HWMUISDKBookCycleConfParamModel *model = [HWMUISDKBookCycleConfParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfMgrService shareInstance] bookCycleConfWithParam:model callback:^(NSError * _Nullable error, HWMUISDKConfDetailModel * confDetail) {
			if (!error) {
				NSString *confDetailData = [HWMUISDKJsonConfDetailModelConverter jsonFromModel:confDetail];
				NSDictionary *confDetailDict = [JSOpenUtils getJsonObject:confDetailData];
				responseDict[@"data"] = confDetailDict;
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				if (confDetail) {
					NSString *confDetailData = [HWMUISDKJsonConfDetailModelConverter jsonFromModel:confDetail];
					NSDictionary *confDetailDict = [JSOpenUtils getJsonObject:confDetailData];
					responseDict[@"data"] = confDetailDict;
				}
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)modifyCycleConf:(NSString *)param {
	HWMUISDKModifyCycleConfParamModel *model = [HWMUISDKModifyCycleConfParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfMgrService shareInstance] modifyCycleConfWithParam:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)modifySubCycleConf:(NSString *)param {
	HWMUISDKModifySubCycleConfParamModel *model = [HWMUISDKModifySubCycleConfParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfMgrService shareInstance] modifySubCycleConfWithParam:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)cancelCycleConf:(NSString *)param {
	HWMUISDKCancelCycleConfParamModel *model = [HWMUISDKCancelCycleConfParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfMgrService shareInstance] cancelCycleConfWithParam:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)cancelSubCycleConf:(NSString *)param {
	HWMUISDKCancelSubCycleConfParamModel *model = [HWMUISDKCancelSubCycleConfParamModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfMgrService shareInstance] cancelSubCycleConfWithParam:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}


- (NSString *)enableCapability:(NSString *)param {
	HWMUISDKCapabilityInfoModel *model = [HWMUISDKCapabilityInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKSDKERR errorCode = [[HWMUISDKConfigService shareInstance] enableCapabilityWithInfo:model];
	responseDict[@"code"] = @(errorCode);
	if (errorCode == HWMUISDKSdkerrSuccess) {
		responseDict[@"desc"] = @"success";
	} else {
		responseDict[@"desc"] = @"not supported in this release";
	}
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setLanguage:(NSString *)param {
	HWMUISDKLanguageInfoModel *model = [HWMUISDKLanguageInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKConfigService shareInstance] setLanguageWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setUserSavePath:(NSString *)param {
	HWMUISDKUserSavePathInfoModel *model = [HWMUISDKUserSavePathInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKConfigService shareInstance] setUserSavePathWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setAudioRawDataOutputConfig:(NSString *)param {
	HWMUISDKAudioRawDataConfigInfoModel *model = [HWMUISDKAudioRawDataConfigInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKConfigService shareInstance] setAudioRawDataOutputConfigWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setAnswerType:(NSString *)param {
	HWMUISDKInComingAnswerTypeInfoModel *model = [HWMUISDKInComingAnswerTypeInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKConfigService shareInstance] setAnswerTypeWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setDeviceConfigForConfIncoming:(NSString *)param {
	HWMUISDKDeviceConfigModel *model = [HWMUISDKDeviceConfigModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKConfigService shareInstance] setDeviceConfigForConfIncomingWithDeviceConfig:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getConfPstnAccessNumber {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKPstnAccessNumberInfoModel * pstnAccessNumberInfo = [[HWMUISDKConfigService shareInstance] getConfPstnAccessNumber];
	NSString *pstnAccessNumberInfoData = [HWMUISDKJsonPstnAccessNumberInfoModelConverter jsonFromModel:pstnAccessNumberInfo];
	NSDictionary *pstnAccessNumberInfoDict = [JSOpenUtils getJsonObject:pstnAccessNumberInfoData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = pstnAccessNumberInfoDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)aVDeviceCtrl:(NSString *)param {
	HWMUISDKDeviceStateInfoModel *model = [HWMUISDKDeviceStateInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKDeviceCtrlInfoModel * deviceCtrlInfo = [[HWMUISDKConfigService shareInstance] aVDeviceCtrlWithInfo:model];
	NSString *deviceCtrlInfoData = [HWMUISDKJsonDeviceCtrlInfoModelConverter jsonFromModel:deviceCtrlInfo];
	NSDictionary *deviceCtrlInfoDict = [JSOpenUtils getJsonObject:deviceCtrlInfoData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = deviceCtrlInfoDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)disableVoicePrompts:(NSString *)param {
	HWMUISDKVoicePromptsInfoModel *model = [HWMUISDKVoicePromptsInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKConfigService shareInstance] disableVoicePromptsWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setShareScreenPermission:(NSString *)param {
	HWMUISDKSharePermissionModel *model = [HWMUISDKSharePermissionModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKConfigService shareInstance] setShareScreenPermission:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setLogPath:(NSString *)param {
	HWMUISDKLogPathInfoModel *model = [HWMUISDKLogPathInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKConfigService shareInstance] setLogPathWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getErrorMessage:(NSString *)param {
	NSInteger  model = [[JSOpenUtils getJsonObject:param] intValue];
	HWMUISDKErrorMessageInfoModel * info = [[HWMUISDKConfigService shareInstance] getErrorMessageWithErrorCode:model];
	NSString *infoData = [HWMUISDKJsonErrorMessageInfoModelConverter jsonFromModel:info];
	NSString *response = infoData;
	return response;
}

- (NSString *)setTransparentWnd:(NSString *)param {
	HWMUISDKTransparentWndInfoModel *model = [HWMUISDKTransparentWndInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKConfigService shareInstance] setTransparentWndWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setCustomUIText:(NSString *)param {
	HWMUISDKCustomSceneTextInfoListModel *model = [HWMUISDKCustomSceneTextInfoListModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKConfigService shareInstance] setCustomUITextWithCustomSceneTextInfoList:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setVirtualBackgroundDefaultImages:(NSString *)param {
	HWMUISDKVirtualBackgroundInfoModel *model = [HWMUISDKVirtualBackgroundInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKConfigService shareInstance] setVirtualBackgroundDefaultImagesWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}


- (NSString *)config:(NSString *)param {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKUIConfigService shareInstance] configWithUiConfig:param];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setWaterMark:(NSString *)param {
	HWMUISDKWaterMarkInfoModel *model = [HWMUISDKWaterMarkInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKUIConfigService shareInstance] setWaterMarkWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getRenderWindowInfoList {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKHwndListInfoModel * hwndInfo = [[HWMUISDKUIConfigService shareInstance] getRenderWindowInfoList];
	NSString *hwndInfoData = [HWMUISDKJsonHwndListInfoModelConverter jsonFromModel:hwndInfo];
	NSDictionary *hwndInfoDict = [JSOpenUtils getJsonObject:hwndInfoData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = hwndInfoDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)showMeetingWindow {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKUIConfigService shareInstance] showMeetingWindow];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setAvatar:(NSString *)param {
	HWMUISDKAvatarInfoModel *model = [HWMUISDKAvatarInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKUIConfigService shareInstance] setAvatarWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setMeetingWindowIcon:(NSString *)param {
	HWMUISDKWindowIconInfoModel *model = [HWMUISDKWindowIconInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKUIConfigService shareInstance] setMeetingWindowIconWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)showSettingWindow:(NSString *)param {
	HWMUISDKShowSettingWindowInfoModel *model = [HWMUISDKShowSettingWindowInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKUIConfigService shareInstance] showSettingWindowWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)showToast:(NSString *)param {
	HWMUISDKToastInfoModel *model = [HWMUISDKToastInfoModel yy_modelWithJSON:param];
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	[[HWMUISDKUIConfigService shareInstance] showToastWithInfo:model];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)getMainWindowInfo {
	NSMutableDictionary *responseDict = [NSMutableDictionary new];
	HWMUISDKMainWindowInfoModel * mainWindowInfo = [[HWMUISDKUIConfigService shareInstance] getMainWindowInfo];
	NSString *mainWindowInfoData = [HWMUISDKJsonMainWindowInfoModelConverter jsonFromModel:mainWindowInfo];
	NSDictionary *mainWindowInfoDict = [JSOpenUtils getJsonObject:mainWindowInfoData];
	responseDict[@"code"] = @(0);
	responseDict[@"desc"] = @"success";
	responseDict[@"data"] = mainWindowInfoDict;
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}

- (NSString *)setAvatarStyle:(NSString *)param {
	HWMUISDKAvatarStyleModel *model = [HWMUISDKAvatarStyleModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKUIConfigService shareInstance] setAvatarStyle:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}


- (NSString *)startCall:(NSString *)param {
	HWMUISDKStartCallInfoModel *model = [HWMUISDKStartCallInfoModel yy_modelWithJSON:param];
	__block NSMutableDictionary *responseDict = [NSMutableDictionary new];
	dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
	dispatch_async_on_main_queue(^{
		[[HWMUISDKCallService shareInstance] startCallWithInfo:model callback:^(NSError * _Nullable error) {
			if (!error) {
				responseDict[@"code"] = @(0);
				responseDict[@"desc"] = @"success";
			} else {
				responseDict[@"code"] = @(error.code);
				if (error.localizedDescription.length) {
					responseDict[@"desc"] = error.localizedDescription;
				} else if (error.description.length) {
					responseDict[@"desc"] = error.description;
				} else {
					responseDict[@"desc"] =[NSString stringWithFormat:@"error code is %ld", (long)error.code];
				}
			}
			dispatch_semaphore_signal(semaphore);
		}];
	});
	dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
	NSString *response = [JSOpenUtils dictionaryToJson:responseDict];
	return response;
}


- (NSInteger)init:(NSString *)param {
	HWMUISDKInitInfoModel * model = [HWMUISDKJsonInitInfoModelConverter modelFromJson:param];
	HWMUISDKSDKERR result = [HWMUISDKService initWithInfo:model];
	[[HWMUISDKLoginService shareInstance] addLoginNotifyCallback:self];
	[[HWMUISDKConfCtrlService shareInstance] addConfCtrlNotifyCallback:self];
	[[HWMUISDKConfMgrService shareInstance] addConfMgrNotifyCallback:self];
	[[HWMUISDKCallService shareInstance] addCallNotifyCallback:self];
	[[HWMUISDKConfigService shareInstance] addConfigNotifyCallback:self];
	[[HWMUISDKUIConfigService shareInstance] addUIConfigNotifyCallback:self];
	[[HWMUISDKPrivateMeetingService shareInstance] addPrivateMeetingNotifyCallback:self];
	return (NSInteger)result;
}

- (NSString *)exit {
	HWMUISDKSDKERR result = [HWMUISDKService exit];
	NSString *response = [NSString stringWithFormat:@"%ld", (long)result];
	return response;
}


- (NSInteger)initPrivate:(NSString *)param {
	HWMUISDKInitPrivateInfoModel * model = [HWMUISDKJsonInitPrivateInfoModelConverter modelFromJson:param];
	HWMUISDKSDKERR result = [HWMUISDKPrivateService initPrivateWithInfo:model];
	[[HWMUISDKLoginService shareInstance] addLoginNotifyCallback:self];
	[[HWMUISDKConfCtrlService shareInstance] addConfCtrlNotifyCallback:self];
	[[HWMUISDKConfMgrService shareInstance] addConfMgrNotifyCallback:self];
	[[HWMUISDKCallService shareInstance] addCallNotifyCallback:self];
	[[HWMUISDKConfigService shareInstance] addConfigNotifyCallback:self];
	[[HWMUISDKUIConfigService shareInstance] addUIConfigNotifyCallback:self];
	[[HWMUISDKPrivateMeetingService shareInstance] addPrivateMeetingNotifyCallback:self];
	return (NSInteger)result;
}

- (void)onRefreshPairCode:(HWMUISDKPairCodeInfoModel *)info {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"info"] = [HWMUISDKJsonPairCodeInfoModelConverter jsonFromModel:info];
	onReceiveNotify(JSCmdCode_OnRefreshPairCode, dataDict);
	});
}

- (void)onLoginTokenRefreshNotify:(HWMUISDKPrivateLoginStateInfoModel *)info {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"info"] = [HWMUISDKJsonPrivateLoginStateInfoModelConverter jsonFromModel:info];
	onReceiveNotify(JSCmdCode_OnLoginTokenRefreshNotify, dataDict);
	});
}

- (void)onQueryCorpDepartmentInfo:(HWMUISDKQueryCorpDepartmentInfoParamListModel *)queryDepartInfoParamList {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"queryDepartInfoParamList"] = [HWMUISDKJsonQueryCorpDepartmentInfoParamListModelConverter jsonFromModel:queryDepartInfoParamList];
	onReceiveNotify(JSCmdCode_OnQueryCorpDepartmentInfo, dataDict);
	});
}

- (void)onConfEventInfoNotify:(NSString *)eventInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"eventInfo"] = eventInfo;
	onReceiveNotify(JSCmdCode_OnConfEventInfoNotify, dataDict);
	});
}

- (void)onScanInfoForJoinConfNotify:(HWMUISDKScanJoinConfResultModel *)scanJoinConfResult {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"scanJoinConfResult"] = [HWMUISDKJsonScanJoinConfResultModelConverter jsonFromModel:scanJoinConfResult];
	onReceiveNotify(JSCmdCode_OnScanInfoForJoinConfNotify, dataDict);
	});
}

- (void)onAppCfgChanged:(NSString *)meetingConfig {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"meetingConfig"] = meetingConfig;
	onReceiveNotify(JSCmdCode_OnAppCfgChanged, dataDict);
	});
}

- (void)onPairVerifyCodeNotify:(HWMUISDKPairVerifyCodeInfoModel *)pairVerifyCodeInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"pairVerifyCodeInfo"] = [HWMUISDKJsonPairVerifyCodeInfoModelConverter jsonFromModel:pairVerifyCodeInfo];
	onReceiveNotify(JSCmdCode_OnPairVerifyCodeNotify, dataDict);
	});
}

- (void)onPairLinkListNotify:(HWMUISDKPairLinkListInfoModel *)pairLinkListInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"pairLinkListInfo"] = [HWMUISDKJsonPairLinkListInfoModelConverter jsonFromModel:pairLinkListInfo];
	onReceiveNotify(JSCmdCode_OnPairLinkListNotify, dataDict);
	});
}

- (void)onPairLinkSuccessNotify {
	dispatch_async_on_main_queue(^{
	NSDictionary *dataDict = @{@"desc" : @"receive OnPairLinkSuccessNotify event"};
	onReceiveNotify(JSCmdCode_OnPairLinkSuccessNotify, dataDict);
	});
}

- (void)onRecvMsgFromPairLinkNotify:(NSString *)msgInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"msgInfo"] = msgInfo;
	onReceiveNotify(JSCmdCode_OnRecvMsgFromPairLinkNotify, dataDict);
	});
}

- (void)onAbnormalLeaveMeetingNotify:(HWMUISDKAbnormalLeaveMeetingInfoModel *)abnormalLeaveMeetingInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"abnormalLeaveMeetingInfo"] = [HWMUISDKJsonAbnormalLeaveMeetingInfoModelConverter jsonFromModel:abnormalLeaveMeetingInfo];
	onReceiveNotify(JSCmdCode_OnAbnormalLeaveMeetingNotify, dataDict);
	});
}

- (void)onOperateExternalAttendeeNotify:(HWMUISDKOperateExternalInviteeInfoModel *)operateInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"operateInfo"] = [HWMUISDKJsonOperateExternalInviteeInfoModelConverter jsonFromModel:operateInfo];
	onReceiveNotify(JSCmdCode_OnOperateExternalAttendeeNotify, dataDict);
	});
}

- (void)onCallAllExternalAttendeesNotify:(HWMUISDKCallAllExternalAttendeesInfoModel *)operateInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"operateInfo"] = [HWMUISDKJsonCallAllExternalAttendeesInfoModelConverter jsonFromModel:operateInfo];
	onReceiveNotify(JSCmdCode_OnCallAllExternalAttendeesNotify, dataDict);
	});
}

- (void)onQueryOtherNumberNotify:(HWMUISDKQueryOtherNumberInfoModel *)queryOtherNumberInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"queryOtherNumberInfo"] = [HWMUISDKJsonQueryOtherNumberInfoModelConverter jsonFromModel:queryOtherNumberInfo];
	onReceiveNotify(JSCmdCode_OnQueryOtherNumberNotify, dataDict);
	});
}

- (void)onKickedOutNotify {
	dispatch_async_on_main_queue(^{
	NSDictionary *dataDict = @{@"desc" : @"receive OnKickedOutNotify event"};
	onReceiveNotify(JSCmdCode_OnKickedOutNotify, dataDict);
	});
}

- (void)onCorpConfigNotify:(HWMUISDKCorpConfigInfoModel *)configInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"configInfo"] = [HWMUISDKJsonCorpConfigInfoModelConverter jsonFromModel:configInfo];
	onReceiveNotify(JSCmdCode_OnCorpConfigNotify, dataDict);
	});
}

- (void)onUserCorpInfoChanged:(HWMUISDKUserCorpInfoNotifyType )type {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"type"] = @(type);
	onReceiveNotify(JSCmdCode_OnUserCorpInfoChanged, dataDict);
	});
}

- (void)onLoginErrorNotify:(HWMUISDKSDKERR )ret reason:(NSString *)reason {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"ret"] = @(ret);
	dataDict[@"reason"] = reason;
	onReceiveNotify(JSCmdCode_OnLoginErrorNotify, dataDict);
	});
}

- (void)onShareVmrInfoNotify:(HWMUISDKShareVmrInfoModel *)shareVmrInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"shareVmrInfo"] = [HWMUISDKJsonShareVmrInfoModelConverter jsonFromModel:shareVmrInfo];
	onReceiveNotify(JSCmdCode_OnShareVmrInfoNotify, dataDict);
	});
}

- (void)onLoginStateChangeNotify:(HWMUISDKLoginStateInfoModel *)loginStateInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"loginStateInfo"] = [HWMUISDKJsonLoginStateInfoModelConverter jsonFromModel:loginStateInfo];
	onReceiveNotify(JSCmdCode_OnLoginStateChangeNotify, dataDict);
	});
}

- (void)onConfStateChanged:(HWMUISDKConfStateInfoModel *)confStateInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"confStateInfo"] = [HWMUISDKJsonConfStateInfoModelConverter jsonFromModel:confStateInfo];
	onReceiveNotify(JSCmdCode_OnConfStateChanged, dataDict);
	});
}

- (void)onConfEndedNotify:(HWMUISDKConfEndInfoModel *)confEndInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"confEndInfo"] = [HWMUISDKJsonConfEndInfoModelConverter jsonFromModel:confEndInfo];
	onReceiveNotify(JSCmdCode_OnConfEndedNotify, dataDict);
	});
}

- (void)onP2PConfRecordNotify:(HWMUISDKP2PConfRecordInfoModel *)recordInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"recordInfo"] = [HWMUISDKJsonP2PConfRecordInfoModelConverter jsonFromModel:recordInfo];
	onReceiveNotify(JSCmdCode_OnP2PConfRecordNotify, dataDict);
	});
}

- (void)onConfInfoNotify:(HWMUISDKConfInfoModel *)confInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"confInfo"] = [HWMUISDKJsonConfInfoModelConverter jsonFromModel:confInfo];
	onReceiveNotify(JSCmdCode_OnConfInfoNotify, dataDict);
	});
}

- (void)onShareStateChanged:(HWMUISDKShareStateInfoModel *)shareStateInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"shareStateInfo"] = [HWMUISDKJsonShareStateInfoModelConverter jsonFromModel:shareStateInfo];
	onReceiveNotify(JSCmdCode_OnShareStateChanged, dataDict);
	});
}

- (void)onSelfRoleChanged:(HWMUISDKConfRole )role {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"role"] = @(role);
	onReceiveNotify(JSCmdCode_OnSelfRoleChanged, dataDict);
	});
}

- (void)onPoorNetworkQualityInfoNotify:(HWMUISDKPoorNetWorkQualityInfoModel *)poorNetWorkInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"poorNetWorkInfo"] = [HWMUISDKJsonPoorNetWorkQualityInfoModelConverter jsonFromModel:poorNetWorkInfo];
	onReceiveNotify(JSCmdCode_OnPoorNetworkQualityInfoNotify, dataDict);
	});
}

- (void)onMeetingInfoChanged:(HWMUISDKMeetingInfoModel *)meetingInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"meetingInfo"] = [HWMUISDKJsonMeetingInfoModelConverter jsonFromModel:meetingInfo];
	onReceiveNotify(JSCmdCode_OnMeetingInfoChanged, dataDict);
	});
}

- (void)onWaitingListChanged:(HWMUISDKAttendeeListInfoModel *)waitingList {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"waitingList"] = [HWMUISDKJsonAttendeeListInfoModelConverter jsonFromModel:waitingList];
	onReceiveNotify(JSCmdCode_OnWaitingListChanged, dataDict);
	});
}

- (void)onAddAttendeeNotify:(HWMUISDKAddAttendeeResultListModel *)addAttendeeResultList {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"addAttendeeResultList"] = [HWMUISDKJsonAddAttendeeResultListModelConverter jsonFromModel:addAttendeeResultList];
	onReceiveNotify(JSCmdCode_OnAddAttendeeNotify, dataDict);
	});
}

- (void)onSelfLocalRecordStateNotify:(HWMUISDKLocalRecordStateInfoModel *)localRecordStateInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"localRecordStateInfo"] = [HWMUISDKJsonLocalRecordStateInfoModelConverter jsonFromModel:localRecordStateInfo];
	onReceiveNotify(JSCmdCode_OnSelfLocalRecordStateNotify, dataDict);
	});
}

- (void)onAttendeeListChanged:(HWMUISDKAttendeeListInfoModel *)attendeeList {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"attendeeList"] = [HWMUISDKJsonAttendeeListInfoModelConverter jsonFromModel:attendeeList];
	onReceiveNotify(JSCmdCode_OnAttendeeListChanged, dataDict);
	});
}

- (void)onRealTimeSubtitleInfoNotify:(HWMUISDKRealTimeSubtitleInfoModel *)realTimeSubtitleInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"realTimeSubtitleInfo"] = [HWMUISDKJsonRealTimeSubtitleInfoModelConverter jsonFromModel:realTimeSubtitleInfo];
	onReceiveNotify(JSCmdCode_OnRealTimeSubtitleInfoNotify, dataDict);
	});
}

- (void)onSubtitleRecordNotify:(HWMUISDKSubtitleRecordInfoModel *)subtitleRecordInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"subtitleRecordInfo"] = [HWMUISDKJsonSubtitleRecordInfoModelConverter jsonFromModel:subtitleRecordInfo];
	onReceiveNotify(JSCmdCode_OnSubtitleRecordNotify, dataDict);
	});
}

- (void)onSubtitleStateChanged:(BOOL )isOpen {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"isOpen"] = @(isOpen);
	onReceiveNotify(JSCmdCode_OnSubtitleStateChanged, dataDict);
	});
}

- (void)onWaitingRoomStateChanged:(BOOL )isOpen {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"isOpen"] = @(isOpen);
	onReceiveNotify(JSCmdCode_OnWaitingRoomStateChanged, dataDict);
	});
}

- (void)onStartLocalRecordOperationInterruptNotify:(HWMUISDKInterruptInfoModel *)info {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"info"] = [HWMUISDKJsonInterruptInfoModelConverter jsonFromModel:info];
	onReceiveNotify(JSCmdCode_OnStartLocalRecordOperationInterruptNotify, dataDict);
	});
}

- (void)onConfIncomingNotify:(HWMUISDKConfIncomingInfoModel *)confIncomingInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"confIncomingInfo"] = [HWMUISDKJsonConfIncomingInfoModelConverter jsonFromModel:confIncomingInfo];
	onReceiveNotify(JSCmdCode_OnConfIncomingNotify, dataDict);
	});
}

- (void)onConfListChanged:(HWMUISDKConfListInfoModel *)confListInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"confListInfo"] = [HWMUISDKJsonConfListInfoModelConverter jsonFromModel:confListInfo];
	onReceiveNotify(JSCmdCode_OnConfListChanged, dataDict);
	});
}

- (void)onAVDeviceCtrlStateChanged:(HWMUISDKDeviceStateInfoModel *)info {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"info"] = [HWMUISDKJsonDeviceStateInfoModelConverter jsonFromModel:info];
	onReceiveNotify(JSCmdCode_OnAVDeviceCtrlStateChanged, dataDict);
	});
}

- (void)onAudioFrameNotify:(HWMUISDKAudioFrameDataModel *)audioFrameData {
	dispatch_async_on_main_queue(^{
		HWMUISDKAudioFrameType eFrameType = audioFrameData.eFrameType;
		NSInteger iSamples = audioFrameData.iSamples;
		NSInteger iSamplesPerSec = audioFrameData.iSamplesPerSec;
		NSInteger iBytesPerSample = audioFrameData.iBytesPerSample;
		NSInteger iChannels = audioFrameData.iChannels;
		size_t length = iSamples * iBytesPerSample * iChannels;
		char *pBuffer = new char[length]{};
		memmove(pBuffer,[audioFrameData.pBuffer bytes],length);
		NSInteger uiDataLen = audioFrameData.uiDataLen;
		onReceiveNotifyWithCallback(^(){
			if (!audioFrameNotifyNotificationsCallback.IsEmpty()) {
				Napi::Env env = audioFrameNotifyNotificationsCallback.Env();
				Napi::Object result = Napi::Object::New(env);
				result.Set("eFrameType", Napi::Number::New(env, eFrameType));
				result.Set("iSamples", Napi::Number::New(env, iSamples));
				result.Set("iSamplesPerSec", Napi::Number::New(env, iSamplesPerSec));
				result.Set("iBytesPerSample", Napi::Number::New(env, iBytesPerSample));
				result.Set("iChannels", Napi::Number::New(env, iChannels));
				result.Set("pBuffer", [self charToUint8Array:env data:pBuffer length:length]);
				result.Set("uiDataLen", Napi::Number::New(env, uiDataLen));
				audioFrameNotifyNotificationsCallback.Call({result});
			}
			delete[] pBuffer;
		});
	});
}

- (void)onClickInjectBtnNotify:(HWMUISDKInjectBtnInfoModel *)injectBtnInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"injectBtnInfo"] = [HWMUISDKJsonInjectBtnInfoModelConverter jsonFromModel:injectBtnInfo];
	onReceiveNotify(JSCmdCode_OnClickInjectBtnNotify, dataDict);
	});
}

- (void)onClickInjectParticipantItemBtnNotify:(HWMUISDKInjectParticipantItemBtnInfoModel *)injectBtnInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"injectBtnInfo"] = [HWMUISDKJsonInjectParticipantItemBtnInfoModelConverter jsonFromModel:injectBtnInfo];
	onReceiveNotify(JSCmdCode_OnClickInjectParticipantItemBtnNotify, dataDict);
	});
}

- (void)onClickInjectCallAllBtnNotify:(HWMUISDKCallAllBtnInfoModel *)injectBtnInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"injectBtnInfo"] = [HWMUISDKJsonCallAllBtnInfoModelConverter jsonFromModel:injectBtnInfo];
	onReceiveNotify(JSCmdCode_OnClickInjectCallAllBtnNotify, dataDict);
	});
}

- (void)onRenderWindowInfoListChanged:(HWMUISDKHwndListInfoModel *)hwndInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"hwndInfo"] = [HWMUISDKJsonHwndListInfoModelConverter jsonFromModel:hwndInfo];
	onReceiveNotify(JSCmdCode_OnRenderWindowInfoListChanged, dataDict);
	});
}

- (void)onQueryContactAvatarNotify:(HWMUISDKContactInfoModel *)contactInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"contactInfo"] = [HWMUISDKJsonContactInfoModelConverter jsonFromModel:contactInfo];
	onReceiveNotify(JSCmdCode_OnQueryContactAvatarNotify, dataDict);
	});
}

- (void)onDoubleClickParticipantListItemNotify:(HWMUISDKParticipantItemInfoModel *)participantInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"participantInfo"] = [HWMUISDKJsonParticipantItemInfoModelConverter jsonFromModel:participantInfo];
	onReceiveNotify(JSCmdCode_OnDoubleClickParticipantListItemNotify, dataDict);
	});
}

- (void)onCallStateChanged:(HWMUISDKCallStateInfoModel *)callStateInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"callStateInfo"] = [HWMUISDKJsonCallStateInfoModelConverter jsonFromModel:callStateInfo];
	onReceiveNotify(JSCmdCode_OnCallStateChanged, dataDict);
	});
}

- (void)onCallEndedNotify:(HWMUISDKCallRecordInfoModel *)callRecordInfo {
	dispatch_async_on_main_queue(^{
	NSMutableDictionary *dataDict = [NSMutableDictionary new];
	dataDict[@"callRecordInfo"] = [HWMUISDKJsonCallRecordInfoModelConverter jsonFromModel:callRecordInfo];
	onReceiveNotify(JSCmdCode_OnCallEndedNotify, dataDict);
	});
}

- (JSNotifyData *)getLastNotifyData {
	if(self.notifyDataArr.count > 0) {
		JSNotifyData *lastData = self.notifyDataArr.lastObject;
		[self.dataLock lock];
		[self.notifyDataArr removeObject:lastData];
		[self.dataLock unlock];
		return lastData;
	} else {
		return nil;
 	}
}

- (void)insertNotifyData:(JSNotifyData *)data {
	if(data) {
		[self.dataLock lock];
		[self.notifyDataArr insertObject:data atIndex:0];
		[self.dataLock unlock];
	}
}

static inline void dispatch_async_on_main_queue(dispatch_block_t block) {
	if (!block) return;
	if ([[NSThread currentThread] isMainThread]) {
		block();
	} else {
		dispatch_async(dispatch_get_main_queue(), block);
 	}
}

- (napi_value)charToUint8Array:(Napi::Env)env data:(const char *)data length:(size_t)length {
	napi_value result;
	void* buffer = malloc(length);
	memmove(buffer, data, length);

	// 创建外部数据
	napi_create_external_arraybuffer(env, buffer, length, NULL, NULL, &result);

	// 创建视图
	napi_create_typedarray(env, napi_uint8_array, length, result, NULL, &result);

	return result;
}
@end



NS_ASSUME_NONNULL_END

