//
//  JSOpenUtils.m
//  JSTest
//
//  Created by chenlinfeng on 2020/10/26.
//

#import "JSOpenUtils.h"

@implementation JSOpenUtils

extern void dictionaryFilterNullNode(NSMutableDictionary*);
extern void arrayFilterNullNode(NSMutableArray*);
 
void inline dictionaryFilterNullNode(NSMutableDictionary *dic) {
    NSMutableArray *deleteKeys = [NSMutableArray array];
    [[dic allKeys] enumerateObjectsUsingBlock:^(id obj, NSUInteger idx, BOOL *stop) {
        id value = [dic objectForKey:obj];
        if ([value isKindOfClass:[NSNull class]]) {
            [deleteKeys addObject:obj];
        } else if([value isKindOfClass:[NSMutableArray class]]) {
            arrayFilterNullNode(value);
        } else if([value isKindOfClass:[NSMutableDictionary class]]) {
            dictionaryFilterNullNode(value);
        }
    }];
    [deleteKeys enumerateObjectsUsingBlock:^(id obj, NSUInteger idx, BOOL *stop) {
        [dic removeObjectForKey:obj];
    }];
}
 
void inline arrayFilterNullNode(NSMutableArray *array) {
    [array enumerateObjectsUsingBlock:^(id obj, NSUInteger idx, BOOL *stop) {
        if ([obj isKindOfClass:[NSMutableDictionary class]]) {
            dictionaryFilterNullNode(obj);
        }
    }];
}

+ (NSString *)string2JSONString:(NSString *)string {
    NSMutableString *s = [NSMutableString stringWithString:string];
    [s replaceOccurrencesOfString:@"\"" withString:@"\\\"" options:NSCaseInsensitiveSearch range:NSMakeRange(0, [s length])];
    [s replaceOccurrencesOfString:@"/" withString:@"\\/" options:NSCaseInsensitiveSearch range:NSMakeRange(0, [s length])];
    [s replaceOccurrencesOfString:@"\n" withString:@"\\n" options:NSCaseInsensitiveSearch range:NSMakeRange(0, [s length])];
    [s replaceOccurrencesOfString:@"\b" withString:@"\\b" options:NSCaseInsensitiveSearch range:NSMakeRange(0, [s length])];
    [s replaceOccurrencesOfString:@"\f" withString:@"\\f" options:NSCaseInsensitiveSearch range:NSMakeRange(0, [s length])];
    [s replaceOccurrencesOfString:@"\r" withString:@"\\r" options:NSCaseInsensitiveSearch range:NSMakeRange(0, [s length])];
    [s replaceOccurrencesOfString:@"\t" withString:@"\\t" options:NSCaseInsensitiveSearch range:NSMakeRange(0, [s length])];
    return [NSString stringWithString:s];
}

+ (id)getJsonObject:(NSString *)jsonStr {
    NSError *error = nil;
    id result = [NSJSONSerialization JSONObjectWithData:[jsonStr dataUsingEncoding:NSUTF8StringEncoding]
                                                options:NSJSONReadingMutableContainers
                                                  error:&error];
    
    if (error || [NSJSONSerialization isValidJSONObject:result] == NO) {
        return jsonStr;
    }
    
    if ([result isKindOfClass:[NSMutableArray class]]) {
        arrayFilterNullNode(result);
        
    } else if([result isKindOfClass:[NSMutableDictionary class]]) {
        dictionaryFilterNullNode(result);
        
    }else if ([result isKindOfClass:[NSNull class]]){
        return jsonStr;
    }
    
    return result;
}

+ (NSString *)dictionaryToJson:(NSDictionary *)dic {
    NSError *error = nil;
    
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:dic
                                                       options:NSJSONWritingPrettyPrinted
                                                         error:&error];
    
    return [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
}
 

@end
