﻿/**
* @file HwmLoginService.h
*
* Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
*
* @brief Xxxxxx.
*/


#ifndef __HWM_PRIVATE_UISDK_SERVICE_H__
#define __HWM_PRIVATE_UISDK_SERVICE_H__

#include "HwmPrivateUISdkMeetingServiceDef.h"
#include "HwmGlobalErrorCodeDef.h"
#include "HwmUISdkLoginServiceDef.h"

BEGIN_HWM_UISDK_NAMESPACE

/**
* @brief [en]xxxxxxxxx
*        [cn]登录操作类结果回调
*/
class HWM_API IHwmPrivateMeetingResultCallback
{
public:
    /**
    * @brief [en] Callback of PopupWindowManager interface.
    *        [cn] 弹出窗口管理器回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnPopupWindowResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of AnonymousEnterConfWithVerifyLink interface.
    *        [cn] 匿名链接入会（有验证）回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @js:disable
    * @mac:disable
    **/
    virtual HWM_VOID OnAnonymousJoinConfByVerifyLinkResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of start ctd conf interface.
    *        [cn] 开始ctd会议回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnStartCtdConfResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of AnonymousJoinConf interface.
    *        [cn] 匿名id入会回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @js:disable
    * @mac:disable
    **/
    virtual HWM_VOID OnAnonymousJoinConfByIdResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of CheckSliderAndGetVerifyCode interface.
    *        [cn] 检验滑块并获取验证码
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @js:disable
    * @mac:disable
    **/
    virtual HWM_VOID OnCheckSliderAndGetVerifyCodeResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of RequestVerifyCodeOrGetSlider interface.
    *        [cn] 请求验证码或获取滑块
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @js:disable
    * @mac:disable
    **/
    virtual HWM_VOID OnRequestVerifyCodeOrGetSliderResult(SDKERR ret, const HWM_CHAR* reason, HwmSliderParam* sliderParam = NULL) {};

    /**
    * @brief [en] Callback of AnonymouseJoinConfByVerifyCode interface.
    *        [cn] 根据验证码入会(匿名)
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnAnonymousJoinConfByVerifyCodeResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of RefreshSlider interface.
    *        [cn] 刷新滑块
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @js:disable
    * @mac:disable
    **/
    virtual HWM_VOID OnRefreshSliderResult(SDKERR ret, const HWM_CHAR* reason, HwmSliderParam* sliderParam = NULL) {};

    /**
    * @brief [en] Callback of RefreshMeetingToken interface.
    *        [cn] 刷新usg会议token回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @js:disable
    * @mac:disable
    **/
    virtual HWM_VOID OnRefreshMeetingTokenResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of EnableCAVerification interface.
    *        [cn] 证明书校验开关回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnEnableCAVerificationResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of ClickAnnotationBtn interface.
    *        [cn] 调用点击标注按钮事件结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnClickAnnotationBtnResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of ClickConfCtrlBtn interface.
    *        [cn] 调用点击会控按钮事件结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param info [type:HwmConfCtrlInfo*]
    * [en] Conf control info
    * [cn] 会控操作信息
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnClickConfCtrlBtnResult(SDKERR ret, const HWM_CHAR* reason, HwmConfCtrlInfo* info) {};

    /**
    * @brief [en] Callback of GetDeviceInfo interface for mic.
    *        [cn] 获取麦克风设备信息结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param deviceInfoList [type:HwmDeviceInfo*]   
    * [en] Device info
    * [cn] 设备信息
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnGetDeviceInfoResult(SDKERR ret, const HWM_CHAR* reason, const HwmDeviceListInfo* devicelistInfo) {};

    /**
    * @brief [en] Callback of SetDeviceIndex interface.
    *        [cn] 设置设备结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnSetDeviceIndexResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of GetDeviceVolume interface.
    *        [cn] 获取设备音量结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    * 
    * @param deviceVolumeInfo [type:HwmDeviceVolumeInfo*]
    * [en] Device volume info
    * [cn] 设备音量信息
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnGetDeviceVolumeResult(SDKERR ret, const HWM_CHAR* reason, const HwmDeviceVolumeInfo* deviceVolumeInfo) {};

    /**
    * @brief [en] Callback of SetDeviceVolume interface.
    *        [cn] 设置设备音量结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnSetDeviceVolumeResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of StartPlayFile interface.
    *        [cn] 开始播放文件结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    * 
    * @param playHandle [type:HWM_INT32]
    * [en] play handle
    * [cn] 播放文件句柄，作为停止播放文件接口的入参
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnStartPlayFileResult(SDKERR ret, const HWM_CHAR* reason, HWM_INT32 playHandle) {};

    /**
    * @brief [en] Callback of StopPlayFile interface.
    *        [cn] 停止播放文件结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnStopPlayFileResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of DetectMicDevice interface.
    *        [cn] 检测麦克风设备结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnDetectMicDeviceResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of SetAutoAccept interface.
    *        [cn] 配置自动接听结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnSetAutoAcceptResult(SDKERR ret, const HWM_CHAR* reason) {};

	/**
    * @brief [en] Callback of GetNoiseReduceSettings interface.
    *        [cn] 获取降噪配置项结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param level [type:HwmNoiseReduceSettings*]
    * [en] Noise reduce level
    * [cn] 降噪等级
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnGetNoiseReduceSettingsResult(SDKERR ret, const HWM_CHAR* reason, const HwmNoiseReduceSettings* noiceReduceSettings) {};

    /**
    * @brief [en] Callback of GetConfSettings interface.
    *        [cn] 获取会中配置项结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param confSettingsInfo [type:HwmConfSettingsInfo*]
    * [en] Conf settings info
    * [cn] 会中配置项信息
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnGetConfSettingsResult(SDKERR ret, const HWM_CHAR* reason, const HwmConfSettingsInfo* confSettingsInfo) {};

    /**
    * @brief [en] Callback of SetConfSettings interface.
    *        [cn] 设置会中配置项结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnSetConfSettingsResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of RemoveDeviceBinding interface.
    *        [cn] 设置会中配置项结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnRemoveDeviceBindingResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of JoinConfByNonce interface.
    *        [cn] nonce入会回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnJoinConfByNonceResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of SetWinBoardAudioOptimize interface.
    *        [cn] 开启大屏音频接口结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnSetWinBoardAudioOptimizeResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of OnSetClientType interface.
    *        [cn] 设置客户端类型接口结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnSetClientTypeResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of ExtendConfDuration interface.
    *        [cn] 延长会议时间结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnExtendConfDurationResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of SetCpuThreshold interface.
    *        [cn] 设置CPU阈值接口结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnSetCpuThresholdResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of GetSSOAuthorizeUrl interface.
    *        [cn] 根据企业域名获取鉴权中心Url 接口 结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param ssoAuthorizeUrl [type:HWM_CHAR*]              
    * [en] SSO Authorize Url
    * [cn] 鉴权中心Url
    */
    virtual HWM_VOID OnGetSSOAuthorizeUrlResult(SDKERR ret, const HWM_CHAR* reason, const HWM_CHAR* ssoAuthorizeUrl) {};

    /**
    * @brief [en] Callback of GetProxy interface.
    *        [cn] 获取代理信息回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param proxyInfo [type:HwmProxyInfo*]
    * [en] proxy info
    * [cn] proxy信息描述
    *
    **/
    virtual HWM_VOID OnGetProxyResult(SDKERR ret, const HWM_CHAR* reason, const HwmProxyInfo* proxyInfo) {};

    /**
     * @brief [en] Callback of EnablePair interface.
     *        [cn] 开启或关闭配对功能回调
     *
     * @param ret [type:SDKERR]
     * [en] Error code
     * [cn] 错误码
     *
     * @param reason [type:HWM_CHAR*]
     * [en] Reason
     * [cn] 错误描述
     *
     * @mac:disable
     **/
    virtual HWM_VOID OnEnablePairResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of JoinConfByLink interface.
    *        [cn] 通过会议链接入会回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnJoinConfByLinkResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of SetEnableCapability interface.
    *        [cn] 设置客户端能力开关接口回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnSetEnableCapabilityResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of LoginByToken interface.
    *        [cn] token登录接口回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param loginByTokenResult [type:HwmLoginByTokenResult*]   
    * [en] Return result
    * [cn] 返回信息描述
    **/
    virtual HWM_VOID OnLoginByTokenResult(SDKERR ret, const HWM_CHAR* reason, const HwmLoginByTokenResult* loginByTokenResult) {};

    /**
    * @brief [en] Callback of LoginByThirdUserInfo interface.
    *        [cn] 通过第三方用户信息登录接口回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnLoginByThirdUserInfoResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of QueryDocFileLists interface.
    *        [cn] 查询会议文档信息结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param docFileList [type:HwmDocFileInfolist*]        
    * [en] doc file info list
    * [cn] 会议文档信息列表
    **/
    virtual HWM_VOID OnQueryDocFileListResult(SDKERR ret, const HWM_CHAR* reason, const HwmDocFileInfolist* docFileList) {};

    /**
    * @brief [en] Callback of DeleteDoc interface.
    *        [cn] 删除会议文档结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnDeleteDocResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of ApplyDocOperateRight interface.
    *        [cn] 获取协作权限结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param applyDocRightResult [type:HwmApplyDocOperRightResult*]        
    * [en] apply doc right result
    * [cn] 申请协作权限结果信息
    **/
    virtual HWM_VOID OnApplyDocOperateRightResult(SDKERR ret, const HWM_CHAR* reason, const HwmApplyDocOperRightResult* applyDocRightResult) {};

    /**
    * @brief [en] Callback of CreateFolder interface.
    *        [cn] 创建会议文档文件夹结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param fileGuid [type:HWM_CHAR*]       
    * [en] file guid
    * [cn] 文档 guid
    **/
    virtual HWM_VOID OnCreateFolderResult(SDKERR ret, const HWM_CHAR* reason, const HWM_CHAR* fileGuid) {};

    /**
    * @brief [en] Callback of GetDeviceResource interface.
    *        [cn] 获取设备资源结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param deviceResource [type:HwmDeviceResource*] 
    * [en] Device resource
    * [cn] 设备资源信息
    **/
    virtual HWM_VOID OnGetDeviceResourceResult(SDKERR ret, const HWM_CHAR* reason, const HwmDeviceResource* deviceResource) {};

    /**
    * @brief [en] Callback of QueryDocAccessUrl interface.
    *        [cn] 查询文档权限链接结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param queryDocAccessUrlResult [type:HwmQueryDocAccessUrlResult*]
    * [en] query doc access url result
    * [cn] 查询文档链接结果
    **/
    virtual HWM_VOID OnQueryDocAccessUrlResult(SDKERR ret, const HWM_CHAR* reason, const HwmQueryDocAccessUrlResult* queryDocAccessUrlResult) {};

    /**
    * @brief [en] Callback of QueryDocAccessUrl interface.
    *        [cn] 批量设置部门信息结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnSetCorpDepartmentInfoResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of UnInit interface.
    *        [cn] 去初始化结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnUnInitResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of ConfigUTEventPublicParam interface.
    *        [cn] 配置打点公共参数结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnConfigUTEventPublicParamResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of AddUserTrack interface.
    *        [cn] 添加用户打点轨迹结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnAddUserTrackResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of StartEvent interface.
    *        [cn] 打点开始事件结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnStartEventResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of FinishEvent interface.
    *        [cn] 打点结束事件结果回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnFinishEventResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of AnonymousJoinConfBySignature interface.
    *        [cn] 安全会议匿名入会回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnAnonymousJoinConfBySignatureResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of OptimizeShareSmooth interface.
    *        [cn] 提升共享流畅度回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnOptimizeShareSmoothResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of QueryNonce interface.
    *        [cn] 获取nonce回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param queryNonceResult [type:HwmQueryNonceResult*]
    * [en] query nonce result
    * [cn] 获取nonce结果
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnQueryNonceResult(SDKERR ret, const HWM_CHAR* reason, const HwmQueryNonceResult* queryNonceResult) {};

    /**
    * @brief [en] Callback of BreakPairLink interface.
    *        [cn] 断开配对链路的接口回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnBreakPairLinkResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of ModifyPairLinkMode interface.
    *        [cn] 修改配对链路模式的接口回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnModifyPairLinkModeResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of SendCustomMsgToPairLink interface.
    *        [cn] 发送自定义消息到配对链路的接口回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnSendCustomMsgToPairLinkResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of SubmitNssSurvey interface.
    *        [cn] 提交满意度评价回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @js:disable
    * @mac:disable
    **/
    virtual HWM_VOID OnSubmitNssSurveyResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of GetConfLockedState interface.
    *        [cn] 获取会议锁定状态接口回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param state [type:HwmLockedState]
    * [en] state
    * [cn] 会议锁定状态
    *
    * @js:disable
    * @mac:disable
    **/
    virtual HWM_VOID OnGetConfLockedStateResult(SDKERR ret, const HWM_CHAR* reason, HwmLockedState state) {};

    /**
    * @brief [en] Callback of GetCpuPerformanceLevel interface.
    *        [cn] 获取cpu表现性能接口回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param cpuLevelResult [type:HwmCpuLevelResult*]
    * [en] Cpu Level Result
    * [cn] cpu性能结果信息
    *
    * @doc:disable
    * @mac:disable
    **/
    virtual HWM_VOID OnGetCpuPerformanceLevelResult(SDKERR ret, const HWM_CHAR* reason, const HwmCpuLevelResult* cpuLevelResult) {};

    /**
    * @brief [en] request media separate log
    *        [cn] 请求媒体分离日志结果
    *
    * @param ret [type:SDKERR]
    * [en]Error code
    * [cn]错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en]Reason
    * [cn]错误描述
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnRequestMediaSeparateLogResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of EndProjection interface.
    *        [cn] 结束投屏回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @doc:disable
    **/
    virtual HWM_VOID OnEndProjectionResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of SwitchProjectionToConf interface.
    *        [cn] 投屏会议转普通会议回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @doc:disable
    **/
    virtual HWM_VOID OnSwitchProjectionToConfResult(SDKERR ret, const HWM_CHAR* reason) {};
    
    /**
    * @brief
    * [en]Callback of QueryVersionInfo interface.
    * [cn]查询版本信息结果
    * 
    * @param ret [type:SDKERR]
    * [en]Error code
    * [cn]错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en]Reason
    * [cn]错误描述
    * 
    * @param queryResultInfo [type:HwmQueryVersionInfoResult*]
    * [en]Reason
    * [cn]版本信息查询结果
    *
    * @js:disable
    * 
    */
    virtual HWM_VOID OnQueryVersionInfoResult(SDKERR ret, const HWM_CHAR* reason, const HwmQueryVersionInfoResult* queryResultInfo) {};

        /**
    * @brief 
    * [en]Callback of InitPairServer interface.
    * [cn]初始化配对服务结果
    *
    * @param ret [type:SDKERR]
    * [en]Error code
    * [cn]错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en]Reason
    * [cn]错误描述
    *
    * @win:disable
    * @js:disable
    **/
    virtual HWM_VOID OnInitPairServerResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of GetSpesInfo interface.
    *        [cn] 获取Spes信息
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param spesInfo [type:HwmSpesInfoResult*]
    * [en]Spes info
    * [cn]Spes信息
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnGetSpesInfoResult(SDKERR ret, const HWM_CHAR* reason, const HwmSpesInfoResult* spesInfo) {};

    /**
    * @brief [en] Callback of UpdateExternalInviteesList interface.
    *        [cn] 更新外部邀请与会者
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    **/
    virtual HWM_VOID OnUpdateExternalInviteesListResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of StartPlayAudioFile interface.
    *        [cn] 播放音频文件回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnStartPlayAudioFileResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief
    * [en] Callback of ConfigSettingWindow interface.
    * [cn] 定制设置界面
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnConfigSettingWindowResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief
    * [en] Callback of SetCfgClientType interface.
    * [cn] 设置配置文件类型
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnSetCfgClientTypeResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief
    * [en] Callback of SetOtherNumber interface.
    * [cn] 设置其他号码回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    **/
    virtual HWM_VOID OnSetOtherNumberResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of SetDeployInfo interface.
    *        [cn] 设置部署信息
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    **/
    virtual HWM_VOID OnSetDeployInfoResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of SwapScreenContent interface.
    *        [cn] 会中交换屏幕
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    **/
    virtual HWM_VOID OnSwapScreenContentResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of GetScreenContentSwapInfo interface.
    *        [cn] 获取会中屏幕交换信息接口回调
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param info [type:HwmScreenContentSwapInfo*]
    * [en] info
    * [cn] 会中交换屏幕信息
    *
    * @mac:disable
    *
    **/
    virtual HWM_VOID OnGetScreenContentSwapInfoResult(SDKERR ret, const HWM_CHAR* reason, const HwmScreenContentSwapInfo* info) {};

    /**
    * @brief [en] Callback of SetInnerHttpProxyInfo interface.
    *        [cn] 设置内部Http代理信息
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    **/
    virtual HWM_VOID OnSetInnerHttpProxyInfoResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of SetMeetingCustomInfo interface.
    *        [cn] 设置会议自定义信息
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    **/
    virtual HWM_VOID OnSetMeetingCustomInfoResult(SDKERR ret, const HWM_CHAR* reason) {};

    /**
    * @brief [en] Callback of GetJwtToken interface.
    *        [cn] 获取本地鉴权token信息
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 错误码
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 错误描述
    *
    * @param jwtTokenInfo [type:HwmJwtTokenInfo*]
    * [en] jwt Token info
    * [cn] 本地鉴权token信息
    *
    **/
    virtual HWM_VOID OnGetJwtTokenResult(SDKERR ret, const HWM_CHAR* reason, const HwmJwtTokenInfo* jwtTokenInfo) {};
};

/**
* @brief [en]xxxxxxxxx
*        [cn]登录通知
*/
class HWM_API IHwmPrivateMeetingNotifyCallback
{
public:
    /**
    * @brief [en] meeting config notify
    *        [cn] 会议配置项下发
    *
    * @param meetingConfig [type:HWM_CHAR*]             
    * [en] meeting config
    * [cn] 会议配置项
    *
    * @doc:disable
    * @mac:disable
    */
    virtual HWM_VOID OnMeetingConfig(const HWM_CHAR* meetingConfig) {};

    /**
    * @brief [en] Annotion state updata notify. when annotion state is updated, will receive this notify
    *        [cn] 标注状态变更通知,当标注状态发生更新时会收到该通知
    *
    * @param state [type:HWM_INT32]                     
    * [en] annotion state
    * [cn] 标注状态
    *
    * @mac:disable
    */
    virtual HWM_VOID OnAnnotationStateUpdataNotify(HWM_INT32 state) {};

    /**
    * @brief[en] Notify of mic input level change
    *       [cn] 麦克风输入等级变化通知
    *
    * @param level [type:HWM_INT32]                     
    * [en] level.
    * [cn] 输入等级
    *
    * @mac:disable
    */
    virtual HWM_VOID OnMicInputLevelChange(HWM_UINT32 level) {};

    /**
    * @brief [en] Notify of speaker output level change
    *        [cn] 扬声器输出等级变化通知
    *
    * @param level [type:HWM_INT32]
    * [en] level.
    * [cn] 输入等级
    *
    * @mac:disable
    */
    virtual HWM_VOID OnSpeakerOutputLevelChange(HWM_UINT32 level) {};

    /**
    * @brief[en] Notify of mic level change
    *       [cn] 麦克风音柱变化通知
    *
    * @param level [type:HWM_INT32]
    * [en] level.
    * [cn] 输入等级
    *
    * @mac:disable
    */
    virtual HWM_VOID OnMicLevelChange(HWM_UINT32 level) {};

    /**
    *@brief[en] Notify of attendee count change
    *[cn] 与会者人数变化通知
    *
    * @param info [type:HwmAttendeeCountInfo*]
    * [en] Attendee countinfo.
    * [cn] 与会者人数信息
    *
    * @mac:disable
    */
    virtual HWM_VOID OnAttendeeCountChange(const HwmAttendeeCountInfo* info) {};


    /**
    *@brief[en] Notify of join vmr conf conflict info
    *[cn] 加入vmr会议冲突信息上报
    *
    * @param info [type:HwmConfConflictInfo*]
    * [en] conflict vmr conf info.
    * [cn] 冲突的vmr会议信息
    *
    * @mac:disable
    */
    virtual HWM_VOID OnJoinVmrConfConflictInfoNotify(const HwmConfConflictInfo* info) {};

    /**
    *@brief[en] Notify of proxy info change
    *[cn] 代理信息变化通知
    *
    * @param info [type:HwmProxyInfo*]
    * [en] proxy info.
    * [cn] 代理信息
    *
    * @mac:disable
    * @js:disable
    */
    virtual HWM_VOID OnProxyInfoChange(const HwmProxyInfo* info) {};

    /**
    * @brief [en] Notify of Reserved inject btn.
    *        [cn] 点击注入保留按钮通知
    *
    * @param injectBtn [type:HwmReservedClickInjectBtn]    
    * [en] Button type
    * [cn] 按钮类型
    *
    * @param data [type:HWM_VOID*]                               
    * [en] Notify data
    * [cn] 通知所带参数
    *
    * @param id [type:HWM_CHAR*]
    * [en] User custome menu id
    * [cn] 用户自定义菜单id
    *
    * @mac:disable
    **/
    virtual HWM_VOID OnClickReservedInjectBtn(HwmReservedClickInjectBtn injectBtn, HWM_VOID* data, const HWM_CHAR* id) {};

    /**
    * @brief [en] Notify of extend conf duration
    *        [cn] 会议即将结束，需要延长会议时间的通知
    *
    *
    * @mac:disable
    */
    virtual HWM_VOID OnExtendConfNotify() {};

    /**
    * @brief [en] Notify of pair code refresh.
    *        [cn] 配对码信息刷新通知
    *
    * @param info [type:HwmPairCodeInfo*]
    * [en] Pair code info
    * [cn] 配对码信息
    *
    * @doc:disable
    */
    virtual HWM_VOID OnRefreshPairCode(const HwmPairCodeInfo* info) {};
    
    /**
    * @brief [en] Notify of token refresh.
    *        [cn] token刷新通知
    *
    * @param info [type:HwmPrivateLoginStateInfo*]              
    * [en] Login info
    * [cn] 登录信息
    */
    virtual HWM_VOID OnLoginTokenRefreshNotify(const HwmPrivateLoginStateInfo* info) {};

    /**
    * @brief [en] Notify of application info
    *        [cn] 收到会议应用通知消息
    *
    * @param applicationJsonInfo [type:HWM_CHAR*]       
    * [en] application json info
    * [cn] 应用信息 json字符串
    *
    * @mac:disable
    */
    virtual HWM_VOID OnApplicationNotify(const HWM_CHAR* applicationJsonInfo) {};

    /**
    * @brief
    * [en] Notify of contact avatar changed
    * [cn] 联系人头像变更通知
    *
    * @detail
    * [en]
    * [cn] 收到该通知时，表示联系人头像发生了变化
    *
    * @param avatarInfo [type:HwmContactAvatarInfo*]
    * [en] Contact avatar info.
    * [cn] 联系人头像信息
    *
    * @mac:disable
    */
    virtual HWM_VOID OnContactAvatarChanged(const HwmContactAvatarInfo* avatarInfo) {};

    /**
    * @brief [en] Notify of query corp department info
    *        [cn] 批量查询部门信息通知
    *
    * @param queryDepartInfoParamList [type:HwmQueryCorpDepartmentInfoParamList*]     
    * [en] query department info param list
    * [cn] 查询部门信息参数列表
    */
    virtual void OnQueryCorpDepartmentInfo(const HwmQueryCorpDepartmentInfoParamList* queryDepartInfoParamList) {};

    /**
    *@brief[en] Notify of server domain strategy
    *[cn] 域名策略变化通知
    *
    * @param domainStrategy [type:HwmServerDomainStrategy*] 
    * [en] domain strategy.
    * [cn] 域名策略信息
    *
    * @mac:disable
    */
    virtual HWM_VOID OnServerDomainStrategyNotify(const HwmServerDomainStrategy* domainStrategy) {};

    /**
    * @brief
    * [en]This class is about audio quality notify.
    * [cn]音频质量通知
    *
    * @param info [type:AudioQualityInfo*]
    * [en]audio quality info
    * [cn]音频质量信息
    *
    * @mac:disable
    */
    virtual HWM_VOID OnAudioQualityNotify(const AudioQualityInfo* info) {};

    /**
    * @brief [en] Notify of proxy account info changed
    *        [cn] 代理账号信息变更通知
    *
    * @param accountInfo [type:HwmProxyAccountInfo*]     
    * [en] proxy account info
    * [cn] 代理账号信息
    *
    * @mac:disable
    */
    virtual HWM_VOID OnProxyAccountInfoChanged(const HwmProxyAccountInfo* accountInfo) {};

    /**
    * @brief [en]Notify of conf event info
    *        [cn]会中事件信息上报通知
    *
    * @param eventInfo [type:HWM_CHAR*]
    * [en] Conf state info
    * [cn] 会议状态信息
    */
    virtual HWM_VOID OnConfEventInfoNotify(const HWM_CHAR* eventInfo) {};

    /**
    * @brief [en] Notify of scan join conf result
    *        [cn] 扫码入会通知
    *
    * @param scanJoinConfResult [type:HwmScanJoinConfResult*]
    * [en] scan join conf result info
    * [cn] 扫码入会结果信息
    *
    */
    virtual HWM_VOID OnScanInfoForJoinConfNotify(const HwmScanJoinConfResult* scanJoinConfResult) {};

    /**
    * @brief [en] meeting config notify
    *        [cn] 跟随高级参数返回的会议配置项
    *
    * @param meetingConfig [type:HWM_CHAR*]
    * [en] json config
    * [cn] json配置
    */
    virtual HWM_VOID OnAppCfgChanged(const HWM_CHAR* meetingConfig) {};

    /**
    * @brief [en] Notify of pair verify code.
    *        [cn] 配对验证码通知
    *
    * @param pairVerifyCodeInfo [type:HwmPairVerifyCodeInfo*]
    * [en] Pair verify code info
    * [cn] 配对验证码
    *
    * @doc:disable
    */
    virtual HWM_VOID OnPairVerifyCodeNotify(const HwmPairVerifyCodeInfo* pairVerifyCodeInfo) {};

    /**
    * @brief [en] Notify of pair link list.
    *        [cn] 配对链路列表通知
    *
    * @param pairLinkListInfo [type:HwmPairLinkListInfo*]
    * [en] Pair link list info
    * [cn] 配对链路列表
    *
    * @doc:disable
    */
    virtual HWM_VOID OnPairLinkListNotify(const HwmPairLinkListInfo* pairLinkListInfo) {};

    /**
    * @brief [en] Notify of pair link suceess.
    *        [cn] 配对链路成功通知
    *
    * @doc:disable
    */
    virtual HWM_VOID OnPairLinkSuccessNotify() {};

    /**
    * @brief [en] Notify of msg from pair link.
    *        [cn] 配对链路中消息上报
    *
    * @param msgInfo [type:HWM_CHAR*]
    * [en] 消息信息
    * [cn] Msg info
    *
    * @doc:disable
    */
    virtual HWM_VOID OnRecvMsgFromPairLinkNotify(const HWM_CHAR* msgInfo) {};

    /**
    * @brief [en] Notify of request media separate log
    *        [cn] 请求媒体分离日志，拷贝日志操作的通知
    *
    * @param ret [type:HwmErrorResult*]
    * [en] operate result
    * [cn] 操作结果
    *
    * @mac:disable
    * @js:disable
    **/
    virtual HWM_VOID OnRequestMediaSeparateLogNotify(const HwmErrorResult* ret) {};

    /**
    * @brief
    * [en] Notice of abnormal leave meeting
    * [cn] 异常断开的会议通知
    *
    * @param abnormalLeaveMeetingInfo [type:HwmAbnormalLeaveMeetingInfo*]
    * [en] Abnormal leave meeting info
    * [cn] 异常断开的会议信息
    *
    * @doc:disable
    */
    virtual HWM_VOID OnAbnormalLeaveMeetingNotify(const HwmAbnormalLeaveMeetingInfo* abnormalLeaveMeetingInfo) {};

    /**
    * @brief [en] Notify external invitee of invite、hangup、 recall or call other 
    *        [cn] 外部与会者的邀请、挂断、重呼、呼叫其他号码等操作的通知
    *
    * @param operateInfo[type:HwmOperateExternalInviteeInfo*]
    * [en] external invitee notifys
    * [cn] 操作外部与会者通知
    *
    **/
    virtual HWM_VOID OnOperateExternalAttendeeNotify(const HwmOperateExternalInviteeInfo* operateInfo) {};

    /**
    * @brief [en] Notify external invitee of invite all not in conf
    *        [cn] 外部与会者的批量邀请操作的通知
    *
    * @param operateInfo[type:HwmCallAllExternalAttendeesInfo*]
    * [en] external invitees notify
    * [cn] 操作外部与会者通知
    *
    **/
    virtual HWM_VOID OnCallAllExternalAttendeesNotify(const HwmCallAllExternalAttendeesInfo* operateInfo) {};

    /**
    * @brief[en] Notify of complain
    *       [cn] 举报通知
    *
    * @param complainInfo [type:HwmComplainInfo*]
    * [en] Complain Info
    * [cn] 举报信息
    *
    * @mac:disable
    * @js:disable
    */
    virtual HWM_VOID OnComplainNotify(const HwmComplainInfo* complainInfo) {};

    /**
    * @brief[en] Notify of query other number info
    *       [cn] 请求其他号码
    *
    * @param complainInfo [type:HwmQueryOtherNumberInfo*]
    * [en] Query other number info
    * [cn] 请求其他号码信息
    *
    */
    virtual HWM_VOID OnQueryOtherNumberNotify(const HwmQueryOtherNumberInfo* queryOtherNumberInfo) {};

    /**
    * @brief
    * [en] Notify of multi-share type change
    * [cn] 会议是否支持多人共享通知
    *
    * @detail
    * [en] (only for windows)
    * [cn] 收到该通知时，表示会议是否支持多人共享通知(仅对windows平台生效)。
    *
    * @param multiShareType [type:HwmAllowMultiShareType]
    * [en]multi-share type
    * [cn]多人共享类型
    *
    * @mac:disable
    */
    virtual HWM_VOID OnMultiShareTypeChanged(HwmAllowMultiShareType multiShareType) {};


    /**
    * @brief
    * [en] Notify of share audio state change
    * [cn] 共享音频状态变化通知
    *
    * @param shareAudioStateInfo [type:HwmShareAudioStateInfo*]
    * [en] Share audio state info
    * [cn] 共享音频状态信息
    *
    * @mac:disable
    */
    virtual HWM_VOID OnShareAudioStateChanged(const HwmShareAudioStateInfo* shareAudioStateInfo) {};
};

/**
* @brief [en]This class is about private meeting management object.
*        [cn]私有会议管理对象
* @detail
* [en]This class is about private meeting management object.
* [cn]获取私有会议管理对象的方法
*
* @GetInstance
*        HWM_UISDK_NAMESPACE::HwmPrivateUISDK::GetPrivateMeetingApi()
*/
class IHwmPrivateMeeting
{
public:
    /**
    * @brief
    * [en]This class is about the global callbacks of setting private meeting operations class.
    * [cn]设置私有会议操作类全局回调
    *
    * @param callback [cs_allowNull:N]
    * [en]
    * [cn]私有会议操作类全局回调
    * @see IHwmPrivateMeetingResultCallback
    *
    * @since:v1.0
    */
    virtual HWM_VOID SetPrivateMeetingResultCallback(IHwmPrivateMeetingResultCallback* callback) = 0;

    /**
    * @brief
    * [en]This class is about the global callbacks of private meeting notifications class.
    * [cn]设置私有会议通知类全局回调
    *
    * @param callback [cs_allowNull:N]
    * [en]
    * [cn]私有会议通知类全局回调
    * @see IHwmPrivateMeetingNotifyCallback
    *
    * @since:v1.0
    */
    virtual HWM_VOID SetPrivateMeetingNotifyCallback(IHwmPrivateMeetingNotifyCallback* callback) = 0;

    /**
    * @brief [en] This interface is used to manage popup window.
    *        [cn] 弹出窗口管理器
    *
    * @param popupWindowType [type:HwmPopupWindowType]               
    * [en] Popup window type info
    * [cn] 弹出窗口类型参数
    *
    * @param isShow [type:HWM_BOOL]                                        
    * [en] IsShow
    * [cn] 弹出或关闭
    *
    * @js:disable
    * @mac:disable
    **/
    virtual SDKERR PopupWindow(HwmPopupWindowType popupWindowType, HWM_BOOL isShow) = 0;

    /**
    * @brief [en] This interface is used to anonymous join conf by verify id.
    *        [cn] 匿名id入会
    *
    * @param anonymousIdConfInfo [type:HwmAnonymousIdConfInfo*]         
    * [en] Anonymous id conf info
    * [cn] 匿名id入会参数
    *
    * @js:disable
    * @mac:disable
    **/
    virtual SDKERR AnonymousJoinConfById(const HwmAnonymousIdConfInfo *anonymousIdConfInfo) = 0;

    /**
    * @brief [en] This interface is used to check and get slider.
    *        [cn] 校验滑块并获取验证码
    *
    * @param checkSliderAndGetVerifyCodeInfo [type:HwmCheckSliderAndGetVerifyCodeInfo*]        
    * [en] Check slider and get verify code info
    * [cn] 校验滑块并获取验证码参数
    *
    * @js:disable
    * @mac:disable
    **/
    virtual SDKERR CheckSliderAndGetVerifyCode(const HwmCheckSliderAndGetVerifyCodeInfo *checkSliderAndGetVerifyCodeInfo) = 0;

    /**
    * @brief [en] This interface is used to request verify code and get slider.
    *        [cn] 请求验证码或获取滑块
    *
    * @param requestVerifyCodeOrGetSliderInfo [type:HwmRequestVerifyCodeOrGetSliderInfo*]       
    * [en] Request verify code or get slider info
    * [cn] 请求验证码或获取滑块参数
    *
    * @js:disable
    * @mac:disable
    **/
    virtual SDKERR RequestVerifyCodeOrGetSlider(const HwmRequestVerifyCodeOrGetSliderInfo *requestVerifyCodeOrGetSliderInfo) = 0;

    /**
    * @brief [en] This interface is used to join conf by verify code.
    *        [cn] 根据验证码入会
    *
    * @param anonymousJoinConfByVerifyCodeInfo [type:HwmAnonymousJoinConfByVerifyCodeInfo*]    
    * [en] Anonymous join conf by verify code info
    * [cn] 根据验证码入会参数
    *
    * @mac:disable
    **/
    virtual SDKERR AnonymousJoinConfByVerifyCode(const HwmAnonymousJoinConfByVerifyCodeInfo *anonymousJoinConfByVerifyCodeInfo) = 0;

    /**
    * @brief [en] This interface is used to anonymous join conf by verify link.
    *        [cn] 匿名链接入会
    *
    * @param anonymousLinkVerifyConfInfo [type:HwmAnonymousVerifyLinkConfInfo*]               
    * [en] Anonymous link verify conf info
    * [cn] 匿名链接入会参数
    *
    * @js:disable
    * @mac:disable
    **/
    virtual SDKERR AnonymousJoinConfByVerifyLink(const HwmAnonymousVerifyLinkConfInfo *anonymousLinkVerifyConfInfo) = 0;

    /**
    * @brief [en] This interface is used to refresh slider.
    *        [cn] 刷新滑块
    *
    * @js:disable
    * @mac:disable
    **/
    virtual SDKERR RefreshSlider() = 0;

    /**
    * @brief [en] This interface is used to book ctd conf.
    *        [cn] 预约ctd会议(新内部接口)
    *
    * @param ctdConfInfo [type:HwmCtdCallInfo*]               
    * [en] Ctd call info
    * [cn] 开始ctd会议参数
    **/
    virtual SDKERR StartCtdConf(const HwmCtdConfInfo *ctdConfInfo) = 0;

    /**
    * @brief [en] This interface is used to refresh meeting token.
    *        [cn] 刷新usg会议token
    *
    * @js:disable
    **/
    virtual SDKERR RefreshMeetingToken() = 0;

    /**
    * @brief [en] This interface is used to verify CA.
    *        [cn] 证明书校验开关
    *
    * @param isVerify [type:HWM_BOOL]                                
    * [en] is Verify
    * [cn] 是否校验
    **/
    virtual SDKERR EnableCAVerification(HWM_BOOL isVerify) = 0;

    /**
    * @brief [en] This interface is used to click annotation btn.
    *        [cn] 调用标注按钮点击事件
    *
    * @mac:disable
    **/
    virtual SDKERR ClickAnnotationBtn() = 0;

    /**
    * @brief [en] This interface is used to click conf control btn.
    *        [cn] 调用会控按钮点击事件
    *
    * @param info [type:HwmConfCtrlInfo]
    * [en] Conf control info
    * [cn] 会控操作信息
    *
    * @mac:disable
    **/
    virtual SDKERR ClickConfCtrlBtn(const HwmConfCtrlInfo* info) = 0;

    /**
    * @brief [en] This interface is used to get device info.
    *        [cn] 获取设备信息
    *
    * @param deviceType [type:HwmDeviceType]                   
    * [en] device type
    * [cn] 设备类型
    *
    * @mac:disable
    **/
    virtual SDKERR GetDeviceInfo(HwmDeviceType deviceType) = 0;

    /**
    * @brief [en] This interface is used to set device index.
    *        [cn] 设置设备
    *
    * @param deviceType [type:HwmDeviceType]                   
    * [en] device type
    * [cn] 设备类型
    *
    * @param deviceName [type:HWM_CHAR]                             
    * [en] device name
    * [cn] 设备名称
    *
    * @param deviceIndex [type:HWM_UINT32]              
    * [en] device index
    * [cn] 设备编号
    *
    * @mac:disable
    **/
    virtual SDKERR SetDeviceIndex(HwmDeviceType deviceType, const HWM_CHAR deviceName[MAX_DISPLAY_NAME], HWM_UINT32 deviceIndex) = 0;

    /**
    * @brief [en] This interface is used to get device volume.
    *        [cn] 获取设备音量
    *
    * @param deviceType [type:HwmDeviceType]                    
    * [en] device type
    * [cn] 设备类型
    *
    * @mac:disable
    **/
    virtual SDKERR GetDeviceVolume(HwmDeviceType deviceType) = 0;

    /**
    * @brief [en] This interface is used to set device volume.
    *        [cn] 设置设备音量
    *
    * @param deviceType [type:HwmDeviceType]
    * [en] device type
    * [cn] 设备类型
    *
    * @param volume [type:HWM_UINT32]                         
    * [en] volume
    * [cn] 音量
    *
    * @mac:disable
    **/
    virtual SDKERR SetDeviceVolume(HwmDeviceType deviceType, HWM_UINT32 volume) = 0;

    /**
    * @brief [en] This interface is used to start play file.
    *        [cn] 开始播放文件
    *
    * @param loopTime [type:HWM_UINT32]                      
    * [en] loop time
    * [cn] 循环播放次数，0为一直循环
    *
    * @param filePath [type:HWM_CHAR]   
    * [en] file path
    * [cn] 文件路径
    *
    * @mac:disable
    **/
    virtual SDKERR StartPlayFile(HWM_UINT32 loopTime, const HWM_CHAR filePath[HWM_MAX_FILE_PATH_LEN]) = 0;

    /**
    * @brief [en] This interface is used to stop play file.
    *        [cn] 停止播放文件
    *
    * @param playHandle [type:HWM_INT32]                             
    * [en] play handle
    * [cn] 播放文件句柄
    *
    * @mac:disable
    **/
    virtual SDKERR StopPlayFile(HWM_INT32 playHandle) = 0;

    /**
    * @brief [en] This interface is used to detect mic device.
    *        [cn] 检测麦克风设备
    *
    * @param isOpen [type:HWM_BOOL]                                   
    * [en] is open
    * [cn] 是否开启
    *
    * @mac:disable
    **/
    virtual SDKERR DetectMicDevice(HWM_BOOL isOpen) = 0;

    /**
    * @brief [en] This interface is used to set auto accept.
    *        [cn] 配置自动接听
    *
    * @param isOpen [type:HWM_BOOL]
    * [en] is open
    * [cn] 是否开启
    *
    * @mac:disable
    **/
    virtual SDKERR SetAutoAccept(HWM_BOOL isOpen) = 0;

    /**
    * @brief [en] This interface is used to get noise reduce settings.
    *        [cn] 获取降噪配置项
    *
    * @mac:disable
    **/
    virtual SDKERR GetNoiseReduceSettings() { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief [en] This interface is used to set noise reduce settings.
    *        [cn] 设置降噪配置项
    *
    * @param settings [type:HwmNoiseReduceSettings]
    * [en] settings
    * [cn] 降噪配置项
    *
    * @synchronized
    * @mac:disable
    **/
    virtual SDKERR SetNoiseReduceSettings(const HwmNoiseReduceSettings* settings) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief [en] This interface is used to get conf settings.
    *        [cn] 获取会中配置项
    *
    * @param confSettings [type:HwmConfSettings]                 
    * [en] conf settings
    * [cn] 会中配置项
    *
    * @mac:disable
    **/
    virtual SDKERR GetConfSettings(HwmConfSettings confSettings) = 0;

    /**
    * @brief [en] This interface is used to set conf settings.
    *        [cn] 设置会中配置项
    *
    * @param confSettings [type:HwmConfSettings]                 
    * [en] conf settings
    * [cn] 会中配置项
    *
    * @param isOpen [type:HWM_BOOL]
    * [en] is open
    * [cn] 是否开启
    *
    * @mac:disable
    **/
    virtual SDKERR SetConfSettings(HwmConfSettings confSettings, HWM_BOOL isOpen) = 0;

    /**
    * @brief [en] This interface is used to remove device bingding.
    *        [cn] 解除绑定
    * @mac:disable
    **/
    virtual SDKERR RemoveDeviceBinding() = 0;

    /**
    * @brief [en] This interface is used to join conf by nonce.
    *        [cn] nonce入会
    *
    * @param joinConfByNonceInfo [type:HwmJoinConfByNonceInfo*]                
    * [en] Nonce conf info
    * [cn] nonce入会参数
    *
    * @mac:disable
    **/
    virtual SDKERR JoinConfByNonce(const HwmJoinConfByNonceInfo *joinConfByNonceInfo) = 0;

    /**
    * @brief [en] This interface is used to set win board audio optimize.
    *        [cn] 启用大屏音频接口
    *
    * @param isEnable [type:HWM_BOOL]
    * [en] is enable
    * [cn] 是否启用
    *
    * @mac:disable
    **/
    virtual SDKERR SetWinBoardAudioOptimize(HWM_BOOL isEnable) = 0;

    /**
    * @brief [en] This interface is used to set client type.
    *        [cn] 设置客户端类型接口
    *
    * @param clientType [type:HwmClientType]
    * [en] client type
    * [cn] 客户端类型
    *
    * @mac:disable
    **/
    virtual SDKERR SetClientType(HwmClientType clientType) = 0;

    /**
    * @brief [en]This interface is used to extend conf duration
    *        [cn]延长会议时间
    *
    * @param extendInfo [type:HwmExtendConfDurationInfo*]                    
    * [en] Extend conf duration info
    * [cn] 延长会议时长信息
    *
    * @mac:disable
    */
    virtual SDKERR ExtendConfDuration(const HwmExtendConfDurationInfo *extendInfo) = 0;

    /**
    * @brief [en] This interface is used to set cpu threshold.
    *        [cn] 设置CPU阈值接口
    *
    * @param info [type:HwmCpuThresholdInfo*]                       
    * [en] cpu threshold info
    * [cn] CPU 阈值信息
    *
    * @mac:disable
    **/
    virtual SDKERR SetCpuThreshold(const HwmCpuThresholdInfo *info) = 0;

    /**
    * @brief [en] This method is used to get SSO authorise url.
    *        [cn] 根据企业域名获取鉴权中心Url
    *
    * @param domain [type:HWM_CHAR*]             
    * [en] domain
    * [cn] 企业域名
    *
    **/
    virtual SDKERR GetSSOAuthorizeUrl(const HWM_CHAR *domain) = 0;

    /**
    * @brief [en] This interface is used to get proxy info.
    *        [cn] 获取代理信息
    **/
    virtual SDKERR GetProxy() = 0;

    /**
    * @brief [en] This interface is used to login sdk by account and token.
    *        [cn] token登录
    *
    * @param loginInfo [type: HwmAccountAndTokenAuthInfo*]            
    * [en] Login info
    * [cn] 登录信息
    **/
    virtual SDKERR LoginByToken(HwmAccountAndTokenAuthInfo *loginInfo) = 0;

    /**
    * @brief [en] This interface is used to login by third user info.
    *        [cn] 通过第三方用户信息登录
    *
    * @param thirdUserInfo [type: HwmThirdUserInfo*]
    * [en] Third user info
    * [cn] 第三方用户信息
    **/
    virtual SDKERR LoginByThirdUserInfo(const HwmThirdUserInfo* thirdUserInfo) = 0;

    /**
    * @brief [en] This interface is used to to enable or disable pair feature.
    *        [cn] 开启或关闭配对功能
    *
    * @param enable [type:HWM_BOOL]                               
    * [en] If enable
    * [cn] 是否开启
    *
    * @mac:disable
    **/
    virtual SDKERR EnablePair(HWM_BOOL isEnable) = 0;

    /**
    * @brief [en] This interface is used to join conf by link.
    *        [cn] 通过链接入会
    *
    * @param joinConfByLinkInfo [type:HwmJoinConfByLinkInfo*]            
    * [en] Join conf by link
    * [cn] 通过链接入会
    **/
    virtual SDKERR JoinConfByLink(HwmJoinConfByLinkInfo *joinConfByLinkInfo) = 0;

    /**
    * @brief [en] This interface is used to enable capability
    *        [cn] 设置客户端能力开关
    *
    * @param type [type:HwmCapabilityType]                            
    * [en] Capability type
    * [cn] 能力类型枚举
    *
    * @param isEnable [type:HWM_BOOL]                                    
    * [en] Enable state
    * [cn] 开启状态
    *
    * @mac:disable
    **/
    virtual SDKERR SetEnableCapability(HwmSDKCapabilityType type, HWM_BOOL isEnable) = 0;

    /**
    * @brief
    * [en]This interface is used to get whether call is enable.
    * [cn]呼叫是否登录上
    * 
    * @synchronized
    * @js:disable
    */
    virtual HWM_BOOL GetCallIsEnable() { return HWM_FALSE; };

    /**
    * @brief
    * [en]This interface is used to get whether rtc conf can be created.
    * [cn]是否可以创建RTC会议
    *
    * @synchronized
    * @js:disable
    */
    virtual HWM_BOOL GetRtcIsEnable() { return HWM_FALSE; };

    /**
    * @brief [en] This interface is used to query doc file lists.
    *        [cn] 查询会议文档信息
    *
    * @param docParam [type:HwmQueryFileListParam*]                   
    * [en] query doc file lists param
    * [cn] 查询文档需要的参数信息
    *
    * @mac:disable
    **/
    virtual SDKERR QueryDocFileList(const HwmQueryFileListParam* docParam) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief [en] This interface is used to delete document.
    *        [cn] 删除会议文档
    *
    * @param deleteParam [type:HwmDeleteFileParam*]                    
    * [en] delete file param
    * [cn] 删除文档需要的参数信息
    *
    * @mac:disable
    **/
    virtual SDKERR DeleteDoc(const HwmDeleteFileParam* deleteParam) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief [en] This interface is used to apply doc operateRight.
    *        [cn] 获取协作权限
    *
    * @param applyDocOperParam [type:HwmApplyDocOperRightParam*]      
    * [en] apply doc operate param
    * [cn] 申请协作权限需要的参数信息
    *
    * @mac:disable
    **/
    virtual SDKERR ApplyDocOperateRight(const HwmApplyDocOperRightParam* applyDocOperParam) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief [en] This interface is used to create folder.
    *        [cn] 创建会议文档文件夹
    *
    * @param confDcoParam [type:HwmCreateFolderParam*]                 
    * [en] conf dco param
    * [cn] 创建会议文档需要的参数信息
    *
    * @mac:disable
    **/
    virtual SDKERR CreateFolder(const HwmCreateFolderParam* confDcoParam) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief [en] This interface is used to set client mode.
    *        [cn] 设置云桌面模式
    *
    * @param clientmode [type:HwmClientMode]                 
    * [en] client mode
    * [cn] 云桌面模式
    *
    * @mac:disable
    * @synchronized
    **/
    virtual SDKERR SetClientMode(HwmClientMode clientmode) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief [en] This interface is used to getting the device resource
    *        [cn] 获取设备资源
    *
    * @mac:disable
    **/
    virtual SDKERR GetDeviceResource() { return SDKERR::UISDK_NOT_SUPPORT_END; };
    /**
    * @brief [en] Default Custom Shared Frame Rate Mode on the Configuration Settings Page.
    *        [cn] 配置设置界面默认自定义共享帧率方式
    *
    * @param enabled [type:HWM_BOOL]                 
    * [en] is enable
    * [cn] 是否启用
    *
    * @param frameRateType [type:HwmShareFrameRateType]
    * [en] share frame rate type
    * [cn] 共享帧率方式
    *
    * @mac:disable
    * @synchronized
    **/
    virtual SDKERR ConfigDefaultShareFrameRate(HWM_BOOL enabled, HwmShareFrameRateType frameRateType) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief [en] This interface is used to query doc access url.
    *        [cn] 获取协作权限
    *
    * @param queryDocAccessUrlParam [type:HwmQueryDocAccessUrlParam*]
    * [en] query doc access url param
    * [cn] 查询文档权限链接参数
    *
    * @mac:disable
    **/
    virtual SDKERR QueryDocAccessUrl(const HwmQueryDocAccessUrlParam* queryDocAccessUrlParam) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief [en] Enable Crash Collection.
    *        [cn] 启用崩溃收集
    * 
    * @synchronized
    * @mac:disable
    **/
    virtual SDKERR EnableCrashCollection() { return SDKERR::UISDK_NOT_SUPPORT_END; }
    
    /**
    * @brief [en] Set Corp Department Info.
    *        [cn] 批量设置用户部门信息
    *
    * @param CorpDepartInfoList [type:HwmSetCorpDepartmentInfoList*]       
    * [en] corp department info list param
    * [cn] 企业部门信息列表参数
    **/
    virtual SDKERR SetCorpDepartmentInfo(const HwmSetCorpDepartmentInfoList* CorpDepartInfoList) { return SDKERR::UISDK_NOT_SUPPORT_END; }


    /**
    * @brief
    * [en]
    * [cn]查询联系人头像
    *
    * @detail
    * [en]
    * [cn]该接口用于查询联系人头像
    *
    * @param avatarParam [type:HwmQueryContactAvatarParam][cs_allowNull:N]
    * [en]
    * [cn]查询联系人头像参数
    *
    * @synchronized
    * @mac:disable
    */
    virtual SDKERR QueryContactAvatar(const HwmQueryContactAvatarParam* avatarParam) { return SDKERR::UISDK_NOT_SUPPORT_END; }


    /**
    * @brief
    * [en]Deinitialize
    * [cn]去初始化
    *
    * @detail
    * [en]
    * [cn]该接口用于清空初始化时设置的回调指针
    *
    * @mac:disable
    */
    virtual SDKERR UnInit() { return SDKERR::UISDK_NOT_SUPPORT_END; };
    
    /**
    * @brief
    * [en]Config UTEvent Public Param
    * [cn]配置打点公共参数
    *
    * @detail
    * [en]
    * [cn]该接口用于配置打点公共参数
    *
    * @param publicParam [type:HwmUTEventPublicParam*][cs_allowNull:N]
    * [en]
    * [cn]打点公共参数
    *
    * @mac:disable
    * @doc:disable
    */
    virtual SDKERR ConfigUTEventPublicParam(const HwmUTEventPublicParam* publicParam) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief
    * [en]Add user track
    * [cn]添加用户打点轨迹
    *
    * @detail
    * [en]
    * [cn]该接口用于用户打点
    *
    * @param trackParam [type:HwmUserTrackParam*][cs_allowNull:N]
    * [en]
    * [cn]用户打点轨迹参数
    *
    * @mac:disable
    * @doc:disable
    */
    virtual SDKERR AddUserTrack(const HwmUserTrackParam* trackParam) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief
    * [en]Start event
    * [cn]打点开始事件
    *
    * @detail
    * [en]
    * [cn]该接口用于记录事件打点开始时间和打点结束事件配套使用统计耗时
    *
    * @param keyInfo [type:HwmEventKeyInfo*][cs_allowNull:N]
    * [en]
    * [cn]事件名称
    *
    * @mac:disable
    * @doc:disable
    */
    virtual SDKERR StartEvent(const HwmEventKeyInfo* keyInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief
    * [en]Finish event
    * [cn]打点结束事件
    *
    * @detail
    * [en]
    * [cn]该接口用于记录事件打点结束时间和打点开始事件配套使用统计耗时
    *
    * @param keyInfo [type:HwmEventKeyInfo*][cs_allowNull:N]
    * [en]
    * [cn]事件名称
    *
    * @param trackParam [type:HwmUserTrackParam*][cs_allowNull:N]
    * [en]
    * [cn]用户打点轨迹参数
    *
    * @mac:disable
    * @doc:disable
    */
    virtual SDKERR FinishEvent(const HwmEventKeyInfo* keyInfo, const HwmUserTrackParam* trackParam) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief
    * [en]Anonymous join conference by signature
    * [cn]安全会议匿名入会
    *
    * @detail
    * [en]
    * [cn]该接口用于公司局WeLink安全会议匿名入会场景
    *
    * @param anonymousSignatureConfInfo [type:HwmAnonymousSignatureConfInfo*][cs_allowNull:N]
    * [en]
    * [cn]安全会议匿名入会参数
    *
    * @mac:disable
    **/
    virtual SDKERR AnonymousJoinConfBySignature(const HwmAnonymousSignatureConfInfo* anonymousSignatureConfInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief
    * [en]Custom UI Configuration
    * [cn]自定义UI配置
    *
    * @detail
    * [en]This interface is used to customize the UI style and interaction.
    * [cn]该接口用于自定义UI样式、交互等
    *
    * @param cfg [type:HwmCustomizedConfig*][cs_allowNull:N]
    * [en]Configuration information.
    * [cn]配置信息
    *
    * @mac:disable
    * @synchronized
    **/
    virtual SDKERR CustomizeConfig(const HwmCustomizedConfig *cfg) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en]Optimize Share Smooth
    * [cn]提升共享流畅度
    *
    * @detail
    * [en]This interface is used to optimize share smooth
    * [cn]该接口用于提升共享流畅度
    *
    * @param cfg [type:HwmOptimizeShareConfig*][cs_allowNull:N]
    * [en]Configuration information.
    * [cn]共享配置参数
    *
    * @mac:disable
    */
    virtual SDKERR OptimizeShareSmooth(const HwmOptimizeShareConfig* cfg) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en]Set indicates enable sparkrtc flag
    * [cn]设置是否支持sparkrtc会议
    *
    * @param enableRtc [type:HWM_BOOL]
    * [en]Indicates enable sparkrtc flag.
    * [cn]是否支持sparkrtc会议
    *
    * @synchronized
    */
    virtual SDKERR SetEnableRtc(HWM_BOOL enableRtc) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is used to apply json config.
    * [cn] 获取json配置
    *
    * @detail
    * [en] This interface is used to apply json config
    * [cn] 该接口用于获取json配置。
    *
    * @param [cs_allowNull:Y]
    *
    * @synchronized
    **/
    virtual SDKERR ApplyObsJsonConfigFromDB() = 0;

    /**
    * @brief
    * [en]Query nonce
    * [cn]请求nonce
    *
    * @detail
    * [en]This interface is used to query nonce
    * [cn]该接口用于请求nonce
    *
    * @mac:disable
    */
    virtual SDKERR QueryNonce() { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is used to break pair link.
    * [cn] 断开配对链路
    *
    * @param pairLinkInfo [type:HwmPairLinkInfo*][cs_allowNull:N]
    * [en] The pair link info
    * [cn] 配对链路信息
    *
    * @doc:disable
    * @mac:transToSync
    * 
    **/
    virtual SDKERR BreakPairLink(const HwmPairLinkInfo* pairLinkInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is modify pair link mode.
    * [cn] 修改配对链路模式,临时/固定
    *
    * @param pairLinkInfo [type:HwmPairLinkInfo*][cs_allowNull:N]
    * [en] The pair link info
    * [cn] 配对链路信息
    *
    * @doc:disable
    * @mac:transToSync
    * 	
    **/
    virtual SDKERR ModifyPairLinkMode(const HwmPairLinkInfo* pairLinkInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is send custom msg to pair link.
    * [cn] 发送自定义消息到配对链路
    *
    * @param customMsg [type:HWM_CHAR*][cs_allowNull:N]
    * [en] The custom msg
    * [cn] 自定义消息
    *
    * @mac:transToSync
    * @doc:disable
    **/
    virtual SDKERR SendCustomMsgToPairLink(const HWM_CHAR* customMsg) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is stop refresh pair verify code
    * [cn] 停止刷新配对验证码
    *
    * @doc:disable
    * @synchronized
    **/
    virtual SDKERR StopRefreshPairVerifyCode() { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en]submit nss survey
    * [cn]提交满意度评价
    *
    * @detail
    * [en]This interface is used to submit nss survey
    * [cn]该接口用于提交满意度评价
    *
    * @param info [type:HwmNssSurveyInfo*][cs_allowNull:N]
    * [en]Nss survey info.
    * [cn]NSS满意度评价信息
    *
    * @js:disable
    * @mac:disable
    */
    virtual SDKERR SubmitNssSurvey(const HwmNssSurveyInfo* info) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en]get conf locked state
    * [cn]获取会议锁定状态
    *
    * @detail
    * [en]This interface is used to get conf locked state
    * [cn]该接口用于获取会议锁定状态
    *
    * @js:disable
    * @mac:disable
    */
    virtual SDKERR GetConfLockedState() { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en]request media separate log
    * [cn]获取媒体分离日志
    *
    * @detail
    * [en]This interface is used to request media separate log.
    * [cn]该接口用于获取媒体分离日志
    *
    * @mac:disable
    */
    virtual SDKERR RequestMediaSeparateLog() { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief [en] This interface is used to get cpu performance level.
    *        [cn] 获取cpu表现性能
    *
    * @doc:disable
    * @mac:disable
    **/
    virtual SDKERR GetCpuPerformanceLevel() { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is used to set custom path.
    * [cn] 设置自定义路径
    *
    * @detail
    * [en]
    * [cn] 该接口用于设置自定义路径。
    *
    * @param customPathInfo [type:HwmCustomPathInfo*]
    * [en] Custom path info
    * [cn] 自定义路径信息
    *
    * @mac:disable
    * @synchronized
    **/
    virtual SDKERR SetCustomPath(const HwmCustomPathInfo* customPathInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is used to end projection.
    * [cn] 结束投屏
    *
    * @detail
    * [en] This interface is used to end projection.
    * [cn] 该接口用于结束投屏。注意事项：1、只能在会议中使用。
    *
    * @param endProjectionParam [type:HwmEndProjectionParam*][cs_allowNull:N]
    * [en] End projection param
    * [cn] 发起投屏的参数体
    *
    * @doc:disable
    **/
    virtual SDKERR EndProjection(const HwmEndProjectionParam* endProjectionParam) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is used to switch projection to conf.
    * [cn] 投屏会议转普通会议
    *
    * @detail
    * [en] This interface is used to switch projection to conf.
    * [cn] 该接口用于投屏会议转普通会议。注意事项：1、只能在会议中使用。
    *
    * @doc:disable
    **/
    virtual SDKERR SwitchProjectionToConf() { return SDKERR::UISDK_NOT_SUPPORT_END; }
	
	/**
    * @brief
    * [en]This interface is used to query version info.
    * [cn]查询版本信息
    *
    * @param versionInfo[cs_allowNull:N]
    * [en]
    * [cn]查询版本请求信息
    * 
    * @js:disable
    */
    virtual SDKERR QueryVersionInfo(const HwmVersionInfo* versionInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en]This class is about init pair server.
    * [cn]初始化配对服务
    *
    * @win:disable
    * @mac:transToSync
    * @js:disable
    */
    virtual SDKERR InitPairServer(const HwmInitPairInfo* pairInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is used to get spes info.
    * [cn] 获取Spes信息
    *
    * @mac:disable
    **/
    virtual SDKERR GetSpesInfo() { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is update external invitees info.
    * [cn] 更新外部邀请者
    *
    **/
    virtual SDKERR UpdateExternalInviteesList(const HwmExternalInviteesInfo* list) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is auto optimize experience.
    * [cn] 开启体验自动优化
    *
    * @mac:disable
    * @synchronized
    **/
    virtual SDKERR AutoOptimizeExperience(const HwmAutoOptimiseInfo* info) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is used to playing the audio file.
    * [cn] 开始播放音频文件
    *
    * @detail
    * [en]
    * [cn] 该接口用于播放音频文件，只支持播放wav文件
    *
    * @param param [type:HwmStartPlayAudioFileParam*]
    * [en] param
    * [cn] 播放音频文件参数
    *
    **/
    virtual SDKERR StartPlayAudioFile(const HwmStartPlayAudioFileParam* audioFileParam) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is used to stop playing audio files.
    * [cn] 停止播放音频文件
    *
    * @detail
    * [en]
    * [cn] 该接口用于停止播放音频文件
    *
    * @synchronized
    */
    virtual SDKERR StopPlayAudioFile() { return SDKERR::UISDK_NOT_SUPPORT_END; }


    /**
    * @brief [en] This interface is config setting window.
    *        [cn] 定制设置界面
    *
    * @param configInfo [type:HwmSettingWindowConfig*]
    * [en] Setting window config info
    * [cn] 设置界面配置信息
    *
    * @doc:disable
    * @mac:disable
    **/
    virtual SDKERR ConfigSettingWindow(const HwmSettingWindowConfig* configInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; }


    /**
    * @brief [en] This interface is used to set cfg client type info.
    *        [cn] 设置配置文件类型
    *
    * @param cfgClientTypeInfo [type:HwmCfgClientTypeInfo*]
    * [en] Cfg Client Type Info
    * [cn] 配置文件类型
    *
    * @doc:disable
    * @mac:disable
    **/
    virtual SDKERR SetCfgClientType(const HwmCfgClientTypeInfo *cfgClientTypeInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is used to set other's number.
    * [cn] 设置其他号码
    *
    **/
    virtual SDKERR SetOtherNumber(const HwmOtherNumberInfo* info) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is set deploy info
    * [cn] 设置部署信息
    *
    * @doc:disable
    **/
    virtual SDKERR SetDeployInfo(const HwmDeployInfo* deployInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; }


    /**
    * @brief
    * [en] This interface is swap screen content in conf
    * [cn] 会中交换屏幕
    *
    * @mac:disable
    **/
    virtual SDKERR SwapScreenContent() { return SDKERR::UISDK_NOT_SUPPORT_END; }


    /**
    * @brief
    * [en] This interface is get screen content swap info in conf
    * [cn] 获取会中屏幕交换信息
    *
    * @mac:disable
    **/
    virtual SDKERR GetScreenContentSwapInfo() { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is set inner http proxy info
    * [cn] 设置内部Http代理信息
    *
    * @doc:disable
    **/
    virtual SDKERR SetInnerHttpProxyInfo(const HwmInnerHttpProxyInfo* innerHttpProxyInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is set meeting custom info
    * [cn] 设置会议自定义信息
    *
    * @doc:disable
    **/
    virtual SDKERR SetMeetingCustomInfo(const HwmMeetingCustomInfo* meetingCustomInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; }

    /**
    * @brief
    * [en] This interface is get JwtToken info.
    * [cn] 本地鉴权token信息
    *
    * @doc:disable
    * @mac:transToSync
    **/
    virtual SDKERR GetJwtToken() { return SDKERR::UISDK_NOT_SUPPORT_END; }
};

END_HWM_UISDK_NAMESPACE
#endif /* __HWM_PRIVATE_UISDK_SERVICE_H__ */


