﻿/**
 * @file HwmUISDKDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] define file.
 *        [cn] 结构体、枚举定义文件
 */

#ifndef _HWM_PRIVATE_UISDK_SERVICE_DEF_H_
#define _HWM_PRIVATE_UISDK_SERVICE_DEF_H_

#include "HwmUISdkCommonDef.h"
#include "HwmBaseMacroDef.h"

BEGIN_HWM_UISDK_NAMESPACE
/**
* [en]This enum is used to describe attendee type
* [cn]弹出窗口类型
*/
typedef enum tagHwmPopupWindowType
{
    NETWORK_CHECK_WND = 0,                                  /**< [en]Network check window
                                                            [cn]网络检测窗口 */
    MEDIA_SETTING_WND,                                      /**< [en]Media setting window
                                                            [cn]音视频设置界面 */
} HwmPopupWindowType;

/**
* [en]Contact department info parameters.
* [cn]联系人部门信息参数
*/
typedef struct tagHwmContactDepartmentInfo
{
    HWM_CHAR departmentName[HWM_MAX_DEPARTMENT_INFO_LEN];       /**< [en]First part of contact department info
                                                            [cn]联系人部门信息 */
    HWM_CHAR expandInfo[HWM_MAX_DEPARTMENT_INFO_LEN];           /**< [en]Second part of contact department info
                                                            [cn]联系人部门信息扩展部分 */
} HwmContactDepartmentInfo;

/**
* [en]Contact department info parameters.
* [cn]设置联系人信息参数
*/
typedef struct tagHwmSetContactInfo
{
    HwmContactDepartmentInfo contactDepartmentInfo;         /**< [en]Contact department info
                                                            [cn]联系人部门信息 */
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];                        /**< [en]Contact sip number
                                                            [cn]联系人号码 */
} HwmSetContactInfo;

/**
* [en]Anonymous join conf by link
* [cn]匿名链接入会需要的信息(新接口，需手机号验证)
*/
typedef struct tagHwmAnonymousVerifyLinkConfInfo
{
    HWM_CHAR siteUrl[HWM_MAX_URL_LEN];                          /**< [en]Server address that parses from links
                                                                     [cn]根据链接解析出的服务器地址 */
    HWM_CHAR random[HWM_MAX_RANDOM_LEN];                        /**< [en]Random num that parses from links
                                                                     [cn]根据链接解析出的随机数 */
    HWM_CHAR name[HWM_MAX_USER_NAME_LEN];                       /**< [en]Join conf name
                                                                     [cn]入会呢称 */
    HWM_CHAR idPrefix[HWM_MAX_CONFID_PREFIX_LEN];               /**< [en]Prefix of site that belongs to conf id
                                                                     [cn]会议id所属站点的前缀 */
    HWM_BOOL isMicOn;                                           /**< [en]Is mic on
                                                                     [cn]是否开启麦克风 */
    HWM_BOOL isCameraOn;                                        /**< [en]Is camera on
                                                                     [cn]是否开启摄像头 */
    HWM_CHAR confId[HWM_MAX_CONF_ID_LEN];                       /**< [en]Conf Id.
                                                                     [cn]会议id, 离线入会时使用 */
    HWM_BOOL isOfflineJoin;                                     /**< [en]Is offline join conf.
                                                                     [cn]是否离线入会 */
} HwmAnonymousVerifyLinkConfInfo;

/**
* [en]Anonymous join conf id info
* [cn]匿名id入会需要的信息(新接口，需手机号验证)
*/
typedef struct tagHwmAnonymousIdConfInfo
{
    HWM_CHAR confId[HWM_MAX_CONF_ID_LEN];                    /**< [en]Conf id
                                                                  [cn]会议id */
    HWM_CHAR password[HWM_MAX_CONF_PASSWORD_LEN];            /**< [en]Conf password
                                                                  [cn]会议密码 */
    HWM_CHAR name[HWM_MAX_USER_NAME_LEN];                    /**< [en]Join conf name
                                                                  [cn]入会呢称 */
    HWM_BOOL isMicOn;                                        /**< [en]Is mic on
                                                                  [cn]是否开启麦克风
                                                                  [cs_allowNull:Y] */
    HWM_BOOL isCameraOn;                                     /**< [en]Is camera on
                                                                  [cn]是否开启摄像头 */
} HwmAnonymousIdConfInfo;

/**
* [en]Check slider and get verify code info
* [cn]校验滑块并获取验证码需要的信息
*/
typedef struct tagHwmCheckSliderAndGetVerifyCodeInfo
{
    HWM_UINT32 pointX;                                    /**< [en]The point of X
                                                            [cn]x坐标点 */
    HWM_INT64 slideTime;                                    /**< [en]Slider time
                                                            [cn]滑动时间 */
} HwmCheckSliderAndGetVerifyCodeInfo;

/**
* [en]Request verify code or slider info
* [cn]请求验证码或获取滑块需要的信息
*/
typedef struct tagHwmRequestVerifyCodeOrGetSliderInfo
{
    HWM_CHAR phoneNumber[HWM_MAX_PHONE_NUM_LEN];                /**< [en]Phone number
                                                            [cn]手机号 */
    HWM_CHAR countryCode[HWM_MAX_COUNTRY_CODE_LEN];             /**< [en]CountryCode
                                                            [cn]国家码 */
} HwmRequestVerifyCodeOrGetSliderInfo;

/**
* [en]This structure is used to describe auto register mode.
* [cn]自动注册模式
*/
typedef enum tagHwmAutoRegisterMode
{
    AUTO_REGISTER_MODE_DISABLED,         /**< [en]Indicates disabled.
                                         [cn]不注册（默认） */
    AUTO_REGISTER_MODE_AUTO,             /**< [en]Indicates auto.
                                         [cn]自动注册 */
    AUTO_REGISTER_MODE_REUSED,           /**< [en]Indicates reused.
                                         [cn]不注册但支持使用已有账号（手机号匹配到的账号） */
}HwmAutoRegisterMode;

/**
* [en]Anonymous join conf by verify code info
* [cn]根据验证码入会需要的信息
*/
typedef struct tagHwmAnonymousJoinConfByVerifyCodeInfo
{
    HWM_CHAR verifyCode[HWM_MAX_VER_CODE_LEN];                  /**< [en]Verify code
                                                            [cn]验证码 */
    HwmAutoRegisterMode autoRegMode;                        /**< [en]This structure is used to describe auto register mode
                                                            [cn]自动注册模式 */
    HWM_BOOL isMicOn;                                        /**< [en]Is mic on
                                                             [cn]是否开启麦克风
                                                             [cs_allowNull:Y] */
    HWM_BOOL isCameraOn;                                     /**< [en]Is camera on
                                                             [cn]是否开启摄像头 */
} HwmAnonymousJoinConfByVerifyCodeInfo;

/**
* [en]Ctd conf attendee info
* [cn]ctd会议与会者信息(入会前)
*/
typedef struct tagHwmCtdConfAttendeeInfo
{
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];                        /**< [en]Indicates number.
                                                                     [cn]号码 */
    HWM_CHAR name[HWM_MAX_USER_NAME_LEN];                       /**< [en]Indicates name.
                                                                     [cn]可选，与会者名称 */
    HWM_CHAR aliasCN[HWM_MAX_DISPLAY_NAME_LEN];                 /**< [en]Indicates chinese alias.
                                                                     [cn]中文别名
                                                                     [cs_allowNull:Y][doc:disable] */
    HWM_CHAR aliasEN[HWM_MAX_DISPLAY_NAME_LEN];                 /**< [en]Indicates english alias.
                                                                     [cn]英文别名
                                                                     [cs_allowNull:Y][doc:disable] */
    HWM_CHAR extendedField[HWM_MAX_EXTENDED_FIELD_LEN];         /**< [en]Indicates extended field.
                                                                     [cn]扩展字段
                                                                     [cs_allowNull:Y] */
    HWM_CHAR email[HWM_MAX_EMAIL_LEN];                          /**< [en]Indicates email.
                                                                     [cn]可选，电子邮箱地址 */
    HWM_CHAR sms[HWM_MAX_PHONE_NUM_LEN];                        /**< [en]Indicates sms.
                                                                     [cn]可选，短信通知手机号码 */
    HWM_CHAR acountId[HWM_MAX_ACCOUNT_LEN];                     /**< [en]Indicates account id.
                                                                     [cn]可选，华为云会议账号 */
    HWM_CHAR userUuid[HWM_MAX_USER_NAME_LEN];                   /**< [en]Indicates user account
                                                                     [cn]与会唯一标识 */
} HwmCtdConfAttendeeInfo;

/**
* [cn]预约ctd会议需要的信息(新内部接口)
*/
typedef struct tagHwmCtdConfInfo
{
    HwmCtdConfAttendeeInfo callerInfo;                      /**< [en]Ctd conf caller info.
                                                                 [cn]ctd会议呼叫者（主持人） */
    HwmCtdConfAttendeeInfo calleeInfo;                      /**< [en]Ctd conf callee info.
                                                                 [cn]ctd会议被呼叫者（普通与会者） */
} HwmCtdConfInfo;

/**
* [en]Avatar Param
* [cn]设置头像参数
*/
typedef struct tagHwmAvatarParam
{
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];                        /**< [en]number
                                                            [cn]号码参数 */
    HWM_CHAR avatarPath[HWM_MAX_FILE_PATH_LEN];                 /**< [en]avatar path
                                                            [cn]头像路径 */
}HwmAvatarParam;

/**
* [en]Number.
* [cn]号码
*/
typedef struct tagHwmNumber
{
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];                        /**< [en]The number
                                                            [cn]号码 */
}HwmNumber;

/**
* [en]Other number info.
* [cn]其他号码信息
*/
typedef struct tagHwmOtherNumberInfo
{
    HWM_UINT32 numberCount;                               /**< [en]The size of numbers
                                                            [cn]号码个数
                                                            [length for numbers] */
    HwmNumber* numbers;                                     /**< [en]The number
                                                            [cn]号码 */
    HWM_CHAR sipNumber[HWM_MAX_NUMBER_LEN];                     /**< [en]The sip number
                                                            [cn]sip号码 */
}HwmOtherNumberInfo;

/**
* [en]Conf settings.
* [cn]会中配置项
*/
typedef enum tagHwmConfSettings
{
    HWM_CONF_SETTINGS_HOWLING_DETECTION,                    /**< [en]Howling
                                                            [cn]啸叫检测开关 */
    HWM_CONF_SETTINGS_ANC,                                  /**< [en]ANC
                                                            [cn]音频降噪开关 */
    HWM_CONF_SETTINGS_BEAUTY,                               /**< [en]Beatuty
                                                            [cn]美颜开关 */
    HWM_CONF_SETTINGS_HIGH_RESOLUTION,                      /**< [en]High Resolution
                                                            [cn]1080P开关 */
    HWM_CONF_SETTINGS_VQE,                                  /**< [en]VQE
                                                            [cn]使用原始语音开关 */
    HWM_CONF_SETTINGS_HIGH_RESOLUTION_SVC_MODE,             /**< [en]High Resolution svc mode
                                                            [cn]高分辨率多流模式开关 */
    HWM_CONF_SETTINGS_PNR,                                  /**< [en]PNR
                                                            [cn]声纹降噪开关 */
} HwmConfSettings;

/**
* [en] Nonce conf info
* [cn] nonce入会参数
*/
typedef struct tagHwmJoinConfByNonceInfo
{
    HWM_CHAR nonce[HWM_MAX_NONCE_LEN];                          /**< [en]nonce
                                                            [cn]随机数 */
    HWM_CHAR confId[HWM_MAX_CONF_ID_LEN];                       /**< [en]Conf id
                                                            [cn]会议id */
    HWM_CHAR password[HWM_MAX_CONF_PASSWORD_LEN];               /**< [en]Conf password
                                                            [cn]会议密码 */
    HWM_CHAR name[HWM_MAX_USER_NAME_LEN];                       /**< [en]Join conf name
                                                            [cn]入会呢称 */
    HWM_BOOL isMicOn;                                        /**< [en]Is mic on
                                                             [cn]是否开启麦克风
                                                             [cs_allowNull:Y] */
    HWM_BOOL isCameraOn;                                     /**< [en]Is camera on
                                                             [cn]是否开启摄像头 */
}HwmJoinConfByNonceInfo;

/**
* [en] Client type
* [cn] 客户端类型
*/
typedef enum tagHwmClientType
{
    CLIENT_WIN = 0,                                   /**< [en]Indicates win.
                                                      [cn]win平台 */
    CLIENT_SMARTROOMS = 8,                            /**< [en]Indicates smartrooms.
                                                      [cn]smartrooms */
    CLIENT_TYPE_BUTT
}HwmClientType;

/**
* [en] Extend conf duration info
* [cn] 延长会议时长信息
*/
typedef struct tagHwmExtendConfDurationInfo
{
    HWM_UINT32 duration;               /**< [en]Duration
                                         [cn]延长会议时长 */
}HwmExtendConfDurationInfo;

/**
* [en] cpu threshold info
* [cn] CPU 阈值信息
*/
typedef struct tagHwmCpuThresholdInfo
{
    HWM_UINT32 above;               /**< [en]above
                                         [cn] */
    HWM_UINT32 belowSlow;           /**< [en]below slow
                                         [cn] */
    HWM_UINT32 belowQuick;          /**< [en]below quick
                                         [cn] */
}HwmCpuThresholdInfo;

/**
 * [en]Account and token auth info.
 * [cn]账号token登录鉴权信息
 */
typedef struct tagHwmAccountAndTokenAuthInfo
{
    HWM_CHAR account[HWM_MAX_USERNAME_LEN];          /**< [en]The account
                                                          [cn]账号 */
    HWM_CHAR token[HWM_MAX_TOKEN_LEN];               /**< [en]The token
                                                          [cn]token */
}HwmAccountAndTokenAuthInfo;

/**
 * [en]Third user info.
 * [cn]第三方用户信息
 */
typedef struct tagHwmThirdUserInfo
{
    HWM_CHAR thirdUserInfoKey[HWM_MAX_THIRD_USER_INFO_KEY_LENGTH]; /**< [en]The third user info key.
                                                                        [cn]第三方用户信息key */
}HwmThirdUserInfo;

/**
 * [en]Join conf info.
 * [cn]会议链接入会信息
 */
typedef struct tagHwmJoinConfByLinkInfo
{
    HWM_CHAR siteUrl[HWM_MAX_URL_LEN];                  /**< [en]Conf link
                                                             [cn]根据链接解析出的服务器地址 */
    HWM_CHAR random[HWM_MAX_CONF_PASSWORD_LEN];         /**< [en]Conf random
                                                             [cn]根据链接解析出的随机数 */
    HWM_CHAR name[HWM_MAX_DISPLAY_NAME_LEN];            /**< [en]name
                                                             [cn]会场名 */
    HWM_CHAR aliasCN[HWM_MAX_DISPLAY_NAME_LEN];         /**< [en]Indicates chinese alias.
                                                             [cn]中文别名
                                                             [cs_allowNull:Y][doc:disable] */
    HWM_CHAR aliasEN[HWM_MAX_DISPLAY_NAME_LEN];         /**< [en]Indicates english alias.
                                                             [cn]英文别名
                                                             [cs_allowNull:Y][doc:disable] */
    HWM_CHAR extendedField[HWM_MAX_EXTENDED_FIELD_LEN]; /**< [en]Indicates extended field.
                                                             [cn]扩展字段
                                                             [doc:disable] */
    HWM_BOOL isMicOn;                                   /**< [en]Is mic on
                                                             [cn]是否开启麦克风
                                                             [cs_allowNull:Y] */
    HWM_BOOL isCameraOn;                                /**< [en]Is camera on
                                                             [cn]是否开启摄像头 */
    HWM_BOOL isSpeakerOff;                              /**< [en]Is speaker off
                                                             [cn]是否关闭扬声器，true关闭扬声器；false不关闭扬声器。
                                                             [cs_allowNull:Y] */
    HWM_CHAR idPrefix[HWM_MAX_CONFID_PREFIX_LEN];       /**< [en]prefix of conf id
                                                             [cn]会议id所属站点的前缀 */
    HWM_CHAR confId[HWM_MAX_CONF_ID_LEN];               /**< [en]Conf Id.
                                                             [cn]会议id, 离线入会时使用 */
    HWM_BOOL isOfflineJoin;                             /**< [en]Is offline join conf.
                                                             [cn]是否离线入会 */
}HwmJoinConfByLinkInfo;

/**
* [en]Capability type.
* [cn]能力类型
*/
typedef enum tagHwmSDKCapabilityType
{
    HWM_SDK_CAPABILITY_SUPPORT_TO_BE_COHOST,            /**< [en]Is support to be cohost.
                                                         [cn]是否支持被设置为联席主持人 */
    HWM_SDK_CAPABILITY_SUPPORT_INVITED_SHARING,         /**< [en]Is support invited sharing.
                                                         [cn]是否支持被邀请共享 */
    HWM_SDK_CAPABILITY_SUPPORT_MOVED_TO_WAITING_ROOM,   /**< [en]Is support moved to waiting room.
                                                         [cn]是否支持被移入等候室 */
    HWM_SDK_CAPABILITY_SUPPORT_INVITED_OPEN_MIC_TIPS,   /**< [en]Is support invited to open the microphone tips.
                                                         [cn]是否支持被邀请打开麦克风提醒，
                                                             设置为不支持时主持人对本端取消静音时直接打开麦克风*/
    HWM_SDK_CAPABILITY_SUPPORT_INVITED_OPEN_CAM,        /**< [en]Is support invited to open/close the camera.
                                                         [cn]是否支持被邀请打开摄像头和关闭摄像头*/
    HWM_SDK_CAPABILITY_SUPPORT_PRIVATE_CHAT,            /**< [en]Is support private chat.
                                                         [cn]是否支持私聊 */
    HWM_SDK_CAPABILITY_SUPPORT_CLIENT_LOCAL_RECORDING,  /**< [en]Is support client local recording.
                                                         [cn]是否支持客户端本地录制，
                                                             设置为不支持时需要同步在Config里面配置隐藏录制按钮*/
    HWM_SDK_CAPABILITY_SUPPORT_ANONYMOUS_USE_PNR,       /**< [en]Is support anonymous use pnr.
                                                         [cn]是否支持匿名用户使用声纹降噪 */
    HWM_SDK_CAPABILITY_SUPPORT_REQUEST_CLOUD_RECORD,    /**< [en]Is support request cloud record.
                                                         [cn]是否支持请求云录制 */
    HWM_SDK_CAPABILITY_SUPPORT_REQUEST_LOCAL_RECORD,    /**< [en]Is support request local record.
                                                         [cn]是否支持请求本地录制 */
    HWM_SDK_CAPABILITY_SUPPORT_ADD_VRBK_IMAGE,          /**< [en]Is support add vrbk image.
                                                             [cn]是否支持添加虚拟背景图 */
    HWM_SDK_CAPABILITY_SUPPORT_WAITING_ROOM_CHAT,       /**< [en]Is support waiting room chat.
                                                             [cn]是否支持等候室聊天 */
    HWM_SDK_CAPABILITY_SUPPORT_COMPLAIN,                /**< [en]Is support complain.
                                                             [cn]是否支持举报 */
    HWM_SDK_CAPABILITY_SUPPORT_P2P_MINI_WINDOW,         /**< [en]Is support p2p mini window.
                                                             [cn]是否支持点对点迷你窗口*/
    HWM_SDK_CAPABILITY_BUTT
} HwmSDKCapabilityType;

/**
* [en]This structure is used to describe the device information.
* [cn]设备信息
*/
typedef struct tagHwmDeviceInfo
{
    HWM_UINT32 index;                               /**< [en]Indicates device index. 
                                                         [cn]设备对应的index */
    HWM_CHAR strName[MAX_DISPLAY_NAME];             /**< [en]Indicates device name. 
                                                         [cn]设备名称 */
    HWM_UINT32 cameraOrient;                        /**< [en]Indicates the camera orient, only the mobile platform camera device has a value. 
                                                         [cn]摄像头角度, 仅移动平台摄像头设备有值 */
    HWM_UINT32 deviceId;                            /**< [en]Indicates device ID used by UI. 
                                                         [cn]设备ID，供UI使用的设备的唯一标识符 */
    HWM_BOOL isUsing;                               /**< [en]Indicates whether the device is using. 
                                                         [cn]设备是否正在使用 */
} HwmDeviceInfo;

/**
* [en]Device list info.
* [cn]设备列表信息
*/
typedef struct tagHwmDeviceListInfo
{
    HwmDeviceType deviceType;               /**< [en] device type
                                                 [cn] 设备类型 */
    HWM_INT32 listLen;                      /**< [en] Length of device info
                                                 [cn] 设备个数
                                                 [length for deviceInfoList] */
    HwmDeviceInfo* deviceInfoList;          /**< [en] Device info
                                                 [cn] 设备信息 */
}HwmDeviceListInfo;

/**
* [en]This enum is used to describe the attendee count type.
* [cn]与会者数量类型
*/
typedef enum tagHwmAttendeeCountType
{
    ATTENDEE_COUNT_TYPE_ATTENDEE,                   /**< [en]Indicates attendee count. [cn]在线与会者列表数量 */
    ATTENDEE_COUNT_TYPE_AUDIENCE,                   /**< [en]Indicates audience count. [cn]观众列表数量 */
    ATTENDEE_COUNT_TYPE_WAITING,                    /**< [en]Indicates waiting count. [cn]等候室列表数量 */
    ATTENDEE_COUNT_TYPE_BUTT
}HwmAttendeeCountType;

/**
* [en]This struct is used to describe the attendee count info.
* [cn]与会者数量
*/
typedef struct tagHwmAttendeeCountInfo
{
    HWM_UINT32 count;                             /**< [en]Indicates count. 
                                                       [cn]数量 */
    HwmAttendeeCountType type;                    /**< [en]Attendee count type. 
                                                       [cn]与会者数量类型 */
}HwmAttendeeCountInfo;

/**
* [en]This structure is used to describe the refresh login result.
* [cn]刷新登录结果
*/
typedef struct tagHwmRefreshLoginResult
{
    HWM_CHAR strUuid[HWM_MAX_DEVICE_UUID_LEN];          /**< [en]Indicates uuid. [cn] 个人统一标识符 */
    HWM_CHAR confToken[HWM_MAX_TOKEN_LEN];              /**< [en]Indicates conf token. [cn] 会议token */
    HWM_INT32 isUsgEnable;                              /**< [en]Indicates isUsgEnable[en] is usg enable. [cn] usg是否可用 */
    HWM_INT32 isCallEnable;                             /**< [en]isCallEnable[en] is call enable [cn] 呼叫是否可用*/
    HWM_INT32 basicCallAbility;                         /**< [en]Indicates has call ability. [cn]是否有点对点呼叫能力 */
} HwmRefreshLoginResult;

/**
* [en]Conf Control type.
* [cn]会控操作类型
*/
typedef enum tagConfCtrlType
{
    CONFCTRL_TYPE_ATTENDEE,                                 /**< [en]Attendee
                                                                 [cn]查看与会者 */
    CONFCTRL_TYPE_LOCK_CONF,                                /**< [en]Lock conf
                                                                 [cn]锁定/解锁会议 */
}ConfCtrlType;

/**
* [en]This struct is used to describe conference control info.
* [cn]会控操作信息
*/
typedef struct tagHwmConfCtrlInfo
{
    ConfCtrlType confCtrlType;                             /**< [en]Indicates conference control type.
                                                                [cn]会控操作类型 */
    HWM_BOOL isOpen;                                       /**< [en] Is open
                                                                [cn] 是否开启 */
}HwmConfCtrlInfo;

/**
* [en]This struct is used to describe conference conflict info.
* [cn]会议冲突信息
*/
typedef struct tagHwmConfConflictInfo
{
    HWM_CHAR conflictConfId[HWM_MAX_CONF_ID_LEN];          /**< [en]Indicates conference id.
                                                       [cn]冲突的会议ID */
    HWM_CHAR conflictConfSubject[HWM_MAX_SUBJECT_LEN];     /**< [en]Indicates conference subject.
                                                       [cn]冲突的会议主题 */
    HWM_CHAR conflictConfOwnerName[HWM_MAX_APPNAME_LEN];   /**< [en]Indicates xxx.
                                                       [cn]预订人 */
    HWM_BOOL isConflictConfOwner;                          /**< [en]Indicates xxx.
                                                       [cn]本人是否是冲突的会议的所有者，如果是，才有权限强制结束冲突会议 */
    HWM_CHAR confId[HWM_MAX_CONF_ID_LEN];                  /**< [en]Indicates conference id.
                                                       [cn]会议id */
    HWM_CHAR confPwd[HWM_MAX_CONF_PASSWORD_LEN];           /**< [en]Indicates conference password.
                                                       [cn]会议密码 */
    HWM_CHAR accessNumber[HWM_MAX_CONF_ACCESS_LEN];        /**< [en]Indicates conference access number.
                                                       [cn]会议接入码 */
    HwmMediaType mediaType;                            /**< [en]Indicates media type
                                                       [cn]媒体类型*/
    HWM_BOOL supportTerminal;                              /**< [en]Indicates whether is support invite Terminal.
                                                       [cn]是否支持邀请硬终端入会 */
}HwmConfConflictInfo;

/**
 * [en]Pair Code.
 * [cn]配对码信息
 */
typedef struct tagHwmPairCodeInfo
{
    HWM_CHAR pairCode[HWM_MAX_NUMBER_LEN];    /**< [en]Pair Code
                                               [cn]配对码 */
    HWM_UINT64 validTime;                     /**< [en]Indicates valid time.
                                               [cn]截止时间 */
}HwmPairCodeInfo;

/**
* [en]Reserved click inject button type.
* [cn]保留的点击注入按钮类型
*/
typedef enum tagHwmReservedClickInjectBtn
{
    HWM_RESERVED_CLICK_INJECT_BTN_CUSTOM_CHECKBOX,      /**< [en]Custom checkbox button
                                                        [cn]自定义复选框按钮 */
    HWM_RESERVED_CLICK_INJECT_BTN_CTD,                  /**< [en]CTD button
                                                        [cn]自动回呼按钮 */
    HWM_RESERVED_CLICK_INJECT_BTN_LANGUAGE,             /**< [en]Language button
                                                        [cn]语言设置按钮 */
    HWM_RESERVED_CLICK_INJECT_BTN_CUSTOM_INPUT,         /**< [en]Custom input button
                                                        [cn]用户自定义输入框按钮 */

    HWM_RESERVED_CLICK_INJECT_BTN_BUTT
} HwmReservedClickInjectBtn;

/**
* [en]Custom checkbox inject info.
* [cn]自定义复选框点击注入信息
*/
typedef struct tagHwmCustomCheckBoxInjectInfo
{
    HWM_BOOL isChecked;                              /**< [en]Is checked
                                                 [cn]是否勾选 */
}HwmCustomCheckBoxInjectInfo;

/**
* [en]CTD button inject info.
* [cn]自动回呼按钮点击注入信息
*/
typedef struct tagHwmCTDBtnInjectInfo
{
    HWM_BOOL isOpen;                                  /**< [en]Is open
                                                  [cn]是否开启 */
    HWM_CHAR defaultNumber[HWM_MAX_PHONE_NUM_LEN];    /**< [en]Default num
                                                  [cn]默认号码 */
    HWM_CHAR customNumber[HWM_MAX_PHONE_NUM_LEN];     /**< [en]Custom num
                                                  [cn]自定义号码 */
    HWM_CHAR callbackNumber[HWM_MAX_PHONE_NUM_LEN];   /**< [en]Callback num
                                                  [cn]回呼号码 */
}HwmCTDBtnInjectInfo;

/**
* [en]Language button inject info.
* [cn]语言按钮点击注入信息
*/
typedef struct tagHwmLanguageBtnInjectInfo
{
    HwmLanguage language;            /**< [en]Language type
                                          [cn]语言类型 */
}HwmLanguageBtnInjectInfo;

/**
* [en]Custom input inject info.
* [cn]自定义输入框点击注入信息
*/
typedef struct tagHwmCustomInputInjectInfo
{
    HWM_CHAR value[MAX_DISPLAY_NAME];     /**< [en]Value of input
                                               [cn]输入框显示的值 */
}HwmCustomInputInjectInfo;

/**
* [en]This struct is used to describe the slider.
* [cn]滑块信息
*/
typedef struct tagHwmSliderParam
{
    HWM_CHAR shadowImageName[HWM_MAX_FILE_PATH_LEN];        /**< [en]Background picture
                                                                 [cn]背景图片 */
    HWM_CHAR sliderImageName[HWM_MAX_FILE_PATH_LEN];        /**< [en]Slider picture
                                                                 [cn]滑块图片 */
    HWM_UINT32 pointY;                                /**< [en]The y-axis position of the slider
                                                                 [cn]滑块的y轴位置 */
}HwmSliderParam;

/**
* [en]login info.
* [cn]token登录返回信息
*/
typedef struct tagHwmLoginByTokenResult
{
    HWM_CHAR userUuid[HWM_MAX_DEVICE_UUID_LEN];     /**< [en]Indicates UUID.
                                                         [cn]UUID(由系统分配的真实的唯一用户标识) */
    HWM_CHAR account[HWM_MAX_ACCOUNT_LEN];          /**< [en]account.
                                                         [cn]账号 */
    HWM_CHAR thirdAccount[HWM_MAX_ACCOUNT_LEN];     /**< [en]third account.
                                                         [cn]第三方账号  */
    HWM_CHAR corpId[HWM_MAX_CORP_ID_LEN];           /**< [en]Indicates corp id.
                                                         [cn]企业ID */
}HwmLoginByTokenResult;

/**
* [en]This enum is used to describe login state
* [cn]登录状态
* @win:disable
*/
typedef enum tagHwmPrivateLoginState
{
    PRIVATE_LOGIN_STATE_UNLOGIN,                   /**< [en]Indicates unLogin.
                                                        [cn]未登录 */
    PRIVATE_LOGIN_STATE_LOGINING,                  /**< [en]Indicates login in progress.
                                                        [cn]登录中 */
    PRIVATE_LOGIN_STATE_LOGINEND,                  /**< [en]Indicates have logined.
                                                        [cn]已登录 */
    PRIVATE_LOGIN_STATE_LOGOUTING                  /**< [en]Indicates logout in progress.
                                                        [cn]退出登录中 */
} HwmPrivateLoginState;

/**
* [en]This structure is used to describe the login info.
* [cn]登录信息
*/
typedef struct tagHwmPrivateLoginStateInfo
{
    HWM_CHAR accessToken[HWM_MAX_DEVICE_UUID_LEN];          /**< [en]Indicates uuid.
                                                                 [cn] 个人统一标识符 */
} HwmPrivateLoginStateInfo;

/**
* [en]Device volume info.
* [cn]设备音量信息
*/
typedef struct tagHwmDeviceVolumeInfo
{
    HwmDeviceType deviceType;                 /**< [en] Device type
                                                   [cn] 设备类型 */
    HWM_UINT32 volume;                        /**< [en] Volume
                                                   [cn] 设备音量 */
} HwmDeviceVolumeInfo;

/**
* [en]Conf settings info.
* [cn]会议设置信息
*/
typedef struct tagHwmConfSettingsInfo
{
    HwmConfSettings confSettings;               /**< [en] Conf settings
                                                     [cn] 会中配置项 */
    HWM_BOOL isOpen;                            /**< [en] Is open
                                                     [cn] 是否开启 */
} HwmConfSettingsInfo;

/**
* [en]This struct is used to describe query doc dictionary info<br>
* [cn]查询文档结果
*/
typedef struct tagHwmDocFileInfo
{
    HWM_INT64   fileId;                           /**< [en]Indicates limit fileId. [cn]文件id  */
    HWM_CHAR    fileGuid[HWM_MAX_CONF_UUID_LEN];  /**< [en]Indicates file guid. [cn]文件guid  */
    HWM_CHAR    name[HWM_MAX_NAME_LEN];           /**< [en]Indicates file or dic name. [cn]文件/文件夹名字 */
    HWM_INT64   parentId;                         /**< [en]Indicates limit fileId. [cn]parent文件id  */
}HwmDocFileInfo;

/**
* [en]This struct is used to describe query doc dictionary info lists<br>
* [cn]查询文档结果列表
*/
typedef struct tagHwmDocFileInfolist
{
    HWM_UINT32  listLen;                           /**< [en]Indicates list len. [cn]列表长度[length for docFileInfo]  */
    HwmDocFileInfo*  docFileInfo;                  /**< [en]Indicates docFileInfo. [cn]文档信息  */
}HwmDocFileInfolist;

/**
* [en]This struct is used to describe query doc dictionary result<br>
* [cn]申请协作权限
*/
typedef struct tagHwmApplyDocOperRightResult
{
    HWM_CHAR        tempAccessUrl[HWM_MAX_URL_LEN];            /**< [en]Indicates tempAccessUrl. [cn]临时授权访问url**/
}HwmApplyDocOperRightResult;


/**
* [en]
* [cn]文档服务对接服务信息
*/
typedef enum tagHwmDocServerType
{
    HWM_DOC_SHIMO_SERVER = 0                 /**< [en]xxxx. [cn]石墨文档服务 */
}HwmDocServerType;

typedef enum tagHwmQueryDocType
{
    HWM_QUERY_DOC_USED = 0,    /**< [en]Indicates used.   [cn]最近使用  */
    HWM_QUERY_DOC_UPDATED,     /**< [en]Indicates update. [cn]最近更新  */
    HWM_QUERY_DOC_Created,     /**< [en]Indicates create by myself. [cn]自己创建的  */
    HWM_QUERY_DOC_SHARED,      /**< [en]Indicates shared to me. [cn]共享给我的  */
}HwmQueryDocType;

/**
* [en]This struct is used to describe query doc dictionary info<br>
* [cn]查询文档
*/
typedef struct tagHwmQueryFileListParam
{
    HwmDocServerType   serverType;                     /**< [en]Indicates doc server type. [cn]文档服务类型 */
    HWM_CHAR           folder[HWM_MAX_CONF_UUID_LEN];  /**< [en]Indicates father file. [cn]父级文件夹id  */
    HWM_UINT32         limit;                          /**< [en]Indicates limit file number. [cn]文件数目，非必填  */
    HWM_INT64          lastTimeStamp;                  /**< [en]Indicates limit file before lastTimeStamp. [cn]时间戳，非必填 表示这次只查询这个时间戳之前的文件  */
    HwmQueryDocType    queryDocType;                   /**< [en]Indicates limit file number. [cn]文件数目，非必填  */
}HwmQueryFileListParam;


/**
* [en]This struct is used to describe query doc dictionary info<br>
* [cn]删除文档
*/
typedef struct tagHwmDeleteFileParam
{
    HwmDocServerType   serverType;                     /**< [en]Indicates doc server type. [cn]文档服务类型 */
    HWM_CHAR           docGuid[HWM_MAX_CONF_UUID_LEN]; /**< [en]Indicates file guid. [cn]文件或文件夹guid  */
}HwmDeleteFileParam;

/**
* [en]This struct is used to describe create doc dictionary info<br>
* [cn]申请权限用户类型
*/
typedef enum tagHwmApplyDocIdentityType
{
    HWM_QUERY_OPER_USER_APP = 0,    /**< [en]Indicates used.   [cn]用户app  */
    HWM_QUERY_OPER_USER_TMP,        /**< [en]Indicates update. [cn]临时使用  */
}HwmApplyDocIdentityType;

/**
* [en]This struct is used to describe query doc dictionary info<br>
* [cn]申请协作权限
*/
typedef struct tagHwmApplyDocOperRightParam
{
    HWM_UINT32      appType;                                /**< [en]Indicates app type. [cn]appType 石墨填0  */
    HWM_CHAR        confId[HWM_MAX_CONF_ID_LEN];            /**< [en]Indicates conference id. [cn]会议id**/
    HwmApplyDocIdentityType    requesterIdentity;           /**< [en]Indicates requesterIdentity. [cn]0-应用用户申请，1-临时用户申请  */
}HwmApplyDocOperRightParam;

/**
* [en]This struct is used to describe doc permission type<br>
* [cn] 文档权限类型
*/
typedef enum tagHwmDocPermissionType
{
    HWM_DOC_PERMISSION_READER = 0,     /**< [en]Indicates reader.   [cn]reader  */
    HWM_DOC_PERMISSION_EDITOR,         /**< [en]Indicates editor. [cn]editor  */
    HWM_DOC_PERMISSION_COMMENTATOR     /**< [en]Indicates editor. [cn]commentator  */
}HwmDocPermissionType;

/**
* [en]This struct is used to describe create conf doc info<br>
* [cn]创建会议关联文档或者单独文档
*/
typedef struct tagHwmCreateFolderParam
{
    HWM_CHAR        confId[HWM_MAX_CONF_ID_LEN];            /**< [en]Indicates conference id. [cn]会议id**/
    HwmDocPermissionType  permissionType;                   /**< [en]Indicates doc permission. [cn]文档权限**/
    HWM_CHAR        name[HWM_MAX_NAME_LEN];                 /**< [en]Indicates file or dic name. [cn]文件夹名字 */
}HwmCreateFolderParam;

/**
* [en]cloud desktop mode.
* [cn]云桌面模式
*/
typedef enum tagClientMode
{
    CLIENT_DEFAULT,
    CLIENT_CLOUD_DESKTOP
}HwmClientMode;

/**
* [en]concurrent resources.
* [cn]并发资源
*/
typedef struct tagHwmConcurrentResource
{
    HWM_BOOL isValid;                                           /**< [en]is valid
                                                                [cn]是否有效 */
    HWM_CHAR expireDate[HWM_MAX_EXPIRE_DATE_LEN];               /**< [en]expire date
                                                                [cn]截止时间 */
}HwmConcurrentResource;

/**
* [en]vmr resource
* [cn]vmr会议资源
*/
typedef struct tagHwmVmrResource
{
    HWM_BOOL    isValid;                                        /**< [en]is valid
                                                                [cn]是否有效 */
    HWM_CHAR    vmrId[HWM_MAX_VMR_ID_LEN];                      /**< [en]vmrid
                                                                [cn]vmrid */
    HWM_CHAR    vmrConfId[HWM_MAX_VMR_CONF_ID_LEN];             /**< [en]vmr conf id
                                                                [cn]vmr会议id */
    HWM_CHAR    expireDate[HWM_MAX_EXPIRE_DATE_LEN];            /**< [en]expire date
                                                                [cn]截止时间 */
    HWM_CHAR    guestPwd[HWM_MAX_CONF_PASSWORD_LEN];            /**< [en]guest password
                                                                [cn]来宾密码 */
    HWM_INT32   maxParties;                                     /**< [en]max parties
                                                                [cn]并发方数 */
    HWM_INT32   duration;                                       /**< [en]duration
                                                                [cn]持续时间(分钟, 最大1440), 0-不限制*/
    HWM_INT32   status;                                         /**< [en]status
                                                                [cn]0-正常状态 1-停用状态 2-已到期 */
}HwmVmrResource;

/**
* [en]access resource
* [cn]接入账号资源
*/
typedef struct tagHwmAccessAccountResource
{
    HWM_INT32   status;                                         /**< [en]status
                                                                [cn]0-正常状态 1-停用状态 */
    HWM_CHAR    expireDate[HWM_MAX_EXPIRE_DATE_LEN];            /**< [en]expire date
                                                                [cn]截止时间 */
}HwmAccessAccountResource;

/**
* [en]device resource
* [cn]设备资源
*/
typedef struct tagHwmDeviceResource
{
    HwmConcurrentResource concurrentResource;              /**< [en]concurrent resources
                                                        [cn]并发资源 */
    HwmVmrResource vmrResource;                            /**< [en]vmr resource
                                                        [cn]vmr会议资源, 可能是免费配送, 也可能是商用资源 */
    HwmAccessAccountResource accessAccountResource;        /**< [en]access account resource
                                                        [cn]接入账号资源 */
    HWM_BOOL    isResourceExpireNotify;                 /**< [en]is resource expire notify
                                                        [cn]资源过期是否提醒, false: 不提醒 true: 即将到期提醒 */
    HWM_INT32   resourceStatus;                         /**< [en]resource status
                                                        [cn]0-正常状态 1-只能加入会议（接入正常，无并发、vrm资源） 2-完全停用状态 */
    HWM_BOOL    isEnableShareVmr;                       /**< [en]is shard vmr notify
                                                        [cn]共享vmr */
}HwmDeviceResource;

/**
* [en]Default Sharing Frame Rate Options
* [cn]默认共享帧率选项
*/
typedef enum tagHwmShareFrameRateType
{
    SHARE_FRAME_RATE_30,                                /**< [en]set to 30 fps
                                                             [cn]默认帧率设置为30帧/秒 */
    SHARE_FRAME_RATE_20,                                /**< [en]set to 20 fps
                                                             [cn]默认帧率设置为20帧/秒 */
    SHARE_FRAME_RATE_15,                                /**< [en]set to 15 fps
                                                             [cn]默认帧率设置为15帧/秒 */
    SHARE_FRAME_RATE_10,                                /**< [en]set to 10 fps
                                                             [cn]默认帧率设置为10帧/秒 */
    SHARE_FRAME_RATE_5,                                /**< [en]set to 5 fps
                                                             [cn]默认帧率设置为5帧/秒 */
    SHARE_FRAME_RATE_1,                                /**< [en]set to 1 fps
                                                             [cn]默认帧率设置为1帧/秒 */
}HwmShareFrameRateType;

/**
* [en]This struct is used to describe query doc access url<br>
* [cn]查询文档链接参数
*/
typedef struct tagHwmQueryDocAccessUrlParam
{
    HWM_CHAR           confId[HWM_MAX_CONF_ID_LEN];                  /**< [en]Indicates conference id. [cn]会议id**/
    HWM_BOOL           isCollaborator;                               /**< [en]Indicates is collaborator. [cn]是否有协作权限 */
    HWM_CHAR           folderGuid[HWM_MAX_CONF_UUID_LEN];            /**< [en]Indicates folder guid. [cn]文件夹id **/
    HwmDocPermissionType  permissionType;                            /**< [en]Indicates doc permission. [cn]文档权限 获取不到填1**/
    HWM_UINT32         appType;                                      /**< [en]Indicates app type. [cn]appType 石墨填0  **/
}HwmQueryDocAccessUrlParam;

/**
* [en]This struct is used to describe query doc access url result<br>
* [cn]查询文档链接结果
*/
typedef struct tagHwmQueryDocAccessUrlResult
{
    HWM_CHAR        docAccessUrl[HWM_MAX_URL_LEN];            /**< [en]Indicates doc access url. [cn]文档权限链接**/
    HWM_CHAR        folderGuid[HWM_MAX_NAME_LEN];             /**< [en]Indicates folder guid. [cn]文件夹id**/
}HwmQueryDocAccessUrlResult;

/**
* [en]This struct is used to query corp department info<br>
* [cn]批量查询企业部门信息参数
*/
typedef struct tagHwmQueryCorpDepartmentInfoParam
{
    HWM_CHAR            userUuid[HWM_MAX_DEVICE_UUID_LEN];              /**< [en]user uuid. [cn]用户uuid **/
    HWM_CHAR            sipNumber[HWM_MAX_NUMBER_LEN];                  /**< [en]sipNumber [cn]sip号,跨企业场景下优先使用此字段 **/
}HwmQueryCorpDepartmentInfoParam;

/**
* [en]This struct is used to query corp department info<br>
* [cn]批量查询企业部门信息参数列表
*/
typedef struct tagHwmQueryCorpDepartmentInfoParamList
{
    HWM_UINT32                           queryParamLen;       /**< [en]The size of queryParamList
                                                                   [cn]请求参数列表长度
                                                                   [length for queryParamList] */
    HwmQueryCorpDepartmentInfoParam*     queryParamList;      /**< [en]query corp user info param.
                                                                   [cn]请求部门信息列表 **/
}HwmQueryCorpDepartmentInfoParamList;

/**
* [en]This enumeration is used to describe number hide type.
* [cn]号码隐藏类型
*/
typedef enum tagHwmNumberHideType
{
    SHOW_NUMBER = 1,                         /**< [en]Indicates show number.
                                                  [cn]显示号码 */
    HIDE_NUMBER,                             /**< [en]Indicates hide number.
                                                  [cn]隐藏号码 */
    SAFE_NUMBER                              /**< [en]Indicates safe number.
                                                  [cn]打码号码 */
}HwmNumberHideType;

/**
* [en]This struct is used to describe set corp department info<br>
* [cn]设置企业部门信息
*/
typedef struct tagHwmSetCorpDepartmentInfo
{
    HWM_UINT32               userNumberCount;                   /**< [en]The size of userNumber
                                                                     [cn]号码个数
                                                                     [length for userNumber]
                                                                     [mac:disable] */
    HwmNumber*               userNumber;                        /**< [en]User number.
                                                                     [cn]用户其他号码
                                                                     [mac:disable] */
    HwmNumberHideType  hideType;                                /**< [en]Hide type.
                                                                     [cn]隐藏类型 */
    HWM_CHAR departmentInfo[HWM_MAX_APP_WND_TITLE_LEN];         /**< [en]Department info.
                                                                     [cn]部门信息 */
    HWM_CHAR sipNumber[HWM_MAX_NUMBER_LEN];                     /**< [en]Sip Number.
                                                                     [cn]sip号码 */
    HWM_CHAR name[HWM_MAX_NAME_LEN];                            /**< [en]name.
                                                                     [cn]用户名 */
    HWM_CHAR mobile[HWM_MAX_PHONE_NUM_LEN];                     /**< [en]mobile.
                                                                     [cn]手机号码 */
}HwmSetCorpDepartmentInfo;

/**
* [en]This struct is used to describe set corp department info<br>
* [cn]设置企业部门信息列表
*/
typedef struct tagHwmSetCorpDepartmentInfoList
{
    HWM_UINT32                     departInfoLen;               /**< [en]The length of departInfoList
                                                                     [cn]部门信息列表个数
                                                                     [length for departInfoList] */
    HwmSetCorpDepartmentInfo*      departInfoList;              /**< [en]User number.
                                                                     [cn]部门信息列表 */
}HwmSetCorpDepartmentInfoList;

/**
* [en]This struct is used to describe query avatar param
* [cn]查询联系人头像参数
*/
typedef struct tagHwmQueryContactAvatarParam
{
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];                    /**< [en]number
                                                                 [cn]号码
                                                                 [cs_allowNull:N] */
    HWM_CHAR userUuid[HWM_MAX_DEVICE_UUID_LEN];              /**<[en]Indicates UUID
                                                                 [cn]UUID(由系统分配的真实的唯一用户标识) 
                                                                 [cs_allowNull:N] */
} HwmQueryContactAvatarParam;

/**
* [en]This structure is used to describe the query avatar result info.
* [cn]查询头像结果参数
*/
typedef struct tagHwmContactAvatarInfo
{
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];                    /**< [en]number
                                                                 [cn]号码 */
    HWM_CHAR thirdUserId[HWM_MAX_USER_ID_LEN];              /**< [en]The third user id
                                                                 [cn]三方账号 */
    HWM_CHAR userUuid[HWM_MAX_DEVICE_UUID_LEN];              /**<[en]Indicates UUID
                                                                 [cn]UUID(由系统分配的真实的唯一用户标识) */
    HWM_CHAR avatarPath[HWM_MAX_FILE_PATH_LEN];             /**< [en]avatar path
                                                                 [cn]头像路径 */
} HwmContactAvatarInfo;


/**
* [en]Ut event public param.
* [cn]打点公共参数
*/
typedef struct tagHwmUTEventPublicParam
{
    HWM_CHAR version[HWM_MAX_VERSION_LEN];             /**< [en]Indicates the software version.
                                                            [cn]终端软件版本号
                                                            [cs_allowNull:Y][cs_length:1-16] */
    HWM_CHAR appId[HWM_MAX_APPID_LEN];                 /**< [en]Indicates the app id.
                                                            [cn]应用标识，服务器提供平台绑定应用，目前服务器暂不支持，所以暂时填充应用名称，具体为：应用名称 华为会议设置为CloudLink、workplace这边设置为WeLink、opensdk集成使用集成商提供的名称+SDK类型 例如：正集源OKODM：AndroidNativeSDK, AndroidUISDK, iOSNativeSDK, iOSUISDK, WindowsNativeSDK, WindowsUISDK, WebSDK
                                                            [cs_allowNull:Y][cs_length:1-64] */
    HWM_CHAR osName[HWM_MAX_OPERATE_SYSTEM_NAME_LEN];  /**< [en]Indicates the operate system name.
                                                            [cn]系统名称
                                                            [cs_allowNull:Y][cs_length:1-16] */
    HWM_CHAR tenantId[HWM_MAX_TENANT_ID_LEN];          /**< [en]Indicates the tenant ID.
                                                            [cn]租户id，用于welink
                                                            [cs_allowNull:Y][cs_length:1-256] */
    HWM_CHAR channelId[HWM_MAX_DEVICE_ID_LEN];         /**< [en]Indicates the channel ID.
                                                            [cn]渠道id
                                                            [cs_allowNull:Y][cs_length:1-128] */
}HwmUTEventPublicParam;


/**
* [en]User track param.
* [cn]用户打点轨迹参数
*/
typedef struct tagHwmUserTrackParam
{
    HWM_CHAR eventId[HWM_MAX_EVENT_ID_LEN];             /**< [en]Indicates the event ID.
                                                             [cn]预定义的事件ID
                                                             [cs_allowNull:N][cs_length:1-16] */
    HWM_CHAR arg1[HWM_MAX_ARG1_LEN];                    /**< [en]Indicates the first argument.
                                                             [cn]单个事件中需要快速提取进行统计的字段(需要各个打点事件根据实际情况使用，不一定需要用到)
                                                             [cs_allowNull:Y][cs_length:0-256] */
    HWM_CHAR arg2[HWM_MAX_ARG2_LEN];                    /**< [en]Indicates the second argument.
                                                             [cn]单个事件中需要快速提取进行统计的字段(需要各个打点事件根据实际情况使用，不一定需要用到)
                                                             [cs_allowNull:Y][cs_length:0-256] */
    HWM_CHAR arg3[HWM_MAX_ARG3_LEN];                    /**< [en]Indicates the third argument.
                                                             [cn]单个事件中需要快速提取进行统计的字段(需要各个打点事件根据实际情况使用，不一定需要用到)
                                                             [cs_allowNull:Y][cs_length:0-256] */
    HWM_CHAR args[HWM_MAX_ARG_LEN];                     /**< [en]Indicates the other argument.
                                                             [cn]事件中其他字段，内容为json体,key跟value自定义(需要各个打点事件根据实际情况使用，不一定需要用到)
                                                             [cs_allowNull:Y][cs_length:0-8192] */
    HWM_UINT32 maxIntervalMs;                           /**< [en]max interval for finishEvent.
                                                             [cn]统计时长的最大时间间隔，单位为毫秒，FinishEvent传递该值，如果统计超过该时间间隔则不打点 */
}HwmUserTrackParam;


/**
* [en]event key info.
* [cn]打点事件 key 信息
*/
typedef struct tagHwmEventKeyInfo
{
    HWM_CHAR eventName[HWM_MAX_EVENT_NAME_LEN];         /**< [en]Indicates the event name.
                                                             [cn]事件名称
                                                             [cs_allowNull:N][cs_length:1-256] */
}HwmEventKeyInfo;

/**
* [en]app auth info.
* [cn]App鉴权信息
*/
typedef struct tagHwmAppAuthInfo
{
    HWM_CHAR corpId[HWM_MAX_CORP_ID_LEN];          /**< [en]Corporation Id
                                                        [cn]企业Id*/
    HWM_CHAR userId[HWM_MAX_USER_ID_LEN];          /**< [en]user id.
                                                        [cn]用户ID */
    HWM_CHAR signature[HWM_MAX_SIGNATURE_LEN];     /**< [en]The signature
                                                        [cn]鉴权信息 */
    HWM_CHAR nonce[HWM_APPID_NONCE_LEN];           /**< [en]The nonce
                                                        [cn]随机字符串，用于计算鉴权信息 */
    HWM_INT64 expireTime;                          /**< [en]The expire time(s)
                                                        [cn]鉴权信息时间戳（s） */
}HwmAppAuthInfo;

/**
* [en]Anonymous join conf by signature info.
* [cn]安全会议匿名入会需要的信息
*/
typedef struct tagHwmAnonymousSignatureConfInfo
{
    HWM_CHAR confId[HWM_MAX_CONF_ID_LEN];                /**< [en]Conf id
                                                              [cn]会议id */
    HWM_CHAR password[HWM_MAX_CONF_PASSWORD_LEN];        /**< [en]Conf password
                                                              [cn]会议密码 */
    HWM_CHAR confRandom[HWM_MAX_RANDOM_LEN];             /**< [en]Indicates conference random.
                                                              [cn]会议随机数，用于直接使用会议随机数入会，等同于会议ID+会议密码，公司局快速匿名入会场景使用 */
    HWM_CHAR name[HWM_MAX_DISPLAY_NAME_LEN];             /**< [en]name
                                                              [cn]会场名 */
    HWM_CHAR aliasCN[HWM_MAX_DISPLAY_NAME_LEN];          /**< [en]Indicates chinese alias.
                                                              [cn]中文别名
                                                              [cs_allowNull:Y][doc:disable] */
    HWM_CHAR aliasEN[HWM_MAX_DISPLAY_NAME_LEN];          /**< [en]Indicates english alias.
                                                              [cn]英文别名
                                                              [cs_allowNull:Y][doc:disable] */
    HWM_CHAR extendedField[HWM_MAX_EXTENDED_FIELD_LEN];  /**< [en]Indicates extended field.
                                                              [cn]扩展字段
                                                              [doc:disable] */
    HWM_BOOL isCloseSpk;                                 /**< [en]is close loudspeaker
                                                              [cn]是否关闭扬声器 */
    HwmAppAuthInfo appAuthInfo;                          /**< [en]app auth info
                                                              [cn]app鉴权信息 */
}HwmAnonymousSignatureConfInfo;

/**
* [en]This enumeration is used to describe domain mode.
* [cn]域名模式
*/
typedef enum tagHwmServerDomainStrategyMode
{
    SERVER_DOMAIN_STRATEGY_MODE_COM = 0,                         /**< [en]Indicates server domain com strategy. [cn]COM模式 */
    SERVER_DOMAIN_STRATEGY_MODE_CN,                              /**< [en]Indicates server domain cn strategy. [cn]CN模式 */
}HwmServerDomainStrategyMode;

/**
* [en]This structure is used to describe the domain.
* [cn]域名模式信息
*/
typedef struct tagHwmServerDomainStrategy
{
    HwmServerDomainStrategyMode mode;                            /**< [en]Indicates the server domain strategy. [cn]域名模式 */
}HwmServerDomainStrategy;

/**
* [en]This structure is used to describe the domain.
* [cn]录制提示定制
* @mac:disable
*/
typedef struct tagHwmRecordingConfirm {
    HWM_INT32 action;   /**< [en]Actions: 1 I know; 2 Leave the meeting. [cn]执行动作：1 我知道了；2 离开会议 */
    HWM_INT32 timeout;  /**< [en]Automatic shutdown time (s). < = 0: The automatic shutdown is not enabled. [cn]自动关闭时间 s，<=0 不自动关闭 */
} HwmRecordingConfirm;

/**
* [en]Value of diminish message box.
* [cn]弹窗削减类型
*/
typedef enum
{
    MSGBOX_DIMINISHED_NONE,     /**< [en]Donot diminish. [cn]不削减 */
    MSGBOX_DIMINISHED_NORMAL,   /**< [en]As Normal. [cn]普通 */
} MsgboxDiminishType;

/**
* [en]Config diminish message box.
* [cn]弹窗削减配置
*/
typedef struct tagHwmMsgboxDiminish
{
    MsgboxDiminishType type;    /**< [en]Message Box Diminish Type. [cn]削减类型 */

    HWM_INT32 timeout;          /**< [en]Automatic shutdown time (s). < = 0: The automatic shutdown is not enabled. [cn]自动关闭时间 s，<=0 不自动关闭 */

} HwmMsgboxDiminish;

/**
* [en]Config toast.
* [cn]Toast提示配置
*/
typedef struct tagHwmToastOption
{
    HWM_BOOL isHide;    /**< [en]Is hide. [cn]是否隐藏 */
} HwmToastOption;


/**
* [en]Config small window of float mode.
* [cn]悬浮视图小窗配置
*/
typedef struct tagHwmFloatSmallWnd
{
    HWM_BOOL isDefaultCollapsed;    /**< [en]Is default collapsed. [cn]是否默认收起 */
} HwmFloatSmallWnd;

/**< [en]Interaction Custom Mask. [cn] 交互定制掩码 */
typedef enum {
    MASK_RECORDINGCONFIRM = 1 << 0,                 /**< [en]Customizing Using Recording Prompts [cn]使用录制提示定制 */
    MASK_MSGBOX_DIMINISH = 1 << 1,                  /**< [en]Customizing Using Message Box Diminish Configuration. [cn]使用弹窗削减配置 */
    MASK_TOAST_OPTION = 1 << 2,                     /**< [en]Customizing Using Toast Configuration. [cn]使用Toast提示配置 */
    MASK_FLOAT_SMALL_WND = 1 << 3,                  /**< [en]Customizing Using Small Window of Float Mode Configuration. [cn]使用悬浮窗视图小窗配置 */
} HwmInteractionMask;

/**
* [en]This structure is used to describe the domain.
* [cn]交互定制
*/
typedef struct tagHwmInteraction {
    HwmInteractionMask mask;                        /**< [en]Custom Function Mask [cn]定制功能掩码 */
    HwmRecordingConfirm recordingConfirm;           /**< [en]Recording Tips. [cn]录制提示 */
    HwmMsgboxDiminish msgboxDiminish;               /**< [en]Message Box Diminish Configuration. [cn]弹窗削减配置 */
    HwmToastOption toastOption;                     /**< [en]Toast Option Configuration. [cn]Toast提示配置 */
    HwmFloatSmallWnd floatSmallWnd;                 /**< [en]Small Window of Float Mode Configuration. [cn]悬浮视图小窗配置 */
} HwmInteraction;


/**
* [en]This structure is used to describe the domain.
* [cn]自定义信息
* @mac:disable
*/
typedef struct tagHwmCustomizedConfig
{
    HwmInteraction interaction; /**< [en]Customized interaction information. [cn]定制的交互信息 */
}HwmCustomizedConfig;

/**
* [en]This enum is used to describe audio quality level
* [cn]音频质量等级
* @mac:disable
*/
typedef enum tagHwmAudioQualityLevel
{
    AUDIO_QUALITY_NORMAL = 0,                           /**< [en]Indicates normal value
                                                             [cn]默认值。音频质量正常或没有音频信息*/
    AUDIO_QUALITY_NOT_GOOD,                             /**< [en]Indicates audio quality not good
                                                             [cn]音频质量不好 */
    AUDIO_QUALITY_BAD,                                  /**< [en]Indicates audio quality bad
                                                             [cn]音频质量较差 */
    AUDIO_QUALITY_VERY_BAD                              /**< [en]Indicates audio quality very bad
                                                             [cn]音频质量非常差 */
}HwmAudioQualityLevel;

/**
* [en]This struct is used to describe conference audio quality info.
* [cn]音频质量信息
* @mac:disable
*/
typedef struct tagAudioQualityInfo
{
    HwmAudioQualityLevel sendQuality;                           /**< [en]Indicates sender quality. [cn]发送端质量 */
    HwmAudioQualityLevel recvQuality;                           /**< [en]Indicates receiving terminal quality. [cn]接收端质量 */
}AudioQualityInfo;

/**
* [en]Proxy account info.
* [cn]代理账号信息
*/
typedef struct tagHwmProxyAccountInfo
{
    HWM_CHAR account[HWM_MAX_USERNAME_LEN];              /**< [en]The account
                                                              [cn]代理账号 */
    HWM_CHAR password[HWM_MAX_PASSWORD_LEN];             /**< [en]The password
                                                              [cn]代理密码 */
}HwmProxyAccountInfo;

/**
* [en]Scan join conf result info.
* [cn]扫码入会结果信息
*/
typedef struct tagHwmScanJoinConfResult
{
    HWM_CHAR signature[HWM_MAX_SIGNATURE_LEN];          /**< [en]Indicates signature string. [cn]签名串 */
    HWM_CHAR confId[HWM_MAX_CONF_ID_LEN];               /**< [en]Indicates conference id. [cn]会议id */
    HWM_CHAR password[HWM_MAX_CONF_PASSWORD_LEN];       /**< [en]Indicates conference password. [cn]会议密码 */
}HwmScanJoinConfResult;

/**
* [en]This structure is used to describe custom thread type.
* [cn]自定义线程类型
* @mac:disable
*/
typedef enum tagHwmCustomThreadType
{
    HWM_CUSTOM_THREAD_OFF = 0,      /**< [en]Indicates custom thread off
                                         [cn]关闭自定义线程 */
    HWM_CUSTOM_THREAD_ON = 1        /**< [en]Indicates custom thread on
                                         [cn]开启自定义线程 */
}HwmCustomThreadType;

/**
* [en]This structure is used to describe data conf thread info.
* [cn]数据会议线程信息
* @mac:disable
*/
typedef struct tagHwmDataConfThreadInfo
{
    HWM_UINT32 threadNum;                    /**< [en]Indicates thread num.
                                                  [cn]线程数，目前仅支持2至4线程，建议设置为2，数值越大，流畅度越高、性能消耗越大
                                                  [cs_allowNull:N] */
    HwmCustomThreadType customThreadType;    /**< [en]custom thread type.
                                                  [cn]自定义线程类型
                                                  [cs_allowNull:N] */
}HwmDataConfThreadInfo;

/**
* [en]This structure is used to describe optimize share config.
* [cn]共享配置参数
* @mac:disable
*/
typedef struct tagHwmOptimizeShareConfig
{
    HwmDataConfThreadInfo threadInfo;        /**< [en]DataConfThreadInfo.
                                                  [cn]线程信息
                                                  [cs_allowNull:N]*/
}HwmOptimizeShareConfig;

/**
* [en]This structure is used to describe query nonce result.
* [cn]nonce信息
*/
typedef struct tagHwmQueryNonceResult
{
    HWM_CHAR nonce[HWM_MAX_NONCE_LEN];              /**< [en]Indicates nonce. [cn]随机数 */
    HWM_CHAR url[HWM_MAX_URL_LEN];                  /**< [en]Indicates url. [cn]url */
}HwmQueryNonceResult;


/**
* [en]Pair Mode
* [cn]配对模式
*/
typedef enum tagHwmPairMode
{
    HWM_PAIR_MODE_TMP = 1,                             /**< [en]Temp pair mode
                                                            [cn]临时配对关系 */
    HWM_PAIR_MODE_FIXED,                               /**< [en]Fixed pair mode
                                                            [cn]固定配对关系 */
}HwmPairMode;

/**
* [en]Pair link info
* [cn]配对链路信息
**/
typedef struct tagHwmPairLinkInfo
{
    HWM_CHAR userId[HWM_MAX_USER_ID_LEN];              /**< [en]User Id.
                                                            [cn]userId 控制（手机号码或邮箱）
                                                            [cs_allowNull:N] */
    HWM_CHAR userAgent[HWM_MAX_USERAGENT_LEN];         /**< [en]userAgent. 
                                                            [cn]用户类型，用于区分端类型
                                                            [cs_allowNull:N]*/
    HWM_CHAR deviceId[HWM_MAX_DEVICE_UUID_LEN];        /**< [en]Device ID.
                                                            [cn]设备ID */
    HWM_CHAR deviceName[HWM_MAX_USER_NAME_LEN];        /**< [en]Device name.
                                                            [cn]设备名称 */
    HWM_CHAR userName[HWM_MAX_USER_NAME_LEN];          /**< [en]User name.
                                                            [cn]用户名称 */
    HwmPairMode pairMode;                              /**< [en]PairMode
                                                            [cn]临时/固定配对关系 */
    HWM_BOOL isOffline;                                /**< [en]Is offline
                                                            [cn]是否离线 */
} HwmPairLinkInfo;

/**
* [en]Pair verify code info
* [cn]配对验证码信息
**/
typedef struct tagHwmPairVerifyCodeInfo
{
    HWM_CHAR verifyCode[HWM_MAX_VER_CODE_LEN];                  /**< [en]Verify code
                                                                     [cn]验证码 */
    HWM_INT32 expireTime;                                       /**< [en]Expire time
                                                                     [cn]过期时间 */
    HwmState displayState;                                      /**< [en]Display state
                                                                     [cn]显示状态 */
} HwmPairVerifyCodeInfo;

/**
* [en]Pair link list info
* [cn]配对链路列表信息
**/
typedef struct tagHwmPairLinkListInfo
{
    HWM_UINT32  numOfPairLinks;                 /**< [en]Num of pairLinks
                                                     [cn]配对链路个数
                                                     [length for pairLinks] */
    HwmPairLinkInfo* pairLinks;                 /**< [en]PairLinks info. 
                                                     [cn]绑定的列表 */
} HwmPairLinkListInfo;

/**
* [en]This struct is used to describe Nss survey info.
* [cn]NSS满意度评价信息
*/
typedef struct tagHwmNssSurveyInfo
{
    HWM_CHAR confId[HWM_MAX_CONF_ID_LEN];        /**< [en]Indicates when creating a meeting, add the create request ID in the call-id field to differentiate multiple sessions created simultaneously.
                                                      [cn]在创建会议时，在call-id字段添加创建请求ID，用于区分同时创建的多个会议 */
    HWM_CHAR subName[HWM_MAX_SUBNAME_LEN];       /**< [en]Indicates question description. [cn]问题描述 */
    HWM_CHAR subRemark[HWM_MAX_SUBREMARK_LEN];   /**< [en]Indicates remark. [cn]备注 */
}HwmNssSurveyInfo;

/**
* [en]Locked state
* [cn]会议锁定状态
*/
typedef enum tagHwmLockedState
{
    HWM_LOCKED_STATE_UNLOCK,                     /**< [en]unlock
                                                      [cn]未锁定 */
    HWM_LOCKED_STATE_LOCK,                       /**< [en]lock
                                                      [cn]锁定 */
}HwmLockedState;


/**
* [en]Cpu level
* [cn]cpu性能等级
*/
typedef enum tagHwmCpuLevel
{
    CALL_CPU_LEVEL_BUTT = 0,
    CALL_CPU_LEVEL_SUPER_LOW = 9,               /**< [en]Super low
                                                     [cn]性能极低 */
    CALL_CPU_LEVEL_LOW = 10,                    /**< [en]Low
                                                     [cn]性能低 */
    CALL_CPU_LEVEL_MIDDLE,                      /**< [en]Middle
                                                     [cn]性能中等 */
    CALL_CPU_LEVEL_HIGH                         /**< [en]High
                                                     [cn]性能高 */
}HwmCpuLevel;

/**
* [en]This structure is used to describe get cpu performance level result.
* [cn]获取cpu表现性能的结果
*/
typedef struct tagHwmCpuLevelResult
{
    HwmCpuLevel cpuLevel;               /**< [en]Cpu level
                                             [cn]cpu等级 */
}HwmCpuLevelResult;

/**
* [en]This structure is used to describe get error code and error describe result.
* [cn]错误码和错误描述的结果
*/
typedef struct tagHwmErrorResult
{
    HWM_INT32 result;                               /**< [en]Error code.
                                                         [cn]错误码 */
    HWM_CHAR reasonDesc[HWM_MAX_REASON_LEN];        /**< [en]Error describe.
                                                         [cn]错误描述 */
}HwmErrorResult;


/**
* [en]Error show type
* [cn]错误提示类型
*/
typedef enum tagHwmErrorShowType
{
    HWM_ERROR_SHOW_BUTT = 0,
    HWM_ERROR_SHOW_TYPE_TOAST,               /**< [en]Toast
                                                  [cn]toast */
    HWM_ERROR_SHOW_TYPE_SURE,                /**< [en]Confirm，i see
                                                  [cn]弹窗，确定*/
    HWM_ERROR_SHOW_TYPE_I_SEE,               /**< [en]Confirm，i see
                                                  [cn]弹窗，我知道了*/
}HwmErrorShowType;

/**
* [en]Error info.
* [cn]错误信息
*/
typedef struct tagHwmErrorInfo
{
    HwmErrorShowType errorShowType;                         /**< [en]Error show type
                                                                 [cn]错误提示类型 */
    HWM_CHAR errorMessage[HWM_MAX_ERROR_MESSAGE_LEN];       /**< [en]Error message
                                                                 [cn]错误提示，注：UTF8编码 */
}HwmErrorInfo;

/**
* [en]Custom path type
* [cn]自定义路径枚举
*/
typedef enum tagHwmCustomPathType
{
    HWM_CUSTOM_PATH_PNR,                          /**< [en]pnr path
                                                       [cn]声纹降噪录制临时文件保存路径 */

    HWM_CUSTOM_PATH_TYPE_BUTT

} HwmCustomPathType;

/**
* [en]Custom path info.
* [cn]自定义路径信息
*/
typedef struct tagHwmCustomPathInfo
{
    HwmCustomPathType customPathType;                   /**< [en]custom path type
                                                             [cn]自定义路径类型
                                                             [cs_allowNull:N] */
    HWM_CHAR path[HWM_MAX_FILE_PATH_LEN];               /**< [en]custom path
                                                             [cn]保存路径，注：绝对路径，需要UTF8编码
                                                             [cs_allowNull:N] */
}HwmCustomPathInfo;

/**
* [en]Noise reduce level
* [cn]降噪等级
*/
typedef enum tagHwmNoiseReduceLevel
{
    NOISE_REDUCE_LEVEL_AUTO = 0,                    /**< [en]Auto
                                                     [cn]自动挡 */
    NOISE_REDUCE_LEVEL_LOW,                         /**< [en]Low
                                                     [cn]低挡  */
    NOISE_REDUCE_LEVEL_MIDDLE,                      /**< [en]Middle
                                                     [cn]中挡 */
    NOISE_REDUCE_LEVEL_HIGH                         /**< [en]High
                                                     [cn]高挡 */
}HwmNoiseReduceLevel;

/**
* [en]Noise reduce setting.
* [cn]降噪配置项
*/
typedef struct tagHwmNoiseReduceSettings
{
    HwmNoiseReduceLevel level;               /**< [en]Noise reduce level
                                             [cn]降噪等级 */
}HwmNoiseReduceSettings;

/**
* [en]End projection conf mode
* [cn]结束投屏会议类型枚举
*/
typedef enum tagHwmEndProjectionConfMode
{
    END_PROJECTION_MODE_CANCEL = 0,                          /**< [en]Indicates end projection for cancel.
                                                                  [cn]投屏协商中大屏取消 */
    END_PROJECTION_MODE_BY_SENDER_WITH_TWO_MEMBERS = 1,      /**< [en]Indicates end projection by sender with two members.
                                                                  [cn]两方投屏端结束投屏 */
    END_PROJECTION_MODE_BY_RECEIVER = 2,                     /**< [en]Indicates end projection by receiver.
                                                                  [cn]大屏端结束投屏 */
    END_PROJECTION_MODE_BY_SENDER_WITH_MULTI_MEMBERS = 3,    /**< [en]Indicates end projection by sender with multi members.
                                                                  [cn]多方投屏会议投屏端结束投屏 */
} HwmEndProjectionConfMode;

/**
* [en]This structure is used to describe end projection param.
* [cn]结束投屏参数体
*/
typedef struct tagHwmEndProjectionParam
{
    HwmEndProjectionConfMode mode;                  /**< [en]Indicates end projection conf mode.
                                                         [cn]结束投屏类型
                                                         [cs_allowNull:N] */
}HwmEndProjectionParam;

/**
* [en]This structure is used to describe query version info
* [cn]查询版本请求信息
**/
typedef struct tagHwmVersionInfo {
    HWM_UINT32            serverPort;                                          /**< [en]Indicates the server port. 
                                                                                    [cn]服务器端口号 
                                                                                    [cs_allowNull:Y] */
    HWM_CHAR              serverUrl[HWM_MAX_URL_LEN];                          /**< [en]Indicates the server address. 
                                                                                    [cn]服务器地址 
                                                                                    [cs_allowNull:Y][cs_length:0-256] */
    HWM_CHAR              userAccount[HWM_MAX_NAME_LEN];                       /**< [en]Indicates the account. 
                                                                                    [cn]账号 
                                                                                    [cs_allowNull:Y][cs_length:0-256] */
    HWM_CHAR              softwareType[HWM_MAX_PRODUCT_NAME_LEN];              /**< [en]Indicates the software type. 
                                                                                    [cn]软终端类型
                                                                                    [cs_allowNull:Y][cs_length:0-256] */
    HWM_CHAR              currentVersion[HWM_MAX_SOFTWARE_VER_LEN];            /**< [en]Indicates the server version. 
                                                                                    [cn]当前软终端版本号版本 
                                                                                    [cs_allowNull:Y][cs_length:0-128] */
    HWM_UINT32            lastestLoginedType;                                  /**< [en]Indicates the latest logined server type, 1 indicate mdx, 2 indicate cms. 
                                                                                    [cn]上次登录服务器类型,1表示cms,2表示mdx
                                                                                    [cs_allowNull:Y] */
}HwmVersionInfo;


/**
* [en]This structure is used to describe org name info
* [cn]组织名信息
**/
typedef struct tagHwmOrgNameInfo {
    HWM_CHAR              name[HWM_MAX_ORG_NAME_LEN];                          /**< [en]Indicates the org name
                                                                                    [cn]组织名
                                                                                    [cs_allowNull:Y][cs_length:0-512] */
}HwmOrgNameInfo;

/**
* [en]This structure is used to describe query version result
* [cn]查询版本请求结果
**/
typedef struct tagHwmQueryVersionInfoResult {
    HWM_CHAR              userAccount[HWM_MAX_NAME_LEN];                          /**<  [en]Indicates the account. 
                                                                                        [cn]账号 */
    HWM_CHAR              softwareType[HWM_MAX_PRODUCT_NAME_LEN];                 /**<  [en]Indicates the software type. 
                                                                                        [cn]软终端类型*/
    HWM_CHAR              upgradingVersion[HWM_MAX_SOFTWARE_VER_LEN];             /**<  [en]Indicates the version to be upgrading. 
                                                                                        [cn]待升级软终端版本号*/
    HWM_CHAR              versionPath[HWM_MAX_URL_LEN];                           /**<  [en]Indicates the upgrading file path. 
                                                                                        [cn]待升级软终端版本路径*/
    HWM_CHAR              versionDescription[HWM_MAX_VERSION_DESCRIPTION_LEN];    /**<  [en]Indicates the version modification description. 
                                                                                        [cn]版本修改描述*/
    HWM_BOOL              isForceUpgrade;                                         /**<  [en]Indicates whether is mandatory upgrade. 
                                                                                        [cn]是否为强制升级*/
    HWM_BOOL              isConsistent;                                           /**<  [en]Indicates whether is the same with newest version. 
                                                                                        [cn]是否版本一致*/
    HWM_CHAR              redirectUrl[HWM_MAX_URL_LEN];                           /**<  [en]Indicates the redirect url. 
                                                                                        [cn]重定向地址 */
    HWM_CHAR              serviceDomain[HWM_MAX_DOMAIN_LENGTH];                   /**<  [en]Indicates the service domain. 
                                                                                        [cn]服务器地址 */
    HWM_CHAR              serviceIpList[HWM_MAX_DOMAIN_LENGTH];                   /**<  [en]IP list. 
                                                                                        [cn]ip列表，可能存在多个ip */
    HWM_CHAR              versionDescriptionEn[HWM_MAX_VERSION_DESCRIPTION_LEN];  /**<  [en]Indicates the version modification description. 
                                                                                        [cn]版本修改英文描述*/
    HWM_CHAR              minUpgradeVersion[HWM_MAX_UPGRADE_VERSION_LEN];         /**<  [en]Indicates the minimal upgrade version. 
                                                                                        [cn]最小升级版本*/
    HWM_CHAR              minPlatformVersion[HWM_MAX_UPGRADE_VERSION_LEN];        /**<  [en]Indicates the minimal platform version. 
                                                                                        [cn]最小平台版本*/
    HWM_BOOL              isTrialVersion;                                         /**<  [en]Indicates whether is trial version. 
                                                                                        [cn]是否为试用版本*/
    HWM_UINT32            orgNameLen;                                             /**<  [en]The size of orgNameList
                                                                                        [cn]组织名列表长度
                                                                                        [length for orgNameList] */
    HwmOrgNameInfo*       orgNameList;                                            /**<  [en]Indicates org name list.
                                                                                        [cn]组织名列表*/
}HwmQueryVersionInfoResult;

/**
* [en]This enum is used to pair role type
* [cn]配对角色类型
*/
typedef enum tagHwmPairRoleType
{
    HWM_CONF_PAIR_ROLE_SERVER = 0,                /**< [en]role of server
                                                       [cn]服务端 */
    HWM_CONF_PAIR_ROLE_CLIENT = 1                 /**< [en]role of client
                                                       [cn]客户端 */
}HwmPairRoleType;

/**
* [en]This structure is used to describe init pair info
* [cn]初始化配对信息
**/
typedef struct tagHwmInitPairInfo {
    HwmPairRoleType         pairRole;                                          /**< [en]Indicates the pair role type. 
                                                                                    [cn]配对角色类型
                                                                                    [cs_allowNull:Y] */
    HWM_UINT32              maxPairNum;                                        /**< [en]Indicates the server address. 
                                                                                    [cn]最大配对数量
                                                                                    [cs_allowNull:Y] */
    HWM_UINT32              codeMode;                                          /**< [en]Indicates the code mode. 
                                                                                    [cn]配对模式
                                                                                    [cs_allowNull:Y] */
}HwmInitPairInfo;

/**
* [en]This structure is used to describe query spes info result
* [cn]查询Spes信息结果
**/
typedef struct tagHwmSpesInfoResult {
    HWM_BOOL                isSpesExternalAccess;                              /**< [en]Indicates whether is spes external access.
                                                                                    [cn]是否spes外网接入*/
}HwmSpesInfoResult;

/**
* [en]This struct is used to describe abnormal leave meeting info
* [cn]异常断开的会议信息
*/
typedef struct tagHwmAbnormalLeaveMeetingInfo
{
    HWM_CHAR  confId[HWM_MAX_CONF_ID_LEN];                                     /**< [en]Indicates conference id.
                                                                                    [cn]会议id */
    HWM_CHAR  confPwd[HWM_MAX_PASSWORD_LEN];                                   /**< [en]Indicates conference password.
                                                                                    [cn]会议密码 */
}HwmAbnormalLeaveMeetingInfo;

/**
* [en]This enum is used to describe Client DeviceType
* [cn]私有成员类型
*/
typedef enum tagHwmPrivateClientDeviceType
{
    PRIVATE_CLIENT_DEVICE_DESKTOP = 0,    /**< [en]desktop
                                           <br>[cn]pc登录*/
    PRIVATE_CLIENT_DEVICE_MOBILE,         /**< [en]mobile
                                           <br>[cn]移动端登录*/
    PRIVATE_CLIENT_DEVICE_PAD,            /**< [en]pad
                                           <br>[cn]平板登录*/
    PRIVATE_CLIENT_DEVICE_SMARTROOM,      /**< [en]smart room
                                           <br>[cn]smart room版*/
    PRIVATE_CLIENT_DEVICE_MINI,           /**< [en]MiniPrograms
                                           <br>[cn]小程序*/
    PRIVATE_CLIENT_DEVICE_WEB,            /**< [en]Web
                                           <br>[cn]浏览器*/
    PRIVATE_CLIENT_DEVICE_TV,             /**< [en]TV
                                           <br>[cn]TV版*/
    PRIVATE_CLIENT_DEVICE_HARD,           /**< [en]HardTerminal
                                           <br>[cn]硬终端*/
    PRIVATE_CLIENT_DEVICE_TYPE_THIRD,     /**< [en]ThirdTerminal
                                           <br>[cn]友商终端*/
    PRIVATE_CLIENT_DEVICE_PSTN,           /**< [en]PSTN
                                           <br>[cn]PSTN*/
    PRIVATE_CLIENT_DEVICE_MCU,           /**< [en]MCU
                                          <br>[cn]MCU*/
    PRIVATE_CLIENT_DEVICE_OTHER,           /**<[en]other*/
    PRIVATE_CLIENT_DEVICE_UNKNOWN = 99    /**<[en]unkown
                                          <br>[cn]未知 */
}HwmPrivateClientDeviceType;

/**
* [en]This enum is used to describe attendee type
* [cn]私有成员类型
*/
typedef enum tagHwmPrivateAttendeeType
{
    PRIVATE_ATTENDEE_TYPE_NORMAL = 0,      /**< [en]Indicates conference soft terminal user
                                            <br>[cn]会议软终端用户*/
    PRIVATE_ATTENDEE_TYPE_CUSTOMNUMBER,    /**< [en]Indicates custom number
                                            <br>[cn]自定义号码*/
    PRIVATE_ATTENDEE_TYPE_MOBILE,          /**< [en]Indicates user mobile phone number
                                            <br>[cn]用户手机号码*/   
    PRIVATE_ATTENDEE_TYPE_TELEPHONE,       /**< [en]Indicates user telephone
                                            <br>[cn]用户固定电话*/
}HwmPrivateAttendeeType;

/**
* [en]This enum is used to describe external state
* [cn]外部成员状态
*/
typedef enum tagHwmInviteeState
{
    EXTERNAL_ATTENDEE_STATE_WAITING = 0,            /**< [en]Indicates exteranal attendee state waiting
                                                     <br>[cn]外部用户呼叫中*/
    EXTERNAL_ATTENDEE_STATE_TIMEOUT,                /**< [en]Indicates exteranal attendee state timeout
                                                     <br>[cn]外部用户呼叫超时*/
    EXTERNAL_ATTENDEE_STATE_BUSY,                   /**< [en]Indicates exteranal attendee state busy
                                                     <br>[cn]外部用户呼叫忙*/
    EXTERNAL_ATTENDEE_STATE_DENIED,                 /**< [en]Indicates exteranal attendee state denied
                                                     <br>[cn]外部用户呼叫拒接*/
    EXTERNAL_ATTENDEE_STATE_CONNECTING,             /**< [en]Indicates exteranal attendee state connecting
                                                     <br>[cn]外部用户入会中*/
    EXTERNAL_ATTENDEE_STATE_SUCCESS,                 /**< [en]Indicates exteranal attendee state success
                                                     <br>[cn]外部用户入会成功*/
    EXTERNAL_ATTENDEE_STATE_FAILED,                 /**< [en]Indicates exteranal attendee state failed
                                                     <br>[cn]外部用户入会失败*/
    EXTERNAL_ATTENDEE_STATE_REMOVED,                /**< [en]Indicates exteranal attendee state removed
                                                     <br>[cn]外部用户移除*/
    EXTERNAL_ATTENDEE_STATE_HANGUP,                 /**< [en]Indicates exteranal attendee state hangup
                                                     <br>[cn]外部用户被挂断*/
}HwmInviteeState;

/**
* [en]This structure is used to describe external invitee info
* [cn]外部与会者信息
**/
typedef struct tagHwmExternalInvitee {
    HWM_CHAR name[HWM_MAX_USER_NAME_LEN];              /**< [en]Indicates name.
                                                            [cn]可选，与会者名称 */
    HWM_CHAR aliasCN[HWM_MAX_DISPLAY_NAME_LEN];        /**< [en]Indicates chinese alias.
                                                            [cn]可选，中文别名
                                                            [doc:disable] */
    HWM_CHAR aliasEN[HWM_MAX_DISPLAY_NAME_LEN];        /**< [en]Indicates english alias.
                                                            [cn]可选，英文别名
                                                            [doc:disable] */
    HWM_CHAR extendedField[HWM_MAX_EXTENDED_FIELD_LEN];/**< [en]Indicates extended field.
                                                            [cn]扩展字段
                                                            [doc:disable] */
    HWM_CHAR acountId[HWM_MAX_ACCOUNT_LEN];            /**< [en]Indicates account id.
                                                            [cn]可选，华为云会议账号 */
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];               /**< [en]Indicates number.
                                                            [cn]号码 */
    HWM_CHAR userUuid[HWM_MAX_USER_NAME_LEN];          /**< [en]Indicates user account
                                                            [cn]与会唯一标识 */
    HWM_CHAR orgId[HWM_MAX_ORG_ID_LENGTH];             /**< [en]Indicates org id.
                                                            [cn]企业id */   
    HwmPrivateClientDeviceType clientDeviceType;   /**< [en]Indicates client device type.
                                                            [cn]终端登录类型  */
    HwmPrivateAttendeeType attendeeType;          /**< [en]Indicates attendee type.
                                                            [cn]成员类型 */
    HwmInviteeState state;                             /**< [en]Indicates attendee state.
                                                            [cn]成员状态 */
}HwmExternalInvitee;

/**
* [en]This struct is used to update exteranl invitees.
* [cn]外部与会者列表信息
*/
typedef struct tagHwmExternalInviteesInfo
{
    HwmExternalInvitee* inviteesList;             /**< [en]inviteesList list
                                                       [cn]外部被邀请者 */
    HWM_UINT32 inviteesLength;                    /**< [en]Num of inviteesList
                                                       [cn]外部被邀人数
                                                       [length for inviteesList] */
}HwmExternalInviteesInfo;

/**
* [en]This enum is used to describe operate exteranl invitee type
* [cn]
*/
typedef enum tagHwmOperateExternalInviteeType
{
    OPERATE_EXTERNAL_INVITEE_CALL = 0,      /**< [en]Indicates call external invitee
                                             <br>[cn]呼叫外部邀请者*/
    OPERATE_EXTERNAL_INVITEE_HANGUP,        /**< [en]Indicates hangup external hang up
                                             <br>[cn]挂断外部邀请者*/
    OPERATE_EXTERNAL_INVITEE_REMOVE,        /**< [en]Indicates hangup external remove
                                             <br>[cn]移除外部邀请者*/
    OPERATE_EXTERNAL_INVITEE_OTHER_NUMBER   /**< [en]Indicates hangup external
                                             <br>[cn]呼叫其他号码*/
}HwmOperateExternalInviteeType;

/**
* [en]This struct is used to operate exteranl invitees.
* [cn]外部与会者操作信息
*/
typedef struct tagHwmOperateExternalInviteeInfo
{
    HwmOperateExternalInviteeType type;              /**< [en]operate type
                                                       [cn]邀请类型
                                                       [cs_allowNull:N]*/
    HwmExternalInvitee invitee;                   /**< [en]external invite
                                                       [cn]邀请者信息
                                                       [cs_allowNull:N]*/
}HwmOperateExternalInviteeInfo;

/**
* [en]This struct is used to operate exteranl invitees.
* [cn]外部与会者批量操作信息
*/
typedef struct tagHwmCallAllExternalAttendeesInfo
{
    HwmExternalInvitee *invitee;                    /**< [en]external invite
                                                         [cn]邀请者信息
                                                         [cs_allowNull:N]*/
    HWM_UINT32 count;                               /**< [en]size of 'invitee'
                                                         [cn]invitee 字段中与会者数量
                                                         [length for invitee]
                                                         [cs_allowNull:N]*/
}HwmCallAllExternalAttendeesInfo;

/**
* [en]This struct is used to describe complain info
* [cn]举报投诉信息结果
*/
typedef struct tagHwmComplainInfo
{
    HWM_CHAR  deviceId[HWM_MAX_DEVICE_ID_LEN];                                 /**< [en]Indicates device id.
                                                                                    [cn]当前设备id */
    HWM_CHAR  confId[HWM_MAX_CONF_ID_LEN];                                     /**< [en]Indicates conference id.
                                                                                    [cn]会议id */
    HWM_CHAR  confSubject[HWM_MAX_SUBJECT_LEN];                                /**< [en]Indicates conference subject.
                                                                                    [cn]会议主题 */
    HWM_CHAR  userUuid[HWM_MAX_USER_NAME_LEN];                                /**< [en]Indicates complain user uuid.
                                                                                    [cn]被举报的用户uuid */
    HWM_CHAR  userName[HWM_MAX_USERNAME_LEN];                                 /**< [en]Indicates complain user name.
                                                                                    [cn]被举报的用户名称 */
    HWM_INT32 centerX;                                                         /**< [en]Indicates the x-coordinate of the center position.
                                                                                    [cn]建议举报弹窗显示的中心位置x坐标*/
    HWM_INT32 centerY;                                                         /**< [en]Indicates the y-coordinate of the center position.
                                                                                    [cn]建议举报弹窗显示的中心位置y坐标*/
    HWM_BOOL isAIGC;                                                           /**< [en]Indicates is aigc or not.
                                                                                    [cn]是否AIGC内容*/
}HwmComplainInfo;

/**
* [en]This struct is used to describe integrator type
* [cn]集成方类型
*/
typedef enum tagHwmIntegratorType
{
    HWM_INTEGRATOR_INVALID = 0,             /**< [en]Invalid
                                                 [cn]无效类型 */
    HWM_INTEGRATOR_WELINK_BOARD             /**< [en]Welink board
                                                 [cn]公司局大屏 */
}HwmIntegratorType;

/**
* [en]This struct is used to describe auto optimise info
* [cn]自动优化信息
*/
typedef struct tagHwmAutoOptimiseInfo
{
    HwmIntegratorType type;                 /**< [en]Integrator type
                                                 [cn]集成方类型 */
}HwmAutoOptimiseInfo;

/**
* [en]Start play audio file param
* [cn]播放音频文件参数
*/
typedef struct tagHwmStartPlayAudioFileParam
{
    HWM_UINT32 loopTimes;                           /**< [en]loop time
                                                         [cn]循环次数，0代表无限循环
                                                         [cs_allowNull:Y] */
    HWM_CHAR filePath[HWM_MAX_FILE_PATH_LEN];       /**< [en]file path
                                                         [cn]文件路径，注：绝对路径，需要UTF8编码 */
}HwmStartPlayAudioFileParam;

/**
* [en] cfg client type info
* [cn] 配置文件类型
*/
typedef struct tagHwmCfgClientTypeInfo
{
    HWM_CHAR cfgClientType[HWM_MAX_CFG_CLIENT_TYPE_LEN];   /**< [en]cfg client type
                                                                [cn]配置文件类型 */
}HwmCfgClientTypeInfo;

/*
* [en]Setting Area info
* [cn]设置区域信息
*/
typedef struct tagHwmSettingArea
{
    HWM_BOOL isHide;                                /**< [en]Is hide.
                                                         [cn]是否隐藏 */
}HwmSettingArea;

/*
* [en]Normal setting tab info
* [cn]基本设置页信息
*/
typedef struct tagHwmNormalSettingTab
{
    HWM_BOOL isHide;                                   /**< [en]Is hide.
                                                            [cn]是否隐藏 */
    HwmSettingArea callOrConfArea;                     /**< [en]CallOrConf setting area.
                                                            [cn]会议呼叫设置区域 */
    HwmSettingArea chatNotifyArea;                     /**< [en]ChatNotify setting area.
                                                            [cn]聊天消息提醒设置区域 */
    HwmSettingArea subtitleArea;                       /**< [en]Subtitle setting area.
                                                            [cn]字幕设置区域 */
    HwmSettingArea shareArea;                          /**< [en]Share setting area.
                                                            [cn]共享设置区域 */
}HwmNormalSettingTab;

/*
* [en]Video setting tab info
* [cn]视频设置页信息
*/
typedef struct tagHwmVideoSettingTab
{
    HWM_BOOL isHide;                                   /**< [en]Is hide.
                                                            [cn]是否隐藏 */
    HwmSettingArea cameraArea;                         /**< [en]Camera setting area.
                                                            [cn]摄像头设置区域 */
    HwmSettingArea videoViewArea;                      /**< [en]Video view setting area.
                                                            [cn]视频画面设置区域 */
}HwmVideoSettingTab;

/*
* [en]Audio setting tab info
* [cn]音频设置页信息
*/
typedef struct tagHwmAudioSettingTab
{
    HWM_BOOL isHide;                                   /**< [en]Is hide.
                                                            [cn]是否隐藏 */
    HwmSettingArea micArea;                            /**< [en]Mic setting area.
                                                            [cn]麦克风设置区域 */
    HwmSettingArea spkArea;                            /**< [en]Spk setting area.
                                                            [cn]扬声器设置区域 */
    HwmSettingArea advancedArea;                      /**<  [en]Advanced setting area.
                                                            [cn]高级设置区域 */
}HwmAudioSettingTab;

/*
* [en]Screen setting tab info
* [cn]屏幕设置页信息
*/
typedef struct tagHwmScreenSettingTab
{
    HWM_BOOL isHide;                                    /**<[en]Is hide.
                                                            [cn]是否隐藏 */
    HwmSettingArea dualScreenArea;                      /**<[en]Dual screen setting area.
                                                            [cn]双屏设置区域 */
    HwmSettingArea displayTopologyArea;                 /**<[en]Display topology setting area
                                                            [cn]显示器显示模式设置区域 */
    HwmSettingArea swapContentArea;                     /**<[en]Swap screen content setting area
                                                            [cn]切换显示内容设置区域 */
}HwmScreenSettingTab;

/*
* [en]Subtitle setting tab info
* [cn]字幕设置页信息
*/
typedef struct tagHwmSubtitleSettingTab
{
    bool isHide;                                       /**< [en]Is hide.
                                                            [cn]是否隐藏 */
    HwmSettingArea subtitleSettingArea;                /**< [en]Dual screen setting area.
                                                            [cn]字幕基础设置区域 */
    HwmSettingArea translateSettingArea;               /**< [en]Display topology setting area
                                                            [cn]字幕翻译设置区域 */
}HwmSubtitleSettingTab;

/*
* [en]Record setting tab info
* [cn]录制设置页信息
*/
typedef struct tagHwmRecordSettingTab
{
    HWM_BOOL isHide;                                   /**< [en]Is hide.
                                                            [cn]是否隐藏 */
    HwmSettingArea localRecordArea;                    /**< [en]Local setting area.
                                                            [cn]本地录制设置区域 */
}HwmRecordSettingTab;

/*
* [en]VirtualBackgroud setting tab info
* [cn]虚拟背景设置页信息
*/
typedef struct tagHwmVirtualBackgroudSettingTab
{
    HWM_BOOL isHide;                                   /**< [en]Is hide.
                                                            [cn]是否隐藏 */
    HwmSettingArea virtualBackgroudArea;               /**< [en]Virtual backgroud setting area.
                                                            [cn]虚拟背景设置区域 */
}HwmVirtualBackgroudSettingTab;

/*
* [en]Hotkey setting tab info
* [cn]快捷键设置页信息
*/
typedef struct tagHwmHotKeySettingTab
{
    HWM_BOOL isHide;                                    /**< [en]Is hide.
                                                             [cn]是否隐藏 */
    HwmSettingArea hotkeyArea;                          /**< [en]Hotkey setting area.
                                                             [cn]快捷键设置区域 */
}HwmHotKeySettingTab;

/*
* [en]Setting window config info
* [cn]设置界面配置信息
*/
typedef struct tagHwmSettingWindowConfig
{
    HwmNormalSettingTab normalTab;                                 /**< [en]Normal setting tab.
                                                                        [cn]基本设置页 */
    HwmVideoSettingTab videoTab;                                   /**< [en]Video setting tab.
                                                                        [cn]视频设置页 */
    HwmAudioSettingTab audioTab;                                   /**< [en]Audio setting tab.
                                                                        [cn]音频设置页 */
    HwmScreenSettingTab screenTab;                                 /**< [en]Screen setting tab.
                                                                        [cn]屏幕设置页信息 */
    HwmSubtitleSettingTab subtitleTab;                             /**< [en]Subtitle setting tab.
                                                                        [cn]字幕设置页信息 */
    HwmRecordSettingTab recordTab;                                 /**< [en]Record setting tab.
                                                                        [cn]录制设置页 */
    HwmVirtualBackgroudSettingTab virtualBackgroudTab;             /**< [en]Virtual backgroud setting tab.
                                                                        [cn]虚拟背景设置页 */
    HwmHotKeySettingTab hotkeyTab;                                 /**< [en]Hotkey setting tab.
                                                                        [cn]快捷键设置页 */
}HwmSettingWindowConfig;

/**
* [en]Query other number info
* [cn]请求其他号码信息
*/
typedef struct tagHwmQueryOtherNumberInfo
{
    HWM_CHAR sipNumber[HWM_MAX_NUMBER_LEN];                 /**< [en]sipNumber
                                                                 [cn]sip号，跨企业场景下优先使用此字段 */
    HWM_CHAR extendedField[HWM_MAX_EXTENDED_FIELD_LEN];     /**< [en]Indicates extended field.
                                                                 [cn]扩展字段 */
}HwmQueryOtherNumberInfo;

/**
* [en]This enum is used to describe multi-share type
* [cn]多人共享类型
*/
typedef enum tagHwmAllowMultiShareType
{
    ALLOW_MULTI_SHARE_TYPE_SINGAL = 1,         /**< [en]Indicates only one user can share.
                                                    [cn]只允许单人共享 */
    ALLOW_MULTI_SHARE_TYPE_MULTI,              /**< [en]Indicates not only one user can share.
                                                    [cn]允许多人共享 */
}HwmAllowMultiShareType;


/**
* [en]Share audio state info
* [cn]共享音频状态信息
**/
typedef struct tagHwmShareAudioStateInfo
{
    HWM_BOOL isOpen;                            /**< [en]Is open
                                                     [cn]是否开启 */
} HwmShareAudioStateInfo;

/**
* [en]This structure is used to describe screen content swap state info
* [cn]会中交换屏幕信息
**/
typedef struct tagHwmScreenContentSwapInfo {
    HWM_BOOL                isSwapped;          /**< [en]Indicates whether is screen content swapped.
                                                     [cn]屏幕是否已交换 */
}HwmScreenContentSwapInfo;

/**
 * [en]Inner Http Proxy info.
 * [cn]内部Http代理信息
 */
typedef struct tagHwmInnerHttpProxyInfo
{
    HWM_CHAR server[HWM_MAX_URL_LEN];                    /**< [en]The server address
                                                              [cn]代理地址 */
    HWM_UINT16 port;                                     /**< [en]The server port
                                                              [cn]代理端口 */
    HWM_CHAR account[HWM_MAX_USERNAME_LEN];              /**< [en]The account
                                                              [cn]代理账号 */
    HWM_CHAR password[HWM_MAX_PASSWORD_LEN];             /**< [en]The password
                                                              [cn]代理密码 */
}HwmInnerHttpProxyInfo;

/**
* [en]This structure is used to describe meeting custom info
* [cn]会议自定义信息
*/
typedef struct tagHwmMeetingCustomInfo
{
    HWM_CHAR customInfo[HWM_MAX_OPEN_CUSTOM_PARA_LEN];      /**< [en]Indicates the custom info
                                                                 [cn]自定义信息 */
}HwmMeetingCustomInfo;

/**
* [en]This struct is used to describe jwt token info.
* [cn]本地鉴权token信息
*/
typedef struct tagHwmJwtTokenInfo
{
    HWM_CHAR jwtToken[HWM_MAX_JWT_TOKEN_LEN];            /**< [en]Indicates the jwt token
                                                              [cn]本地鉴权token */
}HwmJwtTokenInfo;

END_HWM_UISDK_NAMESPACE

#endif /* _HWM_PRIVATE_UISDK_SERVICE_DEF_H_ */
