const fs = require("fs");
const path = require("path");
const plist = require("plist");

async function patchRendererProcessInfoPlist(electronRendererBinaryPath) {
  if (process.platform === "darwin") {
    const ELECTRON_RENDERER_BINARY_PATH = electronRendererBinaryPath;

    const plistPath = path.join(__dirname, ELECTRON_RENDERER_BINARY_PATH, "Contents/Info.plist");

    const properties = plist.parse(fs.readFileSync(plistPath, "utf8"));
    if (!properties.NSHighResolutionCapable) {
      properties.NSHighResolutionCapable = true;
    }
    if (!properties.NSRequiresAquaSystemAppearance) {
      properties.NSRequiresAquaSystemAppearance = true;
    }
    fs.writeFileSync(plistPath, plist.build(properties));
  }
}

module.exports = {
  patchRendererProcessInfoPlist,
};
