const os = require('os')
const path = require('path')
const fs = require('fs')

const platform = os.platform()
const arch = os.arch()

export const getNodePath = () => {
  // 本地npm run auto时,node所在路径
  let _platformArch = 'win32'
  if (platform === 'darwin') {
    if (arch === 'arm64') {
      _platformArch = 'mac-arm64'
    } else {
      _platformArch = 'mac'
    }
  } else if (arch === 'x64') {
    _platformArch = 'x64'
  }
  let _path = `../../../sdk/${_platformArch}/`
  let nodePath = path.join(window.__dirname, _path + 'HwmUisdk.node')
  console.log(nodePath)
  if (!fs.existsSync(nodePath)) {
    // 路径不存在时,说明是打成安装包,此时node所在路径修正
    _path = `../sdk/${_platformArch}/`
    nodePath = path.join(window.__dirname, _path + 'HwmUisdk.node')
  }
  return nodePath
}
