import React from 'react'
import './index.css'
import ApiService from '../../../AppService/ApiService'
import { showErrorTips } from '../../../utils'

const tagHwmSettingPage = [
  {
    value: 0, // 基本设置页
    label: 'Normal setting page',
  },
  {
    value: 1, // 视频设置页
    label: 'Video setting page',
  },
  {
    value: 2, // 音频设置页
    label: 'Audio setting page',
  },
  {
    value: 3, // 录制设置页
    label: 'Record setting page',
  },
  {
    value: 4, // 快捷键设置页
    label: 'Hotkey setting page',
  },
  {
    value: 5, // 屏幕设置
    label: 'Screen setting page',
  },
]
class Setting extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      pageType: 0,
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  selectPageType (e) {
    this.setState({
      pageType: Number(e?.target?.value),
    })
  }

  async openSettingDialog () {
    const apiService = await new ApiService()
    const setResult = await apiService.openSettingDialog({
      isShow: true,
      defaultPage: this.state.pageType,
    })
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async closeSettingDialog () {
    const apiService = await new ApiService()
    await apiService.openSettingDialog({
      isShow: false,
      defaultPage: this.state.pageType,
    })
  }

  render () {
    return (
            <div className="setting">
                <select value={this.state.pageType} onChange={this.selectPageType.bind(this)}>
                    {tagHwmSettingPage.map(item => {
                      return <option value={item.value} key={item.value}>{item.label}</option>
                    })}
                </select>
                <button onClick={this.openSettingDialog.bind(this)}>Open</button>
                <button onClick={this.closeSettingDialog.bind(this)}>Close</button>
                <button onClick={this.goBack.bind(this)}>Back</button>
            </div>
    )
  }
}
export default Setting
