import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class ApplyHostRole extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      password: '',
    }
  }

  changePassword (e) {
    this.setState({
      password: e.target.value,
    })
  }

  async goToApplyHostRole () {
    const { password } = this.state
    const apiService = new ApiService()
    const setResult = await apiService.applyHostRole(password)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="applyHostRole">
        <div className="input-box-long">
          <div className="input-box-title-long">Password:</div>
          <div className="input-box-text">
            <textarea value={this.state.password} onChange={this.changePassword.bind(this)} />
          </div>
        </div>
        <button onClick={this.goToApplyHostRole.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default ApplyHostRole
