import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'
import { ShareType, Monitor, MonitorMode } from '../../../../Constants/enum'

const ShareTypeOptions = [
  {
    value: ShareType.HWM_SHARE_TYPE_MONITOR,
    label: 'Monitor',
  },
  {
    value: ShareType.HWM_SHARE_TYPE_APP,
    label: 'App',
  },
  {
    value: ShareType.HWM_SHARE_TYPE_WHITE_BOARD,
    label: 'WhiteBoard',
  },
  {
    value: ShareType.HWM_SHARE_TYPE_ALL,
    label: 'All',
  },
]

const MonitorOptions = [
  {
    value: Monitor.HWM_MONITOR_MAIN,
    label: 'Main',
  },
  {
    value: Monitor.HWM_MONITOR_SECONDARY,
    label: 'Secondary',
  },
]

const OperatableUIMonitorOptions = [
  {
    value: 0,
    label: 'Default',
  },
  {
    value: Monitor.HWM_MONITOR_MAIN,
    label: 'Forced Main',
  },
  {
    value: Monitor.HWM_MONITOR_SECONDARY,
    label: 'Forced Secondary',
  },
]

const MonitorModeOptions = [
  {
    value: MonitorMode.HWM_MONITOR_MODE_PRIMARY_SECONDARY,
    label: 'PRIMARY_SECONDARY',
  },
  {
    value: MonitorMode.HWM_MONITOR_MODE_MULTI_MONITOR,
    label: 'MULTI_MONITOR',
  },
]

class StartShare extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      shareType: ShareType.HWM_SHARE_TYPE_MONITOR,
      monitorShareInfo: {
        monitor: Monitor.HWM_MONITOR_MAIN,
        monitorMode: MonitorMode.HWM_MONITOR_MODE_PRIMARY_SECONDARY,
        monitorIndex: 0,
      },
      appShareInfo: {
        appHandle: 0,
      },
      operatableUiMonitor: {
        monitor: 0,
        monitorMode: MonitorMode.HWM_MONITOR_MODE_PRIMARY_SECONDARY,
        monitorIndex: 0,
      },
    }
  }

  changeShareType (e) {
    this.setState({
      shareType: Number(e.target.value),
    })
  }

  changeMonitorOfMonitorShareInfo (e) {
    const { monitorShareInfo } = this.state
    monitorShareInfo.monitor = Number(e.target.value)
    this.setState({
      monitorShareInfo,
    })
  }

  changeMonitorModeOfMonitorShareInfo (e) {
    const { monitorShareInfo } = this.state
    monitorShareInfo.monitorMode = Number(e.target.value)
    this.setState({
      monitorShareInfo,
    })
  }

  changeMonitorIndexOfMonitorShareInfo (e) {
    const { monitorShareInfo } = this.state
    monitorShareInfo.monitorIndex = Number(e.target.value)
    this.setState({
      monitorShareInfo,
    })
  }

  changeAppHandleOfAppShareInfo (e) {
    this.setState({
      appShareInfo: {
        appHandle: Number(e.target.value),
      },
    })
  }

  changeMonitorOfOperatableUiMonitor (e) {
    const { operatableUiMonitor } = this.state
    operatableUiMonitor.monitor = Number(e.target.value)
    this.setState({
      operatableUiMonitor,
    })
  }

  changeMonitorModeOfOperatableUiMonitor (e) {
    const { operatableUiMonitor } = this.state
    operatableUiMonitor.monitorMode = Number(e.target.value)
    this.setState({
      operatableUiMonitor,
    })
  }

  changeMonitorIndexOfOperatableUiMonitor (e) {
    const { operatableUiMonitor } = this.state
    operatableUiMonitor.monitorIndex = Number(e.target.value)
    this.setState({
      operatableUiMonitor,
    })
  }

  async goStartShare () {
    const { shareType, monitorShareInfo, appShareInfo, operatableUiMonitor } = this.state
    const param = {
      shareType,
      monitorShareInfo,
      appShareInfo,
      operatableUiMonitor,
    }
    const apiService = new ApiService()
    const setResult = await apiService.startShare(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="area">

        <div className="input-box">
          <div className="input-box-title">ShareType:</div>
          <div className="input-box-text">
            <select value={this.state.shareType} onChange={this.changeShareType.bind(this)}>
              {ShareTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>

        <div className="input-box-main-title">Monitor Share Info:</div>
        <div className="input-box">
          <div className="input-box-title">MonitorMode:</div>
          <div className="input-box-text">
            <select value={this.state.monitorShareInfo.monitorMode} onChange={this.changeMonitorModeOfMonitorShareInfo.bind(this)}>
              {MonitorModeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Monitor:</div>
          <div className="input-box-text">
            <select value={this.state.monitorShareInfo.monitor} onChange={this.changeMonitorOfMonitorShareInfo.bind(this)}>
              {MonitorOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">MonitorIndex:</div>
          <div className="input-box-text">
            <input value={this.state.monitorShareInfo.monitorIndex} onChange={this.changeMonitorIndexOfMonitorShareInfo.bind(this)}/>
          </div>
        </div>

        <div className="input-box-main-title">App Share Info:</div>
        <div className="input-box">
          <div className="input-box-title">AppHandle:</div>
          <div className="input-box-text">
            <input value={this.state.appShareInfo.appHandle} onChange={this.changeAppHandleOfAppShareInfo.bind(this)}/>
          </div>
        </div>

        <div className="input-box-main-title">Operatable Ui Monitor:</div>
        <div className="input-box">
          <div className="input-box-title">MonitorMode:</div>
          <div className="input-box-text">
            <select value={this.state.operatableUiMonitor.monitorMode} onChange={this.changeMonitorModeOfOperatableUiMonitor.bind(this)}>
              {MonitorModeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Monitor:</div>
          <div className="input-box-text">
            <select value={this.state.operatableUiMonitor.monitor} onChange={this.changeMonitorOfOperatableUiMonitor.bind(this)}>
              {OperatableUIMonitorOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">monitorIndex:</div>
          <div className="input-box-text">
            <input value={this.state.operatableUiMonitor.monitorIndex} onChange={this.changeMonitorIndexOfOperatableUiMonitor.bind(this)}/>
          </div>
        </div>

        <button onClick={this.goStartShare.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default StartShare
