import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class Config extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      configInfo: '',
    }
  }

  componentDidMount () {
    const param = {
      frame: {
        name: 'demo',
        isUploadKeyLog: true,
        confMenu: {
          titleBar: {
            confDetail: {
              button: [
                {
                  buttonId: 'copy_conf_info',
                  isCustomizedClick: true,
                },
                {
                  buttonId: 'copy_audience_conf_info',
                  isCustomizedClick: true,
                },
              ],
            },
          },
          statusBar: {
            button: [
              {
                buttonId: 'record',
                showAsAction: 'never',
              },
            ],
          },
          toolBar: {
            customButton: [
              {
                buttonId: 'customMenu',
                title: '自定义按钮',
                buttonPos: 1,
                buttonImg: 'imagePath',
                subMenu: '',
              },
              {
                buttonId: 'customMore',
                title: '自定义更多',
                buttonPos: 0,
                buttonImg: 'imagePath',
              },
              {
                buttonId: 'customShare',
                title: '自定义共享',
                buttonPos: 2,
                buttonImg: 'imagePath',
              },
            ],
            button: [
              {
                buttonId: 'microphone',
                showAsAction: 'never',
              },
              {
                buttonId: 'speaker',
                showAsAction: 'never',
              },
              {
                buttonId: 'camera',
                showAsAction: 'never',
              },
              {
                buttonId: 'invite',
                showAsAction: 'never',
                isCustomizedClick: true,
              },
              {
                buttonId: 'leave',
                showAsAction: 'never',
                isCustomizedClick: true,
              },
              {
                buttonId: 'attendee',
                showAsAction: 'never',
                isCustomizedClick: true,
                dialogPos: 'center',
              },
              {
                buttonId: 'share',
                showAsAction: 'never',
                isCustomizedClick: true,
              },
              {
                buttonId: 'chat',
                showAsAction: 'never',
                isCustomizedClick: true,
                dialogPos: 'center',
              },
              {
                buttonId: 'annotation',
                showAsAction: 'never',
              },
              {
                buttonId: 'stop_share',
                showAsAction: 'never',
              },
              {
                buttonId: 'feedback',
                showAsAction: 'ifRoom',
                isCustomizedClick: true,
              },
              {
                buttonId: 'dual_screen',
                showAsAction: 'never',
              },
              {
                buttonId: 'remote_control',
                showAsAction: 'never',
              },
              {
                buttonId: 'record',
                showAsAction: 'never',
              },
              {
                buttonId: 'subtitle',
                showAsAction: 'never',
              },
              {
                buttonId: 'security',
                showAsAction: 'never',
              },
              {
                buttonId: 'network_detection',
                showAsAction: 'never',
              },
              {
                buttonId: 'vote',
                showAsAction: 'never',
              },
              {
                buttonId: 'virtual_background',
                showAsAction: 'never',
              },
              {
                buttonId: 'moveall_to_waitingroom',
                showAsAction: 'never',
              },
              {
                buttonId: 'participant_detail',
                isCustomizedClick: true,
              },
              {
                buttonId: 'call_all',
                showAsAction: 'never',
                isCustomizedClick: true,
              },
              {
                buttonId: 'call_other_number',
                showAsAction: 'never',
                isCustomizedClick: true,
              },
              {
                buttonId: 'hands_up',
                showAsAction: 'never',
              },
              {
                buttonId: 'change_chairman_auth',
                showAsAction: 'never',
              },
              {
                buttonId: 'rename',
                showAsAction: 'never',
              },
              {
                buttonId: 'lock_conf',
                showAsAction: 'never',
              },
              {
                buttonId: 'export_participants',
                showAsAction: 'never',
              },
              {
                buttonId: 'attendee_access_control',
                showAsAction: 'never',
              },
              {
                buttonId: 'lock_Share',
                showAsAction: 'never',
              },
              {
                buttonId: 'invite_or_cancel_share',
                showAsAction: 'never',
              },
              {
                buttonId: 'hide_no_video_view',
                showAsAction: 'never',
              },
              {
                buttonId: 'video_smart_sorting',
                showAsAction: 'never',
              },
              {
                buttonId: 'mute_all',
                showAsAction: 'never',
              },
              {
                buttonId: 'allow_unmute',
                showAsAction: 'never',
              },
              {
                buttonId: 'share_strategy',
                showAsAction: 'never',
              },
              {
                buttonId: 'share_hide_video',
                showAsAction: 'never',
              },
              {
                buttonId: 'share_audio',
                showAsAction: 'never',
              },
              {
                buttonId: 'recall',
                isCustomizedClick: true,
              },
            ],
          },
        },
      },
    }
    this.setState({
      configInfo: JSON.stringify(param),
    })
  }

  changeConfig (e) {
    this.setState({
      configInfo: e.target.value,
    })
  }

  async setConfig () {
    const { configInfo } = this.state
    const apiService = new ApiService()
    const setResult = await apiService.config(configInfo)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async setInvite () {
    const param = {
      frame: {
        confMenu: {
          toolBar: {
            button: [{
              buttonId: 'invite',
              showAsAction: 'ifRoom',
              isCustomizedClick: true,
            }],
          },
        },
      },
    }
    const apiService = new ApiService()
    const setResult = await apiService.config(JSON.stringify(param))
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async setCopyConfInfo () {
    const param = {
      frame: {
        confMenu: {
          titleBar: {
            confDetail: {
              button: [
                {
                  buttonId: 'copy_conf_info',
                  isCustomizedClick: true,
                },
              ],
            },
          },
        },
      },
    }
    const apiService = new ApiService()
    const setResult = await apiService.config(JSON.stringify(param))
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
            <div className="config">
                <textarea value={this.state.configInfo} onChange={this.changeConfig.bind(this)}></textarea>
                <button onClick={this.setConfig.bind(this)}>Config</button>
                <button onClick={this.setInvite.bind(this)}>Invite Setting</button>
                <button onClick={this.setCopyConfInfo.bind(this)}>Copy ConfInfo Setting</button>
                <button onClick={this.goBack.bind(this)}>Back</button>
            </div>
    )
  }
}

export default Config
