import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { InComingAnswerType } from '../../../../Constants/enum'
import { showErrorTips } from '../../../../utils'

const AnswerTypeOptions = [
  {
    value: InComingAnswerType.HWM_INCOMING_ANSWER_NORMAL,
    label: 'Normal',
  },
  {
    value: InComingAnswerType.HWM_INCOMING_ANSWER_DECLINE,
    label: 'Auto Decline',
  },
  {
    value: InComingAnswerType.HWM_INCOMING_ANSWER_ANSWER,
    label: 'Auto Answer',
  },
  {
    value: InComingAnswerType.HWM_INCOMING_ANSWER_CUSTOM,
    label: 'Custom',
  },
]

class SetAnswerType extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      type: InComingAnswerType.HWM_INCOMING_ANSWER_NORMAL,
    }
  }

  changeType (e) {
    this.setState({
      type: Number(e.target.value),
    })
  }

  async goToSetAnswerType () {
    const { type } = this.state
    const param = {
      type,
    }
    const apiService = new ApiService()
    const setResult = await apiService.setAnswerType(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="SetAnswerType">
        <div className="input-box">
          <div className="input-box-title">Type:</div>
          <div className="input-box-text">
            <select value={this.state.type} onChange={this.changeType.bind(this)}>
              {AnswerTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <button onClick={this.goToSetAnswerType.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetAnswerType
