import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class SetAvatar extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      number: '',
      thirdUserId: '',
      avatarPath: '',
    }
  }

  changeNumber (e) {
    this.setState({
      number: e.target.value,
    })
  }

  changeThirdUserId (e) {
    this.setState({
      thirdUserId: e.target.value,
    })
  }

  changeAvatarPath (e) {
    this.setState({
      avatarPath: e.target.value,
    })
  }

  async goToSetAvatar () {
    const { number, avatarPath, thirdUserId } = this.state
    const param = {
      number,
      avatarPath,
      thirdUserId,
    }
    const apiService = new ApiService()
    const setResult = await apiService.setAvatar(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="setAvatar">
        <div className="input-box">
          <div className="input-box-title">Number:</div>
          <div className="input-box-text">
            <input value={this.state.number} onChange={this.changeNumber.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">ThirdUserId:</div>
          <div className="input-box-text">
            <input value={this.state.thirdUserId} onChange={this.changeThirdUserId.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">AvatarPath:</div>
          <div className="input-box-text">
            <input value={this.state.avatarPath} onChange={this.changeAvatarPath.bind(this)}/>
          </div>
        </div>
        <button onClick={this.goToSetAvatar.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetAvatar
