import React from 'react'
import { SDKERR } from 'hwmsdk-electron/ts/Api/enum'

import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class SetTransparentWnd extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      handle: '',
    }
  }

  changeHandle (e) {
    this.setState({
      handle: e.target.value,
    })
  }

  goBack () {
    this.props.history.goBack()
  }

  async submit () {
    const arrayHandle = this.state.handle.split(',').map((item) => Number(item))
    const param = { handle: arrayHandle }
    const apiService = new ApiService()
    const setResult = await apiService.setTransparentWnd(param)
    if (setResult.ret !== SDKERR.SDKERR_SUCCESS) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  render () {
    return (
      <div className="setTransparentWnd">
        <div className="input-line">
          <span className="input-line-label">Handle:</span>
          <span className="input-line-input">
            <input value={this.state.handle} onChange={this.changeHandle.bind(this)} placeholder="example: 3932538,527852,1182862" />
          </span>
        </div>
        <button onClick={this.submit.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetTransparentWnd
