import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { SettingVrbkDefaultImageMode } from '../../../../Constants/enum'
import { showErrorTips } from '../../../../utils'
const path = require('path')

const SetImgesOptions = [
  {
    value: SettingVrbkDefaultImageMode.HWM_SETTING_VRBK_DEFAULT_IMAGE_MODE_REPLACE_ALL,
    label: 'Replace All',
  },
  {
    value: SettingVrbkDefaultImageMode.HWM_SETTING_VRBK_DEFAULT_IMAGE_MODE_APPEND,
    label: 'Append',
  },
]

class SetVirtualBackgroundDefaultImages extends React.Component {
  constructor (props) {
    super(props)
    let imgDir = path.join(__dirname, '.\\..\\virtualbg')
    imgDir = path.normalize(imgDir)
    console.log('==========imgDir: ', imgDir)

    this.state = {
      mode: SettingVrbkDefaultImageMode.HWM_SETTING_VRBK_DEFAULT_IMAGE_MODE_APPEND,
      imageList: [{
        imagePath: path.join(imgDir, '1.jpg'),
      }, {
        imagePath: path.join(imgDir, '2.jpg'),
      }, {
        imagePath: path.join(imgDir, '3.jpg'),
      }, {
        imagePath: path.join(imgDir, '4.jpg'),
      }, {
        imagePath: path.join(imgDir, '5.jpg'),
      }],
      imageLength: 5,
    }
  }

  changeMode (e) {
    this.setState({
      mode: Number(e.target.value),
    })
  }

  async goToSetVirtualBackgroundImages () {
    const { mode, imageList, imageLength } = this.state
    const param = {
      mode,
      imageList,
      imageLength,
    }
    const apiService = new ApiService()
    const result = await apiService.setVirtualBackgroundDefaultImages(param)
    if (result.ret !== 0) {
      showErrorTips(result.ret, result.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="setVirtualBackgroundDefaultImages">
        <div className="input-box">
          <div className="input-box-title">Mode:</div>
          <div className="input-box-text">
            <select value={this.state.mode} onChange={this.changeMode.bind(this)}>
              {SetImgesOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <button onClick={this.goToSetVirtualBackgroundImages.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetVirtualBackgroundDefaultImages
