import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class SharePermission extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      isAllowed: false,
    }
  }

  async goEnableSharePermission () {
    const param = {
      isAllowed: true,
    }
    const apiService = new ApiService()
    const setResult = await apiService.setShareScreenPermission(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goDisableSharePermission () {
    const param = {
      isAllowed: false,
    }
    const apiService = new ApiService()
    const setResult = await apiService.setShareScreenPermission(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
            <div className="area">
                <div className="input-box-title">Share Permission:</div>
                <button onClick={this.goEnableSharePermission.bind(this)}>Enable</button>
                <button onClick={this.goDisableSharePermission.bind(this)}>Disable</button>
                <button onClick={this.goBack.bind(this)}>Back</button>
            </div>
    )
  }
}

export default SharePermission
