import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class JoinConfByRandom extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      confId: '',
      random: '',
      nickName: '',
      domain: '',
      isSpeakerOff: false,
      isMicOn: true,
      isCameraOn: false,
    }
  }

  changeConfId (e) {
    this.setState({
      confId: e.target.value,
    })
  }

  changeRandom (e) {
    this.setState({
      random: e.target.value,
    })
  }

  changeNickName (e) {
    this.setState({
      nickName: e.target.value,
    })
  }

  changeDomain (e) {
    this.setState({
      domain: e.target.value,
    })
  }

  changeIsSpeakerOff (e) {
    this.setState({
      isSpeakerOff: e.target.checked,
    })
  }

  changeIsMicOn (e) {
    this.setState({
      isMicOn: e.target.checked,
    })
  }

  changeIsCameraOn (e) {
    this.setState({
      isCameraOn: e.target.checked,
    })
  }

  async goToJoinConfByRandom () {
    const { confId, random, nickName, domain, isSpeakerOff, isMicOn, isCameraOn } = this.state
    const param = {
      confId,
      random,
      nickName,
      domain,
      isSpeakerOff,
      isMicOn,
      isCameraOn,
    }
    const apiService = new ApiService()
    const setResult = await apiService.joinConfByRandom(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="joinConfByRandom">
        <div className="input-box">
          <div className="input-box-title">ConfId:</div>
          <div className="input-box-text">
            <input value={this.state.confId} onChange={this.changeConfId.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Random:</div>
          <div className="input-box-text">
            <input value={this.state.random} onChange={this.changeRandom.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">NickName:</div>
          <div className="input-box-text">
            <input value={this.state.nickName} onChange={this.changeNickName.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Domain:</div>
          <div className="input-box-text">
            <input value={this.state.domain} onChange={this.changeDomain.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsSpeakerOff:</div>
          <div className="input-box-text-check">
            <input type="checkbox" checked={this.state.isSpeakerOff} onChange={this.changeIsSpeakerOff.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsMicOn:</div>
          <div className="input-box-text-check">
            <input type="checkbox" checked={this.state.isMicOn} onChange={this.changeIsMicOn.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsCameraOn:</div>
          <div className="input-box-text-check">
            <input type="checkbox" checked={this.state.isCameraOn} onChange={this.changeIsCameraOn.bind(this)} />
          </div>
        </div>
        <button onClick={this.goToJoinConfByRandom.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default JoinConfByRandom
