import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { SDKERR } from '../../../../Constants/enum'
import { showErrorTips } from '../../../../utils'

class LoginByAppId extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      corpId: '',
      thirdUserId: '',
      userName: '',
      signature: '',
      nonce: '',
      expireTime: 0,
      userEmail: '',
      userPhone: '',
      deptCode: '',
    }
  }

  changeCorpId (e) {
    this.setState({
      corpId: e.target.value,
    })
  }

  changeThirdUserId (e) {
    this.setState({
      thirdUserId: e.target.value,
    })
  }

  changeUserName (e) {
    this.setState({
      userName: e.target.value,
    })
  }

  changeSignature (e) {
    this.setState({
      signature: e.target.value,
    })
  }

  changeNonce (e) {
    this.setState({
      nonce: e.target.value,
    })
  }

  changeExpireTime (e) {
    this.setState({
      expireTime: Number(e.target.value),
    })
  }

  changeUserEmail (e) {
    this.setState({
      userEmail: e.target.value,
    })
  }

  changeUserPhone (e) {
    this.setState({
      userPhone: e.target.value,
    })
  }

  changeDeptCode (e) {
    this.setState({
      deptCode: e.target.value,
    })
  }

  async goToLoginByAppId () {
    const { corpId, thirdUserId, userName, signature, nonce, expireTime, userEmail, userPhone, deptCode } = this.state
    const param = {
      corpId,
      thirdUserId,
      userName,
      signature,
      nonce,
      expireTime,
      userEmail,
      userPhone,
      deptCode,
    }
    const apiService = new ApiService()
    const setResult = await apiService.loginByAppId(param)
    if (setResult.ret === 0) {
      this.props.history.push('/main')
    } else if (setResult.ret === SDKERR.SDK_LOGIN_E_ERR_MNG_FAILED) {
      // 服务器降级，接入方收到该错误码可以继续调用入会接口离线入会
      this.props.history.push('/main')
    } else {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="loginByAppId">
        <div className="input-box">
          <div className="input-box-title">CorpId:</div>
          <div className="input-box-text">
            <input value={this.state.corpId} onChange={this.changeCorpId.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">UserName:</div>
          <div className="input-box-text">
            <input value={this.state.userName} onChange={this.changeUserName.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">ThirdUserId:</div>
          <div className="input-box-text">
            <input value={this.state.thirdUserId} onChange={this.changeThirdUserId.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Signature:</div>
          <div className="input-box-text">
            <input value={this.state.signature} onChange={this.changeSignature.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Nonce:</div>
          <div className="input-box-text">
            <input value={this.state.nonce} onChange={this.changeNonce.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">ExpireTime:</div>
          <div className="input-box-text">
            <input value={this.state.expireTime} onChange={this.changeExpireTime.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">UserEmail:</div>
          <div className="input-box-text">
            <input value={this.state.userEmail} onChange={this.changeUserEmail.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">UserPhone:</div>
          <div className="input-box-text">
            <input value={this.state.userPhone} onChange={this.changeUserPhone.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">deptCode:</div>
          <div className="input-box-text">
            <input value={this.state.deptCode} onChange={this.changeDeptCode.bind(this)}/>
          </div>
        </div>
        <button onClick={this.goToLoginByAppId.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default LoginByAppId
