import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { AuthServerType, SDKERR } from '../../../../Constants/enum'
import { showErrorTips } from '../../../../utils'

const AuthServerTypeOptions = [
  {
    value: AuthServerType.AUTH_SERVER_TYPE_OAUTH2,
    label: 'OAUTH2',
  },
]

class LoginBySSO extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      code: '',
      domain: '',
      authServerType: AuthServerType.AUTH_SERVER_TYPE_OAUTH2,
    }
  }

  changeCode (e) {
    this.setState({
      code: e.target.value,
    })
  }

  changeDomain (e) {
    this.setState({
      domain: e.target.value,
    })
  }

  changeAuthServerType (e) {
    this.setState({
      authServerType: Number(e.target.value),
    })
  }

  async goToLoginBySSO () {
    const { code, domain, authServerType } = this.state
    const param = {
      code,
      domain,
      authServerType,
    }
    const apiService = new ApiService()
    const setResult = await apiService.loginBySSO(param)
    if (setResult.ret === 0) {
      this.props.history.push('/main')
    } else if (setResult.ret === SDKERR.SDK_LOGIN_E_ERR_MNG_FAILED) {
      // 服务器降级，接入方收到该错误码可以继续调用入会接口离线入会
      this.props.history.push('/main')
    } else {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
            <div className="loginBySSO">
                <div className="input-box">
                    <div className="input-box-title">Code:</div>
                    <div className="input-box-text">
                        <input value={this.state.code} onChange={this.changeCode.bind(this)} />
                    </div>
                </div>
                <div className="input-box">
                    <div className="input-box-title">Domain:</div>
                    <div className="input-box-text">
                        <input value={this.state.domain} onChange={this.changeDomain.bind(this)} />
                    </div>
                </div>
                <div className="input-box">
                    <div className="input-box-title" style={{ width: '140px' }}>AuthServerType:</div>
                    <div className="input-box-text" style={{ width: '85px' }}>
                        <select value={this.state.authServerType} onChange={this.changeAuthServerType.bind(this)}>
                            {AuthServerTypeOptions.map(item => {
                              return <option value={item.value} key={item.value}>{item.label}</option>
                            })}
                        </select>
                    </div>
                </div>
                <button onClick={this.goToLoginBySSO.bind(this)}>Submit</button>
                <button onClick={this.goBack.bind(this)}>Back</button>
            </div>
    )
  }
}

export default LoginBySSO
