import React from 'react'
import './index.css'
import ApiService from '../../../AppService/ApiService'
import { showErrorTips } from '../../../utils'

class SetGlobalGuaranteedIpAddresses extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      domain: '',
      guaranteedIps: '',
      domain1: '',
      guaranteedIps1: '',
      domain2: '',
      guaranteedIps2: '',
    }
  }

  changedomain (e) {
    this.setState({
      domain: e.target.value,
    })
  }

  changeGuaranteedIps (e) {
    this.setState({
      guaranteedIps: e.target.value,
    })
  }

  changedomain1 (e) {
    this.setState({
      domain1: e.target.value,
    })
  }

  changeGuaranteedIps1 (e) {
    this.setState({
      guaranteedIps1: e.target.value,
    })
  }

  changedomain2 (e) {
    this.setState({
      domain2: e.target.value,
    })
  }

  changeGuaranteedIps2 (e) {
    this.setState({
      guaranteedIps2: e.target.value,
    })
  }

  async goToSetGlobalGuaranteedIpAddresses () {
    const { domain, guaranteedIps, domain1, guaranteedIps1, domain2, guaranteedIps2 } = this.state

    const guaranteedIpAddressesParam = {
      addressList: [{
        domain,
        guaranteedIps,
      }, {
        domain: domain1,
        guaranteedIps: guaranteedIps1,
      }, {
        domain: domain2,
        guaranteedIps: guaranteedIps2,
      }],
    }

    const apiService = new ApiService()
    const setResult = await apiService.setGlobalGuaranteedIpAddresses(guaranteedIpAddressesParam)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="setGlobalGuaranteedIpAddresses">

        <div className='input-box-title-main'>Group1:</div>

        <div className='input-box'>
          <div className='input-box-title'>Domain:</div>
          <input value={this.state.domain} style={{ width: '100%' }} onChange={this.changedomain.bind(this)} />
        </div>

        <div className="input-box-long">
          <div className="input-box-title">GuaranteedIps:</div>
          <textarea value={this.state.guaranteedIps} style={{ width: '100%' }} onChange={this.changeGuaranteedIps.bind(this)} />
        </div>

        <div className='input-box-title-main'>Group2:</div>

        <div className='input-box'>
          <div className='input-box-title'>Domain:</div>
          <input value={this.state.domain1} style={{ width: '100%' }} onChange={this.changedomain1.bind(this)} />
        </div>

        <div className="input-box-long">
          <div className="input-box-title">GuaranteedIps:</div>
          <textarea value={this.state.guaranteedIps1} style={{ width: '100%' }} onChange={this.changeGuaranteedIps1.bind(this)} />
        </div>

        <div className='input-box-title-main'>Group3:</div>

        <div className='input-box'>
          <div className='input-box-title'>Domain:</div>
          <input value={this.state.domain2} style={{ width: '100%' }} onChange={this.changedomain2.bind(this)} />
        </div>

        <div className="input-box-long">
          <div className="input-box-title">GuaranteedIps:</div>
          <textarea value={this.state.guaranteedIps2} style={{ width: '100%' }} onChange={this.changeGuaranteedIps2.bind(this)} />
        </div>

        <button onClick={this.goToSetGlobalGuaranteedIpAddresses.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetGlobalGuaranteedIpAddresses
