import React from 'react'
import './index.css'
import ApiService from '../../../AppService/ApiService'
import { showErrorTips } from '../../../utils'

class SetGuaranteedIpAddresses extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      guaranteedIpAddresses: '',
    }
  }

  changeGuaranteedIpAddresses (e) {
    this.setState({
      guaranteedIpAddresses: e.target.value,
    })
  }

  async goToSetGuaranteedIpAddresses () {
    const { guaranteedIpAddresses } = this.state
    const apiService = new ApiService()
    const ret = apiService.SetGuaranteedIpAddresses(guaranteedIpAddresses)
    if (ret !== 0) {
      showErrorTips(ret, '')
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="setGuaranteedIpAddresses">
        <div className="input-box-long">
          <div className="input-box-title-long">GuaranteedIpAddresses:</div>
          <div className="input-box-text">
            <textarea value={this.state.guaranteedIpAddresses} onChange={this.changeGuaranteedIpAddresses.bind(this)} />
          </div>
        </div>
        <button onClick={this.goToSetGuaranteedIpAddresses.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetGuaranteedIpAddresses
