import React from 'react'
import './index.css'
import ApiService from '../../../AppService/ApiService'
import { NetworkAccessType, NetConnectType } from '../../../Constants/enum'
import { showErrorTips } from '../../../utils'

const NetworkAccessTypeOptions = [
  {
    value: NetworkAccessType.ACCESS_TYPE_AUTO,
    label: 'Auto Mode',
  },
  {
    value: NetworkAccessType.ACCESS_TYPE_INNER,
    label: 'Inner Access',
  },
  {
    value: NetworkAccessType.ACCESS_TYPE_OUTER,
    label: 'Outer Access',
  },
]

const NetConnectTypeOptions = [
  {
    value: NetConnectType.NET_CONNECT_AUTO,
    label: 'Auto Mode',
  },
  {
    value: NetConnectType.NET_CONNECT_FORCE_VPN,
    label: 'Force Vpn',
  },
  {
    value: NetConnectType.NET_CONNECT_FORCE_DIRECT,
    label: 'Force Direct',
  },
]

class SetNetworkMode extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      accessType: 0,
      netConnectType: NetConnectType.NET_CONNECT_AUTO,
    }
  }

  changeAccessType (e) {
    this.setState({
      accessType: Number(e.target.value),
    })
  }

  changeNetConnectType (e) {
    this.setState({
      netConnectType: Number(e.target.value),
    })
  }

  async goToSetNetworkMode () {
    const { accessType, netConnectType } = this.state
    const param = {
      accessType,
      netConnectType,
    }
    const apiService = new ApiService()
    const setResult = await apiService.setNetworkMode(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="setNetworkMode">
        <div className="input-box">
          <div className="input-box-title">AccessType:</div>
          <div className="input-box-text">
            <select value={this.state.accessType} onChange={this.changeAccessType.bind(this)}>
              {NetworkAccessTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">NetConnectType:</div>
          <div className="input-box-text">
            <select value={this.state.netConnectType} onChange={this.changeNetConnectType.bind(this)}>
              {NetConnectTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <button className='btn' onClick={this.goToSetNetworkMode.bind(this)}>Submit</button>
        <button className='btn' onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetNetworkMode
