import React from 'react'
import { connect } from 'react-redux'
import PropTypes from 'prop-types'
import { ProxyConfigPolicy } from 'hwmsdk-electron/ts/api/Enum'
import { isMac } from 'hwmsdk-electron-demo/src/common/platform'

import './index.css'
import ApiService from 'hwmsdk-electron-demo/src/AppService/ApiService'
import { updateProxy } from 'hwmsdk-electron-demo/redux/settingSlice'

const { ipcRenderer } = require('electron')

const ProxyConfigPolicyOptions = [
  {
    value: ProxyConfigPolicy.HWM_PROXY_CONFIG_POLICY_CUSTOM,
    label: '手动配置代理',
  },
  {
    value: ProxyConfigPolicy.HWM_PROXY_CONFIG_POLICY_OFF,
    label: '不使用代理',
  },
  {
    value: ProxyConfigPolicy.HWM_PROXY_CONFIG_POLICY_AUTO,
    label: '自动配置代理',
  },
]

class SetProxy extends React.Component {
  changeProxyConfigPolicy (e) {
    updateProxy({
      proxyConfigPolicy: Number(e.target.value),
    })
  }

  changeServer (e) {
    updateProxy({
      server: e.target.value,
    })
  }

  changePort (e) {
    updateProxy({
      port: Number(e.target.value),
    })
  }

  changeAccount (e) {
    updateProxy({
      account: e.target.value,
    })
  }

  changePassword (e) {
    updateProxy({
      password: e.target.value,
    })
  }

  goBack () {
    this.props.history.goBack()
  }

  async submit () {
    const { proxyConfigPolicy, server, port, account, password } = this.props
    let param = {
      proxyConfigPolicy,
      server,
      port,
      account,
      password,
    }
    if (proxyConfigPolicy !== ProxyConfigPolicy.HWM_PROXY_CONFIG_POLICY_CUSTOM) {
      param = {
        proxyConfigPolicy,
        server: '',
        port: 0,
        account: '',
        password: '',
      }
    }
    const apiService = new ApiService()
    const setResult = await apiService.setProxy(param)
    if (setResult.ret === 0) {
      this.goBack()
    } else {
      ipcRenderer.send(
        'show-error-alert',
        'setProxy error = ' + setResult.ret,
      )
    }
  }

  render () {
    const { proxyConfigPolicy, server, port, account, password } = this.props
    return (
      <div className="setProxy" >
        {!isMac() && <div className="input-box">
          <div className="input-box-title">Policy:</div>
          <div className="input-box-text">
            <select
              value={proxyConfigPolicy}
              onChange={this.changeProxyConfigPolicy.bind(this)}
            >
              {ProxyConfigPolicyOptions.map((item) => {
                return (
                  <option value={item.value} key={item.value}>
                    {item.label}
                  </option>
                )
              })}
            </select>
          </div>
        </div>}
        {
          proxyConfigPolicy ===
          ProxyConfigPolicy.HWM_PROXY_CONFIG_POLICY_CUSTOM && (
            <div>
              <div className="input-box">
                <div className="input-box-title">Address:</div>
                <div className="input-box-text">
                  <input
                    value={server}
                    onChange={this.changeServer.bind(this)}
                  />
                </div>
              </div>
              <div className="input-box">
                <div className="input-box-title">Port:</div>
                <div className="input-box-text">
                  <input
                    value={port}
                    onChange={this.changePort.bind(this)}
                  />
                </div>
              </div>
              <div className="input-box">
                <div className="input-box-title">Account:</div>
                <div className="input-box-text">
                  <input
                    value={account}
                    onChange={this.changeAccount.bind(this)}
                  />
                </div>
              </div>
              <div className="input-box">
                <div className="input-box-title">Password:</div>
                <div className="input-box-text">
                  <input
                    value={password}
                    onChange={this.changePassword.bind(this)}
                  />
                </div>
              </div>
            </div>
          )
        }
        <button onClick={this.submit.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div >
    )
  }
}

SetProxy.propTypes = {
  proxyConfigPolicy: PropTypes.number,
  server: PropTypes.string,
  port: PropTypes.number,
  account: PropTypes.string,
  password: PropTypes.string,
}

const mapStateToProps = (state) => {
  const { proxyConfigPolicy, server, port, account, password } = state.setting.proxy
  return { proxyConfigPolicy, server, port, account, password }
}
export default connect(mapStateToProps)(SetProxy)
