import React from 'react'
import { withRouter } from 'react-router-dom'

import './index.css'
import ApiService from '../../AppService/ApiService'
import { showErrorTips } from '../../utils'

const os = window.require('os')
const platform = os.platform()

class Login extends React.Component {
  async goToInit () {
    this.props.history.push('/login/init')
  }

  async exitSdk () {
    if (platform === 'darwin') {
      console.log('current is macOS, execute exit when app is before-quit')
    } else {
      const apiService = await new ApiService()
      const setResult = await apiService.exit()
      if (setResult !== 0) {
        window.electron.ipcRenderer.send('show-error-alert', 'exit error = ' + setResult)
      }
    }
  }

  componentDidMount () {
    window.electron.ipcRenderer.on('app-going-to-quit', async () => {
      console.log('app is quit')
      const apiService = await new ApiService()
      await apiService.exit()
    })
  }

  goToConfigPage () {
    this.props.history.push('/configPage')
  }

  goToSetting () {
    this.props.history.push('/setting')
  }

  goToLoginPage () {
    this.props.history.push('/loginPage')
  }

  goToJoinConfPage () {
    this.props.history.push('/joinConfPage')
  }

  goToJoinConfByNonce () {
    this.props.history.push('/login/joinConfByNonce')
  }

  goToConfCtrlPage () {
    this.props.history.push('/confCtrlPage')
  }

  goToSetNetworkMode () {
    this.props.history.push('./login/setNetworkMode')
  }

  goToSetServerAddress () {
    this.props.history.push('/login/SetServerAddress')
  }

  goToSetProxy () {
    this.props.history.push('/login/SetProxy')
  }

  async goToGetUserState () {
    const apiService = new ApiService()
    const setResult = await apiService.getUserState()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToGetLoginState () {
    const apiService = new ApiService()
    const setResult = await apiService.getLoginState()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goToSetGuaranteedIpAddresses () {
    this.props.history.push('./login/setGuaranteedIpAddresses')
  }

  goToSetCAVerifyInfo () {
    this.props.history.push('./login/setCAVerifyInfo')
  }

  goToSetGlobalGuaranteedIpAddresses () {
    this.props.history.push('./login/setGlobalGuaranteedIpAddresses')
  }

  render () {
    return (
            <div className="Login">
                <button onClick={this.goToInit.bind(this)}>Init</button>
                <button onClick={this.goToSetServerAddress.bind(this)}>SetServerAddress</button>
                <button onClick={this.goToSetProxy.bind(this)}>SetProxy</button>
                <button onClick={this.goToLoginPage.bind(this)}>Login</button>
                <button onClick={this.goToJoinConfPage.bind(this)}>Join Conf Anoymous</button>
                <button onClick={this.goToConfCtrlPage.bind(this)}>Conf Control</button>
                <button onClick={this.goToConfigPage.bind(this)}>Config</button>
                <button onClick={this.goToSetting.bind(this)}>Setting</button>
                <button onClick={this.goToJoinConfByNonce.bind(this)}>Join Conf by Nonce</button>
                <button onClick={this.goToSetNetworkMode.bind(this)}>Set Network Mode</button>
                <button onClick={this.goToGetUserState.bind(this)}>Get User State</button>
                <button onClick={this.goToGetLoginState.bind(this)}>Get Login State</button>
                <button onClick={this.goToSetGuaranteedIpAddresses.bind(this)}>Set GuaranteedIp Addresses</button>
                <button onClick={this.goToSetCAVerifyInfo.bind(this)}>Set CAVerify Info</button>
                <button onClick={this.goToSetGlobalGuaranteedIpAddresses.bind(this)}>Set Global GuaranteedIp Addresses</button>
                <button onClick={this.exitSdk.bind(this)}>Exit</button>
            </div>
    )
  }
}

export default withRouter(Login)
