import React from 'react'
import './index.css'
class ConfLists extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      confListInfo: [],
    }
  }

  componentDidMount () {
    this.getConfList()
    // 监听路由的变化,如果路由发生变化则进行相应操作
    this.unListen = this.props.history.listen(location => {
      // 最新路由的 location 对象，可以通过比较 pathname 是否相同来判断路由的变化情况
      if (this.props.location.pathname !== location.pathname) {
        // 路由发生了变化
        this.getConfList()
      }
    })
  }

  componentWillUnmount () {
    this.unListen && this.unListen()
  }

  getConfList () {
    let _confListInfo = window.sessionStorage.getItem('confListInfo')
    _confListInfo = _confListInfo ? JSON.parse(_confListInfo) : []
    this.setState({
      confListInfo: _confListInfo,
    })
  }

  goConfInfo (confId) {
    this.props.history.push({ pathname: '/main/confInfo', query: { confId } })
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    const { confListInfo } = this.state
    return (
      <div className="confLists">
        {
          confListInfo.map((obj) => {
            return (
              <div key={obj.confId} className="confBox" onClick={this.goConfInfo.bind(this, obj.confId)}>
                <div className="confBox_id">{obj.vmrConfId === '' ? obj.confId : obj.vmrConfId}</div>
                <div className="confBox_name">{obj.subject}</div>
              </div>
            )
          })
        }
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default ConfLists
