import React from 'react'
import './index.css'
import ApiService from '../../../AppService/ApiService'
import { MediaType, VmrConfIdType, ConfAllowJoinUserType, VmrIdType, AutoMuteType, DeployType } from '../../../Constants/enum'
import PropTypes from 'prop-types'
import { MediaTypeOptions, VmrConfIdTypeOptions, ConfAllowJoinUserTypeOptions, TerminalAutoMuteTypeOptions } from '../../../Constants/typeOption'
import { showErrorTips } from '../../../utils'
import { connect } from 'react-redux'

class CreateConf extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      subject: '即时会议',
      mediaType: MediaType.HWM_MEDIA_TYPE_VIDEO,
      needPassword: false,
      isAutoRecord: false,
      allowRecord: false,
      confAllowJoinUser: ConfAllowJoinUserType.CONF_ALLOW_JOIN_ANYONE,
      vmrFlag: false,
      vmrId: '',
      vmrInfo: [],
      vmrIndex: 0,
      vmrConfIdType: VmrConfIdType.HWM_VMR_CONF_ID_TYPE_FIXED,
      vmrConfIdTypeDisable: true,
      guestPwd: 'random guest pass',
      guestPwdDisable: false,
      isOpenWaitingRoom: false,
      duration: 60,
      isMicOn: true,
      isCameraOn: false,
      attendees: '',
      attendeesExample: '[{"nickName":"店小二","aliasCN":"汤姆","aliasEN":"tom","number":"15211111111","thirdUserId":"","extendedField":"","corpId":"","type":0,"autoInviteType":0}]',
      customInfo: '',
      concurrentParticipants: 0, // 会议方数，会议最大与会人数限制. 0: 无限制, 大于0: 会议最大与会人数
      isEnableShareVmr: false,
      isUseShareVmr: false, // 使用共享vmr
      defaultSummaryState: false,
      autoPublishSummary: true,
      autoMuteMode: AutoMuteType.AUTO_MUTE_TYPE_MUTE,
      hardTerminalAutoMuteMode: AutoMuteType.AUTO_MUTE_TYPE_UNMUTE,
      supportWatermark: false,
      forbiddenScreenShots: false,
    }
  }

  componentDidMount () {
    this.refreshVmrList()
  }

  changeSubject (e) {
    this.setState({
      subject: e.target.value,
    })
  }

  changeMediaType (e) {
    this.setState({
      mediaType: Number(e.target.value),
    })
  }

  changeNeedPassword (e) {
    this.setState({
      needPassword: e.target.checked,
    })
  }

  changeIsAutoRecord (e) {
    this.setState({
      isAutoRecord: e.target.checked,
    })
  }

  changeDefaultSummaryState (e) {
    this.setState({
      defaultSummaryState: e.target.checked,
    })
  }

  changeAutoPublishSummary (e) {
    this.setState({
      autoPublishSummary: e.target.checked,
    })
  }

  changeAllowRecord (e) {
    this.setState({
      allowRecord: e.target.checked,
    })
  }

  changeConfAllowJoinUser (e) {
    const val = Number(e.target.value)
    this.setState({
      confAllowJoinUser: val,
    })
  }

  async refreshVmrList () {
    const { deployType } = this.props
    if (deployType === DeployType.SINK_MODE) {
      return
    }
    const apiService = await new ApiService()
    const setResult = await apiService.getVmrList()
    if (setResult.ret === 0) {
      const { vmrs, isEnableShareVmr } = setResult.vmrListInfo
      this.setState({
        vmrInfo: vmrs,
        isEnableShareVmr,
      })
    } else {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async changeVmrFlag (e) {
    this.setState({
      vmrFlag: e.target.checked,
      vmrConfIdType: VmrConfIdType.HWM_VMR_CONF_ID_TYPE_FIXED,
    })
    if (e.target.checked) {
      await this.refreshVmrList()
      const { vmrInfo } = this.state
      if (vmrInfo?.length > 0) {
        this.changeVmrIndex(0)
      }
    } else {
      this.setState({
        guestPwd: 'random guest pass',
        guestPwdDisable: false,
        vmrConfIdTypeDisable: true,
      })
    }
  }

  changeUseShareVmr (e) {
    if (e.target.checked) {
      this.setState({
        isUseShareVmr: true,
        vmrConfIdType: VmrConfIdType.HWM_VMR_CONF_ID_TYPE_RANDOM, // 随机会议号
      })
    } else {
      this.setState({
        isUseShareVmr: false,
      })
    }
  }

  changeVmrIndex (e) {
    const vmrIndexInput = typeof e === 'number' ? e : Number(e.target.value)
    const { vmrInfo } = this.state
    this.setState({
      vmrIndex: vmrIndexInput,
      vmrId: vmrInfo[vmrIndexInput].vmrId,
      guestPwd: vmrInfo[vmrIndexInput].guestPwd,
      guestPwdDisable: true,
      vmrConfIdType: VmrConfIdType.HWM_VMR_CONF_ID_TYPE_FIXED,
    })

    // 云会议室才能修改vmrConfIdType
    if (vmrInfo[vmrIndexInput].vmrType === VmrIdType.CLOUD_MEETING_ROOM_ID) {
      this.setState({
        vmrConfIdTypeDisable: false,
      })
    } else {
      this.setState({
        vmrConfIdTypeDisable: true,
      })
    }
    this.setState({
      isOpenWaitingRoom: vmrInfo[vmrIndexInput]?.isOpenWaitingRoom,
      confAllowJoinUser: vmrInfo[vmrIndexInput]?.confAllowJoinUser,
    })
  }

  changeVmrConfIdType (e) {
    const vmrConfIdTypeInput = Number(e.target.value)
    this.setState({
      vmrConfIdType: vmrConfIdTypeInput,
    })
    if (vmrConfIdTypeInput === VmrConfIdType.HWM_VMR_CONF_ID_TYPE_RANDOM) {
      // 随机VMR id
      this.setState({
        guestPwd: 'random guest pass',
        guestPwdDisable: false,
      })
    } else {
      // 固定VMR id
      const { vmrInfo, vmrIndex } = this.state
      this.setState({
        guestPwd: vmrInfo[vmrIndex].guestPwd,
        guestPwdDisable: true,
        isOpenWaitingRoom: vmrInfo[vmrIndex]?.isOpenWaitingRoom,
        confAllowJoinUser: vmrInfo[vmrIndex]?.confAllowJoinUser,
      })
    }
  }

  changeGuestPwd (e) {
    this.setState({
      guestPwd: e.target.value,
    })
  }

  changeIsOpenWaitingRoom (e) {
    const val = e.target.checked
    this.setState({
      isOpenWaitingRoom: val,
    })
  }

  changeDuration (e) {
    this.setState({
      duration: Number(e.target.value),
    })
  }

  changeIsMicOn (e) {
    this.setState({
      isMicOn: e.target.checked,
    })
  }

  changeIsCameraOn (e) {
    this.setState({
      isCameraOn: e.target.checked,
    })
  }

  changeAttendees (e) {
    this.setState({
      attendees: e.target.value,
    })
  }

  changeCustomInfo (e) {
    this.setState({
      customInfo: e.target.value,
    })
  }

  changeConcurrentParticipants (e) {
    this.setState({
      concurrentParticipants: Number(e.target.value),
    })
  }

  changeSoftTerminalAutoMute = (e) => {
    this.setState({ autoMuteMode: Number(e.target.value) })
  }

  changeHardTerminalAutoMuteMode = (e) => {
    this.setState({ hardTerminalAutoMuteMode: Number(e.target.value) })
  }

  changeSupportWatermark = (e) => {
    const val = e.target.checked
    this.setState({
      supportWatermark: val,
    })
  }

  changeForbiddenScreenShots = (e) => {
    const val = e.target.checked
    this.setState({
      forbiddenScreenShots: val,
    })
  }

  async goToCreateConf () {
    const {
      subject, mediaType, needPassword, isAutoRecord, allowRecord, confAllowJoinUser, vmrId, vmrConfIdType,
      guestPwd, isOpenWaitingRoom, duration, isMicOn, isCameraOn, attendees, vmrFlag, customInfo,
      concurrentParticipants, isUseShareVmr, isEnableShareVmr, defaultSummaryState, autoPublishSummary, autoMuteMode, hardTerminalAutoMuteMode,
      supportWatermark, forbiddenScreenShots,
    } = this.state
    const _attendees = attendees ? JSON.parse(attendees) : ''
    const isShareVmr = isEnableShareVmr && isUseShareVmr
    const param = {
      confResType: isShareVmr ? 3 : 0, // 3-共享vmr，0-使用默认方式
      subject,
      mediaType,
      needPassword,
      isAutoRecord,
      allowRecord,
      confAllowJoinUser,
      vmrId: (isShareVmr || !vmrFlag) ? '' : vmrId,
      vmrConfIdType,
      guestPwd: (guestPwd === 'random guest pass') ? '' : guestPwd,
      isOpenWaitingRoom,
      duration,
      isMicOn,
      isCameraOn,
      attendees: _attendees,
      customInfo,
      concurrentParticipants,
      defaultSummaryState: defaultSummaryState ? 1 : 0,
      autoPublishSummary,
      autoMuteMode,
      hardTerminalAutoMuteMode,
      supportWatermark,
      forbiddenScreenShots,
    }
    const apiService = new ApiService()
    const setResult = await apiService.createConf(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    const { vmrInfo, isEnableShareVmr, isUseShareVmr, vmrConfIdTypeDisable, autoMuteMode, hardTerminalAutoMuteMode } = this.state
    return (
      <div className="createConf">
        <div className="input-box">
          <div className="input-box-title">Conf Subject:</div>
          <div className="input-box-text"><input value={this.state.subject} onChange={this.changeSubject.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">MediaType:</div>
          <div className="input-box-text">
            <select value={this.state.mediaType} onChange={this.changeMediaType.bind(this)}>
              {MediaTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">Need Password:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.needPassword} onChange={this.changeNeedPassword.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsAutoRecord:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.isAutoRecord} onChange={this.changeIsAutoRecord.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">allowRecord:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.allowRecord} onChange={this.changeAllowRecord.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">DefaultSummaryState:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.defaultSummaryState} onChange={this.changeDefaultSummaryState.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">AutoPublishSummary:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.autoPublishSummary} onChange={this.changeAutoPublishSummary.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title" style={{ width: '140px' }}>ConfAllowJoinUser:</div>
          <div className="input-box-text" style={{ width: '85px' }}>
            <select value={this.state.confAllowJoinUser} onChange={this.changeConfAllowJoinUser.bind(this)}>
              {ConfAllowJoinUserTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">Vmr Flag:</div>
          <div className="input-box-text-check"><input disabled={isUseShareVmr} type="checkbox" checked={this.state.vmrFlag} onChange={this.changeVmrFlag.bind(this)} /></div>
        </div>
        {isEnableShareVmr
          ? <div className="input-box">
          <div className="input-box-title-check">Use Share Vmr:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={isUseShareVmr} onChange={this.changeUseShareVmr.bind(this)} /></div>
        </div>
          : null}
        <div className="input-box">
          <div className="input-box-title">Vmr Id:</div>
          <div className="input-box-text">
            <select disabled={isUseShareVmr} value={this.state.vmrIndex} onChange={this.changeVmrIndex.bind(this)}>
              {
                vmrInfo.map((obj, index) => {
                  return (
                    <option value={index} key={index}>{obj.vmrConfId}</option>
                  )
                })
              }
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title" style={{ width: '140px' }}>VmrConfIdType:</div>
          <div className="input-box-text" style={{ width: '85px' }}>
            <select disabled={isUseShareVmr || vmrConfIdTypeDisable} value={this.state.vmrConfIdType} onChange={this.changeVmrConfIdType.bind(this)}>
              {VmrConfIdTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Guest pass:</div>
          <div className="input-box-text"><input value={this.state.guestPwd} disabled={this.state.guestPwdDisable} onChange={this.changeGuestPwd.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsOpenWaitingRoom:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.isOpenWaitingRoom} onChange={this.changeIsOpenWaitingRoom.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">SupportWatermark:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.supportWatermark} onChange={this.changeSupportWatermark.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">ForbiddenScreenShots:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.forbiddenScreenShots} onChange={this.changeForbiddenScreenShots.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">SoftTerminalAutoMute:</div>
          <div className="input-box-text-check">
            <select value={autoMuteMode} onChange={this.changeSoftTerminalAutoMute}>
              {TerminalAutoMuteTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">HardTerminalAutoMute:</div>
          <div className="input-box-text-check">
            <select value={hardTerminalAutoMuteMode} onChange={this.changeHardTerminalAutoMuteMode}>
              {TerminalAutoMuteTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Duration:</div>
          <div className="input-box-text"><input value={this.state.duration} onChange={this.changeDuration.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsMicOn:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.isMicOn} onChange={this.changeIsMicOn.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">isCameraOn:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.isCameraOn} onChange={this.changeIsCameraOn.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">concurrentParticipants:</div>
          <div className="input-box-text"><input value={this.state.concurrentParticipants} onChange={this.changeConcurrentParticipants.bind(this)} /></div>
        </div>
        <div className="input-box-long">
          <div className="input-box-title-long">Attendees:</div>
          <div className="input-box-edit"><textarea value={this.state.attendees} onChange={this.changeAttendees.bind(this)} placeholder={this.state.attendeesExample} /></div>
        </div>
        <div className="input-box-long">
          <div className="input-box-title-long">User Data:</div>
          <div className="input-box-edit"><textarea value={this.state.customInfo} onChange={this.changeCustomInfo.bind(this)} /></div>
        </div>
        <button onClick={this.goToCreateConf.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

CreateConf.propTypes = {
  deployType: PropTypes.oneOf([DeployType.SINK_MODE, DeployType.CLOUD_MODE]),
}

const mapStateToProps = (state) => {
  const { deployType } = state.setting.deploy
  return { deployType }
}

export default connect(mapStateToProps)(CreateConf)
