import React from 'react'
import './index.less'
import ApiService from '../../../AppService/ApiService'
import { MediaType, ConfAllowJoinUserType, AttendeeType } from '../../../Constants/enum'
import { MediaTypeOptions, ConfAllowJoinUserTypeOptions, AttendeeTypeOptions } from '../../../Constants/typeOption'
import { showErrorTips } from '../../../utils'

class StartP2pConf extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      callerNickName: '',
      callerAliasCN: '',
      callerAliasEN: '',
      callerExtendedField: '',
      calleeNickName: '',
      calleeAliasCN: '',
      calleeAliasEN: '',
      calleeNumber: '',
      calleeThirdUserId: '',
      calleeExtendedField: '',
      calleeCorpId: '',
      customInfo: '',
      mediaType: MediaType.HWM_MEDIA_TYPE_VIDEO,
      isGuestJoinConfWithoutPwd: false,
      confAllowJoinUser: ConfAllowJoinUserType.CONF_ALLOW_JOIN_ANYONE,
      calleeAttendeeType: AttendeeType.ATTENDEE_TYPE_NORMAL,
    }
  }

  changeCallerNickName (e) {
    this.setState({
      callerNickName: e.target.value,
    })
  }

  changeCallerAliasCN (e) {
    this.setState({
      callerAliasCN: e.target.value,
    })
  }

  changeCallerAliasEN (e) {
    this.setState({
      callerAliasEN: e.target.value,
    })
  }

  changeCallerExtendedField (e) {
    this.setState({
      callerExtendedField: e.target.value,
    })
  }

  changeCalleeNickName (e) {
    this.setState({
      calleeNickName: e.target.value,
    })
  }

  changeCalleeAliasCN (e) {
    this.setState({
      calleeAliasCN: e.target.value,
    })
  }

  changeCalleeAliasEN (e) {
    this.setState({
      calleeAliasEN: e.target.value,
    })
  }

  changeCalleeNumber (e) {
    this.setState({
      calleeNumber: e.target.value,
    })
  }

  changeCalleeThirdUserId (e) {
    this.setState({
      calleeThirdUserId: e.target.value,
    })
  }

  changeCalleeExtendedField (e) {
    this.setState({
      calleeExtendedField: e.target.value,
    })
  }

  changeCalleeCorpId (e) {
    this.setState({
      calleeCorpId: e.target.value,
    })
  }

  changeMediaType (e) {
    this.setState({
      mediaType: Number(e.target.value),
    })
  }

  changeAttendeeType (e) {
    this.setState({
      calleeAttendeeType: Number(e.target.value),
    })
  }

  changeCustomInfo (e) {
    this.setState({
      customInfo: e.target.value,
    })
  }

  changeIsGuestJoinConfWithoutPwd (e) {
    this.setState({
      isGuestJoinConfWithoutPwd: e.target.checked,
    })
  }

  changeConfAllowJoinUser (e) {
    const val = Number(e.target.value)
    this.setState({
      confAllowJoinUser: val,
    })
  }

  async startP2pConf () {
    const {
      callerNickName,
      callerAliasCN,
      callerAliasEN,
      callerExtendedField,
      calleeNickName,
      calleeAliasCN,
      calleeAliasEN,
      calleeNumber,
      calleeThirdUserId,
      calleeExtendedField,
      calleeCorpId,
      mediaType,
      isGuestJoinConfWithoutPwd,
      confAllowJoinUser,
      customInfo,
      calleeAttendeeType,
    } = this.state
    const param = {
      callerInfo: {
        nickName: callerNickName,
        aliasCN: callerAliasCN,
        aliasEN: callerAliasEN,
        extendedField: callerExtendedField,
      },
      calleeInfo: {
        nickName: calleeNickName,
        aliasCN: calleeAliasCN,
        aliasEN: calleeAliasEN,
        number: calleeNumber,
        thirdUserId: calleeThirdUserId,
        extendedField: calleeExtendedField,
        corpId: calleeCorpId,
        type: calleeAttendeeType,
      },
      mediaType,
      customInfo,
      isGuestJoinConfWithoutPwd,
      confAllowJoinUser,
    }
    const apiService = new ApiService()
    const setResult = await apiService.startP2pConf(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="startP2pConf">
        <div className="box-title">Caller Info
          <div className="input-box">
            <div className="input-box-title">NickName:</div>
            <div className="input-box-text">
              <input
                className="input-text"
                value={this.state.callerNickName}
                onChange={this.changeCallerNickName.bind(this)}
              />
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">AliasCN:</div>
            <div className="input-box-text">
              <input
                className="input-text"
                value={this.state.callerAliasCN}
                onChange={this.changeCallerAliasCN.bind(this)}
              />
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">AliasEN:</div>
            <div className="input-box-text">
              <input
                className="input-text"
                value={this.state.callerAliasEN}
                onChange={this.changeCallerAliasEN.bind(this)}
              />
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">ExtendedField:</div>
            <div className="input-box-text">
              <input
                className="input-text"
                value={this.state.callerExtendedField}
                onChange={this.changeCallerExtendedField.bind(this)}
              />
            </div>
          </div>
        </div>
        <div className="box-title">Callee Info
          <div className="input-box">
            <div className="input-box-title">NickName:</div>
            <div className="input-box-text">
              <input
                className="input-text"
                value={this.state.calleeNickName}
                onChange={this.changeCalleeNickName.bind(this)}
              />
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">AliasCN:</div>
            <div className="input-box-text">
              <input
                className="input-text"
                value={this.state.calleeAliasCN}
                onChange={this.changeCalleeAliasCN.bind(this)}
              />
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">AliasEN:</div>
            <div className="input-box-text">
              <input
                className="input-text"
                value={this.state.calleeAliasEN}
                onChange={this.changeCalleeAliasEN.bind(this)}
              />
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">Number:</div>
            <div className="input-box-text">
              <input
                className="input-text"
                value={this.state.calleeNumber}
                onChange={this.changeCalleeNumber.bind(this)}
              />
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">ThirdUserId:</div>
            <div className="input-box-text">
              <input
                className="input-text"
                value={this.state.calleeThirdUserId}
                onChange={this.changeCalleeThirdUserId.bind(this)}
              />
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">ExtendedField:</div>
            <div className="input-box-text">
              <input
                className="input-text"
                value={this.state.calleeExtendedField}
                onChange={this.changeCalleeExtendedField.bind(this)}
              />
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">CorpId:</div>
            <div className="input-box-text">
              <input
                className="input-text"
                value={this.state.calleeCorpId}
                onChange={this.changeCalleeCorpId.bind(this)}
              />
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">Custom Info:</div>
            <div className="input-box-text">
              <input
                className="input-text"
                value={this.state.customInfo}
                onChange={this.changeCustomInfo.bind(this)}
              />
            </div>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Media Type:</div>
          <div className="input-box-text">
            <select value={this.state.mediaType} onChange={this.changeMediaType.bind(this)}>
              {MediaTypeOptions.map((item) => {
                return (
                  <option value={item.value} key={item.value}>
                    {item.label}
                  </option>
                )
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Attendee Type:</div>
          <div className="input-box-text">
            <select value={this.state.calleeAttendeeType} onChange={this.changeAttendeeType.bind(this)}>
              {AttendeeTypeOptions.map((item) => {
                return (
                  <option value={item.value} key={item.value}>
                    {item.label}
                  </option>
                )
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check" style={{ width: '200px' }}>IsGuestJoinConfWithoutPwd:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.isGuestJoinConfWithoutPwd} onChange={this.changeIsGuestJoinConfWithoutPwd.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title" style={{ width: '140px' }}>ConfAllowJoinUser:</div>
          <div className="input-box-text" style={{ width: '85px' }}>
            <select value={this.state.confAllowJoinUser} onChange={this.changeConfAllowJoinUser.bind(this)}>
              {ConfAllowJoinUserTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <button onClick={this.startP2pConf.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default StartP2pConf
