import React from 'react'
import { withRouter } from 'react-router-dom'
import ApiService from '../../AppService/ApiService'
import './index.css'
import { showErrorTips } from '../../utils'
import { isMac } from 'hwmsdk-electron-demo/src/common/platform'

class Main extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      isAudioRawDataOutput: false,
    }
  }

  async Logout () {
    const apiService = new ApiService()
    const setResult = await apiService.logout()
    if (setResult.ret === 0) {
      console.log('logoutresult:', setResult.logoutResult)
      window.sessionStorage.setItem('confListInfo', '')
      this.props.history.push('/')
    } else {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goToCreateConf () {
    this.props.history.push('/main/createConf')
  }

  goToAddAttendee () {
    this.props.history.push('/main/addAttendee')
  }

  goToBookConf () {
    this.props.history.push('/main/bookConf')
  }

  goToConfLists () {
    this.props.history.push('/main/confLists')
  }

  goToChangeVmrInfo () {
    this.props.history.push('/main/changeVmrInfo')
  }

  goToConfigPage () {
    this.props.history.push('/configPage')
  }

  goToSetting () {
    this.props.history.push('/setting')
  }

  goToJoinConfPage () {
    this.props.history.push('/joinConfPage')
  }

  goToConfCtrlPage () {
    this.props.history.push('/confCtrlPage')
  }

  async goToGetUserState () {
    const apiService = new ApiService()
    const setResult = await apiService.getUserState()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToGetLoginState () {
    const apiService = new ApiService()
    const setResult = await apiService.getLoginState()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToGetLoginToken () {
    const apiService = new ApiService()
    const setResult = await apiService.getLoginToken()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goToUploadSelfAvatar () {
    this.props.history.push('./main/uploadSelfAvatar')
  }

  async goToGetConfList () {
    const apiService = new ApiService()
    const setResult = await apiService.getConfList()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToStartP2pConf () {
    this.props.history.push('/main/StartP2pConf')
  }

  async goToShowToast () {
    this.props.history.push('/main/ShowToast')
  }

  async getMainWindowInfo () {
    const apiService = new ApiService()
    const setResult = await apiService.getMainWindowInfo()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async onSetAudioRawDataOutputConfig () {
    const { isAudioRawDataOutput } = this.state
    const newValue = !isAudioRawDataOutput
    this.setState({ isAudioRawDataOutput: newValue })
    const apiService = new ApiService()
    apiService.setAudioRawDataOutputConfig({ isOpen: newValue })
  }

  async goToStartProjection () {
    this.props.history.push('./main/StartProjection')
  }

  async goToSetCustomUIText () {
    this.props.history.push('./main/SetCustomUIText')
  }

  goToAcceptConf () {
    this.props.history.push('/main/acceptConf')
  }

  async goToRejectConf () {
    const apiService = new ApiService()
    const setResult = await apiService.rejectConf()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  render () {
    return (
            <div className="Main">
                <button onClick={this.goToCreateConf.bind(this)}>Create Conf</button>
                <button onClick={this.goToBookConf.bind(this)}>Book Conf</button>
                <button onClick={this.goToConfCtrlPage.bind(this)}>Conf Control</button>
                <button onClick={this.goToJoinConfPage.bind(this)}>Join Conf</button>
                <button onClick={this.goToConfigPage.bind(this)}>Config</button>
                <button onClick={this.goToSetting.bind(this)}>Setting</button>
                <button onClick={this.goToConfLists.bind(this)}>Conf Lists</button>
                <button onClick={this.goToChangeVmrInfo.bind(this)}>Change Vmr Conf</button>
                <button onClick={this.goToGetUserState.bind(this)}>Get User State</button>
                <button onClick={this.goToGetLoginState.bind(this)}>Get Login State</button>
                <button onClick={this.goToGetLoginToken.bind(this)}>Get Login Token</button>
                <button onClick={this.goToUploadSelfAvatar.bind(this)}>Upload Self Avatar</button>
                <button onClick={this.goToGetConfList.bind(this)}>Get Conf list</button>
                <button onClick={this.goToStartP2pConf.bind(this)}>Start P2pConf</button>
                <button onClick={this.goToShowToast.bind(this)}>Show Toast</button>
                <button onClick={this.getMainWindowInfo.bind(this)}>Get Main Window Info</button>
                <button onClick={this.onSetAudioRawDataOutputConfig.bind(this)}>Set Audio Raw Data</button>
                <button onClick={this.goToStartProjection.bind(this)}>Start Projection</button>
                <button onClick={this.goToSetCustomUIText.bind(this)}>Set Custom UI Text</button>
                { !isMac() && <button onClick={this.goToAcceptConf.bind(this)}>Accept Conf</button>}
                { !isMac() && <button onClick={this.goToRejectConf.bind(this)}>Reject Conf</button>}
                <button onClick={this.Logout.bind(this)}>Logout</button>
            </div>
    )
  }
}

export default withRouter(Main)
