import React from 'react'
import ReactDOM from 'react-dom'
import { Provider } from 'react-redux'

import './index.css'
import App from './App'
import NotifyService from './AppService/NotifyService'
import store, { globalDispatch } from '../redux'
import { initSettingRedux } from '../redux/settingSlice'

initSettingRedux(store, globalDispatch)

ReactDOM.render(
  <Provider store={store}>
    <App />
  </Provider>,
  document.getElementById('root'),
)

// 注册所有回调
NotifyService.setNotifyFunc()
