/**
* [en]Media type. [cn]媒体类型
*/
export enum MediaType{
	/**<[en]Audio type [cn]音频类型 */
    HWM_MEDIA_TYPE_AUDIO = 0,
	/**<[en]Video type [cn]视频类型 */
    HWM_MEDIA_TYPE_VIDEO = 1,
};

/**
* [en]Device type. [cn]设备类型
*/
export enum DeviceType{
	/**<[en]Indicates microphone device [cn]麦克风设备 */
    HWM_DEVICE_TYPE_MIC = 0,
	/**<[en]Indicates Speaker device [cn]扬声器设备 */
    HWM_DEVICE_TYPE_SPEAKER = 1,
	/**<[en]Indicates Camera device [cn]视频设备 */
    HWM_DEVICE_TYPE_CAMERA = 2,
};

/**
* [en]Language type. [cn]语言类型
*/
export enum Language{
	/**<[en]zh-CN [cn]中文 */
    HWM_LANGUAGE_ZH_CN = 0,
	/**<[en]en-GB [cn]英文 */
    HWM_LANGUAGE_EN_GB = 1,
	/**<[en]Customized [cn]自定义语言 */
    HWM_LANGUAGE_CUSTOMIZED = 2,
};

/**
* [en]State. [cn]状态类型
*/
export enum State{
	/**<[en]Off state [cn]关闭状态 */
    HWM_STATE_OFF = 0,
	/**<[en]On state [cn]开启状态 */
    HWM_STATE_ON = 1,
};

/**
* [en]Stop share reason. [cn]停止共享原因
*/
export enum StopShareReason{
	/**<[en]Stop sharing normally [cn]正常停止共享 */
    HWM_STOP_SHARE_BY_NORMAL = 0,
	/**<[en]MMR transfer [cn]MMR迁移 */
    HWM_STOP_SHARE_BY_REJOIN_CONF = 1,
};

export enum SDKERR{
	/**<[en]Unknown error. [cn]未知错误 */
    SDKERR_UNKOWN = -1,
	/**<[en]Success. [cn]成功 */
    SDKERR_SUCCESS = 0,
	/**<[en]server flow control. [cn]服务端流控错误 */
    CMS_CONF_SERVER_FLOW_CONTROL = 100000429,
	/**<[en]Request error. [cn]请求错误 */
    CMS_CONF_BAD_REQUEST = 111070001,
	/**<[en]Insufficient permissions. [cn]权限不足 */
    CMS_CONF_INSUFFICIENT_PERMISSIONS = 111070002,
	/**<[en]System processing failure. [cn]系统处理失败 */
    CMS_CONF_EXCEPTION = 111070003,
	/**<[en]Meeting authentication failed. [cn]校验失败 */
    CMS_CONF_AUTH_FAIL = 111070004,
	/**<[en]Meeting does not exist. [cn]会议不存在 */
    CMS_CONF_DATA_NOT_FOUND = 111070005,
	/**<[en]Personal cloud meeting room does not exist. [cn]个人云会议室不存在 */
    CMS_VMR_DATA_NOT_FOUND = 111070006,
	/**<[en]Meeting access number does not exist. [cn]会议接入号不存在 */
    CMS_ACCESS_NUMBER_NOT_FOUND = 111070007,
	/**<[en]Meeting notification could not be sent. [cn]会议通知模板配置错误 */
    CMS_CONF_NOTICE_MODEL_CONFIG_ERROR = 111070008,
	/**<[en]Meeting password cannot be left blank. [cn]会议密码不能为空 */
    CMS_CONF_AUTHEN_NEED_PASSWORD = 111070009,
	/**<[en]Insufficient permissions to view this meeting. [cn]权限不足,无法查看会议 */
    CMS_CONF_ROLE_AUTHENTICATION_FAILED = 111070010,
	/**<[en]Get started meeting exception. [cn]获取召开会议异常 */
    CMS_CONF_GET_STARTED_CONF_EXCEPTION = 111070100,
	/**<[en]Start meeting exception. [cn]开始会议异常 */
    CMS_CONF_START_EXCEPTION = 111070101,
	/**<[en]Apply IVR resource exception. [cn]申请IVR资源异常 */
    CMS_CONF_APPLY_IVR_RESOURCE_EXCEPTION = 111070102,
	/**<[en]Start IVR meeting exception. [cn]开始IVR会议异常 */
    CMS_START_IVRCONF_EXCEPTION = 111070103,
	/**<[en]Apply site resource exception. [cn]申请会场资源异常 */
    CMS_CONF_APPLY_PARTICIPANT_RESOURCE_EXCEPTION = 111070104,
	/**<[en]Start sub meeting exception. [cn]开始子会议异常 */
    CMS_START_SUBCONF_EXCEPTION = 111070105,
	/**<[en]Add channel exception. [cn]创建级联通道异常 */
    CMS_CONF_ADD_CHANNEL_EXCEPTION = 111070106,
	/**<[en]Move and apply site resource exception. [cn]移动会场申请资源异常 */
    CMS_CONF_MOVE_AND_APPLY_RESOURCE_EXCEPTION = 111070107,
	/**<[en]Start meeting exception. [cn]开启会议异常 */
    CMS_START_CONF_EXCEPTION = 111070108,
	/**<[en]Get started cloud meeting exception. [cn]获取召开云会议室会议异常 */
    CMS_CONF_GET_STARTED_VMRCONF_EXCEPTION = 111070109,
	/**<[en]Invite site exception. [cn]邀请会场异常 */
    CMS_CONF_INVITE_PARTICIPANT_EXCEPTION = 111070110,
	/**<[en]Request token is null. [cn]请求token为空 */
    CMS_REQUEST_TOKEN_IS_NULL = 111070111,
	/**<[en]Rename site exception. [cn]重命名会场异常 */
    CMS_CONF_RENAME_PARTICIPANT_EXCEPTION = 111070112,
	/**<[en]Hangup site exception. [cn]会场挂断异常 */
    CMS_CONF_HANGUP_EXCEPTION = 111070113,
	/**<[en]Mass hangup site exception. [cn]会场批量挂断异常 */
    CMS_CONF_BULK_HANGUP_EXCEPTION = 111070114,
	/**<[en]Delete attendee exception. [cn]删除与会者异常 */
    CMS_CONF_DELETE_ATTENDEE_EXCEPTION = 111070115,
	/**<[en]Mass delete attendee exception. [cn]批量删除与会者异常 */
    CMS_CONF_BULK_DELETE_ATTENDEE_EXCEPTION = 111070116,
	/**<[en]Book cycle meeting exception. [cn]预定周期会议异常 */
    CMS_SCHEDULE_CYCLE_CONF_EXCEPTION = 111070117,
	/**<[en]Modify cycle meeting exception. [cn]修改周期会议异常 */
    CMS_MODIFY_CYCLE_CONF_EXCEPTION = 111070118,
	/**<[en]Create cycle meeting exception. [cn]创建周期会议异常 */
    CMS_CREATE_CYCLE_CONF_EXCEPTION = 111070119,
	/**<[en]Region data not found. [cn]区域信息获取失败 */
    CMS_REGION_DATA_NOT_FOUND = 111070120,
	/**<[en]Forbidden subscribe. [cn]禁止订阅 */
    CMS_FORBIDDEN_SUBSCRIBE = 111070121,
	/**<[en]Cancel subscribe fail. [cn]取消订阅失败 */
    CMS_CANCEL_SUBSCRIBE_FAIL = 111070122,
	/**<[en]Sysportal service exception. [cn]Sysportal服务运行异常 */
    CMS_CONF_SYSPORTAL_SERVICE_EXCEPTION = 111071001,
	/**<[en]Conf service exception. [cn]Conf服务运行异常 */
    CMS_CONF_EXECUTOR_RUN_EXCEPTION = 111071002,
	/**<[en]Failed to create the meeting. Try again later. [cn]创建会议失败，请稍后重试 */
    CMS_CONF_ID_NOT_EXIST = 111071003,
	/**<[en]This cloud meeting room does not allow guests to join before the host. [cn]VMR会议不允许来宾在主持人入会前入会 */
    CMS_VMR_ONLY_ALLOW_CHAIR_START_CONF = 111071004,
	/**<[en]This cloud meeting room has been scheduled for another meeting during this period. [cn]VMR会议时间冲突，该时间段此会议室已有预约会议 */
    CMS_VMR_CONF_CONFLICT = 111071005,
	/**<[en]Insufficient cloud meeting time. [cn]VMR会议时长不足 */
    CMS_VMR_IMMEDIATELY_CONF_DURATION_NOT_ENOUGH = 111071006,
	/**<[en]Meeting does not exist. [cn]VMR预约关系不存在 */
    CMS_VMR_SCHEDULE_RELATION_NOT_EXIST = 111071007,
	/**<[en]Cannot query meeting list. [cn]查询会议列表失败 */
    CMS_CONF_QUERY_LIST_FAIL = 111071008,
	/**<[en]Cannot change cloud meeting into immediate meeting. [cn]不支持修改VMR会议为立即会议 */
    CMS_CONF_MODIFY_IMMEDIATELY_VMR_FAIL = 111071009,
	/**<[en]Cannot modify cloud meeting flag. [cn]不支持修改云会议室标识 */
    CMS_CONF_MODIFY_VMR_FLAG_FAIL = 111071010,
	/**<[en]The cloud meeting has not yet started. Please wait. [cn]VMR会议未到准备时间点 */
    CMS_VMR_CONF_NOT_REACH_PREPARE_TIME = 111071011,
	/**<[en]Not cloud meeting. [cn]非VMR会议 */
    CMS_CONF_NOT_VMR = 111071012,
	/**<[en]Start time less than current time. [cn]会议开始时间不能早于系统当前时间 */
    CMS_CONF_START_TIME_LESS_THAN_CURRENT_TIME = 111071013,
	/**<[en]Start time over max schedule time. [cn]会议开始时间超出最大预订时间范围 */
    CMS_CONF_START_TIME_OVER_MAX_SCHEDULE_TIME = 111071014,
	/**<[en]Duration over range. [cn]时长超出范围 */
    CMS_CONF_DURATION_OVER_RANGE = 111071015,
	/**<[en]Cycle ID list null exception. [cn]取消周期会议ID列表不能为空 */
    CMS_CONF_PARAMS_NULL_EXCEPTION = 111071016,
	/**<[en]Meeting size over range. [cn]与会方数超出范围 */
    CMS_CONF_SIZE_OVER_RANGE = 111071017,
	/**<[en]Invalid media type. [cn]媒体类型非法 */
    CMS_CONF_MEDIA_TYPES_ILLEGAL = 111071018,
	/**<[en]Invalid meeting type. [cn]会议类型非法 */
    CMS_CONF_CONFERENCE_TYPE_ILLEGAL = 111071019,
	/**<[en]Cycle params null exception. [cn]周期会议时,必须携带周期会议参数 */
    CMS_CONF_CYCLE_PARAMS_NULL_EXCEPTION = 111071020,
	/**<[en]Duration over range. [cn]会议时长超出范围 */
    CMS_CONF_LENGTH_OVER_RANGE = 111071021,
	/**<[en]Subject length too long. [cn]会议主题超长 */
    CMS_CONF_SUBJECT_LENGTH_TOO_LONG = 111071022,
	/**<[en]Group URI length too long. [cn]groupuri超长 */
    CMS_CONF_GROUPURI_LENGTH_TOO_LONG = 111071023,
	/**<[en]Invalid email address format. [cn]邮箱地址不合法 */
    CMS_CONF_EMAIL_ILLEGAL = 111071024,
	/**<[en]Invalid mobile number format. [cn]手机号不合法 */
    CMS_CONF_SMS_ILLEGAL = 111071025,
	/**<[en]Department name too long. [cn]部门名称过长 */
    CMS_CONF_DEPTNAME_TOO_LONG = 111071026,
	/**<[en]Invalid welcome voice enable value. [cn]入会欢迎词开关不在范围内 */
    CMS_CONF_WELCOME_VOICE_NOT_IN_RANGE = 111071027,
	/**<[en]Invalid enter voice enable value. [cn]入会提示音开关不在范围内 */
    CMS_CONF_ENTER_PROMPT_NOT_IN_RANGE = 111071028,
	/**<[en]Invalid leave voice enable value. [cn]离会提示音开关不在范围内 */
    CMS_CONF_LEAVE_PROMPT_NOT_IN_RANGE = 111071029,
	/**<[en]Invalid reminders value. [cn]会议提醒非法 */
    CMS_CONF_REMINDERS_ILLEGAL = 111071030,
	/**<[en]Invalid allow record value. [cn]会议是否启用网络录制取值非法 */
    CMS_CONF_ALLOW_RECORD_NOT_IN_RANGE = 111071031,
	/**<[en]Invalid auto record value. [cn]会议是否自动启动录制取值非法 */
    CMS_CONF_AUTO_RECORD_NOT_IN_RANGE = 111071032,
	/**<[en]Invalid user type value. [cn]会预定者的用户类型非法 */
    CMS_CONF_USER_TYPE_NOT_IN_RANGE = 111071033,
	/**<[en]Invalid encrypt mode value. [cn]加密类型非法 */
    CMS_CONF_ENCRYPT_MODE_NOT_IN_RANGE = 111071034,
	/**<[en]Invalid language value. [cn]语言非法 */
    CMS_CONF_LANGUAGE_NOT_IN_RANGE = 111071035,
	/**<[en]Invalid auto prolong value. [cn]是否自动延长会议取值非法 */
    CMS_CONF_AUTO_PROLONG_NOT_IN_RANGE = 111071036,
	/**<[en]VmrID too long. [cn]vmrid超长 */
    CMS_CONF_VMRID_TOO_LONG = 111071037,
	/**<[en]Invalid record type value. [cn]录播类型非法 */
    CMS_CONF_RECORD_TYPE_NOT_IN_RANGE = 111071038,
	/**<[en]Live address too long. [cn]主流直播地址超长 */
    CMS_CONF_LIVE_ADDRESS_TOO_LONG = 111071039,
	/**<[en]Aux address too long. [cn]辅流直播地址超长 */
    CMS_CONF_AUX_ADDRESS_TOO_LONG = 111071040,
	/**<[en]Null start date for cycle meeting. [cn]周期会议时,起始日期为空 */
    CMS_CONF_CYCLE_PARAMS_STARTDATE_NULL = 111071041,
	/**<[en]Null end date for cycle meeting. [cn]周期会议时,结束日期为空 */
    CMS_CONF_CYCLE_PARAMS_ENDDATE_NULL = 111071042,
	/**<[en]Invalid cycle type value for cycle meeting. [cn]周期会议时,周期类型非法 */
    CMS_CONF_CYCLE_PARAMS_CYCLE_ILLEGAL = 111071043,
	/**<[en]Invalid interval for cycle meeting. [cn]周期会议时,interval非法 */
    CMS_CONF_CYCLE_PARAMS_INTERVAL_NOT_IN_RANGE = 111071044,
	/**<[en]Null point for cycle meeting. [cn]周期会议时,point为空 */
    CMS_CONF_CYCLE_PARAMS_POINT_NULL_EXCEPTION = 111071045,
	/**<[en]Invalid point value for cycle meeting. [cn]周期会议时,point非法 */
    CMS_CONF_CYCLE_PARAMS_POINT_NOT_IN_RANGE = 111071046,
	/**<[en]Invalid vmr flag value. [cn]vmrFlag非法 */
    CMS_CONF_VMR_FLAG_NOT_IN_RANGE = 111071047,
	/**<[en]Invalid record auxStream. [cn]recordAuxStream非法 */
    CMS_CONF_RECORD_AUX_STREAM_NOT_IN_RANGE = 111071048,
	/**<[en]Invalid multiStream flag. [cn]multiStreamFlag非法 */
    CMS_CONF_MULTI_STREAM_FLAG_NOT_IN_RANGE = 111071049,
	/**<[en]Invalid audience flag. [cn]audienceFlag非法 */
    CMS_CONF_AUDIENCE_FLAG_NOT_IN_RANGE = 111071050,
	/**<[en]Invalid liveChannel ID. [cn]liveChannelID不存在 */
    CMS_CONF_LIVE_CHANNEL_ID_NOT_EXISTED = 111071051,
	/**<[en]Anonymous login is locked. Try again later. [cn]匿名登录锁定,请稍后重试 */
    CMS_CONF_ANONYMOUS_LOGIN_LOCKED = 111071052,
	/**<[en]Link login is locked. Try again later. [cn]链接登录锁定,请稍后重试 */
    CMS_CONF_LINK_LOGIN_LOCKED = 111071053,
	/**<[en]Not enough Meeting ID. [cn]会议ID不足 */
    CMS_CONF_IDENTIFIER_NOT_ENOUGH = 111071054,
	/**<[en]Failed to apply meeting ID. [cn]会议ID申请失败 */
    CMS_CONF_IDENTIFIER_APPLY_FAILED = 111071055,
	/**<[en]Failed to release meeting ID. [cn]会议ID释放失败 */
    CMS_CONF_IDENTIFIER_RELEASE_FAILED = 111071056,
	/**<[en]Live room is used. [cn]直播房间已被占用 */
    CMS_CONF_LIVE_ROOM_ISUSED = 111071057,
	/**<[en]The meeting has not yet started. Please wait. [cn]当前会议还未召开,请耐心等待 */
    CMS_NOT_ALLOWED_GUEST_FIRST_JOIN = 111071058,
	/**<[en]Meeting size over range. [cn]与会方数超出上限 */
    CMS_CONF_SIZE_OVER_COMMUNAL_VMR_MAXNUM = 111071059,
	/**<[en]The enterprise cannot create meetings because it has not purchased any concurrent meeting resources. [cn]企业未配置并发会议资源,无法使用个人会议ID和随机会议ID发起会议 */
    CMS_ORG_CONCURRENT_PARTICIPANTS_NUMBER_IS_ZERO = 111071060,
	/**<[en]Parameter verify failed. [cn]参数校验失败 */
    CMS_PARAMETER_VERIFIED_FAIL = 111071061,
	/**<[en]Json conversion failed. [cn]JSON转换失败 */
    CMS_JSON_CONVERSION_FAILED = 111071062,
	/**<[en]Not cloud meeting room owner. [cn]非云会议室拥有者 */
    CMS_CONF_USER_NOT_VMR_OWNER = 111071063,
	/**<[en]This cloud meeting room has been started for another meeting during this period. [cn]VMR会议冲突,当前已有会议正在召开 */
    CMS_VMR_CONF_CONFLICT_AS_VMR_ALREADY_STARTED = 111071064,
	/**<[en]This meeting cannot be modified because it is already started. [cn]正在召开会议,无法编辑会议详情 */
    CMS_CONF_MODIFY_FAIL_AS_CONF_ALREADY_STARTED = 111071065,
	/**<[en]Attendees amount over range. [cn]与会方数量超出上限 */
    CMS_CONF_ATTENDEES_NUMBER_EXCEED_LIMIT = 111071066,
	/**<[en]This meeting cannot be canceled because it is already started. [cn]会议正在召开中，不允许取消会议 */
    CMS_CONF_CANCEL_FAIL_AS_CONF_STARTED = 111071067,
	/**<[en]Meeting password encrypt failed. [cn]会议密码加密失败 */
    CMS_CONF_PWD_ENCRYPT_FAILED = 111071068,
	/**<[en]No meeting during this period. [cn]选定的时间中没有会议 */
    CMS_CONF_NOCONF_IN_SELECTED_TIME = 111071069,
	/**<[en]Sub cycle meeting cannot modify live room. [cn]周期会议子会议不允许修改直播房间 */
    CMS_SUB_CYCCONF_CANNOT_MODIFY_LIVE_ROOM = 111071070,
	/**<[en]Stop online meeting exception. [cn]结束会议失败 */
    CMS_STOP_ONLINE_CONF_EXCEPTION = 111071071,
	/**<[en]Meeting is ended. [cn]会议已经结束 */
    CMS_CONF_CLOSED_RECENTLY = 111071072,
	/**<[en]Not allow anonymous user. [cn]会议不允许匿名用户呼入 */
    CMS_CONF_NOT_ALLOW_ANONYMOUS = 111071073,
	/**<[en]Only allow user in organization. [cn]会议只允许企业内用户呼入 */
    CMS_CONF_ONLY_ALLOW_USER_IN_ORG = 111071074,
	/**<[en]Only allow invited user. [cn]会议只允许被邀请用户呼入 */
    CMS_CONF_ONLY_ALLOW_USER_INVITED = 111071075,
	/**<[en]Batch export task for history meeting list during this period. [cn]当前有正在执行的批量导出任务 */
    CMS_BATCH_EXPORT_HIS_CONF_LIST_CONFLICT = 111071076,
	/**<[en]Only allow invited user and user in organization. [cn]会议只允许被邀请或者企业内用户用户呼入 */
    CMS_CONF_ONLY_ALLOW_USER_INVITED_AND_USER_IN_ORG = 111071077,
	/**<[en]Max current participants amount reached. [cn]企业单会议并发方数已达上限 */
    CMS_WELINK_C_CONCURRENT_PARTICIPANTS_NUMBER_IS_NOT_ENOUGH = 111071078,
	/**<[en]Invalid CTD param. [cn]ctd会议参数不合法 */
    CMS_CONF_CTD_PARAM_ILLEGAL = 111071079,
	/**<[en]Invalid guest password. [cn]来宾密码不合法 */
    CMS_GUEST_PWD_ILLEGAL = 111071080,
	/**<[en]Guest password conflict with meeting ID. [cn]来宾密码与会议ID冲突 */
    CMS_GUEST_PWD_CONFLICT_WITH_CONF_ID = 111071081,
	/**<[en]Max meeting amount reached. [cn]会议数达到上限 */
    CMS_CONF_NUM_UP_TO_LIMIT = 111071082,
	/**<[en]Invalid meeting random number. [cn]无效的会议随机数 */
    CMS_CONF_RANDOM_INVALID = 111071083,
	/**<[en]Max export history meeting list times reached. [cn]导出历史会议次数超出允许的值 */
    CMS_EXPORT_HIS_CONF_UP_TO_LIMIT = 111071084,
	/**<[en]Max multi view layouts reached. [cn]会议多画面布局超出限制 */
    CMS_MULTI_PIC_TOO_MANY_LAYOUTS = 111071085,
	/**<[en]Max multi view invalid manual type. [cn]会议多画面模式非法 */
    CMS_MULTI_PIC_MANUAL_TYPE_INVALID = 111071086,
	/**<[en]Max multi view sub view amount reached. [cn]会议多画面子画面个数超出限制 */
    CMS_MULTI_PIC_TOO_MANY_SUBPICS = 111071087,
	/**<[en]Max multi view sub view numbers reached. [cn]会议多画面子画面会场数超出限制 */
    CMS_MULTI_PIC_TOO_MANY_SUBNUMBERS = 111071088,
	/**<[en]Webinar and common meeting cannot be converted to each other. [cn]网络研讨会不能修改为普通会议,普通会议也不能修改为网络研讨会 */
    CMS_WEBINAR_COMMON_NON_CONVERT = 111071089,
	/**<[en]Not allow add audience. [cn]不支持添加观众 */
    CMS_NOT_ALLOW_AUDIENCE = 111071090,
	/**<[en]Meeting password authentication failed. [cn]密码错误 */
    CMS_CONF_PWD_AUTH_FAILED = 111071091,
	/**<[en]File export task failed. [cn]导出文件任务失败 */
    CMS_FILE_EXPORT_TASK_FAILED = 111071092,
	/**<[en]File export task is downloading. [cn]导出文件正在处理中 */
    CMS_FILE_EXPORT_TASK_DOWNLOADING = 111071093,
	/**<[en]Not allow audience to join. [cn]会议不允许观众入会 */
    CMS_CONF_FORBID_AUDIENCE_JOIN = 111071094,
	/**<[en]Need to get WEBINAR_CONF_DTO object. [cn]需要获取WEBINAR_CONF_DTO对象 */
    CMS_CONF_NEED_GET_WEBINAR_CONF_DTO = 111071095,
	/**<[en]User-defined languages over range. [cn]自定义语言个数超出范围 */
    CMS_CUSTOM_LANGUAGE_NUM_OVER_RANGE = 111071096,
	/**<[en]Your enterprise does not support simultaneous interpretation. [cn]企业不支持同声传译 */
    CMS_ORG_NOT_SUPPORT_SIMULTANEOUS_INTERPRETATION = 111071097,
	/**<[en]Need to set interpreter groups. [cn]需要设置传译组信息 */
    CMS_NEED_SET_INTERPRETER_GROUPS = 111071098,
	/**<[en]Invalid interpretation language. [cn]传译组语言非法 */
    CMS_INTERPRETER_LANGUAGE_ILLEGAL = 111071099,
	/**<[en]Max languages in a meeting are reached. [cn]单会议最大支持16种语言 */
    CMS_CONF_LANGUAGE_NUM_UP_TO_MAX = 111071100,
	/**<[en]This interpreter group ID already exists. [cn]传译组的组号重复 */
    CMS_INTERPRETER_GROUP_ID_REPEATED = 111071101,
	/**<[en]Max interpreters in the interpreter group reached. [cn]传译组中传译员的个数达到上限 */
    CMS_INTERPRETER_NUM_IN_ONE_GROUP_UP_TO_MAX = 111071102,
	/**<[en]This interpreter already exists in an interpreter group. [cn]传译员重复 */
    CMS_INTERPRETER_REPEATED = 111071103,
	/**<[en]Invalid interpreter account. [cn]传译员账号不存在 */
    CMS_INVALID_INTERPRETER = 111071104,
	/**<[en]Guest password conflict with chairman password. [cn]来宾密码与主持人密码冲突 */
    CMS_GUEST_PWD_CONFLICT_WITH_CHAIR_PWD = 111071105,
	/**<[en]Meeting is holding. [cn]云会议室已有会议正在召开 */
    CMS_ONLINE_CONF_IN_COMMUNAL = 111071106,
	/**<[en]Invalid audience password. [cn]观众密码不合法 */
    CMS_AUDIENCE_PWD_ILLEGAL = 111071107,
	/**<[en]Audience password conflict with meeting id. [cn]观众密码与会议ID冲突 */
    CMS_AUDIENCE_PWD_CONFLICT_WITH_CONF_ID = 111071108,
	/**<[en]Audience password conflict with chairman password. [cn]观众密码与主持人密码冲突 */
    CMS_AUDIENCE_PWD_CONFLICT_WITH_CHAIR_PWD = 111071109,
	/**<[en]Only RTC meeting support E2E encrypt. [cn]非RTC会议不支持端到端加密 */
    CMS_ONLY_RTC_CONF_SUPPORT_E2E_ENCRYPT = 111071110,
	/**<[en]Audience password conflict with guest password. [cn]观众密码与来宾密码冲突 */
    CMS_AUDIENCE_PWD_CONFLICT_WITH_GUEST_PWD = 111071111,
	/**<[en]Cloud meeting room ID type cannot be modified. [cn]不支持修改会议ID类型 */
    CMS_VMRIDTYPE_CANNOT_MODIFY = 111071112,
	/**<[en]Cloud meeting room type cannot be modified. [cn]不支持修改VMR类型 */
    CMS_VMRID_CANNOT_MODIFY = 111071113,
	/**<[en]Cloud meeting room flag cannot be modified. [cn]不支持修改VMR标识 */
    CMS_VMR_FLAG_CANNOT_MODIFY = 111071114,
	/**<[en]conf number over max allowed. [cn]超出最大在线会议数限制 */
    CMS_CONF_NUM_OVER_MAX_ALLOWED = 111071116,
	/**<[en]Sub cycle meeting modify time over range. [cn]周期会议修改时间超出范围 */
    CMS_SUB_CYCCONF_MODIFY_TIME_OVER_RANGE = 111071119,
	/**<[en]Illegal corp. [cn]该用户企业被禁用 */
    CMS_CORP_STATUS_ILLEGAL = 111071135,
	/**<[en]Server region is change. [cn]服务器站点变更 */
    CMS_CONF_MANAGER_SERVER_REGION_CHANGING = 111071147,
	/**<[en]Share VMR not enough. [cn]无共享云会议室资源 */
    CMS_CONF_MANAGER_SHARE_VMR_NOT_ENOUGH = 111071151,
	/**<[en]not allow join external crop conf. [cn]被呼叫方所在企业限制加入外部会议 */
    CMS_CONF_MANAGER_NOT_ALLOW_JOIN_EXTERNAL_CROP_CONF = 111071152,
	/**<[en]Application for meeting resources failed. [cn]申请资源失败 */
    CMS_CONF_APPLY_RESOURCE_FAILED = 111072001,
	/**<[en]Failed to release meeting resources. [cn]释放资源失败 */
    CMS_CONF_RELEASE_RESOURCE_FAILED = 111072002,
	/**<[en]The meeting is ending. [cn]会议正在结束 */
    CMS_CONF_IS_CLOSING = 111072003,
	/**<[en]The meeting is starting. [cn]会议正在开始 */
    CMS_CONF_IS_STARTING = 111072004,
	/**<[en]The meeting has not yet started. [cn]会议还未开始 */
    CMS_CONF_NOT_STARTED = 111072005,
	/**<[en]The meeting has ended. [cn]会议已经结束 */
    CMS_CONF_IS_CLOSED = 111072006,
	/**<[en]Site invitation failed. [cn]邀请会场失败 */
    CMS_CONF_INVITE_PARTICIPANT_FAILED = 111072007,
	/**<[en]Site does not exist. [cn]会场不存在 */
    CMS_CONF_PARTICIPANT_NOT_EXIST = 111072008,
	/**<[en]Failed to disconnect the site. [cn]挂断会场失败 */
    CMS_CONF_PARTICIPANT_HANG_UP_FAILED = 111072009,
	/**<[en]Coming soon... [cn]功能暂未支持,敬请期待... */
    CMS_CONF_NOT_SUPPORT = 111072010,
	/**<[en]Meeting status incorrect. [cn]会议状态非法 */
    CMS_CONF_STATUS_ILLEGAL = 111072011,
	/**<[en]Site control operation failed. [cn]会场会控操作失败 */
    CMS_CONF_GENERIC_CTL_PARTICIPANT_FAILED = 111072012,
	/**<[en]The cloud meeting room is in use by another meeting. [cn]当前VMR会议非目标会议 */
    CMS_VMR_CURRENT_CONF_NOT_GOAL_CONF = 111072013,
	/**<[en]The meeting has ended. [cn]VMR会议已过期 */
    CMS_VMR_CONF_IS_EXPIRED = 111072014,
	/**<[en]The meeting has not yet started. [cn]VMR会议还未开始 */
    CMS_VMR_CONF_IS_NOT_ARRIVE_START_TIME = 111072015,
	/**<[en]Meeting does not exist. [cn]VMR预约记录不存在 */
    CMS_VMR_CONF_WITH_SCHEDULE_NOT_EXIST = 111072016,
	/**<[en]Meeting has no attendee. [cn]会议与会者不存在 */
    CMS_CONF_HAS_NO_ATTENDEE = 111072017,
	/**<[en]Application for chairman password exception. [cn]申请主持人密码错误 */
    CMS_CONF_CHAIRMAN_PWD_EXCEPTION = 111072018,
	/**<[en]Not found site which can be moved exception. [cn]没有找到可以移动的会场 */
    CMS_CONF_NOT_FIND_CANMOVESITE_EXCEPTION = 111072019,
	/**<[en]The current meeting is not a recording meeting. Recording is not supported. [cn]非录播会议不支持录制 */
    CMS_CONF_NOT_SUPPORT_RECORD = 111072020,
	/**<[en]System processing failure. [cn]录播调度失败 */
    CMS_RECORD_RESOURCE_NOT_ENOUGH = 111072021,
	/**<[en]Insufficient recording resources in the system. [cn]录播资源不足 */
    CMS_RECORD_SHEDULE_FAIL = 111072022,
	/**<[en]There are no participants in this meeting. [cn]会议中没有与会人 */
    CMS_CONF_NOT_HAVE_PART = 111072023,
	/**<[en]Operation failed. No sites have joined this meeting. [cn]请确保会议中已有会场入会 */
    CMS_CONF_NO_PARTICIPANT_JOINED = 111072024,
	/**<[en]Voice meeting does not support this function. [cn]语音会议不支持该功能 */
    CMS_AUDIO_CONF_NOT_SUPPORT = 111072025,
	/**<[en]The voice site does not support this operation. [cn]语音会场不支持该操作 */
    CMS_AUDIO_SITE_NOT_SUPPORT = 111072026,
	/**<[en]Voice sites cannot be displayed in custom continuous presence. [cn]手动设置的多画面中无法显示语音会场 */
    CMS_AUDIO_SITE_IN_MULTI_PIC = 111072027,
	/**<[en]At least one site must have custom continuous presence configured. [cn]手动设置的多画面中需最少设置一个会场 */
    CMS_NO_SITE_IN_MULTI_PIC = 111072028,
	/**<[en]At most one presentation pane is allowed in custom continuous presence. [cn]手工设置的多画面最多只允许一个辅流子画面 */
    CMS_ASSISTANT_PIC_NUM_MORE_THEN_ONE = 111072029,
	/**<[en]In the voice-activated continuous presence mode, each pane can only support a single user. [cn]声控多画面模式下,每个子画面最多只允许一个用户 */
    CMS_VAS_SUB_PIC_CONTAINS_USER_MORE_THEN_ONE = 111072030,
	/**<[en]The number used for the site to join the meeting cannot be left blank. [cn]与会者的入会号码不允许为空 */
    CMS_SITE_CALL_NUMBER_IS_EMPTY = 111072031,
	/**<[en]The number used for the site to join the meeting is too long. [cn]与会者的入会号码长度超过系统允许的最大值 */
    CMS_SITE_CALL_NUMBER_LENGTH_TOO_LONG = 111072032,
	/**<[en]The format of the number used for joining the meeting is incorrect. (Correct format: User name name/IP address:Port number or Country code plus phone number) [cn]与会者的入会号码格式非法(支持SIP、TEL号码格式) */
    CMS_SITE_CALL_NUMBER_ILLEGAL_URI = 111072033,
	/**<[en]Length of site name too long. [cn]与会者的名称长度超过系统允许的最大值 */
    CMS_SITE_NAME_LENGTH_TOO_LONG = 111072034,
	/**<[en]The site role type is outside the allowed range. [cn]与会者的角色类型不在系统允许的取值范围内 */
    CMS_SITE_ROLE_NOT_IN_RANGE = 111072035,
	/**<[en]Length of site email address too long. [cn]与会者的邮箱地址长度超过系统允许的最大值 */
    CMS_SITE_EMAIL_LENGTH_TOO_LONG = 111072036,
	/**<[en]Length of site mobile number too long. [cn]与会者的手机号码长度超过系统允许的最大值 */
    CMS_SITE_SMS_LENGTH_TOO_LONG = 111072037,
	/**<[en]The value for whether a site is muted after it first joins the meeting is outside the allowed range. [cn]与会者入会后是否静音的取值不在系统允许的取值范围内 */
    CMS_SITE_MUTE_NOT_IN_RANGE = 111072038,
	/**<[en]The value for whether to automatically invite a site is outside the allowed range. [cn]与会者是否自动邀请的取值不在系统允许的取值范围内 */
    CMS_SITE_AUTO_INVITE_NOT_IN_RANGE = 111072039,
	/**<[en]The host's site viewing type is outside the allowed range. [cn]主持人选看类型取值不在系统允许的取值范围内 */
    CMS_VIEW_TYPE_NOT_IN_RANGE = 111072040,
	/**<[en]The value of the continuous presence setting mode is outside the allowed range. [cn]设置多画面方式取值不在系统允许的取值范围内 */
    CMS_SET_MULTI_PIC_MANUAL_SET_NOT_IN_RANGE = 111072041,
	/**<[en]The polling time is outside the allowed range. [cn]轮询显示时间取值不在系统允许的取值范围内 */
    CMS_SWITCH_TIME_NOT_IN_RANGE = 111072042,
	/**<[en]The pane type cannot be left blank. [cn]画面类型不允许为空 */
    CMS_SET_MULTI_PIC_IMAGE_TYPE_IS_EMPTY = 111072043,
	/**<[en]Invalid pane type. [cn]画面类型非法 */
    CMS_SET_MULTI_PIC_IMAGE_TYPE_IS_NOT_MATCH = 111072044,
	/**<[en]The value of the switch is outside the allowed range. [cn]开关项取值不在系统允许的取值范围内 */
    CMS_ON_OFF_NOT_IN_RANGE = 111072045,
	/**<[en]The site name cannot be left blank. [cn]与会者的名称不允许为空 */
    CMS_SITE_NAME_IS_EMPTY = 111072046,
	/**<[en]Site name too long. [cn]与会者的名称超过系统允许的最大值 */
    CMS_SITE_NEW_NAME_LENGTH_TOO_LONG = 111072047,
	/**<[en]Continuous presence is not supported. Ask the administrator to configure related data on the MCU. [cn]不支持多画面,请联系管理员开启MCU配置 */
    CMS_MCU_NOT_SUPPORT_SET_MULTI_PIC = 111072048,
	/**<[en]Response timed out. Try again later. [cn]等待响应超时 */
    CMS_RESPONSE_TIME_OUT = 111072049,
	/**<[en]Meeting locked. [cn]会议被锁定 */
    CMS_CONF_LOCKED = 111072050,
	/**<[en]The meeting display mode is empty. [cn]会议显示模式为空 */
    CMS_CONF_MODE_IS_EMPTY = 111072051,
	/**<[en]The meeting display mode is outside the allowed range. [cn]会议显示模式不在系统允许的取值范围内 */
    CMS_CONF_MODE_NOT_IN_RANGE = 111072052,
	/**<[en]The meeting pane type is outside the allowed range. [cn]会议画面类型不在系统允许的取值范围内 */
    CMS_CONF_IMAGE_TYPE_NOT_IN_RANGE = 111072053,
	/**<[en]The banner or caption type is empty. [cn]横幅或字幕类型为空 */
    CMS_TEXT_TYPE_IS_EMPTY = 111072054,
	/**<[en]The banner or caption content is empty. [cn]横幅或字幕的内容为空 */
    CMS_TEXT_IS_EMPTY = 111072055,
	/**<[en]The banner or caption content cannot exceed 2,000 bytes. [cn]横幅或字幕的内容长度超过2000字节 */
    CMS_TEXT_IS_TOO_LONG = 111072056,
	/**<[en]The request message body is empty. [cn]请求消息体为空 */
    CMS_REQUEST_BODY_IS_NULL = 111072057,
	/**<[en]The pane index is greater than the total number of panes. [cn]子画面索引大于画面总数 */
    CMS_SUB_PIC_INDEX_MORE_THAN_PIC_NUM = 111072058,
	/**<[en]Meeting has no host. [cn]会议中没有主持人 */
    CMS_CONF_NO_CHAIR_SITE = 111072059,
	/**<[en]Regular participants cannot perform this operation. [cn]当前普通与会方类型不支持该操作 */
    CMS_NORMAL_SITE_NOT_SUPPORT_VIEW = 111072060,
	/**<[en]You have set host polling and cannot select a specific site to view or set continuous presence. [cn]前主持人正在轮询观看会场,不能单独选看其他会场或会议多画面 */
    CMS_CHAIR_POLLING_FORBIDDEN_VIEW = 111072061,
	/**<[en]You cannot select a site to view on the web page. Perform the operation on the terminal. [cn]当前主持人与会方类型不支持该操作 */
    CMS_SVC_SITE_NOT_SUPPORT_VIEW = 111072062,
	/**<[en]Applying for recording resources... [cn]录制资源重新申请错误码 */
    CMS_RSE_RESREAPPLY = 111072063,
	/**<[en]Too many failed login attempts. Try again later. [cn]会控登录锁定 */
    CMS_CONF_CTR_LOGIN_LOCKED = 111072064,
	/**<[en]The meeting ID or password is incorrect. Check the ID and password and try again. [cn]会议不存在或密码错误 */
    CMS_CONF_NOT_FOUND_OR_AUTH_FAILED = 111072065,
	/**<[en]The enterprise has not purchased any recording storage space. [cn]企业未购买录播空间 */
    CMS_ORG_NOT_BUY_RECSPACE = 111072066,
	/**<[en]Insufficient enterprise recording storage space. [cn]企业录播空间已满 */
    CMS_ORG_RECSPACE_NOT_ENOUGH = 111072067,
	/**<[en]Failed to start live broadcast. Try again later. [cn]启动直播失败 */
    CMS_CONF_SETLIVE_FAILED = 111072068,
	/**<[en]Not allow to hand up for host. [cn]不允许指定会议主持人举手发言 */
    CMS_CONF_CHAIR_FORBIDDEN_HAND = 111072069,
	/**<[en]The operation is not allowed for guest. [cn]来宾不允许进行该操作 */
    CMS_GUEST_NO_PERMISSION_OPERATION = 111072070,
	/**<[en]The operation is only allowed for yourself. [cn]仅能对自己进行操作 */
    CMS_NO_PERMISSION_OPERATE_OTHERS = 111072071,
	/**<[en]Not allow to apply host for attendees who do not have meeting control abilites. [cn]没有会控能力的与会者不允许设置为主持人 */
    CMS_NO_CONF_CTL_CAP_NO_CHAIR = 111072072,
	/**<[en]Notify message is expired. [cn]推送消息已过期 */
    CMS_NOTIFY_MSG_IS_EXPIRED = 111072073,
	/**<[en]Only participants with a number registered on HUAWEI CLOUD can be set as the host. [cn]云下会场不能成为主持人 */
    CMS_TRUNK_APPLY_CHAIR_FORBID = 111072074,
	/**<[en]Hung up site for meeting ended. [cn]会议结束挂断会场 */
    CMS_CONF_CLOSE_HUNG_UP = 111072075,
	/**<[en]Hung up site by host. [cn]主持人挂断会场 */
    CMS_CHAIR_HUNG_UP = 111072076,
	/**<[en]Hung up site because host deleted site. [cn]主持人删除会议挂断会场 */
    CMS_CHAIR_DEL_SITE_HUNG_UP = 111072077,
	/**<[en]Hung up site because meeting is recreated. [cn]重建会议挂断会场 */
    CMS_RECREATE_CONF_HUNG_UP = 111072078,
	/**<[en]Hung up site for moving site failed. [cn]移动会场失败挂断会场 */
    CMS_MOVE_SITE_FAIL_HUNG_UP = 111072079,
	/**<[en]Hung up site for inviting site cross region failed. [cn]跨region邀请会场失败挂断会场 */
    CMS_CROSS_REGION_INVITE_SITE_FAIL_HUNG_UP = 111072080,
	/**<[en]Hung up site for invitation exception. [cn]邀请会场失败挂断会场 */
    CMS_INVITE_EXCEPTION_HUNG_UP = 111072081,
	/**<[en]Hung up site for joining meeting repeatedly. [cn]会场重复入会挂断会场 */
    CMS_REPEAT_JOIN_HUNG_UP = 111072082,
	/**<[en]Lock sharing failed. [cn]锁定共享失败 */
    CMS_LOCK_SHARE_FAILED = 111072083,
	/**<[en]This site does not support 1-screen layout. [cn]云下会场禁止设置在多画面一画面中 */
    CMS_TRUNK_SET_ONE_MULTIPIC_FORBID = 111072084,
	/**<[en]Not support realtime subtitle. [cn]会议不支持实时字幕 */
    CMS_CONF_NOT_SUPPORT_REALTIME_SUBTITLE = 111072085,
	/**<[en]Realtime subtitle pid is null. [cn]会议实时字幕指定发言人列表为空 */
    CMS_CONF_REALTIME_SUBTITLE_PID_NULL = 111072086,
	/**<[en]Invalid realtime subtitle pid. [cn]会议实时字幕指定发言人ID有误或已离会 */
    CMS_CONF_REALTIME_SUBTITLE_PID_WRONG = 111072087,
	/**<[en]Failed to set realtime subtitle. [cn]会议实时字幕设置失败 */
    CMS_CONF_REALTIME_SUBTITLE_SET_FAIL = 111072088,
	/**<[en]Not allow audience to change speaker status. [cn]不允许观众解闭音 */
    CMS_CONF_NOT_ALLOW_CHANGE_AUDIENCE_SPEAK_STATUS = 111072089,
	/**<[en]Allow/forbid audience to speak only for audience. [cn]主持人允许/禁止观众说话接口只能操作观众 */
    CMS_CONF_SPEAKABLE_ONLY_FOR_AUDIENCE = 111072090,
	/**<[en]This meeting does not support simultaneous interpretation. [cn]会议不支持同声传译 */
    CMS_CONF_NOT_SUPPORT_SIMULTANEOUS_INTERPRETATION = 111072091,
	/**<[en]Interpreter group is empty. [cn]会议当前传译组为空,请先配置传译组 */
    CMS_CONF_INTERPRETER_GROUP_IS_EMPTY = 111072092,
	/**<[en]This meeting has not enable simultaneous interpretation. [cn]会议未开启同声传译 */
    CMS_CONF_NOT_ENABLE_SIMULTANEOUS_INTERPRETATION = 111072093,
	/**<[en]This site is not interpreter. [cn]当前会场非传译员 */
    CMS_PARTICIPANT_IS_NOT_INTERPRETER = 111072094,
	/**<[en]This site has not yet confirmed interpreter identity. [cn]传译员未确认身份 */
    CMS_PARTICIPANT_NOT_CONFIRM_INTERPRETER = 111072095,
	/**<[en]Invalid site language. [cn]会场选择的语言非法 */
    CMS_PARTICIPANT_LANGUAGE_ILLEGAL = 111072096,
	/**<[en]This site is confirmed interpreter. [cn]当前会场是已确认的传译员 */
    CMS_PARTICIPANT_IS_CONFIRMED_INTERPRETER = 111072097,
	/**<[en]This site listen channel is different from speak channel. [cn]普通会场听说频道不一致 */
    CMS_PARTICIPANT_LISTEN_NOT_EQUAL_SPEAK = 111072098,
	/**<[en]Failed to set interpretation languages. Try again. [cn]设置会议语言频道失败 */
    CMS_SET_CONF_LANGUAGE_CHANNEL_LIST_FAILED = 111072099,
	/**<[en]Failed to set interpretation channel. Try again. [cn]设置会场语言频道失败 */
    CMS_SET_PARTICIPANT_LANGUAGE_CHANNEL_FAILED = 111072100,
	/**<[en]Max participant amount reached. [cn]超过设置的会议方数 */
    CMS_OVER_MAX_PARTICIPANT_NUMBER = 111072101,
	/**<[en]Max allowed handup amount reached. [cn]观众超过最大允许举手数 */
    CMS_OVER_MAX_ALLOW_HAND_NUMBER = 111072102,
	/**<[en]Max allowed speaking amount reached. [cn]观众超过最大允许发言数 */
    CMS_OVER_MAX_ALLOW_SPEAK_NUMBER = 111072103,
	/**<[en]Failed to set virtual audio CSD site. [cn]设置级联通道虚拟语言会场失败 */
    CMS_SET_VIRTUAL_AUDIO_CSD_SITE_FAILED = 111072104,
	/**<[en]This meeting does not support cohost. [cn]该会议未启用联席主持人 */
    CMS_CONF_NOT_SUPPORT_COHOST = 111072105,
	/**<[en]This site does not support cohost. [cn]该会场不支持联席主持人 */
    CMS_PARTICIPANT_NOT_SUPPORT_COHOST = 111072106,
	/**<[en]Host cannot be set to cohost. [cn]不支持设置主持人为联席主持人 */
    CMS_CHAIR_CANNOT_BE_COHOST = 111072107,
	/**<[en]Audience cannot be set to cohost. [cn]不支持设置观众为联席主持人 */
    CMS_AUDIENCE_CANNOT_BE_COHOST = 111072108,
	/**<[en]Need to check cohost permission. [cn]需要去主会议所在region判断是否为联席主持人 */
    CMS_NEED_CHECK_COHOST_PERMISSION = 111072109,
	/**<[en]Cohost cannot operate host. [cn]联席主持人不能操作主持人 */
    CMS_COHOST_CANNOT_OPERATE_CHAIR = 111072110,
	/**<[en]This site does not support share invitation. [cn]当前会场不支持邀请共享能力 */
    CMS_PARTICIPANT_NOT_SUPPORT_INVITE_SHARE = 111072111,
	/**<[en]request include special character. [cn]请求参数包含特殊字符 */
    CMS_REQUEST_INCLUDE_SPECIAL_CHARACTER = 111072126,
	/**<[en]Hung up site because heart beat failed. [cn]与终端心跳中断导致挂断会场 */
    CMS_HEART_BEAT_FAIL_HING_UP = 111072201,
	/**<[en]Insufficient audience cloud meeting room logic resources. [cn]观众数超过VMR套餐中的观众最大并发资源数 */
    CMS_AUDIENCE_VMR_LOGIC_RESOURCE_NOT_ENOUGH = 111072202,
	/**<[en]Insufficient participant cloud meeting room logic resources. [cn]主持人与嘉宾超过VMR套餐中的最大并发资源数 */
    CMS_PARTICIPANT_VMR_LOGIC_RESOURCE_NOT_ENOUGH = 111072203,
	/**<[en]Insufficient webinar resources, so started failed. [cn]网络研讨会套餐已经有在线会议,被占用,激活失败 */
    CMS_STARTED_FAIL_WEBINAR_RESOURCE_NOT_ENOUGH = 111072204,
	/**<[en]Only RTC conf support local record. [cn]非RTC会议不支持本地录制 */
    CMS_ONLY_RTC_CONF_SUPPORT_LOCAL_RECORD = 111072205,
	/**<[en]Invalid E2E encryption parameter. [cn]端到端加密参数非法 */
    CMS_E2E_PARAMETER_ILLEGAL = 111072206,
	/**<[en]Not allow to switch role in webinar. [cn]网络研讨会不允许进行角色转换 */
    CMS_DISABLE_ROLE_SWITCH_OVER = 111072207,
	/**<[en]The client version used by the user is too early. Cannot start local recording. [cn]客户端不支持本地录制 */
    CMS_TERMINAL_NOT_SUPPORT_LOCAL_RECORD = 111072208,
	/**<[en]Meeting is under AR assist. [cn]会议已经在进行AR协作 */
    CMS_CONF_IS_UNDER_AR_ASSIST = 111072211,
	/**<[en]Audience cannot be set to host. [cn]观众不能设置为主持人 */
    CMS_AUDIENCE_CANNOT_BE_CHAIRMAN = 111072213,
	/**<[en]Rename param contains sensitive words. [cn]改名涉及敏感词错误 */
    CMS_RENAME_CONTAINS_SENSITIVEWORDS = 111072214,
	/**<[en]Indicates record start exception. [cn]启动云录制失败，请联系管理员 */
    CMS_RECORD_START_EXCEPTION = 111072222,
	/**<[en]Indicates record paused exception. [cn]暂停云录制失败，请联系管理员 */
    CMS_RECORD_PAUSED_EXCEPTION = 111072223,
	/**<[en]Indicates record stop exception. [cn]停止云录制失败，请联系管理员 */
    CMS_RECORD_STOP_EXCEPTION = 111072224,
	/**<[en]Indicates live start exception. [cn]启动直播失败，请联系管理员 */
    CMS_LIVE_START_EXCEPTION = 111072225,
	/**<[en]Indicates live stop exception. [cn]停止直播失败，请联系管理员 */
    CMS_LIVE_STOP_EXCEPTION = 111072226,
	/**<[en]Indicates sensitive words. [cn]信息中包含敏感词 */
    CMS_LIVE_STOP_SENSITIVE_WORDS = 111072227,
	/**<[en]Not support AUX conf. [cn]不支持新辅流会议 */
    CMS_NOT_SUPPORT_AUX_CONF = 111072403,
	/**<[en]Max participants in a single meeting reached. [cn]达到系统单个会议人数上限 */
    CMS_MMR_PARTICIPANT_REACH_MAX_NUM = 111072504,
	/**<[en]waiting room user is leaved. [cn]等候室准入用户已经离会 */
    CMS_WAITING_ROOM_USER_LEAVE = 111072507,
	/**<[en]waiting room user is joined. [cn]等候室准入用户已经准入 */
    CMS_WAITING_ROOM_USER_JOIN = 111072508,
	/**<[en]This site does not support screen shots. [cn]当前会场不支持禁止截屏 */
    CMS_PARTICIPANT_NOT_SUPPORT_SCREEN_SHOTS = 111072512,
	/**<[en]This apply for new mmrId reach limit. [cn]请求更换mmrId达到上限 */
    CMS_APPLY_REFRESH_MMRID_LIMIT = 111072516,
	/**<[en]Turn on Prohibit mobile viewing and sharing, and prohibit inviting mobile sharing. [cn]开启禁止移动端看共享，禁止邀请移动端共享 */
    CMS_FORBIDDEN_MOBILE_INVITE_SHARE = 111072520,
	/**<[en]Not allow invitation from external organization. [cn]当前被邀用户不允许被外部成员呼叫入会 */
    CMS_ONLY_ALLOW_INVITATIONS_FROM_BELONG_ORG = 111072521,
	/**<[en]Not allow join external crop conf. [cn]企业已限制加入外部会议，可联系企业管理员处理 */
    CMS_NOT_ALLOW_JOIN_EXTERNAL_CROP_CONF = 111072531,
	/**<[en]Not allow invitation from external crop. [cn]当前被邀用户所在企业限制加入外部会议 */
    CMS_ONLY_ALLOW_INVITATIONS_FROM_BELONG_CROP = 111072532,
	/**<[en]Breakout conference forbid inviting user. [cn]分组会议禁止邀请用户 */
    CMS_BREAKOUT_CONF_FORBID_INVITE_USER = 111072533,
	/**<[en]Conference manager is valid, not support offline join. [cn]当前管理面正常，不允许离线操作 */
    CMS_NOT_ALLOW_OFFLINE_OPERATION = 111072599,
	/**<[en]User does not exist. [cn]用户不存在 */
    CMS_USER_DATA_USER_INFO_NOT_EXIST = 111073001,
	/**<[en]Department does not exist. [cn]组织不存在 */
    CMS_USER_DATA_ORG_INFO_NOT_EXIST = 111073002,
	/**<[en]Invalid username format. [cn]用户非法 */
    CMS_USER_DATA_USER_INFO_ILLEGAL = 111073003,
	/**<[en]Invalid department name format. [cn]组织非法 */
    CMS_USER_DATA_ORG_INFO_ILLEGAL = 111073004,
	/**<[en]Could not query department. [cn]查询组织失败 */
    CMS_USER_DATA_ORG_INFO_QUERY_FAILED = 111073005,
	/**<[en]Application for anonymous user failed. [cn]申请匿名用户失败 */
    CMS_ASSIGN_ANONYMOUS_FAILED = 111073006,
	/**<[en]Invalid cloud meeting room package status. [cn]VMR套餐状态非法 */
    CMS_VMR_DATA_STATUS_ILLEGAL = 111073007,
	/**<[en]Failed to Release anonymous user. [cn]释放匿名用户失败 */
    CMS_RELEASE_ANONYMOUS_FAILED = 111073008,
	/**<[en]Not support cycle meeting for welinkC. [cn]WeLinkC 不支持预约周期会议 */
    CMS_WELINK_C_NOT_SUPPORT_CYCLE_CONF = 111073009,
	/**<[en]Not support cloud meeting room for welinkC. [cn]WeLinkC 不支持预约VMR会议 */
    CMS_WELINK_C_NOT_SUPPORT_VMR_CONF = 111073010,
	/**<[en]Failed to get Welink token. [cn]获取WeLink Proxy Token失败 */
    CMS_GET_WE_LINK_TOKEN_FAILED = 111073011,
	/**<[en]Failed to Get M to M token. [cn]获取机机账号Token失败 */
    CMS_GET_M_TO_M_TOKEN_FAILED = 111073012,
	/**<[en]Invalid webinar cloud meeting package status. [cn]网络研讨会VMR套餐状态非法 */
    CMS_WEBINAR_VMR_DATA_STATUS_ILLEGAL = 111073013,
	/**<[en]Max extend times for cloud meeting trial version reached. [cn]会议延长次数超出VMR试用套餐可延长的最大次数 */
    CMS_PROLONG_TIMES_OVER_LIMIT = 111073014,
	/**<[en]Max extend duration for cloud meeting trial version reached. [cn]会议延长时间超出VMR试用套餐单次会议最大时长 */
    CMS_PROLONG_DURATION_OVER_LIMIT = 111073015,
	/**<[en]Not support auto extend meeting for cloud meeting trial version. [cn]VMR试用套餐不支持自动延长 */
    CMS_RFEE_VMR_NOT_SUPPORT_AUTO_PROLONG = 111073016,
	/**<[en]This meeting host already exists. [cn]IDO主持人已经存在 */
    CMS_IDO_CONF_CHAIR_EXIST = 111074001,
	/**<[en]No meeting host permissions. [cn]无IDO主持人权限 */
    CMS_IDO_NOT_CONF_CHAIR = 111074002,
	/**<[en]Failed to extend the meeting. Max meeting duration reached. [cn]延长会议失败,会议已达到最大时长 */
    CMS_IDO_OVER_CONF_MAX_DURATION = 111074003,
	/**<[en]Failed to extend the meeting. The service processing is abnormal. [cn]延长会议失败,服务处理异常 */
    CMS_IDO_SET_CONF_DURATION_FAIL = 111074004,
	/**<[en]Failed to start timer. [cn]启动定时器失败 */
    CMS_START_TIMER_FAIL = 111075001,
	/**<[en]Failed to end timer. [cn]停止定时器失败 */
    CMS_MODIFY_TIMER_FAIL = 111075002,
	/**<[en]Json parse failed. [cn]json转换异常 */
    CMS_JSON_PARSE_FAIL = 111075003,
	/**<[en]Released by host. [cn]会场被终端主持人挂断 */
    CMS_CONF_PORTAL_PARTICIPANT_HANGUP_BY_CHAIR_IDO = 111076001,
	/**<[en]Released by portal host. [cn]会场被portal主持人挂断 */
    CMS_CONF_PORTAL_PARTICIPANT_HANGUP_BY_CHAIR_REST = 111076002,
	/**<[en]Max number of participants reached. [cn]超出VMR最大方数 */
    CMS_CONF_PORTAL_PARTICIPANT_VMR_LOGIC_RESOURCE_NOT_ENOUGH = 111076003,
	/**<[en]Insufficient enterprise resources. [cn]企业并发数不足 */
    CMS_CONF_PORTAL_PARTICIPANT_RESOURCE_NOT_ENOUGH = 111076004,
	/**<[en]Not answered. [cn]会场无响应 */
    CMS_CONF_PORTAL_PARTICIPANT_NO_RESPONSE = 111076005,
	/**<[en]User does not exist. [cn]会场不存在 */
    CMS_CONF_PORTAL_PARTICIPANT_NOT_EXIST = 111076006,
	/**<[en]Offline. [cn]会场离线 */
    CMS_CONF_PORTAL_PARTICIPANT_UNAVAILABLE = 111076007,
	/**<[en]Busy. [cn]忙 */
    CMS_CONF_PORTAL_PARTICIPANT_BUSY = 111076008,
	/**<[en]Rejected by user. [cn]拒接 */
    CMS_CONF_PORTAL_PARTICIPANT_REFUSED = 111076009,
	/**<[en]Released by user. [cn]会场挂断 */
    CMS_CONF_PORTAL_PARTICIPANT_LEAVE = 111076010,
	/**<[en]Insufficient meeting resources in the system. [cn]媒体资源不足 */
    CMS_CONF_PORTAL_PARTICIPANT_MEDIA_RESOURCE_NOT_ENOUGH = 111076011,
	/**<[en]Outbound calling disabled. [cn]PSTN服务未开通 */
    CMS_PSTN_SERVICE_UNAVAILABLE = 111076012,
	/**<[en]Application for address token failed. [cn]申请地址本鉴权信息失败 */
    CMS_CONF_APPLY_ADDRESS_TOKEN_FAILED = 111076013,
	/**<[en]Call failed. [cn]SIP呼叫超时 */
    CMS_CONF_PORTAL_PARTICIPANT_TIMEOUT = 111076014,
	/**<[en]Max number of participants reached. [cn]超过设置的会议方数 */
    CMS_CONF_PORTAL_OVER_MAX_PARTICIPANT_NUMBER = 111076015,
	/**<[en]Invalid user. [cn]用户失效 */
    CMS_CONF_USER_EXPIRATION = 111076017,
	/**<[en]Invalid enterprise. [cn]企业失效 */
    CMS_CONF_ORG_EXPIRATION = 111076018,
	/**<[en]Invalid SP. [cn]SP失效 */
    CMS_CONF_SP_EXPIRATION = 111076019,
	/**<[en]Not allow joining by scanning for hard device. [cn]企业配置来宾不允许扫码邀请硬终端入会* */
    CMS_CONF_GUEST_INVITE_NOT_ALLOW = 111076022,
	/**<[en]Not allow conf control. [cn]会议正在进行AR协作，禁止共享/分组会议/释放主持人等会控操作* */
    CMS_CONF_NOT_ALLOW_CONFCTRL = 111076028,
	/**<[en]Not allow AR Assist. [cn]会议正在进行共享/分组会议, 禁止进行AR协作* */
    CMS_CONF_NOT_ALLOW_AR_ASSIST = 111076029,
	/**<[en]Network error need restart share. [cn]网络异常，需要重新发起共享 */
    CMS_CONF_NETWORK_ERR_NEED_RESTART_SHARE = 111076040,
	/**<[en]Invite user expiration. [cn]被叫用户失效 */
    CMS_CONF_INVITE_USER_EXPIRATION = 111076045,
	/**<[en]Common error. [cn]通常失败 */
    CMS_CONF_PORTAL_PARTICIPANT_COMMON_ERROR = 111076099,
	/**<[en]RSE server info does not exist. [cn]RSE录播相关错误码 */
    CMS_RSE_SERVER_INFO_NOT_EXIST = 111077001,
	/**<[en]Not support AI record. [cn]会议不支持AI会议纪要 */
    CMS_CONF_NOT_SUPPORT_AI_RECORD = 111077101,
	/**<[en]Reapplying for AI record resource. [cn]正在重新申请会议纪要资源 */
    CMS_CONF_RE_APPLY_AI_RECORD_RES = 111077102,
	/**<[en]Insufficient AI record resource. [cn]AI会议纪要资源不足 */
    CMS_AI_RECORD_RESOURCE_NOT_ENOUGH = 111077103,
	/**<[en]In AI recording, the meeting cannot stop live or recording. [cn]会议处于AI会议纪要状态,不允许停止录制/直播 */
    CMS_CONF_IS_IN_AI_RECORD = 111077104,
	/**<[en]Record file does not exist or have no permission. [cn]录播文件已删除或您无权观看,请确认后重试 */
    CMS_RECORD_FILE_NOT_EXIST_OR_HAVE_NO_RIGHT = 111077201,
	/**<[en]RSE authentication failed. [cn]RSE机机鉴权失败 */
    CMS_RSE_AUTH_FAILED = 111077202,
	/**<[en]No available region in multi region. [cn]没有可用Region */
    CMS_MULTI_REGION_NO_AVAILABLE_REGION = 111078000,
	/**<[en]No available global in multi region. [cn]没有可用Global */
    CMS_MULTI_REGION_NO_AVAILABLE_GLOBAL = 111078001,
	/**<[en]Dispatch region error in multi region. [cn]多region 分发region错误 */
    CMS_MULTI_REGION_DISPATCH_REGION_ERROR = 111078002,
	/**<[en]Failed to phrase big data param query xml. [cn]大参数查询xml解析失败 */
    CMS_DATA_PARAM_QUERY_XML_FAILED = 111079000,
	/**<[en]Failed to phrase anonymous assign xml. [cn]匿名账号分配xml解析失败 */
    CMS_ANONYMOUS_ASSIGN_XML_FAILED = 111079001,
	/**<[en]Bad request. [cn]请求消息参数错误 */
    CMS_PARTICIPANT_BAD_REQUEST = 111080001,
	/**<[en]Insufficient permissions. [cn]用户无权限进行该操作 */
    CMS_PARTICIPANT_INSUFFICIENT_PERMISSIONS = 111080002,
	/**<[en]Site data not found or deleted. [cn]会场不存在或已被删除 */
    CMS_PARTICIPANT_DATA_NOT_FOUND = 111080004,
	/**<[en]Common error. [cn]IM通用错误 */
    CMS_IM_COMMON_EXCEPTION = 111080090,
	/**<[en]The sender information is invalid. [cn]IM发送者信息非法 */
    CMS_IM_SENDER_INFO_ILLEGAL = 111080096,
	/**<[en]Basic conference information is missing. [cn]会议基础信息缺失 */
    CMS_CONF_BASE_MISSING = 111080097,
	/**<[en]User site information is missing. [cn]用户会场信息缺失 */
    CMS_USER_PARTICIPANT_MISSING = 111080098,
	/**<[en]Invalid IM channel. [cn]IM频道非法 */
    CMS_IM_CHANNEL_ILLEGAL = 111080099,
	/**<[en]Forbid chat. [cn]禁止聊天 */
    CMS_IM_CHAT_FORBIDDEN = 111080100,
	/**<[en]Invalid chat target. [cn]聊天目标非法 */
    CMS_IM_CHAT_TARGET_ILLEGAL = 111080101,
	/**<[en]Allow public chat only. [cn]仅允许公开聊天 */
    CMS_IM_PUBLIC_CHAT_ONLY = 111080102,
	/**<[en]Invalid msgId. [cn]查询msgId非法 */
    CMS_IM_QUERY_MSG_ID_ILLEGAL = 111080104,
	/**<[en]Invalid message type. [cn]消息类型非法 */
    CMS_IM_MSG_TYPE_ILLEGAL = 111080105,
	/**<[en]The message content is too long. [cn]消息内容过长 */
    CMS_IM_MSG_CONTENT_ILLEGAL = 111080106,
	/**<[en]Message sending is controlled. [cn]消息发送被流控 */
    CMS_IM_CHAT_MSG_IS_CONTROLLED = 111080205,
	/**<[en]Site is inviting. [cn]会场正在通话中 */
    CMS_PARTICIPANT_IS_INVITING = 111081001,
	/**<[en]Site meeting does not exist or is ended. [cn]会场所在会议不存在或已结束 */
    CMS_PARTICIPANT_CONF_NOT_EXIST = 111081002,
	/**<[en]Failed to apply site resource. [cn]申请会场资源失败 */
    CMS_PARTICIPANT_APPLY_RESOURCE_FAILED = 111081003,
	/**<[en]Failed to release site resource. [cn]释放会场资源失败 */
    CMS_PARTICIPANT_RELEASE_RESOURCE_FAILED = 111081004,
	/**<[en]Failed to apply site media resource. [cn]申请会场媒体资源失败 */
    CMS_PARTICIPANT_APPLY_MEDIA_RESOURCE_FAILED = 111081005,
	/**<[en]Authentication failed. [cn]认证失败 */
    CMS_PARTICIPANT_AUTHENTICATION_FAILED = 111081006,
	/**<[en]Meeting is locked. [cn]会议已经被锁定 */
    CMS_PARTICIPANT_CONF_IS_LOCKED = 111081007,
	/**<[en]Login is locked because max authentication times reached. [cn]会议鉴权失败次数已达上限被锁定 */
    CMS_PARTICIPANT_CONF_LOGIN_LOCKED = 111081009,
	/**<[en]Waiting user restrictions. [cn]等候用户限制 */
    CMS_WAITING_USER_LIMIT = 111081010,
	/**<[en]Not support this control. [cn]不支持该会控 */
    CMS_PARTICIPANT_CONTROL_NOT_SUPPORT = 111082001,
	/**<[en]No response. [cn]无响应 */
    CMS_PARTICIPANT_NO_RESPONSE = 111082002,
	/**<[en]Site not exist. [cn]会场不存在 */
    CMS_PARTICIPANT_NOT_EXIST = 111082003,
	/**<[en]Site unavailable. [cn]会场离线 */
    CMS_PARTICIPANT_UNAVAILABLE = 111082004,
	/**<[en]Site busy. [cn]会场正忙 */
    CMS_PARTICIPANT_BUSY = 111082005,
	/**<[en]Site refused. [cn]会场拒接 */
    CMS_PARTICIPANT_REFUSED = 111082006,
	/**<[en]Site leave. [cn]会场挂断 */
    CMS_PARTICIPANT_LEAVE = 111082007,
	/**<[en]PSTN service is closed. [cn]PSTN服务关闭 */
    CMS_PSTN_SERVICE_CLOSED = 111082008,
	/**<[en]SIP invitation timeout. [cn]SIP呼叫超时 */
    CMS_PARTTICIPANT_INVITE_TIMEOUT = 111082009,
	/**<[en]RSE does not exist. [cn]RSE设备不存在 */
    CMS_PARTICIPANT_RSE_NOT_EXIST = 111083001,
	/**<[en]Failed to execute DTMF. [cn]执行DTMF失败 */
    CMS_PARTICIPANT_EXECUTE_DTMF_FAILED = 111084001,
	/**<[en]Get started meeting exception. [cn]启动会议异常 */
    CMS_PARTICIPANT_GET_STARTED_CONF_EXCEPTION = 111084002,
	/**<[en]Call MCU side exception. [cn]呼叫MCU端异常 */
    CMS_PARTICIPANT_CALL_MCUSIDE_EXCEPTION = 111084003,
	/**<[en]Join call exception. [cn]加入呼叫异常 */
    CMS_PARTICIPANT_JOIN_CALL_EXCEPTION = 111084004,
	/**<[en]Invite exception. [cn]邀请异常 */
    CMS_PARTICIPANT_INVITE_EXCEPTION = 111084005,
	/**<[en]Call terminal side exception. [cn]呼叫端侧异常 */
    CMS_PARTICIPANT_CALL_TERMINALSIDE_EXCEPTION = 111084006,
	/**<[en]Answer exception. [cn]应答异常 */
    CMS_PARTICIPANT_ANSWER_EXCEPTION = 111084007,
	/**<[en]Common CTL exception. [cn]通用CTL异常 */
    CMS_PARTICIPANT_GENERIC_CTL_EXCEPTION = 111084008,
	/**<[en]Hangup exception. [cn]挂断异常 */
    CMS_PARTICIPANT_HANGUP_EXCEPTION = 111084009,
	/**<[en]Notify capability exception. [cn]通知能力异常 */
    CMS_PARTICIPANT_INFORM_CAPABILITY_EXCEPTION = 111084010,
	/**<[en]Update MT exception. [cn]更新MT异常 */
    CMS_PARTICIPANT_UPDATE_MT_EXCEPTION = 111084011,
	/**<[en]Negotiate exception. [cn]协商异常 */
    CMS_PARTICIPANT_NEGOTIATE_EXCEPTION = 111084012,
	/**<[en]Not support this meeting. [cn]不支持该会议 */
    CMS_PARTICIPANT_CONF_NOT_SUPPORT = 111084013,
	/**<[en]Not allowed join meeting in RTC inviting because guests are not invited. [cn]RTC外邀入会,来宾不在被邀请名单中,拒绝入会 */
    CMS_RTC_INVITE_NOT_ALLOWED_JOIN_CONF = 111084014,
	/**<[en]Failed to phrase URI join xml. [cn]链接入会XML解析失败 */
    CMS_URI_JOIN_XML_FAILED = 111089002,
	/**<[en]Failed to join data meeting. [cn]数据入会失败 */
    CMS_DATA_JOIN_FAIL = 111090001,
	/**<[en]Join data meeting overtime. [cn]数据入会超时 */
    CMS_DATA_JOIN_OVERTIME = 111090002,
	/**<[en]Failed to get slider image. [cn]获取滑块图片失败 */
    CMS_AUTH_SLIDE_GET_IMAGE_FAILED = 111100001,
	/**<[en]Slider check failed. [cn]滑块校验失败 */
    CMS_AUTH_SLIDE_VERIFY_CHECK_FAILED = 111100002,
	/**<[en]Invalid random number. [cn]无效的随机数 */
    CMS_AUTH_INVALID_RANDOM = 111100003,
	/**<[en]Invalid slider token. [cn]无效滑块token */
    CMS_AUTH_INVALID_SLIDER_TOKEN = 111100004,
	/**<[en]Need to check slider. [cn]需要滑块校验 */
    CMS_AUTH_NEED_CHECK_SLIDER = 111100005,
	/**<[en]Invalid SMS phone number. [cn]非法的手机号 */
    CMS_AUTH_INVALID_SMS = 111100006,
	/**<[en]Failed to send verification code. [cn]发送验证码失败 */
    CMS_SEND_VERIFY_CODE_FAIL = 111100007,
	/**<[en]Verification code expired. [cn]验证码已过期 */
    CMS_AUTH_VERIFY_CODE_EXPIRED = 111100008,
	/**<[en]Verification code error. [cn]验证码错误 */
    CMS_AUTH_VERIFY_CODE_FAIL = 111100009,
	/**<[en]Max verification code check times reached. [cn]验证码错误超过最大次数 */
    CMS_AUTH_VERIFY_CODE_FAIL_CNT_EXCEED = 111100010,
	/**<[en]The uuid is invalid, you need to re-verify the phone number. [cn]uuid无效,需要重新验证手机号 */
    CMS_AUTH_INVALID_UUID = 111100011,
	/**<[en]The meeting is not on this site. [cn]会议不在本站点 */
    CMS_CONF_NOT_ON_LOCAL_STATION = 111100012,
	/**<[en]Need to verify the mobile phone number. Overseas access to China, free enterprises need to verify the mobile phone verification code. [cn]需要验证手机号，海外接入国内，免费企业需要进行手机验证码校验 */
    CMS_AUTH_NEED_MOBILE_VERIFY = 111100013,
	/**<[en]Failed to add IM group. [cn]添加群组失败 */
    CMS_IM_ADD_GROUP_FAILED = 111110001,
	/**<[en]Failed to disband IM group. [cn]删除群组失败 */
    CMS_IM_DISBAND_GROUP_FAILED = 111110002,
	/**<[en]Failed to add IM member. [cn]添加成员失败 */
    CMS_IM_ADD_MEMBER_FAILED = 111110003,
	/**<[en]Failed to remove IM member. [cn]删除成员失败 */
    CMS_IM_REMOVE_MEMBER_FAILED = 111110004,
	/**<[en]hangup for rejoin mmr failed. [cn]mmr重入会失败挂断 */
    CMS_CTRL_HANGUP_MMR_REJOIN_FAILED = 111111007,
	/**<[en]hangup for joinconf conflict. [cn]多端入会冲突，导致离开会议 */
    CMS_CTRL_HANGUP_CONF_CONFLICT = 111111008,
	/**<[en]Failed to enter the waiting room. [cn]入等候室失败 */
    CMS_WAITING_ROOM_ADD_MEMBER_FAILED = 111112001,
	/**<[en]Failed to exit the waiting room. [cn]出等候室失败 */
    CMS_WAITING_ROOM_MOVE_MEMBER_FAILED = 111112002,
	/**<[en]Waiting room cache operation failed. [cn]等候室缓存操作失败 */
    CMS_WAITING_ROOM_CACHE_OPT_FAILED = 111112003,
	/**<[en]Co-hosts cannot be moved into the waiting room. [cn]联席主持人不能被移入等候室 */
    CMS_NOT_ALLOW_COHOST_TO_WAITING_ROOM = 111112004,
	/**<[en]Not allowed to enable waiting room. [cn]不允许启用等候室 */
    CMS_NOT_ALLOW_ENABLE_WAITING_ROOM = 111112005,
	/**<[en]Not support this feature according to client capabilities. [cn]客户端能力不支持此特性 */
    CMS_CLIENT_NOT_SUPPORT = 111112008,
	/**<[en]Sorry,this device not support moving into the waiting room. [cn]抱歉，该设备不支持移入等候室 */
    CMS_DEVICE_NOT_SUPPORT_MOVE_WAITING_ROOM = 111112009,
	/**<[en]can not find application. [cn]找不到应用信息 */
    CMS_APPLICATION_NOT_FOUND = 111113001,
	/**<[en]application exist. [cn]应用已存在，目前一个会议只能关联一种应用 */
    CMS_APPLICATION_EXIST = 111113002,
	/**<[en]not required to create application. [cn]无权限创建应用 */
    CMS_APPLICATION_CREATE_FORBIDDEN = 111113003,
	/**<[en]need verify id. [cn]应用操作需要实名认证（用户需要绑定手机） */
    CMS_APPLICATION_NEED_REAL_NAME = 111113004,
	/**<[en]get token failed. [cn]获取应用用户token失败 */
    CMS_APPLICATION_GET_USER_TOKEN_FAILED = 111113005,
	/**<[en]url illegal. [cn]应用服务URL地址非法 */
    CMS_APPLICATION_URL_INVALID = 111113006,
	/**<[en]shimo doc has not used. [cn]石墨文档应用未启用 */
    CMS_APPLICATION_SHIMO_DOC_NOT_ENABLED = 111113101,
	/**<[en]call shimo doc server failed. [cn]调用石墨文档服务失败 */
    CMS_APPLICATION_SHIMO_DOC_CALL_FAILED = 111113102,
	/**<[en]get shimo token failed. [cn]获取石墨应用级token失败 */
    CMS_APPLICATION_SHIMO_GET_TOKEN_FAILED = 111113103,
	/**<[en]not in conf,has no right to apply. [cn]用户不在会议中，无权限申请权限 */
    CMS_APPLICATION_SHIMO_NOT_IN_CONFERENCE = 111113104,
	/**<[en]account has been stoped. [cn]企业账号被停用 */
    CMS_LOGIN_ACCOUNT_DISABLED = 111113105,
	/**<[en]SMS messages sent frequently, try again later. [cn]短信发送过频繁，请稍后再试 */
    CMS_SMS_SEND_FREQUENTLY = 111113106,
	/**<[en]SMS messages sent has exceeded the daily limit of the enterprise. [cn]短信发送量已超过企业每日上限 */
    CMS_SMS_EXCEEDED_DAILY_LIMIT_OF_ENTERPRISE = 111113107,
	/**<[en]projection link verify failed. [cn]投屏链路校验失败 */
    CMS_PROJECTION_LINK_VERIFY_FAILED = 111114001,
	/**<[en]content moderation failed. [cn]内容审核不通过 */
    CMS_CONTENT_MODERATION_FAILED = 111114020,
	/**<[en]share webinar not enough. [cn]激活共享网络研讨会时资源不足 */
    CMS_SHARE_WEBINAR_NOT_ENOUGH = 111114032,
	/**<[en]corp has not config cascade conf. [cn]企业没有配置入驻式会议接入码，企业高级参数中配置 */
    CMS_USG_CORP_CASCADE_CONF_NOT_CONFIG = 111114042,
	/**<[en]corp has not config sip for cascade conf. [cn]企业没有配置入驻式会议sip中继前缀，企业高级参数中配置 */
    CMS_USG_CORP_NOT_CONFIG_SIP_FOR_CASCADE_CONF = 111114043,
	/**<[en]corp has no resource for cascade conf. [cn]没有资源创建自级联会议，企业无并发且当前用户无专享vmr资源 */
    CMS_USG_CORP_NO_RESOURCE_FOR_CASCADE_CONF = 111114044,
	/**<[en]creating cascade conf,please try later. [cn]自级联会议正在创建中，请稍后重试 */
    CMS_USG_CREATING_CASCADE_CONF = 111114045,
	/**<[en]pre corp code error. [cn] 企业前缀码错误，无对应企业。会管apollo中配置 */
    CMS_USG_PRE_CORP_CODE_ERROR = 111114046,
	/**<[en]corp has not support cascade conf. [cn]企业未开通入驻式会议自级联功能，企业高级参数中配置 */
    CMS_USG_CORP_HAS_NOT_SUPPORT_CASCADE_CONF = 111114047,
	/**<[en]corp is not in Affiliated enterprise's trust list. [cn]企业不在会议所属企业信任列表中，企业高级参数中配置 */
    CMS_USG_CORP_NOT_IN_TRUST_LIST = 111114048,
	/**<[en]call conf control verify interface failed. [cn]调用会控校验入驻式会议密码接口失败，无返回信息，比如网络异常等，内部异常 */
    CMS_USG_CALL_CONF_CTRL_INTERFACE_FAILED = 111114049,
	/**<[en]share webinar not enough. [cn]调用会控检查入驻式会议密码返回异常信息，请联系管理员。 */
    CMS_USG_CALL_CONF_CTRL_INTERFACE_RESPONSE_EXCEPTION = 111114050,
	/**<[en]cannot join cascading conference without password in this corp. [cn]当前企业不允许无密码加入入驻式会议 */
    CMS_USG_CALL_CONF_NEED_PASSWORD = 111114051,
	/**<[en]Insufficient offline conference resources. [cn]线下会议资源不足 */
    CMS_USG_CALL_CONF_INSUFFICIENT_RESOURCES = 111114052,
	/**<[en]breakout conf surpass limit. [cn] 分组会议子会议超过上限 */
    CMS_BREAKOUT_CONF_SUB_OVER_LIMIT = 111500301,
	/**<[en]breakout conf name error. [cn] 分组会议子会议名称错误 */
    CMS_BREAKOUT_CONF_NAME_ERROR = 111500302,
	/**<[en]breakout Start failed. [cn] 分组会议启动失败 */
    CMS_BREAKOUT_CONF_START_FAILED = 111500303,
	/**<[en]breakout not exist when delete [cn] 分组会议中没有子会议（删除） */
    CMS_BREAKOUT_CONF_NOT_EXIST_WHEN_DELETE = 111500304,
	/**<[en]breakout not exist when start. [cn] 分组会议中没有子会议（启动） */
    CMS_BREAKOUT_CONF_NOT_EXIST_WHEN_START = 111500305,
	/**<[en]breakout is closing by host [cn] 分组会议结束中(主持人停止) */
    CMS_BREAKOUT_CONF_CLOSING = 111500306,
	/**<[en]breakout is closing by host [cn] 分组会议已经结束或未启动（加入时） */
    CMS_BREAKOUT_CONF_END_OR_NOT_START = 111500307,
	/**<[en]Attendee in target conf [cn] 移动用户在目标分组 */
    CMS_BREAKOUT_CONF_ATTENDEE_IN_TARGET_CONF = 111500308,
	/**<[en]Chair in current conf [cn] 主持人在当前分组中（请求帮助） */
    CMS_BREAKOUT_CONF_CHAIR_IN_CURRENT_CONF = 111500309,
	/**<[en]not support breakout conf [cn] 不支持分组会议（启动时 启动接口） */
    CMS_BREAKOUT_CONF_NOT_SUPPORT_BREAKOUT = 111500310,
	/**<[en]breakout conf starting or started [cn] 分组会议已经启动或启动中（重复启动） */
    CMS_BREAKOUT_CONF_STARTING_OR_STARTED = 111500311,
	/**<[en]subconf not exist [cn] 子会议不存在 */
    CMS_BREAKOUT_CONF_NOT_EXIST = 111500312,
	/**<[en]not support in mainconf [cn] 主会中用户不支持此操作（请求帮助） */
    CMS_BREAKOUT_CONF_NOT_SUPPORT_IN_MAIN_CONF = 111500313,
	/**<[en]breakout conf state illegal [cn] 分组会议状态异常（缓存误删） */
    CMS_BREAKOUT_CONF_STATE_ILLEGAL = 111500314,
	/**<[en]action forbidden by status [cn] 分组会议静态、动态操作由于状态原因，不支持当前操作 */
    CMS_BREAKOUT_CONF_ACTION_FORBIDDEN_BY_STATUS = 111500315,
	/**<[en] apply chair failed due to host in subconf [cn] 主持人在分组中，不能申请为主持人 */
    CMS_BREAKOUT_CONF_APPLY_CHAIR_FAILED = 111500316,
	/**<[en] apply sub conf id failed [cn] 申请分组的会议id失败 */
    CMS_BREAKOUT_CONF_APPLY_CONF_ID_FAILED = 111500317,
	/**<[en] query main conf failed [cn] 获取主会议信息失败 */
    CMS_BREAKOUT_CONF_QUERY_MAIN_CONF_FAILED = 111500318,
	/**<[en] attendee not found [cn] 没有找到用户信息 */
    CMS_BREAKOUT_CONF_ATTENDEE_NOT_FOUND = 111500319,
	/**<[en] sub conf stop failed [cn] 分组会议停止失败 */
    CMS_BREAKOUT_CONF_STOP_FAILED = 111500320,
	/**<[en] subject faile and leave conf start [cn] 订阅失败需要离会的错误码起始值 */
    CMS_SUBJECT_FAIL_TO_LEAVE_CONF_START = 111502000,
	/**<[en] subject faile and leave conf end [cn] 订阅失败需要离会的错误码结束值 */
    CMS_SUBJECT_FAIL_TO_LEAVE_CONF_END = 111502099,
	/**<[en]Common failure. [cn]通用失败 */
    CMS_FAILED = 112010001,
	/**<[en]Null param. [cn]参数为空 */
    CMS_NULL_PARAM = 112010002,
	/**<[en]Participant not found. [cn]未找到参与者 */
    CMS_PARTICIPANT_NOT_FOUND = 112010003,
	/**<[en]Meeting not found. [cn]会议不存在 */
    CMS_CONFERENCE_NOT_FOUND = 112010004,
	/**<[en]SIP invite information timeout. [cn]invite消息超时 */
    CMS_SIP_INVITE_TIMEOUT_NO_RCV = 112010005,
	/**<[en]SIP invite information failed. [cn]invite消息失败 */
    CMS_SIP_INVITE_FAILED = 112010006,
	/**<[en]SIP information timeout. [cn]info响应超时 */
    CMS_SIP_INFO_TIMEOUT = 112010007,
	/**<[en]SIP information failed. [cn]info响应失败 */
    CMS_SIP_INFO_FAILED = 112010008,
	/**<[en]System processing failed. [cn]系统处理失败 */
    CMS_WAIT_FIRST_CALL_FAILED = 112010009,
	/**<[en]System processing failed. [cn]系统处理失败 */
    CMS_PARTICIPANT_DIALOG_FAILED = 112010010,
	/**<[en]Failed to invite MRS. [cn]呼叫mrs失败 */
    CMS_INVITE_MRS_FAILED = 112010011,
	/**<[en]Failed to invite participant. [cn]呼叫终端失败 */
    CMS_INVITE_PARTICIPANT_FAILED = 112010012,
	/**<[en]Data meeting join information failed. [cn]数据入会Info失败 */
    CMS_INFORM_CONF_INFO_FAILED = 112010013,
	/**<[en]Failed to start meeting. [cn]召开会议失败 */
    CMS_START_CONF_FAILED = 112010014,
	/**<[en]Media negotiation failed. [cn]媒体协商失败 */
    CMS_MEDIA_NEGOTIATION_FAILURE = 112010015,
	/**<[en]User rejects. [cn]用户拒绝 */
    CMS_USER_REJECTED = 112010016,
	/**<[en]User is busy. [cn]用户忙 */
    CMS_USER_BUSY = 112010017,
	/**<[en]No call permission. [cn]没有呼叫权限 */
    CMS_NO_CALL_RIGHT = 112010018,
	/**<[en]Unknown callee. [cn]未知被叫人 */
    CMS_UNKNOWN_CALLEE = 112010019,
	/**<[en]No user response. [cn]没有用户响应 */
    CMS_NO_USER_RESPONDING = 112010020,
	/**<[en]Join meeting timed out. [cn]加入会议超时 */
    CMS_JOIN_CONF_TIMEOUT = 112010021,
	/**<[en]Session has been released. [cn]会话已释放 */
    CMS_SESSION_RELEASED = 112010022,
	/**<[en]Callee is not registered. [cn]被叫人未注册 */
    CMS_CALLEE_NOT_REGISTERED = 112010023,
	/**<[en]SIP invite timed out. [cn]SIP邀请超时 */
    CMS_SIP_INVITE_TIMEOUT_RCV1XX = 112010024,
	/**<[en]User Session timer times out and hangs up. [cn]用户Session timer 超时挂断 */
    CMS_USER_SESSION_TIMER_TIMEOUT_HANGUP = 112010025,
	/**<[en]The participant bye hangs up on the MRS side. [cn]与会者腿MRS侧bye挂断 */
    CMS_RCV_USER_BYE_MRS_HANGUP = 112010026,
	/**<[en]The participant bye hangs up on terminal side. [cn]与会者腿终端侧bye挂断 */
    CMS_RCV_USER_BYE_PART_HANGUP = 112010027,
	/**<[en]No RTP stream hang up. [cn]无码流挂断 */
    CMS_NO_RTP_STREAM_HUNG_UP = 112010028,
	/**<[en]No Upscale vmr. [cn]无高档可用的VMR资源 */
    CMS_CONF_MANAGER_NO_UPSCALE_VMR = 112030001,
	/**<[en]simple conf not found. [cn]简易会议不存在 */
    CMS_SIMPLE_CONF_DATA_NOT_FOUND = 112050008,
	/**<[en]Move breakout conf failed. [cn]网络异常导致移入分组失败 */
    CMS_CONF_MOVE_BC_FAILED = 112051005,
	/**<[en]Normal audience num reach max. [cn]正常观众人数已满 */
    CMS_NORMAL_AUDIENCE_REACH_MAX = 112051014,
	/**<[en]Terminal unsupport watermark. [cn]终端不支持水印 */
    CMS_TERMINAL_UNSUPPORT_WATERMARK = 112051015,
	/**<[en]Terminal unsupport forbidden screenshot. [cn]终端不支持防截屏 */
    CMS_TERMINAL_UNSUPPORT_FORBIDDEN_SCREENSHOT = 112051016,
	/**<[en]Main Conference end notification. [cn]主会场会议结束通知 */
    CMS_MAIN_CONF_END_NOTIFYCATION = 112051017,
	/**<[en]Breakout Conference end notification. [cn]分组会场会议结束通知 */
    CMS_BREAKOUT_CONF_END_NOTIFICATION = 112051018,
	/**<[en]Share webinar audience resource not enough. [cn]无高档可用的共享网络研讨会观众资源 */
    CMS_SHARE_WEBINAR_AUDIENCE_RESOURCE_NOT_ENOURH = 112051999,
	/**<[en]Sysportal exception. [cn]系统异常 */
    CMS_SYSPORTAL_EXCEPTION = 112100000,
	/**<[en]Bad request. [cn]请求异常 */
    CMS_BAD_REQUEST = 112100001,
	/**<[en]Illegal request. [cn]非法请求 */
    CMS_ILLEGAL_REQUEST = 112100002,
	/**<[en]Data not found. [cn]数据未获取到 */
    CMS_DATA_NOT_FOUND = 112100003,
	/**<[en]Data duplication. [cn]数据重复 */
    CMS_DATA_DUPLICATE = 112100004,
	/**<[en]The requested type is not supported. [cn]请求的类型不支持 */
    CMS_APPLY_TYPE_NOT_SUPPORT = 112100006,
	/**<[en]Failed to save notification template. [cn]保存通知模板失败 */
    CMS_SAVE_NOTICE_MODEL_FAILED = 112100007,
	/**<[en]Failed to save data. [cn]保存数据失败 */
    CMS_SAVE_DATA_FAILED = 112100008,
	/**<[en]Failed to query data. [cn]查询数据失败 */
    CMS_QUERY_DATA_FAILED = 112100009,
	/**<[en]Failed to delete data. [cn]删除数据失败 */
    CMS_DELETE_DATA_FAILED = 112100010,
	/**<[en]Password reset required. [cn]需要重置密码 */
    CMS_NEED_RESET_PASSWORD = 112100011,
	/**<[en]Incorrect old password. [cn]旧密码错误 */
    CMS_AUTH_FAILED = 112100012,
	/**<[en]The new password cannot be the same as the old password. [cn]新密码不能与旧密码相同 */
    CMS_NEW_PASSWORD_EQUALS_OLD_PASSWORD = 112100013,
	/**<[en]Insufficient password complexity and low security. [cn]密码复杂度不够,安全性低 */
    CMS_PASSWORD_TOO_SIMPLE = 112100014,
	/**<[en]The length does not meet the requirements. [cn]长度不符合要求 */
    CMS_LEHGTH_NOTMEET_STANDARD = 112100015,
	/**<[en]RSE is in meeting. [cn]RSE在会议中 */
    CMS_RSE_IS_IN_CONFERENCE = 112100016,
	/**<[en]RSE to be deleted. [cn]RSE待删除 */
    CMS_RSE_IS_DELETING = 112100017,
	/**<[en]Failed to query the meeting list. [cn]查询会议列表失败 */
    CMS_RSE_LIST_CONF_FAILED = 112100018,
	/**<[en]User has been locked out. Try again later. [cn]用户已被锁定,请稍后重新登录 */
    CMS_AUTH_LOCKED = 112100019,
	/**<[en]The live room channel name exists. [cn]频道名称已存在 */
    CMS_LIVE_CHANNEL_NAME_EXISTED = 112100022,
	/**<[en]Failed to modify system configuration items for duplicated meeting ID prefix. [cn]修改系统配置项失败,会议ID前缀重复 */
    CMS_CONFID_PREFIX_CANNOT_DECREASE = 112100023,
	/**<[en]CONFID prefix can only be added, not modified or deleted. [cn]CONFID前缀只能增加,不能修改和删除 */
    CMS_CONFID_PREFIX_DUPLICATE = 112100024,
	/**<[en]The live room channel url exists. [cn]直播房间地址已存在 */
    CMS_LIVE_CHANNEL_URL_EXISTED = 112100025,
	/**<[en]The live room has been occupied. [cn]直播房间已被使用 */
    CMS_LIVE_ROOM_ISUSED = 112100026,
	/**<[en]The live room does not exist. [cn]直播房间不存在 */
    CMS_LIVE_ROOM_NOT_EXIST = 112100027,
	/**<[en]Live room release failed. [cn]直播房间释放失败 */
    CMS_LIVE_ROOM_RELEASE_FAIL = 112100028,
	/**<[en]The request is missing header or param. [cn]请求缺失头域 */
    CMS_REQUEST_MISSING_HEADER_OR_PARAM = 112100029,
	/**<[en]The Live main stream URL already exists. [cn]音视频推流地址已存在 */
    CMS_LIVE_MAIN_URL_EXISTED = 112100030,
	/**<[en]The Live auxiliary stream URL already exists. [cn]辅流演示推流地址已存在 */
    CMS_LIVE_AUX_URL_EXISTED = 112100031,
	/**<[en]Password is weak. [cn]密码为弱密码 */
    CMS_PWD_IS_WEAK_PASSWORD = 112100032,
	/**<[en]The live room is occupied. [cn]直播房间被占用 */
    CMS_LIVE_ROOM_ISUSED_FAIL = 112100033,
	/**<[en]Save part of attendees since max attendees size reached. [cn]因为与会者数量超出上限只保存部分 */
    CMS_SAVE_PART_ATTENDEES_SINCE_TOO_MANY = 112100034,
	/**<[en]Failed to export data. [cn]导出数据失败 */
    CMS_EXPORT_DATA_FAIL = 112100035,
	/**<[en]Failed to import data. [cn]导入数据失败 */
    CMS_IMPORT_DATA_FAIL = 112100036,
	/**<[en]Max file size reached. [cn]文件大小超出上限 */
    CMS_FILE_EXCEEDS_MAXIMUM_SIZE = 112100037,
	/**<[en]LVS target address exists. [cn]lvs的目标地址已存在 */
    CMS_LVS_TARGET_ADDRESS_EXISTED = 112100038,
	/**<[en]LVS port existed. [cn]lvs端口重复 */
    CMS_LVS_PORT_EXISTED = 112100039,
	/**<[en]Not allow to modify global standby config. [cn]Global只有主机可以修改配置； */
    CMS_NOT_ALLOWED_MODIFY_GLOBAL_STANDBY = 112100040,
	/**<[en]MCU insulation IP address exists. [cn]mcu隔离的IP已经存在 */
    CMS_MCU_INSULATE_ADDR_EXIST = 112100041,
	/**<[en]MCU insulation IP address cannot be modified. [cn]mcu隔离的IP不能修改 */
    CMS_MCU_INSULATE_ADDR_CANT_MODIFY = 112100042,
	/**<[en]SBC address exists. [cn]SBC配置的地址已经存在 */
    CMS_SBC_ADDR_EXIST = 112100043,
	/**<[en]Internal exception. [cn]内部错误异常 */
    CMS_INTERNAL_EXCEPTION = 112100044,
	/**<[en]System config delete exception. [cn]系统配置不允许被删除 */
    CMS_SYS_CONFIG_DELETE_EXCEPTION = 112100045,
	/**<[en]No ISBC access address. [cn]企业id无法获取关联SBC地址 */
    CMS_NO_ISBC_ACCESS_ADDR = 112100046,
	/**<[en]Media type need to be HD because the organization enable Full HD capability. [cn]企业已开启全高清功能,媒体设置不能低于1080P/8M */
    CMS_MEDIA_TYPE_NEED_HD = 112100047,
	/**<[en]Same interpreter language abbreviation exists. [cn]语言缩写重复 */
    CMS_INTERPRETER_LANGUAGE_ABBREVIATION_REPEATED = 112100061,
	/**<[en]Same interpreter language name exists. [cn]语言名称重复 */
    CMS_INTERPRETER_LANGUAGE_NAME_REPEATED = 112100062,
	/**<[en]MCU type is MIXED and insulation config is not configured, or MCU meeting exsists when modifying mcu connection settings. [cn]修改MCU连接配置告警,以下两种场景会导致:1.MCU存在会议 2.修改类型为MIXED未配置隔离 */
    CMS_MODIFY_MCU_WARNING = 112100063,
	/**<[en]MCU type is MIXED and insulation config is not configured when adding mcu connection settings. [cn]新增MCU连接配置告警,MCU类型为MIXED且未配置隔离 */
    CMS_ADD_MCU_WARNING = 112100064,
	/**<[en]MCU type is MIXED when modifying MCU insulation config or disbanding enterprise. [cn]修改MCU隔离配置时,解除企业绑定时MCU类型为MIXED */
    CMS_MODIFY_MCUINSULATE_WARNING = 112100065,
	/**<[en]MCU type is MIXED when deleting MCU insulation config. [cn]删除MCU隔离配置时,MCU类型为MIXED */
    CMS_DEL_MCUINSULATE_WARNING = 112100066,
	/**<[en]This gateway type is incompatible with MCU. [cn]MCU与网关类型不兼容 */
    CMS_MCU_TYPE_INCOMPATIBLE = 112100067,
	/**<[en]Insufficient media resource. [cn]媒体资源不足 */
    CMS_MEDIARES_MEDIA_RESOURCE_NOT_ENOUGH = 115021001,
	/**<[en]Meeting does not exist. [cn]会议不存在 */
    CMS_MEDIARES_CONF_NOT_EXIST = 115021002,
	/**<[en]Media resource does not exist. [cn]媒体资源不存在 */
    CMS_MEDIARES_MEDIA_RESOURCE_NOT_EXIST = 115021003,
	/**<[en]Insufficient media bandwidth resource. [cn]带宽资源不足 */
    CMS_MEDIARES_BANDWIDTH_RESOURCE_NOT_ENOUGH = 115021005,
	/**<[en]Media device fault. [cn]设备故障 */
    CMS_MEDIARES_DEVICE_FAULT = 115021006,
	/**<[en]Insufficient common logic resource. [cn]通用的逻辑资源不足 */
    CMS_LOGIC_RES_NOT_ENOUGH = 115022000,
	/**<[en]Insufficient meeting resources in the enterprise. [cn]企业会议并发方数不足 */
    CMS_LOGICRES_PNUM_RESOURCE_NOT_ENOUGH = 115022001,
	/**<[en]Insufficient logic port resource. [cn]逻辑资源端口资源不满足 */
    CMS_LOGICRES_PORT_RESOURCE_NOT_ENOUGH = 115022002,
	/**<[en]Live broadcast resources have not been purchased or are insufficient. [cn]企业直播推流方数不足 */
    CMS_LOGICRES_LSNUM_RESOURCE_NOT_ENOUGH = 115022003,
	/**<[en]Insufficient connector resources in the enterprise. [cn]企业连接器资源不足 */
    CMS_CONNECTOR_RESOURCE_NOT_ENOUGH = 115022004,
	/**<[en]The cloud recording ports purchased by enterprises have been used up. [cn]企业购买的云录制端口已经用完 */
    CMS_LOGICRES_RECORED_NUM_RESOURCE_NOT_ENOUGH = 115022005,
	/**<[en]Insufficient concurrent resources for the meeting. [cn]会议并发资源不足 */
    CMS_CONF_CONCURRENT_RESOURCE_NOT_ENOUGH = 115022006,
	/**<[en]Insufficient connector meeting resources. [cn]会议连接器资源不足 */
    CMS_CONF_CONNECTOR_RESOURCE_NOT_ENOUGH = 115022008,
	/**<[en]Insufficient ID resources. [cn]ID资源不足 */
    CMS_ID_RESOURCE_NOT_ENOUGH = 115023001,
	/**<[en]RMS service exception. [cn]RMS服务异常 */
    CMS_RMS_SERVICE_ERROR = 115024001,
	/**<[en]The live room has already been occupied. [cn]直播房间已经被使用 */
    CMS_LIVE_ROOM_IN_USE = 115025001,
	/**<[en]The live room does not exist. [cn]直播房间不存在 */
    CMS_LIVE_ROOM_NOT_EXISTED = 115025002,
	/**<[en]Live room release failed. [cn]直播房间释放失败 */
    CMS_LIVE_ROOM_RELEASE_FAILED = 115025003,
	/**<[en]MCU meeting exists. [cn]MCU有会议 */
    CMS_MCU_HAS_CONF = 115026001,
	/**<[en]Invalid common parameter. [cn]通用参数值不合法 */
    CMS_COMMON_INVALID_PARAMS = 115029001,
	/**<[en]Null parameter. [cn]参数值为空 */
    CMS_COMMON_NULL_PARAMS = 115029002,
	/**<[en]service is not available. [cn]服务不可用 */
    CMS_COMMON_SERVICE_INVALID = 115029003,
	/**<[en]Configuration exception. [cn]配置异常 */
    CMS_CONFIG_ERROR = 115029004,
	/**<[en]Duplicately apply resources. [cn]重复申请资源 */
    CMS_DUPLICATE_APPLY_RESOURCE = 115029005,
	/**<[en]Waiting for applying resources. [cn]等待申请资源中 */
    CMS_WAIT_APPLY_RESOURCE = 115029006,
	/**<[en]Unknown error. [cn]未知错误 */
    CMS_COMMON_UNKNOWN = 115029999,
	/**<[en]User authentication failed. [cn]用户鉴权失败 */
    CMS_USER_AUTHENTICATION_FAILED = 118000000,
	/**<[en]User token authentication failed. [cn]usg token 鉴权失败 */
    CMS_USER_TOKEN_AUTH_FAILED = 118000001,
	/**<[en]User authentication account lockout. [cn]usg鉴权账号锁定 */
    CMS_USER_AUTHENTICATION_LOCKED = 118000002,
	/**<[en]Restrict guest invitations when opening the waiting room. [cn]开启等候室时限制来宾邀请 */
    CMS_RESTRICT_GUEST_INVITE_WHEN_WAITING_ROOM = 112051003,
	/**<[en]Joining the meeting requires a higher client upgrade, please check for upgrades. [cn]加入该会议需要升级较高客户端版本，请检查升级 */
    CMS_MULTI_SHARE_IS_NOT_SUPPORT = 112051006,
	/**<[en]Digital assistants is full. [cn]AI数字人助理并发已满，请稍后再试 */
    CMS_DIGITAL_ASSISTANTS_IS_FULL = 112051023,
	/**<[en]Digital assistants add failed. [cn]AI数字人助理添加失败 */
    CMS_ADD_DIGITAL_ASSISTANTS_FAILED = 112051024,
	/**<[en]Digital assistants state not support. [cn]AI数字人助理状态不支持该操作 */
    CMS_AI_ASSISTANT_STATE_NOT_SUPPORT = 112051025,
	/**<[en]Digital assistants state failed. [cn]AI数字人助理状态错误 */
    CMS_AI_ASSISTANT_STATE_FAILED = 112051026,
	/**<[en]Conf open custom params exist. [cn]会议客户数据已存在 */
    CMS_CONF_OPEN_CUSTOM_PARAMS_EXIST = 112051028,
	/**<[en]Server is busy. Please try again later. [cn]服务器正忙 请稍后再试 */
    USG_SERVER_BUSY = 200000001,
	/**<[en]Internal error. Please contact SRE. [cn]服务器正忙 请联系SRE */
    USG_INTERNAL_ERR = 200000002,
	/**<[en]Invalid parameter. Please check whether the parameters are valid. [cn]请求参数错误 请检查参数是否合法 */
    USG_PARAM_ERR = 200000003,
	/**<[en]Illegal request. Please check the value of the request header field X-Auth-Token or X-Access-Token. [cn]非法请求 请检查请求头域X-Auth-Token或X-Access-Token的值 */
    USG_ILLEGAL_REQ = 200000004,
	/**<[en]Forbidden access during the version upgrade. [cn]系统正在升级，暂时不可访问。如对您造成不便，十分抱歉 */
    USG_UPGRADING = 200000005,
	/**<[en]Url permission valid failed. [cn]分权分域接口权限校验失败 */
    USG_NO_DEPARTMENT_PERMISSIONS = 200000026,
	/**<[en]No department permission. [cn]分权分域部门权限校验失败 */
    USG_URL_PERMISSION_VALID_FAILED = 200000030,
	/**<[en]This user is already the owner of another corporation and cannot create a new corporation for it. [cn]该用户已经是其他企业的所有者,无法为其创建新的企业 */
    USG_OTHER_CORP_OWNER = 201020023,
	/**<[en]Max number of users reached. Please check the purchased meeting users. [cn]用户总数超过限制，请检查购买的会议用户 */
    USG_CORP_USER_NUMBER_MAX = 201040005,
	/**<[en]Password security is low. Please set another password. [cn]密码安全性低，请设置其他密码 */
    USG_PASSWORD_SECURITY_LOW = 201040016,
	/**<[en]Activation code overdue. [cn]激活码过期 */
    USG_ACTIVE_CODE_OVERDUE = 201040031,
	/**<[en]The device under this enterprise has been activated and cannot be reactivated. [cn]该企业下设备已激活，不可再次激活 */
    USG_DEVICE_CANNOT_BE_REACTIVATED = 201040033,
	/**<[en]This device has been activated in another enterprise and cannot be reactivated again. [cn]该设备在其他企业下已激活，不可再次激活 */
    USG_DEVICE_ACTIVATED_IN_OTHERS_ENTERPRISE = 201040034,
	/**<[en]The number of activation codes has reached the resource limit. [cn]激活码数量已达资源上限 */
    USG_ACTIVE_CODE_REACHED_RESOURCE_LIMIT = 201040037,
	/**<[en]User not activated. [cn]用户未激活 */
    USG_USER_NOT_ACTIVATED = 201040041,
	/**<[en]Pre-authentication expired. [cn]预验证失效 */
    USG_PRE_VERIFY_EXPIRE = 201040042,
	/**<[en]This user is the owner of another corporation and cannot be invited. [cn]该用户是其他企业的所有者,暂无法邀请 */
    USG_NO_INVITE_OTHER_CORP_OWNER = 201040043,
	/**<[en]Invalid invite connection. [cn]邀请连接非法 */
    USG_INVITE_LINK_INVALID = 201040044,
	/**<[en]User is already in waiting list. [cn]用户已经在等待列表 */
    USG_USER_IN_WAIT_LIST = 201040045,
	/**<[en]User already exists. [cn]用户已存在 */
    USG_USER_EXIST = 201040046,
	/**<[en]Account modification is not allowed. [cn]不允许修改账户 */
    USG_NOT_ALLOW_MOD_ACCOUNT = 201040047,
	/**<[en]IdeaHub resource exceeds the inactive limit. [cn]IdeaHub资源超过非激活数量限制 */
    USG_IDEAHUB_RESOURCE_EXCEEDS_INACTIVE_LIMIT = 201040049,
	/**<[en]The user name cannot contain sensitive words.. [cn]用户名称不能包含敏感词 */
    USG_NOT_CANNOT_CONTAIN_SENSITVE_WORDS = 201040063,
	/**<[en]The device does not support active codes. [cn]设备类型不支持激活码 */
    USG_DEVICE_NOT_SUPPORT_ACTIVE_CODE = 201050004,
	/**<[en]The maximum number of device activation code resets within one day has been reached. [cn]一天内重置设备激活码次数已达到最大值(5次) */
    USG_ACTIVE_CODE_RESET_REACH_MAXIMUM = 201050010,
	/**<[en]Activation code does not exist. [cn]激活码不存在 */
    USG_ACTIVE_CODE_NOT_EXIT = 201050012,
	/**<[en]Invalid activation code. [cn]激活码错误 */
    USG_ACTIVE_INVALID_ACTIVE_CODE = 201050015,
	/**<[en]Trial activation code cannot be deleted. [cn]试用激活码，不可删除 */
    USG_TRIAL_ACTIVE_CODE_CANNOT_BE_DELETED = 201050016,
	/**<[en]Activation failed. [cn]激活失败 */
    USG_ACTIVE_FAIL = 201050021,
	/**<[en]Terminal does not allow unbinding. [cn]终端不允许解绑 */
    USG_CAN_NOT_UNBOUND = 201050022,
	/**<[en]IdeaManager not enabled. [cn]未启用IdeaManager */
    USG_IDEA_MANAGER_NOT_ENABLED = 201050027,
	/**<[en]VMR resource unavailable. [cn]云会议资源不可用 */
    USG_VMR_RESOURCE_UNAVAILABLE = 201080000,
	/**<[en]The host password and the guest password cannot be the same. Please confirm the input parameters. [cn]主持人密码和来宾密码不能相同 请确认输入参数 */
    USG_VMR_PWD_SAME_AS_CHAIRMAN_PWD = 201080006,
	/**<[en]Same as meeting password. [cn]和会议密码相同 */
    USG_VMR_PWM_SAME_AS_MEETING_PWD = 201080017,
	/**<[en]No invite permission to get an invite code. [cn]没有邀请权限去获取邀请码 */
    USG_INVITATION_ENABLE_INVALID = 201510001,
	/**<[en]Invalid application. [cn]申请失效 */
    USG_CORP_APPLICANT_INVALID = 201510003,
	/**<[en]The device type does not exist. [cn]设备类型不存在 */
    USG_DEVICE_TYPE_NOT_EXIST = 205030005,
	/**<[en]User name or password error. [cn]用户名或密码错误 */
    USG_ERR_PASSWORD = 206010000,
	/**<[en]Account is not activated, no permission to log in. [cn]账号未激活,无权限登录 */
    USG_APPID_ACCOUNT_DISABLED = 206010007,
	/**<[en]User information does not exist or is not activated, no permission to log in. [cn]用户信息不存在或者未激活，无权登录 */
    USG_USER_INFORMATION_DISABLED = 206010008,
	/**<[en]Failed to get verification code, Please contact SRE. [cn]获取验证码失败 请联系SRE */
    USG_SEND_SLIDER_FAILED = 206010010,
	/**<[en]Verification code must be filled. [cn]验证码不能为空 */
    USG_NEED_VERIFY_CODE = 206010011,
	/**<[en]Verification code check failed. [cn]验证码校验失败 */
    USG_CHECK_SLIDER_FAILED = 206010012,
	/**<[en]Jump login failed. Please contact SRE. [cn]跳转登录失败 请联系SRE */
    USG_JUMP_LOGIN_FAIL = 206010013,
	/**<[en]Domain not exist. [cn]企业域名不存在 */
    USG_DOMIAN_NOT_EXIS = 206010014,
	/**<[en]SSO login failed. Please contact SRE. [cn]SSO登录失败 请联系SRE */
    USG_SSO_AUTH_FAILED = 206010022,
	/**<[en]SSO login is not supported. [cn]不支持sso登录 */
    USG_AUTH_NOT_SUPPORT_SSO = 206010023,
	/**<[en]Invalid authentication type. [cn]认证类型非法 */
    USG_INVALID_AUTH_TYPE = 206010024,
	/**<[en]APPID verification failed. [cn]APPID校验失败 */
    USG_APPID_AUTH_FAILED = 206010025,
	/**<[en]Authentication type error. [cn]校验类型错误 */
    USG_AUTH_TYPE_ERR = 206010027,
	/**<[en]Network error. [cn]网络异常 */
    USG_NETWORK_ERROR = 206010029,
	/**<[en]APPID does not allow automatic registration. [cn]APPID不允许自动注册 */
    USG_APPID_NOT_ALLOW_AUTO_REG = 206010030,
	/**<[en]APPID auto registration failed. [cn]APPID自动注册失败 */
    USG_APPID_AUTO_REG_FAILED = 206010031,
	/**<[en]Normal users cannot log in. [cn]普通用户无法登录 */
    USG_NORMAL_USER_CANNOT_LOGIN = 206010036,
	/**<[en]Huawei account authentication failed. [cn]华为账户认证失败 */
    USG_HWACCOUNT_AUTH_FAILED = 206010042,
	/**<[en]APPID authentication expires. [cn]APPID认证过期 */
    USG_APPID_AUTH_EXPIRE = 206010057,
	/**<[en]APPID account is not bound. [cn]APPID账户未绑定 */
    USG_APPID_ACCOUNT_NOT_BIND = 206010058,
	/**<[en]Site mismatch. [cn]站点不匹配 */
    USG_SITE_MISMATCHED = 206010064,
	/**<[en]Phone number conflict. [cn]电话冲突 */
    USG_CONFLICT_PHONE = 206010065,
	/**<[en]E-mail conflict. [cn]邮箱冲突 */
    USG_CONFLICT_EMAIL = 206010066,
	/**<[en]The number of users has reached the maximum. [cn]用户数超过上限 */
    USG_USER_NUM_EXCEED = 206010070,
	/**<[en]WeChat authentication failed. [cn]微信鉴权失败 */
    AUTH_WECHAT_LOGIN_FAILED = 206010071,
	/**<[en]International sites support site changing re-login. [cn]国际站点支持切站点重登 */
    USG_CHANGE_SITE_AND_NEXT_REQUEST = 206010074,
	/**<[en]Account has been unbound. [cn]账号已经解绑 */
    USG_ACCOUNT_IS_UNBOUND = 206010075,
	/**<[en]no fixed link found [cn]设备和大屏没有建立固定链路 */
    USG_OFFLINE_PAIR_AUTH_FIXED_LINK_UNFOUND = 206010079,
	/**<[en]jwt invalid [cn]jwt Token 失效 */
    USG_OFFLINE_PAIR_AUTH_JWT_INVALID = 206010080,
	/**<[en]Need agreed sign privacy [cn]需要同意签署隐私协议，返回的信息data中携带第三方用户缓存信息key */
    USG_NEED_AGREED_SIGN_PRIVACY = 206010090,
	/**<[en]Third user info has invalid [cn]第三方用户缓存信息失效 */
    USG_THIRD_USER_INFO_HAS_INVALID = 206010091,
	/**<[en]Invalid authentication information. Please check the value of the request header field X-Auth-Token or X-Access-Token. [cn]鉴权信息无效 请检查请求头域X-Auth-Token或X-Access-Token的值 */
    USG_INVALID_TOKEN = 206020000,
	/**<[en]Token is created by disaster recovery site. [cn]token是容灾站点创建 */
    USG_TOKEN_IS_CRATER_BY_OTHERSITE = 206020001,
	/**<[en]Token is invalid due to being kicked. [cn]token由于被踢失效 */
    USG_TOKEN_IS_INVAILD_BY_KICKOFF = 206020002,
	/**<[en]The user does not exist. [cn]系统中不存在该用户 */
    USG_USER_NOT_EXIST = 206030000,
	/**<[en]The verification code is incorrect or has expired. Please obtain a new one. [cn]验证码错误或失效，请重新获取 */
    USG_FIND_VERCODE_FAIL = 206030001,
	/**<[en]Incorrect verification code. [cn]验证码错误 */
    USG_VERCODE_ERR = 206030002,
	/**<[en]Failed to send the verification code. [cn]发送验证码失败 */
    USG_NOT_PHONE_AND_EMAIL = 206030003,
	/**<[en]Try to get a new verification code 180s later. [cn]请在180秒后重新发送验证码 */
    USG_RESEND_NOT_ALLOW = 206030004,
	/**<[en]The password cannot be changed. [cn]系统不支持修改密码 */
    USG_NOT_SUPPORT_MODIFY_PWD = 206030005,
	/**<[en]The old password is incorrect. [cn]旧密码错误 */
    USG_OLD_PWD_WRONG = 206030006,
	/**<[en]The length of the new password does not meet the requirements. [cn]新密码长度不符合要求 */
    USG_INVALID_NEW_PWD_LEN = 206030007,
	/**<[en]The password complexity does not meet the requirements. [cn]密码复杂度不满足要求 */
    USG_INVALID_PWD_LEVEL = 206030008,
	/**<[en]The new password must be different from the previous old passwords. [cn]设置的密码不能与最近旧密码相同 */
    USG_CANNOT_SAME_WITH_HISTROY_PWD = 206030009,
	/**<[en]The password cannot contain three or more of the same characters consecutively. [cn]密码不能包含3个以上重复字符 */
    USG_REPEAT_CHAR_NUM_TOO_MUCH = 206030010,
	/**<[en]The password cannot be changed within 5 minutes upon the last password change. [cn]修改密码后，5分钟内不能更新密码 */
    USG_PWD_TOO_FREQUENTLY = 206030011,
	/**<[en]The password cannot contain the account or the reverse order of the account. [cn]密码不能与账号或其逆序账号相同 */
    USG_CANNOT_CONTAIN_ACCOUNT = 206030012,
	/**<[en]At least two characters must be different between the new and old passwords. [cn]新密码相较于旧密码至少要有两个不同的字符 */
    USG_MANY_SAME_WITH_OLD_PWD = 206030013,
	/**<[en]Invalid password format. [cn]密码格式不正确 */
    USG_CONTAINS_INVAILD = 206030014,
	/**<[en]The user is locked and will be locked in 60s. [cn]用户已被锁定，请60秒后重试 */
    USG_USER_LOCKED = 206030015,
	/**<[en]Have no right to reset other's password. [cn]没有权限重置密码 */
    USG_NO_RIGHT_TO_RESET_PWD = 206030016,
	/**<[en]The number of password retrieval times in a day has reached the maximum(10 times). [cn]一天内忘记密码次数达到最大值（10次） */
    USG_FROGET_PWD_OVER_10_TIMES = 206030018,
	/**<[en]The number of incorrect verification code input has reached the maximum, Please get it again. [cn]验证码输入错误次数超过最大值，请重新获取 */
    USG_USG_VERIFY_CODE_CHECK_EXCCED_MAX = 206030019,
	/**<[en]Failed to send the password reset message. Please contact SRE. [cn]发送重置密码失败, 请联系SRE */
    USG_SEND_RESET_PASSWORD_FAILED = 206030022,
	/**<[en]Failed to send verification code. Please contact SRE. [cn]发送验证码失败 请联系SRE */
    USG_SEND_VERIFY_CODE_FAILED = 206030023,
	/**<[en]The system has enabled SSO login and does not support changing the password. Please retry after the system has disabled SSO login. [cn]系统已开启SSO登录,不支持修改密码 系统关闭SSO登录后重试 */
    USG_AUTO_USER_NOT_ALLOW_MOD_PWD = 206030028,
	/**<[en]Forgot password for Huawei account. [cn]华为账号忘记密码 */
    USG_HUAWEI_MODIFY_PWD = 206030031,
	/**<[en]No corresponding terminal type. [cn]无对应的终端类型 */
    USG_NO_CORRESPOND_TERMIAL_TYPE = 206040000,
	/**<[en]Sending verification code is locked. [cn]发送校验码锁定 */
    USG_SEND_VERIFY_CODE_IS_LOCKED = 206060008,
	/**<[en]Slider verification required. [cn]需要滑块校验 */
    USG_NEED_SLIDER_VERIFY = 206060009,
	/**<[en]Invalid slider token. [cn]滑块token非法 */
    USG_SLIDER_TOKEN_INVAILD = 206060010,
	/**<[en]Request parameter arror. [cn]请求参数错误 */
    USG_REQUEST_PARAM_ERROR = 206060011,
	/**<[en]Sending SMS is not supported. [cn]不支持发送短信 */
    USG_NOT_SUPPORT_SEND_SMS = 206060012,
	/**<[en]Repeated sending is not supported. [cn]不支持重复发送 */
    USG_NOT_ALLOW_REPEAT_SEND = 206060013,
	/**<[en]Invalid verification code. [cn]验证码非法 */
    USG_LOGINVERIFY_CODE_INVAILD = 206060014,
	/**<[en]Max verification codes check times reached. [cn]验证码次数超过最大次数 */
    USG_LOGINVERIFY_CODE_EXCCED_MAX = 206060015,
	/**<[en]Failed to bind Huawei account. [cn]华为账户绑定失败 */
    USG_HWACCOUNT_BIND_FAILED = 206060017,
	/**<[en]The SMS message sending function is not enabled. [cn]没有开通短信发送功能 */
    USG_NO_SMS_MSG_SEND_FUNCTION = 208040003,
	/**<[en]message flow control. [cn]消息流控 */
    USG_MESSAGE_FLOW_CONTROL = 208030008,
	/**<[en]The number of messages on the current day reaches the upper limit. [cn]当天消息数量达到上限 */
    USG_REACHES_UPPER_LIMIT_OF_DAY = 208030009,
	/**<[en]The recipient's email address is invalid. [cn]收件人邮箱不合法 */
    USG_EMAIL_ADDRESS_INVALID = 208030012,
	/**<[en]verify activation credential failed. [cn]二维码已过期 */
    USG_VERIFY_ACTIVATION_CREDENTIAL_FAILED = 211000062,
	/**<[en]not allow activate device. [cn]企业开启第三方2C自运营模式后禁止扫码激活设备 */
    USG_NOT_ALLOW_ACTIVATE_DEVICE = 211000092,
	/**<[en]Not the ideahub activation code. [cn]不是ideahub激活码 */
    USG_ACTIVE_NOT_IDEAHUB_CODE = 211030046,
	/**<[en]auth fail too many times, locked. [cn]身份验证失败次数太多,已锁定 */
    USG_AUTH_FAIL_TOO_MANY_TIMES_LOCKED = 211030050,
	/**<[en]auth fail too many times, permanently locked. [cn]身份验证失败次数太多,已永久锁定 */
    USG_AUTH_FAIL_TOO_MANY_TIMES_PERMANENTLY_LOCKED = 211030052,
	/**<[en]The maximum times of log uploads has been reached. [cn]日志上传次数达到最大限制 */
    USG_LOG_UPLOAD_TIMES_EXCEED = 211060003,
	/**<[en]not allow cross copr pair. [cn]不允许跨企业配对 */
    USG_NOT_ALLOW_PAIR_CROSS_CORP = 222020001,
	/**<[en]The device has been bound. [cn]其他设备已绑定该大屏 */
    USG_OFFLINE_PAIR_HAS_BEEN_BOUND = 222020002,
	/**<[en] pair failed double check [cn]二次验证码失效 */
    USG_OFFLINE_PAIR_DOUBLE_CHECK_FAILED = 222020003,
	/**<[en]pair code invalid. [cn]配对码失效 */
    USG_OFFLINE_PAIR_CODE_INVALID = 222020004,
	/**<[en]offine pair already exist. [cn]已有离线临时链路 */
    USG_OFFLINE_PAIR_ALREADY_EXIST = 222020005,
	/**<[en]offine fixed pair already exist . [cn]已有离线固定链路 */
    USG_OFFLINE__FIXED_PAIR_ALREADY_EXIST = 222020006,
	/**<[en]projection code illegal . [cn]投屏码非法 */
    USG_PROJECTION_CODE_ILLEGAL = 222020010,
	/**<[en]ip has been locked. [cn]ip锁定 */
    USG_PROJECTION_IP_BEEN_LOCKED = 222020011,
	/**<[en]Cross corp . [cn]投屏码非用户所在企业的设备生成 */
    USG_PROJECTION_CROSS_CORP = 222020012,
	/**<[en]double check reach max time. [cn]二次验证码输入错误次数达到上限 */
    USG_PROJECTION_DOUBLE_CHECK_REACH_MAX_TIME = 222020013,
	/**<[en]obs upload image not exist. [cn]obs上传的图片对象不存在 */
    USG_OBS_UPLOAD_IMAGE_NOT_EXIST = 225020001,
	/**<[en]obs upload image is repetition. [cn]obs上传的图片唯一标识符重复, 同一图片重复发起审核任务 */
    USG_OBS_UPLOAD_IMAGE_IS_REPETITION = 225030002,
	/**<[en]not support. [cn]不支持当前业务 */
    USG_SLIDER_NOT_SUPPORT = 230010001,
	/**<[en]verify code and business mismatch. [cn]验证码和业务不匹配 */
    USG_SLIDER_VERIFY_CODE_AND_BUSINESS_MISMATCH = 230010002,
	/**<[en]need user not exist. [cn]用户不存在 */
    USG_SLIDER_USER_NOT_EXIST = 230010003,
	/**<[en]try again later. [cn]请稍后尝试 */
    USG_SLIDER_TRY_AGAIN_LATER = 230010004,
	/**<[en]verify code is invalid. [cn]验证码失效 */
    USG_SLIDER_VERIFY_CODE_INVALID = 230010005,
	/**<[en]verify code error. [cn]验证码错误 */
    USG_SLIDER_VERIFY_CODE_ERROR = 230010006,
	/**<[en]get new verify code. [cn]验证码输入错误次数超过最大值，请重新获取 */
    USG_SLIDER_GET_NEW_VERIFY_CODE = 230010007,
	/**<[en]Common failure. [cn]失败 */
    SDK_COMMON_FAIL = 411000001,
	/**<[en]Parameter error. [cn]参数错误 */
    SDK_PARAM_ERROR = 411000002,
	/**<[en]Meeting does not exist. [cn]会议不存在 */
    SDK_CONF_NOT_EXIST = 411000003,
	/**<[en]A meeting already exists. [cn]已经有会议存在 */
    SDK_CONF_EXIST = 411000004,
	/**<[en]Meeting state error. [cn]会议状态异常 */
    SDK_CONF_STATE_ERROR = 411000005,
	/**<[en]Failed to get device. [cn]获取设备异常 */
    SDK_CALL_GET_DEVICE_FAILED = 411000006,
	/**<[en]Failed to set device. [cn]设置设备异常 */
    SDK_CALL_SET_DEVICE_FAILED = 411000007,
	/**<[en]No device available. [cn]无可用设备 */
    SDK_NO_DEVICE_CAN_USED = 411000008,
	/**<[en]This operation is only supported on mobile. [cn]只有移动端支持该操作 */
    SDK_ONLY_MOBILE_SUPPORT = 411000009,
	/**<[en]Network access error. [cn]网络接入错误 */
    SDK_ACCESS_ERROR = 411000010,
	/**<[en]Other supplementary service is running. [cn]正在进行其他补充业务 */
    SDK_SERVICE_DOING = 411000011,
	/**<[en]Memory allocation error. [cn]分配内存错误 */
    SDK_ERR_MEM_ERROR = 411000012,
	/**<[en]Initialization failed. [cn]初始化失败 */
    SDK_ERR_INITIALIZE_FAILED = 411000013,
	/**<[en]User does not exist. [cn]用户不存在 */
    SDK_USER_DOES_NOT_EXIST = 411000014,
	/**<[en]Did not join the data meeting. [cn]未加入数据会议 */
    SDK_DATACONF_NOT_JOIN = 411000015,
	/**<[en]Neither meeting nor call exists. [cn]会议和呼叫均不存在 */
    SDK_CALL_AND_CONF_NOT_EXIST = 411000016,
	/**<[en]SVN port detection failed. [cn]svn端口探测不通 */
    SDK_SVN_DETECT_FAILED = 411000017,
	/**<[en]Failed to write file. [cn]写文件失败 */
    SDK_ERR_WRITE_FILE_FAILED = 411000018,
	/**<[en]RTC does not support STG mode. [cn]RTC不支持STG模式 */
    SDK_ERR_RTC_NOT_SUPPORT_STG = 411000019,
	/**<[en]Failed to load RTC library. RTC meeting is not supported. [cn]rtc库加载失败，不支持rtc会议 */
    SDK_ERR_RTC_LIB_LOAD_FAILED = 411000020,
	/**<[en]The meeting is in the audience pause state when changing roles. [cn]转角色的时候会议正处于观众暂停观看状态 */
    SDK_ERR_SWITCH_ROLE_CONF_PAUSE = 411000021,
	/**<[en]Not in call. [cn]不在呼叫中 */
    SDK_CONF_NOT_IN_CALL = 411000022,
	/**<[en]Meeting or call does not exist. [cn]会议或者呼叫不存在 */
    SDK_CONF_OR_CALL_NOT_EXIST = 411000023,
	/**<[en]Pairing state not allowed. [cn]配对状态不允许 */
    SDK_CONF_PAIR_STATE_NOT_ALLOW = 411000024,
	/**<[en]Pairing request failed. [cn]配对请求失败 */
    SDK_CONF_PAIR_QUERY_FAIL = 411000025,
	/**<[en]Pairing exceeds limit. [cn]配对超出限制 */
    SDK_CONF_PAIR_OVER_LIMIT = 411000026,
	/**<[en]Pairing common error. [cn]配对通用错误 */
    SDK_CONF_PAIR_ERROR_COMMON = 411000027,
	/**<[en]Pairing and joining the meeting failed. [cn]配对入会失败 */
    SDK_CONF_PAIR_ENTER_FAILED = 411000028,
	/**<[en]Pairing and joining the meeting is busy. [cn]配对入会忙 */
    SDK_CONF_PAIR_ENTER_BUSY = 411000029,
	/**<[en]Pairing and joining the meeting is invalid. [cn]配对入会无效 */
    SDK_CONF_PAIR_ENTER_INVALID = 411000030,
	/**<[en]Multiple clicks at the same time to pair and join the meeting error. [cn]同时多次点击入会错误 */
    SDK_CONF_PAIR_ENTER_MULTI = 411000031,
	/**<[en]Pairing is not established or is being established. [cn]配对未建立或正在建立中 */
    SDK_CONF_PAIR_UNESTABLISHED_OR_PRIRING = 411000032,
	/**<[en]The camera is not turned on in the third-party capture mode. [cn]第三方采集模式下摄像头未打开 */
    SDK_CONF_EXTERN_INPUT_CAMERA_NOT_OPEN = 411000033,
	/**<[en]RTC engine creation failed. [cn]RTC 引擎创建失败 */
    SDK_CONF_CREAT_RTC_ENGINE_FAILED = 411000034,
	/**<[en]Not in a meeting. [cn]不在会议中 */
    SDK_CONF_NOT_IN_CONF = 411000035,
	/**<[en]mute self failed. [cn] 静音自己失败并且采用了保护 */
    SDK_CONF_MUTE_SELF_FAILED = 411000036,
	/**<[en]still in setting language channel [cn] 当前正处于切换频道中, 请稍后重试 */
    SDK_CONF_IN_SETTING_LANGUAGE_CHANNEL = 411000037,
	/**<[en]join interpreter room failed [cn]加入语言频道房间失败, 已帮您切回原声频道 */
    SDK_CONF_JOIN_INTERPRETER_ROOM_FAILED = 411000038,
	/**<[en]End the meeting with no stream due to disconnection of network. [cn]无码流结束会议网络断开 */
    SDK_NO_STREAM_END_CONF_NET_BREAK = 411000100,
	/**<[en]End the meeting with no stream because fail to re-join meeting. [cn]无码流结束会议重入会失败 */
    SDK_NO_STREAM_END_CONF_REJOIN_FAIL = 411000101,
	/**<[en]Null pointer exception. [cn]空指针异常 */
    SDK_CHECK_PARAM_NULL_POINTER = 411000102,
	/**<[en]Parameters cannot be empty. [cn]参数不许为空 */
    SDK_CHECK_PARAM_NOT_ALLOW_NULL = 411000103,
	/**<[en]Indicates encrypt and decrtpt func not match. [cn]加解密算法不匹配 */
    SDK_ENCRYPT_DECRTPT_FUNC_NOT_MACTCH = 411000104,
	/**<[en]Indicates Loading User-Defined DLLs failed . [cn]加载用户自定义dll失败 */
    SDK_LOAD_USER_DEFINED_DLL_FAILED = 411000105,
	/**<[en]Indicates Applition not support shimo docs . [cn]企业配置不支持打开石墨文档 */
    SDK_APPLICATION_NOT_SUPPORT_SHIMO_DOCS = 411000106,
	/**<[en]Indicates notification of render fail . [cn]数据会议UI渲染失败 */
    SDK_DATACONF_SCREEN_RENDER_FAIL = 411000107,
	/**<[en]End the meeting with mmr media rejoin failed. [cn]mmr重入会失败 */
    SDK_CONF_END_MMR_REJOIN_FAIL = 411000108,
	/**<[en]Audio is disconnected. [cn]音频断开中 */
    SDK_AUDIO_DISCONNECTED = 411000109,
	/**<[en]Second monitor disconnected. [cn]共享副屏的时候，副屏被断开 */
    SDK_DATACONF_SECOND_MONITOR_DISCONNECT = 411000110,
	/**<[en]prepare data share canceled. [cn]共享前准备被取消. */
    SDK_DATACONF_PREPARE_DATA_SHARE_CANCELED = 411000111,
	/**<[en]already in remote control. [cn]已在远程控制他人. */
    SDK_DATACONF_ALREADY_IN_CONTROL = 411000112,
	/**<[en]already be controlled. [cn]已被远程控制. */
    SDK_DATACONF_ALREADY_BE_CONTROLLED = 411000113,
	/**<[en]Leaving a conference during joining. [cn]入会过程中调用离会接口中断会议. */
    SDK_CONF_JOINING_CONF_LEAVE_CONF = 411000114,
	/**<[en]leave conf for subscribe failed. [cn]订阅失败需要离会 */
    SDK_SUBSCRIBE_FAILED = 411000115,
	/**<[en]Indicates switch template failed. [cn]入会过程中切模板失败 */
    SDK_CONF_SWITCH_TEMPLATE_FAILED = 411000116,
	/**<[en]The message processing thread is not initialized. [cn]消息处理线程未初始化 */
    SDK_LOGIN_MSG_THREAD_UNINIT = 412100001,
	/**<[en]Parameter error. [cn]参数错误 */
    SDK_LOGIN_PARAM_ERROR = 412100002,
	/**<[en]Timeout. [cn]超时 */
    SDK_LOGIN_TIMEOUT = 412100003,
	/**<[en]Memory allocation error. [cn]分配内存错误 */
    SDK_LOGIN_MEM_ERROR = 412100004,
	/**<[en]XML parsing error. [cn]XML解析出错 */
    SDK_LOGIN_XML_ERROR = 412100005,
	/**<[en]DNS resolution error. [cn]DNS解析异常 */
    SDK_LOGIN_DNS_ERROR = 412100006,
	/**<[en]Request message failed. [cn]请求消息异常 */
    SDK_LOGIN_REQUEST_FAILED = 412100007,
	/**<[en]Authentication failed. [cn]鉴权失败 */
    SDK_LOGIN_AUTH_FAILED = 412100008,
	/**<[en]Server error. [cn]服务器异常 */
    SDK_LOGIN_SERVICE_ERROR = 412100009,
	/**<[en]Account is locked. [cn]账号被锁定 */
    SDK_LOGIN_ACCOUNT_LOCKED = 412100010,
	/**<[en]Create timer error. [cn]创建定时器错误 */
    SDK_LOGIN_TIMER_ERROR = 412100011,
	/**<[en]Server CA certificate verification failed. [cn]服务器CA证书校验失败 */
    SDK_LOGIN_CA_VERIFY_FAILED = 412100012,
	/**<[en]Network error. [cn]网络异常 */
    SDK_LOGIN_NETWORK_ERROR = 412100013,
	/**<[en]Server redirect. [cn]服务器返回重定向地址 */
    SDK_LOGIN_SERVER_REDIRECT = 412100014,
	/**<[en]Account is not activated. [cn]账号未激活 */
    SDK_LOGIN_AUTH_ACCOUNT_DIACTIVE = 412100015,
	/**<[en]JSON parsing error. [cn]JSON解析失败 */
    SDK_LOGIN_JSON_ERROR = 412100016,
	/**<[en]The proxy communication times out and the TCP link building fails. Probably because the proxy configuration is incorrect. [cn]代理通信超时，tcp建链失败，大概率是代理配置错误 */
    SDK_LOGIN_CURLE_EXTERN_CONNECT_TIMEOUT = 412100017,
	/**<[en]Disconnected by the proxy. Probably because the server address is misconfigured. [cn]接被代理断开，大概率是服务器地址配置错误 */
    SDK_LOGIN_CURLE_EXTERN_CLOSED_BY_PROXY = 412100018,
	/**<[en]The TCP link establishment timed out. Probably because the proxy domain name or port configuration is incorrect. [cn]tcp建链超时，大概率是proxy域名或者端口配置错误 */
    SDK_LOGIN_CURLE_EXTERN_PROXY_ADDR_OR_PORT_ERROR = 412100019,
	/**<[en]The authentication process failed. The user does not have proxy permission and needs to apply for proxy permission. [cn]认证鉴权过程失败，用户没有proxy权限，需要申请proxy权限 */
    SDK_LOGIN_CURLE_EXTERN_PROXY_PERMISSION_DENIED = 412100020,
	/**<[en]The authentication process failed. The proxy user name or password is incorrect. [cn]认证鉴权过程失败，代理用户名或者密码错误 */
    SDK_LOGIN_CURLE_EXTERN_USER_OR_PWD_ERROR = 412100021,
	/**<[en]The authentication process failed. Incorrect authentication type. User name and password are required. The user needs to be prompted for input. [cn]认证鉴权过程失败，错误的认证类型，同时需要用户名、密码，需要提示用户输入 */
    SDK_LOGIN_CURLE_EXTERN_AUTH_TYPE_ERROR = 412100022,
	/**<[en]The authentication process failed. Other unknown errors. It may be that the authentication method is not supported. The user needs to be prompted to try again. [cn]认证鉴权过程失败，其他未知错误，有可能是不支持认证方式，建议弹框提示用户重新发起 */
    SDK_LOGIN_CURLE_EXTERN_AUTH_ERROR = 412100023,
	/**<[en]The authentication process failed. Unable to resolve gateway. [cn]认证鉴权过程失败，无法解析网关 */
    SDK_LOGIN_CURLE_COULDNT_RESOLVE_PROXY = 412100024,
	/**<[en]The authentication process failed. Unable to resolve host. [cn]认证鉴权过程失败，无法解析主机 */
    SDK_LOGIN_CURLE_COULDNT_RESOLVE_HOST = 412100025,
	/**<[en]The authentication process failed. Unable to connect. [cn]认证鉴权过程失败，无法连接 */
    SDK_LOGIN_CURLE_COULDNT_CONNECT = 412100026,
	/**<[en]The authentication process failed. Operation times out. [cn]认证鉴权过程失败，操作超时 */
    SDK_LOGIN_CURLE_OPERATION_TIMEDOUT = 412100027,
	/**<[en]Message length too long. [cn]消息长度太大 */
    SDK_LOGIN_MSG_TOOLARGE = 412100028,
	/**<[en]Base64 encryption failed. [cn]base64加密失败 */
    SDK_LOGIN_BASE64_ENCODE_ERROR = 412100029,
	/**<[en]XML parsing error. [cn]XML解析出错 */
    SDK_LOGIN_XML_PARSE_ERROR = 412100030,
	/**<[en]Secure function error. [cn]安全函数失败 */
    SDK_LOGIN_SECURE_LIB_ERROR = 412100031,
	/**<[en]Firewall detection parameter error. [cn]防火墙检测参数错误 */
    SDK_LOGIN_FIREWALL_DETECT_PARAM_ERROR = 412100032,
	/**<[en]Failed to create STG tunnel. [cn]创建STG隧道失败 */
    SDK_LOGIN_BUILD_STG_TUNNEL_FAIL = 412100033,
	/**<[en]Failed to update STG service. [cn]更新STG服务失败 */
    SDK_LOGIN_UPDATE_STG_SERVER_ERROR = 412100034,
	/**<[en]Encryption failed. [cn]加密失败 */
    SDK_LOGIN_TUP_CPYPT_ENCRYPT_ERROR = 412100035,
	/**<[en]Do not allow duplicate downloads. [cn]不允许重复下载 */
    SDK_LOGIN_IN_DOWNLOADING_CANNOT_DOWNLOAD_AGAIN = 412100036,
	/**<[en]File operation failed. [cn]文件操作失败 */
    SDK_LOGIN_FILE_OPEART_FAIL = 412100037,
	/**<[en]The request message returns empty. [cn]请求消息返回空 */
    SDK_LOGIN_RSP_BODY_NULL = 412100038,
	/**<[en]The number of detection servers is 0 error. [cn]探测服务器数为0错误 */
    SDK_LOGIN_PROBE_SERVER_NUMBER_ZERO_ERR = 412100039,
	/**<[en]Failed to get local IP address. [cn]获取本地IP失败 */
    SDK_LOGIN_GET_BEST_LOCAL_IP_FAIL = 412100040,
	/**<[en]XXX. [cn]登录模块消息未初始化 */
    SDK_LOGIN_E_ERR_LOGIN_NO_INIT = 412100041,
	/**<[en]http return 429 error. [cn]http 返回429错误 */
    SDK_LOGIN_E_ERR_HTTP_BUSY = 412100042,
	/**<[en]Not logged in, not available [cn]此业务未登录不可用 */
    SDK_LOGIN_E_ERR_NOT_LOGINED = 412100043,
	/**<[en]manger server degrade，you can still join conf in this case. [cn]服务器降级，接入方收到该错误码可以继续调用入会接口离线入会 */
    SDK_LOGIN_E_ERR_MNG_FAILED = 412100044,
	/**<[en]XXX [cn]升级版本过程中取消下载 */
    SDK_LOGIN_E_ERR_CANCEL_DOWNLOAD = 412100045,
	/**<[en]CURL operation parameter error. [cn]CURL请求参数异常 */
    SDK_LOGIN_E_ERR_CURLE_BAD_FUNCTION_ARGUMENT = 412100046,
	/**<[en]JwtToken is out of date [cn]JwtToken过期，需要重新刷新token */
    SDK_LOGIN_E_ERR_JWTTOKEN_OUT_OF_DATE = 412100047,
	/**<[en]need switch to sink mode [cn]恢复下沉模式，需要从云上切到下沉 */
    SDK_LOGIN_E_ERR_SWITCH_SINK_MODE = 412100048,
	/**<[en]need switch to cloud mode [cn]恢复云上模式，需要从下沉切到云上 */
    SDK_LOGIN_E_ERR_SWITCH_CLOUD_MODE = 412100049,
	/**<[en]Internal error. [cn]内部错误 */
    SDK_LOGINLOGIC_GENERAL = 412200001,
	/**<[en]Parameter error. [cn]参数错误 */
    SDK_LOGINLOGIC_PARAM_ERROR = 412200002,
	/**<[en]Network timeout. [cn]网络超时 */
    SDK_LOGINLOGIC_REQUEST_TIMEOUT = 412200003,
	/**<[en]Network Error. [cn]网络错误 */
    SDK_LOGINLOGIC_NETWORK_ERROR = 412200004,
	/**<[en]Need to bind mobile phone. [cn]需要绑定手机 */
    SDK_LOGINLOGIC_NEED_MOBILEBIND = 412200005,
	/**<[en]Need to bind email. [cn]需要绑定邮箱 */
    SDK_LOGINLOGIC_NEED_MAILBIND = 412200006,
	/**<[en]Has initialized already. [cn]重复初始化 */
    SDK_LOGINLOGIC_HAS_INITED = 412200007,
	/**<[en]State machine execution failed. [cn]状态机执行失败 */
    SDK_LOGINLOGIC_STATE_MACHINE_RUN_FAILED = 412200008,
	/**<[en]Failed to start timer. [cn]开启定时器失败 */
    SDK_LOGINLOGIC_START_TIMER_ERROR = 412200009,
	/**<[en]The user is prompted to change the password when logging in for the first time. [cn]首次登录，提示用户修改密码 */
    SDK_LOGINLOGIC_NEED_MODIFY_PASSWORD = 412200010,
	/**<[en]Unknown authentication type. [cn]未知鉴权类型 */
    SDK_LOGINLOGIC_UNKOWN_AUTH_TYPE = 412200011,
	/**<[en]need repair controller [cn]需要重新配对 */
    SDK_LOGINLOGIC_NEED_REPAIR_CONTROLLER = 412200012,
	/**<[en]need repair controller [cn]验证后重新请求 */
    SDK_LOGINLOGIC_NEED_REPAIR_WITH_CREDENTIAL = 412200013,
	/**<[en]need repair controller [cn]换取凭证失败失败需要重新配对 */
    SDK_LOGINLOGIC_NEED_REPAIR_FAILED = 412200014,
	/**<[en]not support media separate [cn]环境不支持媒体分离 */
    SDK_LOGINLOGIC_NOT_SUPPORT_MEDIA_SEPARATE = 412200015,
	/**<[en]media separate plugin disconnect [cn]媒体分离插件未连接 */
    SDK_LOGINLOGIC_MEDIA_SEPARATE_PLUGIN_DISCONNECT = 412200016,
	/**<[en]request media separate log timeout [cn]收集媒体分离日志超时 */
    SDK_LOGINLOGIC_REQUEST_MEDIA_SEPARATE_LOG_TIMEOUT = 412200017,
	/**<[en]request media separate log failed [cn]收集媒体分离日志失败 */
    SDK_LOGINLOGIC_REQUEST_MEDIA_SEPARATE_LOG_FAILED = 412200018,
	/**<[en]request media separate log is already start [cn]收集媒体分离日志已经开始 */
    SDK_LOGINLOGIC_REQUEST_MEDIA_SEPARATE_LOG_ALREADY_START = 412200019,
	/**<[en]tc module version is not support request media separate log [cn]tc插件版本不支持收集媒体分离日志 */
    SDK_LOGINLOGIC_REQUEST_MEDIA_SEPARATE_LOG_NOT_SUPPORT = 412200020,
	/**<[en]Memory allocation error. [cn]分配内存错误 */
    SDK_CALL_MEM_ERROR = 413000003,
	/**<[en]System error. [cn]系统错误 */
    SDK_CALL_SYSTEM_ERROR = 413000004,
	/**<[en]Local meeting is not created. [cn]本地会议未创建 */
    SDK_CALL_LOCAL_CONFER_NOEXIT_ERROR = 413000034,
	/**<[en]No video device to operate. [cn]没有视频设备可以操作 */
    SDK_CALL_NO_VIDEO_DEVICE_TO_OPERATE = 413000073,
	/**<[en]not mcu call and conf. [cn] 不支持MCU呼叫和会议能力 */
    SDK_CALL_NOT_SUPPORT_MCU_CALL_AND_CONF = 413000106,
	/**<[en]Common error. [cn]一般错误 */
    SDK_CONFCTRL_GENERAL = 414100001,
	/**<[en]Parameter error. [cn]参数错误 */
    SDK_CONFCTRL_PARAM_ERROR = 414100002,
	/**<[en]Timeout. [cn]超时 */
    SDK_CONFCTRL_TIMEOUT = 414100003,
	/**<[en]Memory allocation error. [cn]分配内存错误 */
    SDK_CONFCTRL_MEM_ERROR = 414100004,
	/**<[en]DNS resolution error. [cn]DNS解析异常 */
    SDK_CONFCTRL_DNS_ERROR = 414100005,
	/**<[en]Request message failed. [cn]请求消息异常 */
    SDK_CONFCTRL_REQUEST_FAILED = 414100006,
	/**<[en]Authentication failed. [cn]鉴权失败 */
    SDK_CONFCTRL_AUTH_FAILED = 414100007,
	/**<[en]Server error. [cn]服务器异常 */
    SDK_CONFCTRL_SERVICE_ERROR = 414100008,
	/**<[en]Create timer error. [cn]创建定时器错误 */
    SDK_CONFCTRL_TIMER_ERROR = 414100009,
	/**<[en]Start timer error. [cn]开启定时器错误 */
    SDK_CONFCTRL_START_TIMER_ERROR = 414100010,
	/**<[en]The meeting control block is full. Please release the control block that is not in use. [cn]会控控制块已满，请释放没在使用的控制块 */
    SDK_CONFCTRL_CONF_BLOCK_FULL = 414100011,
	/**<[en]The proxy communication times out and the TCP link building fails. Probably because the proxy configuration is incorrect. [cn]代理通信超时，tcp建链失败，大概率是代理配置错误 */
    SDK_CONFCTRL_CURLE_EXTERN_CONNECT_TIMEOUT = 414100012,
	/**<[en]Disconnected by the proxy. Probably because the server address is misconfigured. [cn]接被代理断开，大概率是服务器地址配置错误 */
    SDK_CONFCTRL_CURLE_EXTERN_CLOSED_BY_PROXY = 414100013,
	/**<[en]The TCP link establishment timed out. Probably because the proxy domain name or port configuration is incorrect. [cn]tcp建链超时，大概率是proxy域名或者端口配置错误 */
    SDK_CONFCTRL_CURLE_EXTERN_PROXY_ADDR_OR_PORT_ERROR = 414100014,
	/**<[en]The authentication process failed. The user does not have proxy permission and needs to apply for proxy permission. [cn]认证鉴权过程失败，用户没有proxy权限，需要申请proxy权限 */
    SDK_CONFCTRL_CURLE_EXTERN_PROXY_PERMISSION_DENIED = 414100015,
	/**<[en]The authentication process failed. The proxy user name or password is incorrect. [cn]认证鉴权过程失败，代理用户名或者密码错误 */
    SDK_CONFCTRL_CURLE_EXTERN_USER_OR_PWD_ERROR = 414100016,
	/**<[en]The authentication process failed. Incorrect authentication type. User name and password are required. The user needs to be prompted for input. [cn]认证鉴权过程失败，错误的认证类型，同时需要用户名、密码，需要提示用户输入 */
    SDK_CONFCTRL_CURLE_EXTERN_AUTH_TYPE_ERROR = 414100017,
	/**<[en]The authentication process failed. Other unknown errors. It may be that the authentication method is not supported. The user needs to be prompted to try again. [cn]认证鉴权过程失败，其他未知错误，有可能是不支持认证方式，建议弹框提示用户重新发起 */
    SDK_CONFCTRL_CURLE_EXTERN_AUTH_ERROR = 414100018,
	/**<[en]Curl proxy exception. [cn]curl代理异常 */
    SDK_CONFCTRL_CURLE_COULDNT_RESOLVE_PROXY = 414100019,
	/**<[en]Curl host exception. [cn]curl主机异常 */
    SDK_CONFCTRL_CURLE_COULDNT_RESOLVE_HOST = 414100020,
	/**<[en]Curl connection exception. [cn]curl连接异常 */
    SDK_CONFCTRL_CURLE_COULDNT_CONNECT = 414100021,
	/**<[en]Curl operation timed out. [cn]curl操作超时 */
    SDK_CONFCTRL_CURLE_OPERATION_TIMEDOUT = 414100022,
	/**<[en]Message length too long. [cn]会控消息内容过大 */
    SDK_CONFCTRL_MSG_TOO_LARGE = 414100023,
	/**<[en]Failed to create thread. [cn]创建线程失败 */
    SDK_CONFCTRL_PTHREAD_CREAT_ERROR = 414100024,
	/**<[en]Secure function error. [cn]安全函数返回错误 */
    SDK_CONFCTRL_SEC_FUNC_RETURN_ERROR = 414100025,
	/**<[en]JSON parsing failed. [cn]解析json体失败 */
    SDK_CONFCTRL_JSON_PARSE_FAILED = 414100026,
	/**<[en]WS token is empty. [cn]ws token值为空 */
    SDK_CONFCTRL_TOKEN_IS_NULL_ERROR = 414100027,
	/**<[en]Return JSON data error. [cn]返回json数据异常 */
    SDK_CONFCTRL_RETURN_JSON_ERROR = 414100028,
	/**<[en]Failed to create meeting control block. [cn]创建会议控制块失败 */
    SDK_CONFCTRL_CREAT_CONF_BASIC_ERROR = 414100029,
	/**<[en]Failed to get meeting control block. [cn]获取会议控制块失败 */
    SDK_CONFCTRL_GET_CONF_BASIC_BY_HANDLE_ERROR = 414100030,
	/**<[en]Failed to get meeting control block by CallId. [cn]通过CallId获取会议控制块失败 */
    SDK_CONFCTRL_GET_CONF_BASIC_BY_CALLID_ERROR = 414100031,
	/**<[en]Destroying the meeting control block failed. [cn]销毁会议控制块失败 */
    SDK_CONFCTRL_DESTORY_CONF_BASIC_ERROR = 414100032,
	/**<[en]Temporary creating meeting information not found. [cn]找不到创会临时信息 */
    SDK_CONFCTRL_CREAT_CONF_TMP_INFO_NOT_FOUND = 414100033,
	/**<[en]Failed to get participant ID. [cn]获取参会者ID失败 */
    SDK_CONFCTRL_GET_PARTICIPANT_ID_FAILED = 414100034,
	/**<[en]Failed to get MT by participant ID. [cn]通过ParticipantId获取MT失败 */
    SDK_CONFCTRL_GET_MT_BY_PARTICIPANT_ID_FAILED = 414100035,
	/**<[en]Failed to get self information by participant ID. [cn]通过ParticipantId获取selfinfo失败 */
    SDK_CONFCTRL_GET_SELFINFO_ERROR = 414100036,
	/**<[en]Failed to get participant information by MT. [cn]通过MT获取会议成员信息失败 */
    SDK_CONFCTRL_GET_PARTICIPANT_BY_MT_FAILED = 414100037,
	/**<[en]Manual invitation required. [cn]需要手动邀请 */
    SDK_CONFCTRL_NEED_MAUAL_INVITE_ERROR = 414100038,
	/**<[en]The major parameters of the meeting have been reported. [cn]已上报过会议大参数 */
    SDK_CONFCTRL_HAD_NOTIFY_CONFINFO_BEFORE = 414100039,
	/**<[en]Subtitles are not supported. [cn]不支持字幕 */
    SDK_CONFCTRL_NOT_SUPPORT_SUBTITLE = 414100040,
	/**<[en]Meeting Hang Up - Timeout. [cn]会议挂断 - 超时 */
    SDK_CONFCTRL_CONF_END_TIMEOUOT = 414100041,
	/**<[en]Meeting Hang Up - No Streaming. [cn]会议挂断 - 无码流 */
    SDK_CONFCTRL_CONF_END_NOSTREAM = 414100042,
	/**<[en]Meeting hung up - Hung up by the host. [cn]会议挂断 - 被主持人挂断 */
    SDK_CONFCTRL_CONF_END_CHAIR_HANGUP = 414100043,
	/**<[en]Meeting Hang Up - Meeting has ended. [cn]会议挂断 - 会议已结束 */
    SDK_CONFCTRL_CONF_END_STOP_CONF = 414100044,
	/**<[en]End of meeting due to leave meeting. [cn]离会导致的会议结束 */
    SDK_CONFCTRL_CONF_END_LEAVE_CONF = 414100045,
	/**<[en]Message queue processing function registration failed. [cn]消息队列处理函数注册失败 */
    SDK_CONFCTRL_MSG_PROC_FUN_REG_FAIL = 414100046,
	/**<[en]Message queue processing function deregistration failed. [cn]消息队列处理函数去注册失败 */
    SDK_CONFCTRL_MSG_PROC_FUN_UNREG_FAIL = 414100047,
	/**<[en]Meeting ended due to reject meeting. [cn]拒绝会议导致的会议结束 */
    SDK_CONFCTRL_CONF_END_REJECT_CONF = 414100048,
	/**<[en]Meeting ended by self. [cn]自己结束会议导致的会议结束 */
    SDK_CONFCTRL_CONF_END_SELF_END = 414100049,
	/**<[en]The meeting control module is not initialized. [cn]会控模块未初始化 */
    SDK_CONFCTRL_VIEWER_EXCEEDS_LIMIT = 414100050,
	/**<[en]The watching special site reaches the maximum. [cn]选看的特殊会场超过限制 */
    SDK_CONFCTRL_SPECIAL_WATCH_EXCEEDS_LIMIT = 414100051,
	/**<[en]The watching HD site reaches the maximum. [cn]选看的高清会场超过限制 */
    SDK_CONFCTRL_WATCH_HD_EXCEEDS_LIMIT = 414100052,
	/**<[en]The watching SD site reaches the maximum. [cn]选看的标清会场超过限制 */
    SDK_CONFCTRL_WATCH_SD_EXCEEDS_LIMIT = 414100053,
	/**<[en]The watching specification reaches the maximum. [cn]选看的规格超过限制 */
    SDK_CONFCTRL_WATCH_SPECIFICATIONS_EXCEEDS_LIMIT = 414100054,
	/**<[en]Watching internal errors. [cn]选看内部错误 */
    SDK_CONFCTRL_WATCH_INNER_ERROR = 414100055,
	/**<[en]Duplicated watch render. [cn]选看的句柄重复 */
    SDK_CONFCTRL_WATCH_RENDER_REPEATS = 414100056,
	/**<[en]HTTP request error. [cn]HTTP请求错误 */
    SDK_CONFCTRL_HTTP_RECV_FAILED = 414100057,
	/**<[en]Websocket request timeout. [cn]websocket请求超时 */
    SDK_CONFCTRL_TRACK_REQUEST_TIMEOUT = 414100058,
	/**<[en]Loading failed. [cn]加载错误 */
    SDK_CONFCTRL_TRACK_LOAD_FAILED = 414100059,
	/**<[en]The meeting ends due to the timeout of guest waiting before meeting or the timeout of the meeting control heartbeat. [cn]会前等待页面时间超时或者会控心跳超时导致的会议结束 */
    SDK_CONFCTRL_CONF_END_TIMEOUT_HANGUP = 414100061,
	/**<[en]The meeting ends due to being canceled. [cn]会议被取消预约导致的会议结束 */
    SDK_CONFCTRL_CONF_END_CONCLUDE = 414100062,
	/**<[en]The meeting ends due to network error when guest waiting before meeting. [cn]会前等待页面网络异常导致的会议结束 */
    SDK_CONFCTRL_CONF_END_NETWORK_FAILED = 414100063,
	/**<[en]http return 429 error. [cn]http 返回429错误 */
    SDK_CONFCTRL_E_ERR_HTTP_BUSY = 414100064,
	/**<[en]self is chairman. [cn]已是主持人 */
    SDK_CONFCTRL_E_ERR_SELF_IS_CHAIRMAN = 414100065,
	/**<[en]self is cohost. [cn]已是联席主持人 */
    SDK_CONFCTRL_E_ERR_SELF_IS_COHOST = 414100066,
	/**<[en]no cohost and chairman. [cn]无主持人和联席主持人 */
    SDK_CONFCTRL_E_ERR_NO_COHOST_AND_CHAIRMAN = 414100067,
	/**<[en]no supported cohost and chairman. [cn]无支持的主持人和联席主持人 */
    SDK_CONFCTRL_E_ERR_UNSUPPORT_COHOST_AND_CHAIRMAN = 414100068,
	/**<[en]Invalid user, enterprise or SP. [cn]用户，企业或SP失效 */
    SDK_CONFCTRL_E_ERR_END_EXPIRATION = 414100069,
	/**<[en]not support offline join. [cn]当前不支持离线入会 */
    SDK_CONFCTRL_E_ERR_NOT_SUPPORT_OFFLINE_JOIN = 414100070,
	/**<[en]start confctrl websocket failed. [cn]会控websocket建链失败 */
    SDK_CONFCTRL_E_ERR_START_CONFCTRL_WSS_FAILED = 414100071,
	/**<[en]offline join query user token failed. [cn]离线入会获取用户token失败 */
    SDK_CONFCTRL_E_ERR_OFFLINE_JOIN_QUERY_USER_TOKEN_FAILED = 414100072,
	/**<[en]offline join query conference information failed. [cn]离线入会获取会议信息失败 */
    SDK_CONFCTRL_E_ERR_OFFLINE_JOIN_QUERY_CONF_INFO_FAILED = 414100073,
	/**<[en]Chair end conf. [cn]主持人结束会议 */
    SDK_CONFCTRL_E_ERR_CHAIR_END_CONF = 414100074,
	/**<[en]Timeover end conf. [cn]会议到时间结束会议 */
    SDK_CONFCTRL_E_ERR_TIMEOVER_END_CONF = 414100075,
	/**<[en]callee refused. [cn] 被叫拒接 */
    SDK_CONFCTRL_E_ERR_CALLEE_REFUSED_END_CONF = 414100076,
	/**<[en]callee timeout. [cn] 被叫超时 */
    SDK_CONFCTRL_E_ERR_CALLEE_TIMEOUT_END_CONF = 414100077,
	/**<[en]force open camera conf hangup. [cn]强制视频会议挂断 */
    SDK_CONFCTRL_E_ERR_END_FORCE_OPEN_CAMERA_HANGUP = 414100078,
	/**<[en]signal proxy address is not matched with site url. [cn] 信令代理与站点地址不匹配 */
    SDK_CONFCTRL_E_ERR_NO_MATCHED_SIGNAL_PROXY_WITH_SITE_URL = 414100079,
	/**<[en]conf end for projection failed. [cn] 投屏失败导致会议结束 */
    SDK_CONFCTRL_E_ERR_END_PROJECTION_FAILED = 414100080,
	/**<[en]conf end for projection end. [cn] 投屏结束导致会议结束 */
    SDK_CONFCTRL_E_ERR_END_PROJECTION_END = 414100081,
	/**<[en]conf end for cancel.. [cn] 投屏协商中大屏取消 */
    SDK_CONFCTRL_E_ERR_END_PROJECTION_CANCEL = 414100082,
	/**<[en]Indicates end projection by sender with two members. [cn] 两方投屏会议投屏端结束投屏 */
    SDK_CONFCTRL_E_ERR_END_PROJECTION_BY_SENDER_WITH_TWO_MEMBERS = 414100083,
	/**<[en]Indicates end projection by receiver. [cn] 大屏端结束投屏 */
    SDK_CONFCTRL_E_ERR_END_PROJECTION_BY_RECEIVER = 414100084,
	/**<[en]projection by sender with multi members. [cn] 多方投屏会议投屏端结束投屏 */
    SDK_CONFCTRL_E_ERR_END_PROJECTION_BY_SENDER_WITH_MULTI_MEMBERS = 414100085,
	/**<[en]Opposite end hung up. [cn] 对端已挂断 */
    SDK_CONFCTRL_E_ERR_CONF_END_PEER_HANGS_UP = 414100086,
	/**<[en]CURL operation parameter error [cn]CURL请求参数异常 */
    SDK_CONFCTRL_E_ERR_CURLE_BAD_FUNCTION_ARGUMENT = 414100087,
	/**<[en]Indicates json value is null [cn] json字段为空 */
    SDK_CONFCTRL_E_ERR_JSON_VALUE_NULL = 414100088,
	/**<[en]Indicates json array is empty [cn] json数组大小为0 */
    SDK_CONFCTRL_E_ERR_JSON_ARRAY_EMPTY = 414100089,
	/**<[en]Indicates unsupport water mark hangs up. [cn] 不支持水印挂断 */
    SDK_CONFCTRL_E_ERR_UNSUPPORT_WATERMARK_HANGS_UP = 414100090,
	/**<[en]Indicates unsupport forbidden screenshorts hangs up. [cn] 不支持防截屏挂断 */
    SDK_CONFCTRL_E_ERR_UNSUPPORT_FORBIDDEN_SCREENSHORTS_HANGS_UP = 414100091,
	/**<[en]DB is not initialized. [cn]db未初始化 */
    SDK_COMMON_SQLITE_E_NOT_INITED = 415000001,
	/**<[en]Common failure. [cn]失败 */
    SDK_COMMON_E_FAIL = 415000002,
	/**<[en]Proxy detection has not been completed. [cn]代理探测还没有完成 */
    SDK_COMMON_E_ERR_PROXY_UNFINISH = 415000003,
	/**<[en]Invalid parameter. [cn]参数错误 */
    SDK_TRACK_E_INVALID_PARAMETER = 416000001,
	/**<[en]Track module is not initialized. [cn]打点模块未初始化 */
    SDK_TRACK_E_NOT_INITED = 416000002,
	/**<[en]Track event does not exist. [cn]打点事件不存在 */
    SDK_TRACK_E_EVENT_NOT_EXIST = 416000003,
	/**<[en]Not logged in. [cn]未登录 */
    SDK_TRACK_E_NOT_LOGINED = 416000004,
	/**<[en]Upload is not enabled. [cn]未开启上传 */
    SDK_TRACK_E_NO_UPLOAD = 416000005,
	/**<[en]Config invalid [cn]配置异常 */
    SDK_WAKEUP_E_CONFIG_INVALID = 417010100,
	/**<[en]Model initialization failed. [cn]模型初始化失败 */
    SDK_WAKEUP_E_INIT_MODEL_FAIL = 417010101,
	/**<[en]Feature extraction initialization failed. [cn]提取特征值初始化失败 */
    SDK_WAKEUP_E_INIT_FEATURE_FAIL = 417010102,
	/**<[en]Invalid sesiion ID. [cn]会话ID异常 */
    SDK_WAKEUP_E_SESSIONID_MATCH_FAIL = 417010103,
	/**<[en]Registration function failedr. [cn]注册函数失败 */
    SDK_WAKEUP_E_REG_NOTIFY_FAIL = 417010104,
	/**<[en]Abnormal working path. [cn]工作路径异常 */
    SDK_WAKEUP_E_PARSE_WORKPATH_FAIL = 417010105,
	/**<[en]Invalid token. [cn]token无效 */
    SDK_WAKEUP_E_TOKEN_INVALID = 417010106,
	/**<[en]The target language does not match the model language. [cn]目标语言与模型语言不符合 */
    SDK_WAKEUP_E_MODEL_LANGUAGE = 417010107,
	/**<[en]Failed to open configuration file. [cn]打开配置文件失败 */
    SDK_WAKEUP_E_OPEN_CONDFIG = 417010108,
	/**<[en]The configuration file does not contain keywords_path configuration. [cn]配置文件中不含有keywords_path配置 */
    SDK_WAKEUP_E_CONFIG_KEYWORDS_PATH = 417010109,
	/**<[en]Invalid language. [cn]语言为空 */
    SDK_WAKEUP_E_UPDATE_LANGUAGE_NULL = 417010110,
	/**<[en]The language is not in the allowed list. [cn]语言不在允许列表中 */
    SDK_WAKEUP_E_UPDATE_LANGUAGE_INVALID = 417010111,
	/**<[en]The wake-up model for language is not loaded. [cn]语言的唤醒模型未加载 */
    SDK_WAKEUP_E_UPDATE_LANGUAGE_MODEL_NOT_LOADED = 417010112,
	/**<[en]Log level is empty. [cn]日志级别为空 */
    SDK_WAKEUP_E_UPDATE_LOGLEVEL_NULL = 417010113,
	/**<[en]Invalid Log level. [cn]日志级别非法 */
    SDK_WAKEUP_E_UPDATE_LOGLEVEL_INVALID = 417010114,
	/**<[en]Invalid parameter. [cn]错误参数 */
    SDK_SIP_INVALIDPARAM = 419100001,
	/**<[en]Memory allocation failed. [cn]内存分配失败 */
    SDK_SIP_MEMALLOCFAILURE = 419100003,
	/**<[en]SDP error. [cn]SDP错误 */
    SDK_SIP_SDPROLEFAILURE = 419100004,
	/**<[en]Failed to get memmory. [cn]内存不足 */
    SDK_VTOP_ERR_MSG_NOMEM = 419200001,
	/**<[en]Msg is mull. [cn]消息空指针 */
    SDK_VTOP_ERR_MSG_NULLPTR = 419200002,
	/**<[en]Invalid msg. [cn]消息无效 */
    SDK_VTOP_ERR_MSG_INVAL = 419200003,
	/**<[en]Failed to receive. [cn]消息接收失败 */
    SDK_VTOP_ERR_MSG_BADRECV = 419200004,
	/**<[en]Time out. [cn]消息处理超时 */
    SDK_VTOP_ERR_MSG_TIMEOUT = 419200005,
	/**<[en]Not init. [cn]未初始化 */
    SDK_VTOP_ERR_MSG_NOINIT = 419200006,
	/**<[en]No dest [cn]没有接收端 */
    SDK_VTOP_ERR_MSG_NODESTR = 419200007,
	/**<[en]No app name. [cn]无应用名称 */
    SDK_VTOP_ERR_MSG_NOAPPNAME = 419200008,
	/**<[en]Rehandle. [cn]重复处理 */
    SDK_VTOP_ERR_MSG_REHANDLE = 419200009,
	/**<[en]Trace msg. [cn]追踪信息失败 */
    SDK_VTOP_ERR_MSG_TRACE = 419200010,
	/**<[en]Failed send. [cn]消息发送失败 */
    SDK_VTOP_ERR_MSG_SENDERR = 419200011,
	/**<[en]Bad func. [cn]函数异常 */
    SDK_VTOP_ERR_MSG_BADFUNC = 419200012,
	/**<[en]Msg notify. [cn]消息通知失败 */
    SDK_VTOP_ERR_MSG_NOTIFY = 419200013,
	/**<[en]Failed find. [cn]无法查找到消息 */
    SDK_VTOP_ERR_MSG_NOTFIND = 419200014,
	/**<[en]no msg. [cn]没有消息 */
    SDK_VTOP_ERR_MSG_NOMSG = 419200015,
	/**<[en]Failed to get module Id. [cn]无法找到模块ID */
    SDK_VTOP_ERR_MSG_NOTFINDMID = 419200016,
	/**<[en]tag not exist. [cn]标签不存在 */
    SDK_VTOP_ERR_MSG_TAG_NOT_EXIST = 419200017,
	/**<[en]Queue has full [cn]队列已满 */
    SDK_VTOP_ERR_MSG_QUEUE_FULL = 419200018,
	/**<[en]tag already exist. [cn]标签已存在 */
    SDK_VTOP_ERR_MSG_TAG_ALREADY_EXIST = 419200019,
	/**<[en]unknow error. [cn]未知错误 */
    SDK_VTOP_ERR_MSG_UNKOWN = 419200020,
	/**<[en]Cannot receive sharing invitations. [cn]无法接收共享邀请 */
    APP_CANNOT_ACCEPT_INVITE_SHARE = 420000001,
	/**<[en]ReportDTO parameter verification failed. [cn]reportDTO参数校验失败 */
    APP_REPORT_CHECK_PARAM_FAILED = 420000002,
	/**<[en]Report folder creation failed. [cn]举报文件夹创建失败 */
    APP_REPORT_FOLD_CREATE_FAILED = 420000003,
	/**<[en]Report folder compression failure. [cn]举报文件夹压缩失败 */
    APP_REPORT_COMPRESS_FAILED = 420000004,
	/**<[en]The path of the ZIP file to be uploaded is empty. [cn]待上传的ZIP文件路径为空 */
    APP_REPORT_ZIP_PATH_EMPTY = 420000005,
	/**<[en]The size of the ZIP file to be uploaded reaches the maximum. [cn]待上传的ZIP文件大小超过限制 */
    APP_REPORT_ZIP_SIZE_EXCEED_LIMIT = 420000006,
	/**<[en]The same person reported more than 100 times within 24 hours. [cn]同一个人24小时内举报次数超过100次 */
    APP_REPORT_EXCEED_LIMIT_DAILY = 420000007,
	/**<[en]Digital human error. [cn]数字人服务异常 */
    APP_DIGITAL_HUMAN_ERROR = 420000008,
	/**<[en]Screen lock. [cn]屏幕锁定 */
    APP_SCREEN_LOCK = 420000009,
	/**<[en]Common Error. [cn]通用错误 */
    UISDK_COMMON_ERROR = 430100001,
	/**<[en]Invalid parameters. [cn]参数错误 */
    UISDK_API_INVALID_PARAMETERS = 430100002,
	/**<[en]SIP connection check failed. [cn]SIP连接检查失败 */
    UISDK_SIP_CHECK_TIMEOUT = 430100003,
	/**<[en]Timeout. [cn]超时 */
    UISDK_TIMEOUT = 430100004,
	/**<[en]In process. [cn]接口正在处理中 */
    UISDK_IN_PROCESS = 430100005,
	/**<[en]Not initialized or initialization is not complete. [cn]未初始化或初始化尚未完成。 */
    UISDK_NOT_INITED_END = 430100006,
	/**<[en]Not supported in this release. [cn]此版本不支持。 */
    UISDK_NOT_SUPPORT_END = 430100007,
	/**<[en]Operation interrupt. [cn]操作中断。 */
    UISDK_OPERATION_INTERRUPT = 430100008,
	/**<[en]Contact not found. [cn]联系人不存在 */
    UISDK_CONTACT_NOT_FOUND = 430100009,
	/**<[en]Args length overrun. [cn]参数长度超限 */
    UISDK_ARGS_LENGTH_OVERRUN = 430100010,
	/**<[en]APPID info illegal. [cn]APPID 信息入参不合法 */
    UISDK_APPID_INFO_ILLEGAL = 430100011,
	/**<[en]E2EEncrypt algorithm error. [cn]端到端加密算法不对称 */
    UISDK_E2EENCRYPT_ALGORITHM_ERROR = 430100012,
	/**<[en]unlogin. [cn]未登录 */
    UISDK_UNLOGIN_ERROR = 430200001,
	/**<[en]Repeated login. [cn]重复登录 */
    UISDK_REPEATED_LOGIN_ERROR = 430200002,
	/**<[en]SIP connection timeout. [cn]SIP连接超时 */
    UISDK_SIP_CONNECTION_TIMEOUT = 430200003,
	/**<[en]Invalid login password. [cn]用于登录的密码参数不合法 */
    UISDK_LOGIN_INVALID_PASSWORD_PARAMETER = 430200004,
	/**<[en]Password or account empty. [cn]账号或密码不能都为空 */
    UISDK_PASSWORD_OR_ACCOUNT_EMPTY = 430200005,
	/**<[en]Start local record need confirm. [cn]开启本地录制弹窗确认 */
    UISDK_START_LOCAL_RECORD_NEED_CONFIRM = 430200006,
	/**<[en]disc space not enough. [cn]磁盘空间不足 */
    UISDK_DISC_SPACE_NOT_ENOUGH = 430200007,
	/**<[en]Not has local record priviledge. [cn]无本地录制权限 */
    UISDK_NOT_HAS_LOCAL_RECORD_PRIVILEDGE = 430200008,
	/**<[en]Local record save path not writeable. [cn]路径无写入权限 */
    UISDK_LOCAL_RECORD_SAVE_PATH_NOT_WRITEABLE = 430200009,
	/**<[en]The calling number, account number or third-party account number cannot be empty. [cn]呼叫号码、账号或者第三方账号不能为空 */
    UISDK_CALL_INVALID_ACCOUNT_PARAMETER = 430300001,
	/**<[en]Call account empty. [cn]点对点呼叫账号为空 */
    UISDK_CALL_ACCOUNT_EMPTY = 430300002,
	/**<[en]Call nickname empty. [cn]点对点呼叫名字为空 */
    UISDK_CALL_NICKNAME_EMPTY = 430300003,
	/**<[en]Password required to join the meeting. [cn]加入会议需要密码 */
    UISDK_JOINCONF_NEED_PASSWORD = 430400001,
	/**<[en]Time zone error. [cn]时区错误 */
    UISDK_INVALID_TIMEZONE_PARAMETER = 430400002,
	/**<[en]The meeting duration is less than 1. [cn]会议时长小于1 */
    UISDK_INVALID_CONF_DURATION_PARAMETER = 430400003,
	/**<[en]Joining the conference is interrupted. [cn]入会被中断 */
    UISDK_CONF_INTERRUPTED = 430400004,
	/**<[en]Password input at least 4 digits. [cn]密码输入至少4位 */
    UISDK_JOINCONF_INPUT_INVALID_PASSWORD = 430400005,
	/**<[en]User voluntarily cancels. [cn]用户主动取消 */
    UISDK_JOINCONF_USER_CANCEL = 430400006,
	/**<[en]The guest password illegal. [cn]来宾密码非法 */
    UISDK_INVALID_GUEST_PASSWORD_PARAMETER = 430400007,
	/**<[en]Not in conference or in call. [cn]不在会议或呼叫中 */
    UISDK_NOT_IN_CONF_OR_CALL = 430400008,
	/**<[en]Already exist conf or call. [cn]已存在一路会议或呼叫 */
    UISDK_ALREADY_EXIST_CONF_OR_CALL = 430400009,
	/**<[en]ConfId empty. [cn]会议id不能为空 */
    UISDK_CONFID_EMPTY = 430400010,
	/**<[en]Subject too long. [cn]会议主题长度不能超过50 */
    UISDK_SUBJECT_TOO_LONG = 430400011,
	/**<[en]VMR host password length illegal. [cn]主持人密码长度不合法 */
    UISDK_VMR_HOST_PASSWORD_LENGTH_LEGAL = 430400012,
	/**<[en]VMR name empty. [cn]VMR名字为空 */
    UISDK_VMR_NAME_EMPTY = 430400013,
	/**<[en]Conf starttime early. [cn]会议的开始时间早于当前时间 */
    UISDK_CONF_STARTTIME_EARLY = 430400014,
	/**<[en]Share is locked. [cn]共享被锁定 */
    UISDK_SHARE_LOCKED = 430400015,
	/**<[en]Not in data conference. [cn]不在数据会议中 */
    UISDK_NOT_IN_DATACONF = 430400016,
	/**<[en]Role not support operation [cn]角色不支持该操作 */
    UISDK_ROLE_NOT_SUPPORT_OPERATION = 430400017,
	/**<[en]Scan code expired [cn]二维码过期 */
    UISDK_SCAN_CODE_EXPIRED = 430400018,
	/**<[en]Scan code not support [cn]二维码不支持 */
    UISDK_SCAN_CODE_NOT_SUPPORT = 430400019,
	/**<[en]Version is outdated [cn]大屏版本低 */
    UISDK_SCAN_CODE_OUTDATED_VERSION = 430400020,
	/**<[en]HTTP request, server exception. [cn]HTTP请求，服务器异常 */
    UISDK_HTTP_SERVER_ERROR = 430500001,
	/**<[en]HTTP request, Connecting to the server times out. [cn]HTTP请求，连接服务器超时 */
    UISDK_HTTP_CONNECT_SERVER_TIMEOUT_ERROR = 430500002,
	/**<[en]network unavailable. [cn]网络不可用 */
    UISDK_NO_NETWORK_ERROR = 430500003,
	/**<[en]file type illegal. [cn]文件类型不合法 */
    UISDK_FILE_TYPE_ILLEGAL = 430500004,
	/**<[en]file copy error. [cn]文件拷贝失败 */
    UISDK_COPY_FILE_ERROR = 430500005,
	/**<[en]Leave conf due to background freezing. [cn]应用后台冻结导致离会 */
    UISDK_FROZEN_LEAVE_CONF = 430600001,
	/**<[en]request annotation failed by no app right. [cn]应用没有权限导致申请标注失败 */
    UISDK_ANNOTATION_FAILED_BY_NO_APP_RIGHT = 430600002,
	/**<[en]error no memory. [cn]内存不足 */
    SDK_DATACONF_NO_MEMORY = 440001401,
	/**<[en]opertation not be permitted. [cn]操作无权限. */
    SDK_DATACONF_OPERATE_NOT_PERMIT = 440001402,
	/**<[en]invalid argument. [cn]参数非法. */
    SDK_DATACONF_INVALID_VAL = 440001403,
	/**<[en]IO error. [cn]IO 错误. */
    SDK_DATACONF_ERR_IO = 440001404,
	/**<[en]timeout. [cn]超时. */
    SDK_DATACONF_TIMEOUT = 440001405,
	/**<[en]unknown error. [cn]未知错误. */
    SDK_DATACONF_UNKNOWN = 440001406,
	/**<[en]media service not available. [cn]媒体服务不可用. */
    SDK_DATACONF_SERVICE_DIED = 440001407,
	/**<[en]the state is not support this operation. [cn]不支持的状态. */
    SDK_DATACONF_INVALID_STATE = 440001408,
	/**<[en]unsupport interface. [cn]不支持的接口. */
    SDK_DATACONF_UNSUPPORT = 440001409,
	/**<[en]video layout mode is not supported. [cn]视频布局模式不支持 */
    UISDK_VIDEO_LAYOUT_MODE_NOT_SUPPORT = 600000001,
	/**<[en]pair erro. [cn]配对错误 */
    UISDK_CONTROLLER_PAIR_ERROR = 600000002,
	/**<[en]pair link is not exist. [cn]配对链路不存在 */
    UISDK_CONTROLLER_PAIR_LINK_IS_NOT_EXIST = 600000003,
	/**<[en]cmd is not support. [cn]命令不支持 */
    UISDK_CONTROLLER_CMD_IS_NOT_SUPPORT = 600000004,
	/**<[en]action is running. [cn]正在执行 */
    UISDK_ACTION_IS_RUNNING = 600000005,
	/**<[en]mcu is not supported. [cn]不支持mcu */
    UISDK_MCU_IS_NOT_SUPPORTED = 600000006,
	/**<[en]operate mic error not in conf. [cn]不在会议中 */
    UISDK_OPERATE_NOT_IN_CONF = 600000007,
	/**<[en]operate mic error no permission . [cn]没有操作麦克风权限 */
    UISDK_OPERATE_MIC_ERROR_NO_PERMISSION = 600000008,
	/**<[en]operate mic error not allow unmute. [cn]不允许取消静音 */
    UISDK_OPERATE_MIC_ERROR_NOT_ALLOW_UNMUTE = 600000009,
	/**<[en]operate mic error audience not allow speak. [cn]不允许开麦 */
    UISDK_OPERATE_MIC_ERROR_AUDIENCE_NOT_ALLOW_SPEAK = 600000010,
	/**<[en]operate camera error no permission. [cn]观众无开启摄像头权限 */
    UISDK_OPERATE_CAMERA_ERROR_NO_PERMISSION = 600000011,
	/**<[en]operate camera error not allow open. [cn] 不允许开启摄像头 */
    UISDK_OPERATE_CAMERA_ERROR_NOT_ALLOW_OPEN = 600000012,
	/**<[en]operate camera error not allow open low video bw. [cn]低带宽不允许开启摄像头 */
    UISDK_OPERATE_CAMERA_ERROR_NOT_ALLOW_OPEN_LOW_VIDEO_BW = 600000013,
	/**<[en]param is incorrect. [cn]音量参数不对 */
    UISDK_PARAM_IS_INCORRECT = 600000014,
	/**<[en]operate camera error require all attendees to open camera. [cn]关闭摄像头失败，当前会议强制开启摄像头 */
    UISDK_OPERATE_CAMERA_ERROR_REQUIRE_ALL_ATTENDEES_TO_OPEN_CAMERA = 600000015,
	/**<[en]Low performance cloud desktop devices will have restrictions on opening cameras. [cn]低性能云桌面设备会中限制打开摄像头 */
    UISDK_OPERATE_MIC_ERROR_LOW_PERFORMANCE_CLOUD_DESKTOP = 600000016,
	/**<[en]spk sys api error. [cn]扬声器系统api调用出错 */
    UISDK_OPERATE_SPK_ERROR_SYSTEM_API = 600000017,
	/**<[en]Request terminated. [cn]请求终止 */
    SDK_CALL_REASON_CODE_487_REQ_TEMINATED = 510000487,
	/**<[en]Hangup without toast. [cn]挂断不弹框 */
    SDK_CALL_REASON_CODE_841_HANGUP_WITHOUT_TOAST = 510000841,
	/**<[en]Call is accepted by other terminal. [cn]用户接听结束呼叫其它端 */
    SDK_CALL_REASON_CODE_843_HAS_ACCEPTED = 510000843,
	/**<[en]http error start [cn]http错误码起始 */
    SDK_HTTP_ERROR_START = 710000000,
	/**<[en]Init fail [cn]初始化失败 */
    SDK_HTTP_INIT_FAIL = 710000001,
	/**<[en]uninit [cn]未初始化 */
    SDK_HTTP_UNINIT = 710000002,
	/**<[en]invalid param [cn]无效参数 */
    SDK_HTTP_INVALID_PARAM = 710000003,
	/**<[en]invalid handle [cn]无效handle */
    SDK_HTTP_INVALID_HANDLE = 710000004,
	/**<[en]handle in using, can't be set [cn]handle在使用中 */
    SDK_HTTP_HANDLE_INUSE = 710000005,
	/**<[en]current handle state not support this operation [cn]当前handle状态不支持操作 */
    SDK_HTTP_HANDLE_STATE_ERROR = 710000006,
	/**<[en]alloc fail [cn]内存申请失败 */
    SDK_HTTP_ALLOC_MEM_FAIL = 710000007,
	/**<[en]alloc handle fail [cn]handle申请失败 */
    SDK_HTTP_CREATE_HANDLE_FAIL = 710000008,
	/**<[en]tls mode error [cn]tsl mode错误 */
    SDK_HTTP_INVALID_TLS_MODE = 710000009,
	/**<[en]invalid URL [cn]无效的url */
    SDK_HTTP_INVALID_URL = 710000010,
	/**<[en]invalid head type [cn]无效的头类型 */
    SDK_HTTP_INVALID_HEAD_TYPE = 710000011,
	/**<[en]open log file fail [cn]打开日志文件错误 */
    SDK_HTTP_OPEN_LOG_FAIL = 710000012,
	/**<[en]write log file fail [cn]写日志文件错误 */
    SDK_HTTP_WRITE_LOG_FAIL = 710000013,
	/**<[en]invalid file path [cn]无效的文件路径 */
    SDK_HTTP_INVALID_FILEPATH = 710000014,
	/**<[en]handle has been released [cn]handle已经释放 */
    SDK_HTTP_HANDLE_RELEASED = 710000015,
	/**<[en]create mutex fail [cn]创建锁错误 */
    SDK_HTTP_CREATE_MUTEX_FAIL = 710000016,
	/**<[en]lock mutex fail [cn]加锁失败 */
    SDK_HTTP_LOCK_MUTEX_FAIL = 710000017,
	/**<[en]unlock mutex fail [cn]解锁失败 */
    SDK_HTTP_UNLOCK_MUTEX_FAIL = 710000018,
	/**<[en]create thread fail [cn]创建线程失败 */
    SDK_HTTP_CREATE_THREAD_FAIL = 710000019,
	/**<[en]not support this function [cn]不支持该功能 */
    SDK_HTTP_NOT_SUPPORT = 710000020,
	/**<[en]svn socket create fail [cn]svn socket创建失败 */
    SDK_HTTP_SVN_SOCKET_CREATE_FAIL = 710000021,
	/**<[en]svn socket connect fail [cn]svn socket 连接失败 */
    SDK_HTTP_SVN_SOCKET_CONNECT_FAIL = 710000022,
	/**<[en]svn socket select fail [cn]svn socket选择失败 */
    SDK_HTTP_SVN_SOCKET_SLECET_FAIL = 710000023,
	/**<[en]svn socket send fail [cn]svn socket发送失败 */
    SDK_HTTP_SVN_SOCKET_SEND_FAIL = 710000024,
	/**<[en]svn socket recv fail [cn]svn socket接收失败 */
    SDK_HTTP_SVN_SOCKET_RECV_FAIL = 710000025,
	/**<[en]get hostname fail [cn]获取主机名失败 */
    SDK_HTTP_GETHOSTNAME_FAIL = 710000026,
	/**<[en]IP net transfer fail [cn]IP网络传输失败 */
    SDK_HTTP_NET_NTOA_FAIL = 710000027,
	/**<[en]response parse fail [cn]响应解析失败 */
    SDK_HTTP_RESPONSE_PARSE_ERR = 710000028,
	/**<[en]invalid auth mode [cn]无效鉴权模式 */
    SDK_HTTP_INVALID_AUTH_MODE = 710000029,
	/**<[en]is not login [cn]未登录 */
    SDK_HTTP_NOT_LOGIN = 710000030,
	/**<[en]is logining [cn]正在登录 */
    SDK_HTTP_LOGINING = 710000031,
	/**<[en]is TIMEOUT [cn]超时 */
    SDK_HTTP_UPLOAD_DOWNLOAD_TIMEOUT = 710000032,
	/**<[en]is logined [cn]已登录 */
    SDK_HTTP_LOGINED = 710000033,
	/**<[en]is inited [cn]已初始化 */
    SDK_HTTP_INITED = 710000034,
	/**<[en]is LogPath is too long [cn]日志路径太长 */
    SDK_HTTP_LOGPATH_TOOLONG = 710000035,
	/**<[en]is LogPath is empty [cn]日志路径为空 */
    SDK_HTTP_LOGPATH_EMPTY = 710000036,
	/**<[en] unsupported protocol [cn]不支持的协议 */
    SDK_HTTP_CURLE_UNSUPPORTED_PROTOCOL = 710000101,
	/**<[en]curl failed init [cn]curl初始化失败 */
    SDK_HTTP_CURLE_FAILED_INIT = 710000102,
	/**<[en]url malformat [cn]url格式错误 */
    SDK_HTTP_CURLE_URL_MALFORMAT = 710000103,
	/**<[en]not built in [cn]未内置 */
    SDK_HTTP_CURLE_NOT_BUILT_IN = 710000104,
	/**<[en]couldn't resolve proxy [cn]无法解析代理 */
    SDK_HTTP_CURLE_COULDNT_RESOLVE_PROXY = 710000105,
	/**<[en]cloudn't resolve host [cn]无法解析主机 */
    SDK_HTTP_CURLE_COULDNT_RESOLVE_HOST = 710000106,
	/**<[en]couldn't connect [cn]无法连接 */
    SDK_HTTP_CURLE_COULDNT_CONNECT = 710000107,
	/**<[en]ftp weird server reply [cn]ftp无法识别的服务器回复 */
    SDK_HTTP_CURLE_FTP_WEIRD_SERVER_REPLY = 710000108,
	/**<[en]a service was denied by the server due to lack of access-when login fails this is not returned [cn]远程访问被拒绝 */
    SDK_HTTP_CURLE_REMOTE_ACCESS_DENIED = 710000109,
	/**<[en]ftp accept failed [cn]ftp接收失败 */
    SDK_HTTP_CURLE_FTP_ACCEPT_FAILED = 710000110,
	/**<[en]ftp weird pass reply [cn]ftp weird pass 回复 */
    SDK_HTTP_CURLE_FTP_WEIRD_PASS_REPLY = 710000111,
	/**<[en]timeout occurred accepting server [cn]ftp接收超时 */
    SDK_HTTP_CURLE_FTP_ACCEPT_TIMEOUT = 710000112,
	/**<[en]ftp weird pasv reply [cn]ftp pasv 回复 */
    SDK_HTTP_CURLE_FTP_WEIRD_PASV_REPLY = 710000113,
	/**<[en]ftp weird 227 format [cn]ftp 277格式 */
    SDK_HTTP_CURLE_FTP_WEIRD_227_FORMAT = 710000114,
	/**<[en]ftp can't get host [cn]ftp无法获取主机 */
    SDK_HTTP_CURLE_FTP_CANT_GET_HOST = 710000115,
	/**<[en]NOT USED [cn]未使用, 仅占位 */
    SDK_HTTP_CURLE_OBSOLETE16 = 710000116,
	/**<[en] couldn't set type [cn]不可设置类型 */
    SDK_HTTP_CURLE_FTP_COULDNT_SET_TYPE = 710000117,
	/**<[en]partial file [cn]部分文件 */
    SDK_HTTP_CURLE_PARTIAL_FILE = 710000118,
	/**<[en]ftp couldn't fetr file [cn]ftp无法获取文件 */
    SDK_HTTP_CURLE_FTP_COULDNT_RETR_FILE = 710000119,
	/**<[en] NOT USED [cn]未使用, 仅占位 */
    SDK_HTTP_CURLE_OBSOLETE20 = 710000120,
	/**<[en]quote command failure [cn]引用命令失败 */
    SDK_HTTP_CURLE_QUOTE_ERROR = 710000121,
	/**<[en]http returned error [cn]http返回错误 */
    SDK_HTTP_CURLE_HTTP_RETURNED_ERROR = 710000122,
	/**<[en]write error [cn]写错误 */
    SDK_HTTP_CURLE_WRITE_ERROR = 710000123,
	/**<[en]NOT USED [cn]未使用, 仅占位 */
    SDK_HTTP_CURLE_OBSOLETE24 = 710000124,
	/**<[en]failed upload command [cn]失败的上传命令 */
    SDK_HTTP_CURLE_UPLOAD_FAILED = 710000125,
	/**<[en]couldn't open/read from file [cn]无法打开/读文件 */
    SDK_HTTP_CURLE_READ_ERROR = 710000126,
	/**<[en]CURLE_OUT_OF_MEMORY may sometimes indicate a conversion error! instead of a memory allocation error if CURL_DOES_CONVERSIONS is defined [cn]内存分配不足 */
    SDK_HTTP_CURLE_OUT_OF_MEMORY = 710000127,
	/**<[en]the timeout time was reached [cn]请求超时 */
    SDK_HTTP_CURLE_OPERATION_TIMEDOUT = 710000128,
	/**<[en]NOT USED [cn]未使用, 仅占位 */
    SDK_HTTP_CURLE_OBSOLETE29 = 710000129,
	/**<[en]FTP PORT operation failed [cn]ftp port操作失败 */
    SDK_HTTP_CURLE_FTP_PORT_FAILED = 710000130,
	/**<[en]the REST command failed [cn]rest命令失败 */
    SDK_HTTP_CURLE_FTP_COULDNT_USE_REST = 710000131,
	/**<[en]NOT USED [cn]未使用, 仅占位 */
    SDK_HTTP_CURLE_OBSOLETE32 = 710000132,
	/**<[en]RANGE command didn't work [cn]范围命令不起作用 */
    SDK_HTTP_CURLE_RANGE_ERROR = 710000133,
	/**<[en]http post error [cn]http post错误 */
    SDK_HTTP_CURLE_HTTP_POST_ERROR = 710000134,
	/**<[en]wrong when connecting with SSL [cn]使用SSL连接时出错 */
    SDK_HTTP_CURLE_SSL_CONNECT_ERROR = 710000135,
	/**<[en]couldn't resume download [cn]无法继续下载 */
    SDK_HTTP_CURLE_BAD_DOWNLOAD_RESUME = 710000136,
	/**<[en]couldn't read file [cn]无法读取文件 */
    SDK_HTTP_CURLE_FILE_COULDNT_READ_FILE = 710000137,
	/**<[en]ldap can'tbind [cn]ldap无法绑定 */
    SDK_HTTP_CURLE_LDAP_CANNOT_BIND = 710000138,
	/**<[en]ldap search failed [cn]ldap搜索失败 */
    SDK_HTTP_CURLE_LDAP_SEARCH_FAILED = 710000139,
	/**<[en]NOT USED [cn]未使用, 仅占位 */
    SDK_HTTP_CURLE_OBSOLETE40 = 710000140,
	/**<[en]function not found [cn]找不到函数 */
    SDK_HTTP_CURLE_FUNCTION_NOT_FOUND = 710000141,
	/**<[en]aborted by callback [cn]通过回调终止 */
    SDK_HTTP_CURLE_ABORTED_BY_CALLBACK = 710000142,
	/**<[en]function argument [cn]函数变元 */
    SDK_HTTP_CURLE_BAD_FUNCTION_ARGUMENT = 710000143,
	/**<[en]NOT USED [cn]未使用, 仅占位 */
    SDK_HTTP_CURLE_OBSOLETE44 = 710000144,
	/**<[en]interface failed [cn]接口失败 */
    SDK_HTTP_CURLE_INTERFACE_FAILED = 710000145,
	/**<[en]NOT USED [cn]未使用, 仅占位 */
    SDK_HTTP_CURLE_OBSOLETE46 = 710000146,
	/**<[en]too many redirects [cn]重定向太多 */
    SDK_HTTP_CURLE_TOO_MANY_REDIRECTS = 710000147,
	/**<[en]unknown option [cn]未知选项 */
    SDK_HTTP_CURLE_UNKNOWN_OPTION = 710000148,
	/**<[en]Malformed telnet option [cn]格式错误的telnet选项 */
    SDK_HTTP_CURLE_TELNET_OPTION_SYNTAX = 710000149,
	/**<[en]NOT USED [cn]未使用, 仅占位 */
    SDK_HTTP_CURLE_OBSOLETE50 = 710000150,
	/**<[en]peer's certificate or fingerprint wasn't verified fine [cn]对方的证书或指纹未通过验证 */
    SDK_HTTP_CURLE_PEER_FAILED_VERIFICATION = 710000151,
	/**<[en]got nothing [cn]什么都没有 */
    SDK_HTTP_CURLE_GOT_NOTHING = 710000152,
	/**<[en]ssl engine not found [cn]找不到ssl引擎 */
    SDK_HTTP_CURLE_SSL_ENGINE_NOTFOUND = 710000153,
	/**<[en]ssl engine set failed [cn]ssl引擎设置失败 */
    SDK_HTTP_CURLE_SSL_ENGINE_SETFAILED = 710000154,
	/**<[en]send error [cn]发送错误 */
    SDK_HTTP_CURLE_SEND_ERROR = 710000155,
	/**<[en]recv error [cn]接收错误 */
    SDK_HTTP_CURLE_RECV_ERROR = 710000156,
	/**<[en]NOT USED [cn]未使用, 仅占位 */
    SDK_HTTP_CURLE_OBSOLETE57 = 710000157,
	/**<[en]problem with the local certificate [cn]本地证书有问题 */
    SDK_HTTP_CURLE_SSL_CERTPROBLEM = 710000158,
	/**<[en]couldn't use specified cipher [cn]无法使用指定的密码 */
    SDK_HTTP_CURLE_SSL_CIPHER = 710000159,
	/**<[en]problem with the CA cert (path?) [cn]CA证书有问题(路径?) */
    SDK_HTTP_CURLE_SSL_CACERT = 710000160,
	/**<[en]Unrecognized/bad encoding [cn]无法识别/编码错误 */
    SDK_HTTP_CURLE_BAD_CONTENT_ENCODING = 710000161,
	/**<[en]Invalid LDAP URL [cn]无效的LDAP url */
    SDK_HTTP_CURLE_LDAP_INVALID_URL = 710000162,
	/**<[en]Maximum file size exceeded [cn]超过最大文件大小 */
    SDK_HTTP_CURLE_FILESIZE_EXCEEDED = 710000163,
	/**<[en]Requested FTP SSL level failed [cn]请求的FTP ssl级别失败. */
    SDK_HTTP_CURLE_USE_SSL_FAILED = 710000164,
	/**<[en]Sending the data requires a rewind that failed [cn]发送数据需要失败的倒带 */
    SDK_HTTP_CURLE_SEND_FAIL_REWIND = 710000165,
	/**<[en]failed to initialise ENGINE [cn]无法初始化SSL引擎 */
    SDK_HTTP_CURLE_SSL_ENGINE_INITFAILED = 710000166,
	/**<[en]user, password or similar was not accepted and we failed to login [cn]用户,密码或类似的不被接受, 无法登录 */
    SDK_HTTP_CURLE_LOGIN_DENIED = 710000167,
	/**<[en]file not found on server [cn]在服务器上找不到文件 */
    SDK_HTTP_CURLE_TFTP_NOTFOUND = 710000168,
	/**<[en]permission problem on server [cn]服务器上的权限问题 */
    SDK_HTTP_CURLE_TFTP_PERM = 710000169,
	/**<[en]out of disk space on server [cn]服务器上的磁盘空间不足 */
    SDK_HTTP_CURLE_REMOTE_DISK_FULL = 710000170,
	/**<[en]Illegal TFTP operation [cn]非法的TFTP操作 */
    SDK_HTTP_CURLE_TFTP_ILLEGAL = 710000171,
	/**<[en]Unknown transfer ID [cn]未知的传输ID */
    SDK_HTTP_CURLE_TFTP_UNKNOWNID = 710000172,
	/**<[en]File already exists [cn]文件已经存在 */
    SDK_HTTP_CURLE_REMOTE_FILE_EXISTS = 710000173,
	/**<[en]No such user [cn]无此用户 */
    SDK_HTTP_CURLE_TFTP_NOSUCHUSER = 710000174,
	/**<[en]conversion failed [cn]转换失败 */
    SDK_HTTP_CURLE_CONV_FAILED = 710000175,
	/**<[en]caller must register conversion callbacks using curl_easy_setopt options [cn]调用者必须使用curl_easy_setopt选项注册转换回调 */
    SDK_HTTP_CURLE_CONV_REQD = 710000176,
	/**<[en]could not load CACERT file, missing or wrong format [cn]无法加载CACERT文件，缺少CACERT文件或CACERT文件的格式不正确 */
    SDK_HTTP_CURLE_SSL_CACERT_BADFILE = 710000177,
	/**<[en]remote file not found [cn]未找到远程文件 */
    SDK_HTTP_CURLE_REMOTE_FILE_NOT_FOUND = 710000178,
	/**<[en]error from the SSH layer, somewhat generic so the error message will be of [cn]来自SSH层的错误，有点通用. */
    SDK_HTTP_CURLE_SSH = 710000179,
	/**<[en]Failed to shut down the SSL connection [cn]未能关闭SSL连接 */
    SDK_HTTP_CURLE_SSL_SHUTDOWN_FAILED = 710000180,
	/**<[en]socket is not ready for send/recv,wait till it's ready and try again [cn]套接字尚未准备好发送/接收，请等待它准备就绪，然后重试 */
    SDK_HTTP_CURLE_AGAIN = 710000181,
	/**<[en]could not load CRL file, missing or wrong format (Added in 7.19.0) [cn]无法加载CRL文件，缺少或格式错误（在7.19.0版本中新增） */
    SDK_HTTP_CURLE_SSL_CRL_BADFILE = 710000182,
	/**<[en]Issuer check failed. [cn]颁发者检查失败。 */
    SDK_HTTP_CURLE_SSL_ISSUER_ERROR = 710000183,
	/**<[en]a PRET command failed [cn]PRET命令失败 */
    SDK_HTTP_CURLE_FTP_PRET_FAILED = 710000184,
	/**<[en]mismatch of RTSP CSeq numbers [cn]RTSP CSeq编号不匹配 */
    SDK_HTTP_CURLE_RTSP_CSEQ_ERROR = 710000185,
	/**<[en]mismatch of RTSP Session Ids [cn]RTSP会话ID不匹配 */
    SDK_HTTP_CURLE_RTSP_SESSION_ERROR = 710000186,
	/**<[en]unable to parse FTP file list [cn]无法解析FTP文件列表 */
    SDK_HTTP_CURLE_FTP_BAD_FILE_LIST = 710000187,
	/**<[en]chunk callback reported error [cn]区块回调报告错误 */
    SDK_HTTP_CURLE_CHUNK_FAILED = 710000188,
	/**<[en]200 http/https [cn]200 http/https成功响应 */
    SDK_HTTP_CURL_RSP_200 = 710000200,
	/**<[en]create handle failed [cn]创建句柄失败 */
    SDK_HTTP_CURL_CREATE_HANDLE_FAIL = 710000201,
	/**<[en]set head failed [cn]设置头失败 */
    SDK_HTTP_CURL_SET_HEAD_FAIL = 710000202,
	/**<[en]proxy timeout [cn]代理通信超时，tcp建链失败，大概率是代理配置错误 */
    SDK_HTTP_CURLE_EXTERN_CONNECT_TIMEOUT = 710000300,
	/**<[en]closed by proxy [cn]连接被代理断开，大概率是服务器地址配置错误 */
    SDK_HTTP_CURLE_EXTERN_CLOSED_BY_PROXY = 710000301,
	/**<[en]tcp timeout [cn]tcp建链超时，大概率是proxy域名或者端口配置错误 */
    SDK_HTTP_CURLE_EXTERN_PROXY_ADDR_OR_PORT_ERROR = 710000302,
	/**<[en]Authentication failed. proxy permission denied [cn]认证鉴权过程失败，用户没有proxy权限，需要申请proxy权限 */
    SDK_HTTP_CURLE_EXTERN_PROXY_PERMISSION_DENIED = 710000303,
	/**<[en]Authentication failed. user or password error! [cn]认证鉴权过程失败，代理用户名或者密码错误 */
    SDK_HTTP_CURLE_EXTERN_USER_OR_PWD_ERROR = 710000304,
	/**<[en]Authentication failed. auth type error! [cn]认证鉴权过程失败，错误的认证类型，同时需要用户名、密码，需要提示用户输入 */
    SDK_HTTP_CURLE_EXTERN_AUTH_TYPE_ERROR = 710000305,
	/**<[en]Authentication failed. [cn]认证鉴权过程失败，其他未知错误，有可能是不支持认证方式，建议弹框提示用户重新发起 */
    SDK_HTTP_CURLE_EXTERN_AUTH_ERROR = 710000306,
	/**<[en]active error! [cn]激活失败 */
    SDK_HTTP_CURLE_EXTERN_ACTIVE_ERROR = 710000400,
	/**<[en]error code base. [cn]基础偏移量 */
    RTC_SDK_ERROR_CODE_BASE = 900000000,
	/**<[en]Server error. [cn]服务器异常 */
    RTC_SDK_LEAVE_REASON_SERVER_ERROR = 910000001,
	/**<[en]SFU service failure. [cn]sfu服务故障 */
    RTC_SDK_LEAVE_REASON_BREAKDOWN = 910000002,
	/**<[en]Service unavaliable 503. [cn]服务不可达503 */
    RTC_SDK_LEAVE_REASON_SERVICE_UNREACHABLE = 910000003,
	/**<[en]Internal error. [cn]内部错误 */
    RTC_SDK_LEAVE_REASON_INTERNAL_ERROR = 910000004,
	/**<[en]Kicked off. [cn]被踢 */
    RTC_SDK_LEAVE_REASON_KICKED_OFF = 910000005,
	/**<[en]Signature expired. [cn]签名过期 */
    RTC_SDK_LEAVE_REASON_SIGNATURE_EXPIRED = 910000006,
	/**<[en]Reconnect timeout. [cn]重连超时 */
    RTC_SDK_LEAVE_REASON_RECONNECT_FAILED = 910000007,
	/**<[en]Network detection. [cn]网络检测，UI不需要关注该错误码，不对外体现 */
    RTC_SDK_LEAVE_REASON_NETWORK_TEST = 910000008,
	/**<[en]User is removed. [cn]用户移除 */
    RTC_SDK_LEAVE_REASON_USER_REMOVED = 910000009,
	/**<[en]The room is dismissed. [cn]房间解散 */
    RTC_SDK_LEAVE_REASON_ROOM_DISMISSED = 910000010,
	/**<[en]The app sleeps for a long time. [cn]App长时间休眠 */
    RTC_SDK_LEAVE_REASON_USER_LOGINED = 910000013,
	/**<[en]Auth failed. [cn]鉴权失败 */
    RTC_SDK_LEAVE_REASON_AUTH_FAILED = 910000014,
	/**<[en]Auth retry. [cn]鉴权重试 */
    RTC_SDK_LEAVE_REASON_AUTH_RETRY = 910000015,
	/**<[en]Auth clock sync. [cn]时钟同步 */
    RTC_SDK_LEAVE_REASON_AUTH_CLOCK_SYNC = 910000016,
	/**<[en]Url not right. [cn]Url错误 */
    RTC_SDK_LEAVE_REASON_URL_NOT_RIGHT = 910000017,
	/**<[en]Node not exist. [cn]节点不存在 */
    RTC_SDK_NODE_NOT_EXIST = 931000000,
	/**<[en]Session validate fail. [cn]session校验失败 */
    RTC_SDK_SESSION_VALIDATE_FAIL = 931000001,
	/**<[en]Nonce validate fail. [cn]NONCE校验失败 */
    RTC_SDK_NONCE_VALIDATE_FAIL = 931000002,
	/**<[en]Internal exception. [cn]内部异常 */
    RTC_SDK_INTERNAL_EXCEPTION = 931000003,
	/**<[en]Auth fail. [cn]认证失败 */
    RTC_SDK_AUTH_FAIL = 931000004,
	/**<[en]Please try again. [cn]请重试 */
    RTC_SDK_TRY_AGAIN = 931000005,
	/**<[en]Need to synchronize clock. [cn]需要时钟同步 */
    RTC_SDK_NEED_TO_SYNCHRONIZE_CLOCK = 931000006,
	/**<[en]Request resource not found. [cn]请求资源不存在 */
    RTC_SDK_NOT_FOUND = 931000007,
	/**<[en]Request too many in a fixed time. [cn]固定时间内请求次数太多 */
    RTC_SDK_REQUEST_TOO_MANY = 931000008,
	/**<[en]Client version unsupported. [cn]客户端版本不支持 */
    RTC_SDK_CLIENT_VERSION_UNSUPPORTED = 931000009,
	/**<[en]Media channel closed. [cn]媒体通道关闭 */
    RTC_SDK_CHANNEL_ONLY_MEDIA = 931000010,
	/**<[en]Parameter is invalid. [cn]参数非法 */
    RTC_SDK_PARAM_IS_INVALID = 931000011,
	/**<[en]WebSocket heartbeat timeout. [cn]websocket心跳保活超时 */
    RTC_SDK_WEBSOCKET_HEARTBEAT_TIMEOUT = 931000012,
	/**<[en]Consumer for requestId is null. [cn]ResponseAction根据requestId获取consumer为空 */
    RTC_SDK_CONSUMER_FOR_REQUEST_ID_IS_NULL = 931000013,
	/**<[en]WebSocket connections exceeded the maximum limit. [cn]websocket连接总数超过最大限制 */
    RTC_SDK_WEBSOCKET_OVER_MAX_CONNECTIONS = 931000014,
	/**<[en]WebSocket connections per second exceeded the maximum limit. [cn]websocket连接速率超过最大限制 */
    RTC_SDK_WEBSOCKET_OVER_MAX_CONNECTIONS_PER_SECONDS = 931000015,
	/**<[en]WebSocket traffic shaping started due to exceeding the global write limit. [cn]websocket总写流量整形，因为超过globalWriteLimit */
    RTC_SDK_WEBSOCKET_SHAPING_FOR_GLOBAL_WRITE_LIMIT = 931000016,
	/**<[en]WebSocket traffic shaping started due to exceeding the global read limit. [cn]websocket总读流量整形，因为超过globalReadLimit */
    RTC_SDK_WEBSOCKET_SHAPING_FOR_GLOBAL_READ_LIMIT = 931000017,
	/**<[en]WebSocket traffic shaping started due to exceeding the channel write limit. [cn]websocket channel写流量整形，因为超过channelWriteLimit */
    RTC_SDK_WEBSOCKET_SHAPING_FOR_CHANNEL_WRITE_LIMIT = 931000018,
	/**<[en]WebSocket traffic shaping started due to exceeding the channel read limit. [cn]websocket channel读流量整形，因为超过channelReadLimit */
    RTC_SDK_WEBSOCKET_SHAPING_FOR_CHANNEL_READ_LIMIT = 931000019,
	/**<[en]Message timeout when processing. [cn]消息在队列中等待处理超时 */
    RTC_SDK_MESSAGE_TIMEOUT_WHEN_PROCESS = 931000020,
	/**<[en]Media port without encryption is closed. [cn]媒体非加密通道被关闭 */
    RTC_SDK_MEDIA_NO_ENCRYPTED_PORT_IS_CLOSE = 931000021,
	/**<[en]Crypto is null. [cn]crypto不存在 */
    RTC_SDK_CRYPTO_IS_NULL = 931000022,
	/**<[en]SDP audio is null. [cn]sdp 没有携带音频能力 */
    RTC_SDK_SDP_AUDIO_IS_NULL = 931000023,
	/**<[en]SDP video is null. [cn]sdp 没有携带视频能力 */
    RTC_SDK_SDP_VIDEO_IS_NULL = 931000024,
	/**<[en]SDP aux is null. [cn]sdp 没有携带辅流能力 */
    RTC_SDK_SDP_AUX_IS_NULL = 931000025,
	/**<[en]Service exception. [cn]服务异常 */
    RTC_SDK_SERVICE_EXCEPTION = 932000000,
	/**<[en]Stream number is full. [cn]流号已满 */
    RTC_SDK_STREAM_NUMBER_IS_FULL = 932000001,
	/**<[en]SFU is null. [cn]SFU为空 */
    RTC_SDK_SFU_IS_NULL = 932000002,
	/**<[en]AddStream failed. [cn]下发流信息失败 */
    RTC_SDK_ADD_STREAM_FAILED = 932000004,
	/**<[en]AddAdapter failed. [cn]添加适配器失败 */
    RTC_SDK_ADD_ADAPTER_FAILED = 932000005,
	/**<[en]AddAudioStreamRoute failed. [cn]添加音频路由失败 */
    RTC_SDK_ADD_AUDIO_STREAM_ROUTE_FAILED = 932000006,
	/**<[en]Can not get the user in userCache. [cn]无法在缓存中查到用户信息 */
    RTC_SDK_CAN_NOT_GET_THE_USER_IN_USERCACHE = 932000007,
	/**<[en]Watched user is null. [cn]选看用户不存在 */
    RTC_SDK_WATCHED_USER_IS_NULL = 932000010,
	/**<[en]Illegal sdp audio bandwidth. [cn]音频速率参数非法 */
    RTC_SDK_ILLEGAL_SDP_AUDIO_BANDWIDTH = 932000011,
	/**<[en]User list is null. [cn]用户列表为空 */
    RTC_SDK_USER_LIST_IS_NULL = 932000012,
	/**<[en]Illegal request parameters. [cn]非法请求参数 */
    RTC_SDK_ILLEGAL_REQUEST_PARAMETERS = 932000013,
	/**<[en]Call acs exception. [cn]acs内部调用异常 */
    RTC_SDK_CALL_ACS_EXCEPTION = 932000014,
	/**<[en]Call sfu exception. [cn]sfu内部调用异常 */
    RTC_SDK_CALL_SFU_EXCEPTION = 932000015,
	/**<[en]Call urs exception. [cn]内部调用异常 */
    RTC_SDK_CALL_URS_EXCEPTION = 932000016,
	/**<[en]Client crypto method is wrong. [cn]错误的加密算法 */
    RTC_SDK_CLIENT_CRYPTO_METHOD_IS_WRONG = 932000018,
	/**<[en]Client srtp key decode failed. [cn]客户端媒体加密密钥base64解码失败 */
    RTC_SDK_CLIENT_SRTP_KEY_DECODE_FAILED = 932000019,
	/**<[en]Can not Generate Crypto key. [cn]生成媒体加密密钥失败 */
    RTC_SDK_CAN_NOT_GENERATE_CRYPTO_KEY = 932000020,
	/**<[en]AddStreamCrypto failed. [cn]下发加密信息异常 */
    RTC_SDK_ADDSTREAMCRYPTO_FAILED = 932000021,
	/**<[en]Find sfu public IP failed. [cn]获取SFU的IP失败 */
    RTC_SDK_FIND_SFU_PUBLIC_IP_FAILED = 932000022,
	/**<[en]BatchaddStreamRoute failed. [cn]内部调用异常 */
    RTC_SDK_BATCHADDSTREAMROUTE_FAILED = 932000024,
	/**<[en]BatchdelStreamRoute failed. [cn]内部调用异常 */
    RTC_SDK_BATCHDELSTREAMROUTE_FAILED = 932000025,
	/**<[en]BatchUpdateStreamCapsInfo failed. [cn]内部调用异常 */
    RTC_SDK_BATCHUPDATESTREAMCAPSINFO_FAILED = 932000026,
	/**<[en]Unsupported operation. [cn]不支持的操作 */
    RTC_SDK_UNSUPPORTED_OPERATION = 932000028,
	/**<[en]Resource not available. [cn]媒体资源不足 */
    RTC_SDK_RESOURCE_NOT_AVAILABLE = 932000030,
	/**<[en]Connect Num Over Max. [cn]跨房数量超过上限（跨房表示当前在自己的房间同时加入到其他房间） */
    RTC_SDK_CONNECT_NUM_OVER_MAX = 932000032,
	/**<[en]Connect Same Room. [cn]不允许重复跨入同一房间 */
    RTC_SDK_CONNECT_SAME_ROOM = 932000033,
	/**<[en]WebRTC auxiliary retry. [cn]等待影子用户上线 */
    RTC_SDK_WEBRTC_AUXILIARY_RETRY = 932000034,
	/**<[en]AddAdaptRoute failed. [cn]向sfu添加适配路由失败 */
    RTC_SDK_ADDADAPTRoute_FAILED = 932000036,
	/**<[en]Player not allow APPset upstreams. [cn]观看者没有上行流，不允许通过appset设置上行流分辨率 */
    RTC_SDK_PLAYER_NOT_ALLOW_APPSET_UPSTREAMS = 932000037,
	/**<[en]Visit acs timeout or fail. [cn]MCS访问ACS超时或失败 */
    RTC_SDK_VISIT_ACS_TIMEOUT_OR_FAIL = 932000038,
	/**<[en]Acs unavailable or Internal error. [cn]ACS不可用或发生内部错误 */
    RTC_SDK_ACS_UNAVAILABLE_OR_INTERNAL_ERROR = 932000039,
	/**<[en]Romm not find. [cn]房间没有找到 */
    RTC_SDK_ROMM_NOT_FIND = 932000040,
	/**<[en]Cascade not find. [cn]级联没有找到 */
    RTC_SDK_CASCADE_NOT_FIND = 932000041,
	/**<[en]WebRtc_sdp videoProtocolTypeStr not find. [cn]webrtc_sdp中缺少协议类型 */
    RTC_SDK_WEBRTC_SDP_VIDEOPROTOCOLTYPESTR_NOT_FIND = 932000042,
	/**<[en]WebRtc_sdp VideoCodec not find. [cn]webrtc_sdp中过滤出的WebRtcVideoCodec没有找到 */
    RTC_SDK_WEBRTC_SDP_VIDEOCODEC_NOT_FIND = 932000043,
	/**<[en]Adn is disabled in room. [cn]房间的ADN未使能 */
    RTC_SDK_ADN_IS_DISABLED_IN_ROOM = 932000044,
	/**<[en]Can not find free ssrc. [cn]找不到空闲的SSRC号 */
    RTC_SDK_CAN_NOT_FIND_FREE_SSRC = 932000045,
	/**<[en]AddStreamProxy failed. [cn]向mgr添加流代理信息失败 */
    RTC_SDK_ADDSTREAMPROXY_FAILED = 932000046,
	/**<[en]Reselect media device. [cn]媒体设备使用报错，请用户重新选择媒体设备 */
    RTC_SDK_RESELECT_MEDIA_DEVICE = 932000047,
	/**<[en]Mgr user is full. [cn]MGR用户数已满 */
    RTC_SDK_MGR_USER_IS_FULL = 932000048,
	/**<[en]Mrc receive message timeout. [cn]MRC接收消息超时 */
    RTC_SDK_MRC_RECEIVE_MESSAGE_TIMEOUT = 932010021,
	/**<[en]Room is full. [cn]房间已满 */
    RTC_SDK_ROOM_IS_FULL = 934000001,
	/**<[en]Room not exist. [cn]房间不存在 */
    RTC_SDK_ROOM_NOT_EXIST = 934000002,
	/**<[en]Site not exist. [cn]站点不存在 */
    RTC_SDK_SITE_NOT_EXIST = 934000003,
	/**<[en]Call remote acs exception. [cn]调用ACS失败 */
    RTC_SDK_CALL_REMOTE_ACS_EXCEPTION = 934000004,
	/**<[en]User not exist. [cn]用户不存在 */
    RTC_SDK_USER_NOT_EXIST = 934000006,
	/**<[en]Aux is exist. [cn]已存在辅流共享 */
    RTC_SDK_AUX_IS_EXIST = 934000007,
	/**<[en]Register type unknown. [cn]未知的Register Type */
    RTC_SDK_REGISTER_TYPE_UNKNOWN = 934000008,
	/**<[en]Channel type mismatching. [cn]媒体类型通道不一致 */
    RTC_SDK_CHANNEL_TYPE_MISMATCHING = 934000009,
	/**<[en]Adn is not enabled in room. [cn]房间没有开启ADN（ADN是一个走其他路径的媒体通道服务） */
    RTC_SDK_ADN_IS_NOT_ENABLED_IN_ROOM = 934000010,
	/**<[en]share user number exceeds max. [cn]共享用户数超过最大值 */
    RTC_SDK_SHARE_USER_EXCEEDS_MAX = 934000021,
	/**<[en]Internal error. [cn]内部错误 */
    RTC_SDK_SDK_INTERNAL_ERROR = 990000001,
	/**<[en]Message too large. [cn]消息长度太大 */
    RTC_SDK_MSG_TOOLARGE = 990000002,
	/**<[en]Insufficient memory. [cn]内存不足 */
    RTC_SDK_MEM_NOT_ENOUGH = 990000003,
	/**<[en]Failed to send message synchronously. [cn]同步发送消息失败 */
    RTC_SDK_SYNSEND_MSG_ERR = 990000004,
	/**<[en]Parameter error. [cn]参数错误 */
    RTC_SDK_PARAM_ERROR = 990000005,
	/**<[en]Call ID order error. [cn]呼叫ID时序错误 */
    RTC_SDK_API_CALLED_IN_WRONG_ORDER = 990000006,
	/**<[en]Failed to set local screen. [cn]设置本端画面失败 */
    RTC_SDK_SETUP_LOCAL_VIEW_FAIL = 990000007,
	/**<[en]Failed to open remote screen. [cn]开启远端画面失败 */
    RTC_SDK_START_REMOTE_STREAM_VIEW_FAIL = 990000008,
	/**<[en]Device configuration failed. [cn]设备配置失败 */
    RTC_SDK_SET_DEVICE_FAIL = 990000009,
	/**<[en]Initializing. [cn]初始化中 */
    RTC_SDK_INITIALIZING = 990000010,
	/**<[en]Deinitializing. [cn]去初始化中 */
    RTC_SDK_UN_INITIALIZING = 990000011,
	/**<[en]Uploading log. [cn]正在日志上传中 */
    RTC_SDK_LOG_UPLOADING = 990000012,
	/**<[en]Failed to get media port. [cn]获取媒体端口失败 */
    RTC_SDK_MEDIA_PORT_ERROR = 990000013,
	/**<[en]The maximum number view window reached . [cn]选看窗口超过规格数 */
    RTC_SDK_WATCH_VIEW_TOO_MUCH = 990000014,
	/**<[en]Media negotiation failed. [cn]媒体协商失败 */
    RTC_SDK_MEDIA_CMP_ERR = 990000015,
	/**<[en]Server no response. [cn]服务器没有响应 */
    RTC_SDK_SERVER_NO_RESPONSE = 990000016,
	/**<[en]Role switch failed. [cn]角色切换失败 */
    RTC_SDK_USER_ROLE_CHANGE_FAIL = 990000017,
	/**<[en]Failed to join room. [cn]加入房间失败 */
    RTC_SDK_JOIN_ROOM_FAIL = 990000018,
	/**<[en]Failed to join room. Status is busy. [cn]非空闲状态 */
    RTC_SDK_JOIN_ROOM_STATUS_BUSY = 990000019,
	/**<[en]Failed to join room. Server error. [cn]加入房间失败，服务器异常 */
    RTC_SDK_JOIN_ROOM_SERVER_ERROR = 990000020,
	/**<[en]Failed to join room. Service unavaliable. [cn]加入房间失败，服务不可达 */
    RTC_SDK_JOIN_ROOM_SERVICE_UNREACHABLE = 990000021,
	/**<[en]Failed to join room. Authentication failed. [cn]加入房间失败，鉴权失败 */
    RTC_SDK_JOIN_ROOM_AUTH_FAIL = 990000022,
	/**<[en]Failed to join room. Authentication retry. [cn]加入房间失败，鉴权重试 */
    RTC_SDK_JOIN_ROOM_AUTH_RETRY = 990000023,
	/**<[en]Failed to join room. Clock synchronization. [cn]加入房间失败，时钟同步 */
    RTC_SDK_JOIN_ROOM_AUTH_CLOCK_SYNC = 990000024,
	/**<[en]Failed to join room. URL error. [cn]加入房间失败，url错误 */
    RTC_SDK_JOIN_ROOM_URL_NOT_RIGHT = 990000025,
	/**<[en]Kicked off. [cn]被踢 */
    RTC_SDK_KICKED_OFF = 990000026,
	/**<[en]Share failed. [cn]共享失败 */
    RTC_SDK_SCREEN_CAPTURE_FAIL = 990000027,
	/**<[en]Currently in external media output mode, this operation is forbidden. [cn]当前为外部媒体输出模式，禁用该操作 */
    RTC_SDK_EXT_MEDIA_OUTPUT = 990000028,
	/**<[en]Reconnection failed. [cn]重连失败 */
    RTC_SDK_RECONNECT_FAILED = 990000029,
	/**<[en]Server break down. [cn]服务器宕机 */
    RTC_SDK_SERVER_BREAK_DOWN = 990000030,
	/**<[en]Signature has expired. [cn]签名已过期 */
    RTC_SDK_SIGNATURE_EXPIRED = 990000031,
	/**<[en]Failed to set remote window mode. [cn]设置远端窗口模式失败 */
    RTC_SDK_SET_REMOTE_RENDER_MODE_FAIL = 990000032,
	/**<[en]Failed to subscribe or unsubscribe audio. [cn]订阅或取消订阅音频失败 */
    RTC_SDK_SET_REMOTE_AUDIO_MUTE_FAIL = 990000033,
	/**<[en]Failed to connect to other room. [cn]连接其他房间失败 */
    RTC_SDK_CONNECT_OTHER_ROOM_FAIL = 990000034,
	/**<[en]Failed to disconnect other room. [cn]断开连接其他房间失败 */
    RTC_SDK_DISCONNECT_OTHER_ROOM_FAIL = 990000035,
	/**<[en]Role switching is not allowed. [cn]不允许角色切换 */
    RTC_SDK_SET_USEROLE_NOT_ALLOWED = 990000036,
	/**<[en]Currently in third-party capture mode, this operation is forbidden. [cn]当前为第三方采集模式，禁用该操作 */
    RTC_SDK_EXT_MEDIA_CAPTURE_INPUT = 990000037,
	/**<[en]Failed to set third-party audio capture. [cn]设置第三方音频采集失败 */
    RTC_SDK_SET_EXTAUDIO_CAPTURE_FAIL = 990000038,
	/**<[en]Failed to set third-party video capture. [cn]设置第三方视频采集失败 */
    RTC_SDK_SET_EXTVIDEO_CAPTURE_FAIL = 990000039,
	/**<[en]Failed to set share sound switch. [cn]设置共享声音开关失败 */
    RTC_SDK_SET_SHARE_COMPUTER_SOUND_FAIL = 990000040,
	/**<[en]Failed to start or stop upstream audio stream. [cn]启停上行音频流失败 */
    RTC_SDK_SET_LOCAL_AUDIO_MUTE_FAIL = 990000041,
	/**<[en]Failed to start or stop upstream video stream. [cn]启停上行视频流失败 */
    RTC_SDK_SET_LOCAL_VIDEO_MUTE_FAIL = 990000042,
	/**<[en]User is removed. [cn]用户被移除 */
    RTC_SDK_USER_REMOVED = 990000043,
	/**<[en]The room is dismissed. [cn]房间被解散 */
    RTC_SDK_ROOM_DISMISSED = 990000044,
	/**<[en]Failed to set remote View. [cn]设置远端View失败 */
    RTC_SDK_SETUP_REMOTE_VIEW_FAIL = 990000045,
	/**<[en]Failed to join room because room full. [cn]房间已满，加入失败 */
    RTC_SDK_ROOM_FULL = 990000052,
	/**<[en]mmr network error. [cn]mmr网络问题 */
    RTC_SDK_NETWORK_FAILED = 990000053,
	/**<[en]max count error. [cn]超过最大数量 */
    RTC_SDK_START_WHITEBOARD_MAX_COUNT_EXCEED = 990000060,
	/**<[en]Invited common failed [cn]通用错误 */
    SDK_DEVICE_CAMERA_COMMON_FAILED = 920000001,
	/**<[en]Invited be used [cn]被占用 */
    SDK_DEVICE_CAMERA_BEUSED = 920000002,
	/**<[en]Invited no permission [cn]没权限 */
    SDK_DEVICE_CAMERA_NO_PERMISSION = 920000003,
	/**<[en]Unsupport audio file [cn]不支持的音频文件 */
    SDK_DEVICE_UNSUPPORT_AUDIO_FILE = 920000004,
};

/**
* [en]Auth type. [cn]鉴权类型
*/
export enum AuthType{
	/**<[en]Auth by account and password [cn]账号密码鉴权 */
    HWM_AUTH_TYPE_ACCOUNT_AND_PASSWORD = 0,
	/**<[en]Auth by appId [cn]appId鉴权 */
    HWM_AUTH_TYPE_APPID = 1,
};

/**
* [en]This structure is used to describe auth server type [cn]鉴权服务类型
*/
export enum AuthServerType{
	/**<[en]Indicates user has not binded. [cn]单点登录 */
    AUTH_SERVER_TYPE_OAUTH2 = 0,
};

/**
* [en]This structure is used to describe user corp info notify type [cn]客户企业信息变化通知类型
*/
export enum UserCorpInfoNotifyType{
	/**<[en]Indicates user delete [cn]用户已注销 */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_DELETE = 0,
	/**<[en]Indicates join new corp [cn]用户已加入新的企业（接受邀请、创建企业变成新企业的用户） */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_JOIN_NEW_CORP = 1,
	/**<[en]Indicates leave current corp [cn]用户已被移出当前企业（企业管理员删除、解散、用户主动离开企业变成注册用户） */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_LEAVE_CURRENT_CORP = 2,
	/**<[en]Indicates Smartrooms user is reset activation code or user is deleted [cn]用户重置（Smartrooms账号被重置激活码或者账号被删除） */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_RESET = 3,
	/**<[en]Indicates vmr change [cn]用户vmr变化 */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_VMR_CHANGE = 4,
	/**<[en]Indicates user name change [cn]用户姓名变更 */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_NAME_CHANGE = 5,
	/**<[en]Indicates user status change [cn]接入账号状态变化 */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_STATUS_CHANGE = 6,
};

/**
* [en]Indicates network access type [cn]网络接入类型
*/
export enum NetworkAccessType{
	/**<[en]Indicates auto [cn]默认值，目前和企业外网接入模式一致。 */
    ACCESS_TYPE_AUTO = 0,
	/**<[en]Indicates inner [cn]公司内网接入, 用于媒体和信令下沉场景，app从内网接入，信令/媒体消息走代理服务器才能访问云会议服务端 */
    ACCESS_TYPE_INNER = 1,
	/**<[en]Indicates outter [cn]公司外网接入, 用于非媒体和信令下沉场景，互联网接入，信令/媒体消息可以直接访问云会议服务端 */
    ACCESS_TYPE_OUTER = 2,
};

export enum NetConnectType{
	/**<[en]Indicates auto [cn]自动模式 */
    NET_CONNECT_AUTO = 0,
	/**<[en]Indicates force vpn [cn]强制vpn */
    NET_CONNECT_FORCE_VPN = 1,
	/**<[en]Indicates force direct [cn]强制直连 */
    NET_CONNECT_FORCE_DIRECT = 2,
};

/**
* [en]Proxy config policy [cn]代理配置策略
*/
export enum ProxyConfigPolicy{
	/**<[en]Use proxy with custom configuration [cn]使用具有自定义配置的代理 */
    HWM_PROXY_CONFIG_POLICY_CUSTOM = 0,
	/**<[en]Do not use proxy [cn]不使用代理 */
    HWM_PROXY_CONFIG_POLICY_OFF = 1,
	/**<[en]Use system proxy [cn]使用系统代理 */
    HWM_PROXY_CONFIG_POLICY_AUTO = 2,
};

/**
* [en]This enumeration is used to describe verify mode. [cn]认证模式
*/
export enum VerifyMode{
	/**<[en]Indicates no authentication. [cn]不认证 */
    VERIFY_MODE_NONE = 0,
	/**<[en]Indicates authentication server. [cn]认证服务端 */
    VERIFY_MODE_SERVER = 1,
};

/**
* [en]. [cn]部署类型
*/
export enum DeployType{
	/**<[en]Indicates cloud mode [cn]云上模式 */
    CLOUD_MODE = 0,
	/**<[en]Indicates sink mode [cn]下沉模式 */
    SINK_MODE = 1,
};

/**
* [en]This enumeration is used to describe login state. [cn]登录状态
*/
export enum LoginState{
	/**<[en]Unlogin. [cn]未登录 */
    LOGIN_STATUS_UN_LOGIN = 0,
	/**<[en]Logining. [cn]登录中 */
    LOGIN_STATUS_LOGINING = 1,
	/**<[en]Logined. [cn]已登录 */
    LOGIN_STATUS_LOGINED = 2,
	/**<[en]Logouting. [cn]登出中 */
    LOGIN_STATUS_LOGOUTING = 3,
};

/**
* [en]allow join conference user type. [cn]允许加入会议的用户类型
*/
export enum ConfAllowJoinUserType{
	/**<[en]Anyone [cn]所有用户。 [ios:rename:Anyone] */
    CONF_ALLOW_JOIN_ANYONE = 0,
	/**<[en]logined user [cn]已登录用户。 [ios:rename:LoginedUser] */
    CONF_ALLOW_JOIN_LOGINED_USER = 1,
	/**<[en]Company user [cn]企业内用户。 [ios:rename:InCompanyUser] */
    CONF_ALLOW_JOIN_IN_COMPANY_USER = 2,
	/**<[en]Invited user [cn]被邀请用户。 [ios:rename:InvitedUser] */
    CONF_ALLOW_JOIN_INVITED_USER = 3,
};

/**
* [en]VMR conf Id type. [cn]云会议室的会议ID类型
*/
export enum VmrConfIdType{
	/**<[en]VMR conf Id type is fixed [cn]云会议室的会议ID类型是固定类型。 */
    HWM_VMR_CONF_ID_TYPE_FIXED = 0,
	/**<[en]VMR conf Id type is random [cn]云会议室的会议ID类型是随机类型。 */
    HWM_VMR_CONF_ID_TYPE_RANDOM = 1,
};

/**
* [en]Conf role. [cn]会议角色
*/
export enum ConfRole{
	/**<[en]Indicates attendee [cn]普通与会者 */
    HWM_CONF_ROLE_ATTENDEE = 0,
	/**<[en]Indicates host [cn]主持人 */
    HWM_CONF_ROLE_HOST = 1,
	/**<[en]Indicates audience [cn]观众 */
    HWM_CONF_ROLE_AUDIENCE = 2,
	/**<[en]Indicates cohost [cn]联席主持人 */
    HWM_CONF_ROLE_COHOST = 3,
	/**<[en]Indicates waiting [cn]等候室成员 */
    HWM_CONF_ROLE_WAITING = 4,
};

/**
* [en]conference resource type [cn]会议资源类型
*/
export enum ConfResType{
	/**<[en]default [cn]默认 */
    HWM_CONF_RESTYPE_DEFAULT = 0,
	/**<[en]share vmr [cn]共享vmr */
    HWM_CONF_RESTYPE_SHARE_VMR = 3,
};

/**
* [en]This structure is summary state. [cn]会议纪要状态
*/
export enum SummaryState{
	/**<[en]Indicates summary close [cn]会议纪要关闭 */
    SUMMARY_STATE_CLOSE = 0,
	/**<[en]Indicates summary open [cn]会议纪要开启 */
    SUMMARY_STATE_OPEN = 1,
};

/**
* [en]This enum is used to describe multi-share type [cn] 多人共享类型
*/
export enum MultiShareType{
	/**<[en]Indicates only one user can share.[cn]只允许单人共享 */
    MULTI_SHARE_TYPE_SINGAL = 1,
	/**<[en]Indicates not only one user can share.[cn]允许多人共享 */
    MULTI_SHARE_TYPE_MULTI = 2,
};

/**
* [en]This enum is used to describe auto mute type [cn]入会自动静音类型
*/
export enum AutoMuteType{
	/**<[en]Indicates auto mute type of default. [cn]默认 */
    AUTO_MUTE_TYPE_DEFAULT = 0,
	/**<[en]Indicates auto mute type of mute. [cn]静音 */
    AUTO_MUTE_TYPE_MUTE = 1,
	/**<[en]Indicates auto mute type of unmute. [cn]非静音 */
    AUTO_MUTE_TYPE_UNMUTE = 2,
};

/**
* [en]This struct is used to describe auto invite type. [cn]自动邀请状态
*/
export enum AutoInviteType{
	/**<[en]Indicates not set (default open auto-invite) [cn]不设置（默认自动邀请） */
    AUTO_INVITE_NONE = 0,
	/**<[en]Indicates auto-invite open. [cn]自动邀请开启 */
    AUTO_INVITE_OPEN = 1,
	/**<[en]Indicates auto-invite close. [cn]自动邀请关闭 */
    AUTO_INVITE_CLOSE = 2,
};

/**
* [en]This enum is used to describe attendee type [cn]成员类型
*/
export enum AttendeeType{
	/**<[en]Indicates normal: Voice, HD, SD participants address [cn]语音、高清、标清与会者地址 */
    ATTENDEE_TYPE_NORMAL = 0,
	/**<[en]Indicates telepresence participants address type, single screen, three screen telepresence all belong to this [cn]智真与会者地址类型，单屏、三屏智真均属此类 */
    ATTENDEE_TYPE_TELEPRESENCE = 1,
	/**<[en]Indicates conference room or hard terminal [cn]会议室或硬终端 */
    ATTENDEE_TYPE_TERMINAL = 2,
	/**<[en]Indicates outside attendee [cn]外部与会人 */
    ATTENDEE_TYPE_OUTSIDE = 3,
	/**<[en]Indicates custom number [cn]custom number */
    ATTENDEE_TYPE_CUSTOMNUMBER = 4,
	/**<[en]Indicates mobile user [cn]软终端用户手机 */
    ATTENDEE_TYPE_MOBILE = 5,
	/**<[en]Indicates anonymous user [cn]匿名用户 */
    ATTENDEE_TYPE_ANONYMOUS = 6,
	/**<[en]Indicates telephone user [cn]电话用户 */
    ATTENDEE_TYPE_TELEPHONE = 7,
	/**<[en]Indicates board user [cn]白板用户 */
    ATTENDEE_TYPE_BOARD = 8,
	/**<[en]Indicates ideahub user [cn]海思芯片的大屏设备 */
    ATTENDEE_TYPE_IDEAHUB = 9,
	/**<[en]Indicates hwvision user [cn]智慧屏 */
    ATTENDEE_TYPE_HWVISION = 10,
	/**<[en]Indicates welinkc user [cn]welink大众版 */
    ATTENDEE_TYPE_WELINKC = 11,
};

/**
* [en]Share type. [cn]共享类型
*/
export enum ShareType{
	/**<[en]Share monitor(Only for Windows) [cn]屏幕共享（仅对Windows平台生效） */
    HWM_SHARE_TYPE_MONITOR = 0,
	/**<[en]Share app(Only for Windows) [cn]程序共享（仅对Windows平台生效） */
    HWM_SHARE_TYPE_APP = 1,
	/**<[en]Share white board(Only for Windows) [cn]白板共享（仅对Windows平台生效） */
    HWM_SHARE_TYPE_WHITE_BOARD = 2,
	/**<[en]All Share [cn]全类型共享 */
    HWM_SHARE_TYPE_ALL = 3,
};

/**
* [en]Monitor. [cn]显示器类型。
*/
export enum Monitor{
	/**<[en]Main monitor [cn]主显示器 */
    HWM_MONITOR_MAIN = 1,
	/**<[en]Secondary monitor [cn]副显示器 */
    HWM_MONITOR_SECONDARY = 2,
};

/**
* [en]Monitor mode [cn]屏幕模式
*/
export enum MonitorMode{
	/**<[en]Primary secondary mode [cn]主副屏模式 */
    HWM_MONITOR_MODE_PRIMARY_SECONDARY = 0,
	/**<[en]Multi monitor mode [cn]多屏模式 */
    HWM_MONITOR_MODE_MULTI_MONITOR = 1,
};

/**
* [en]This enum is used to describe attendee state. [cn]成员状态
*/
export enum ConfAttendeeState{
	/**<[en]Indicates in conference [cn]会议中 [ios:rename:InConf] */
    CONF_ATTENDEE_STATE_IN_CONF = 0,
	/**<[en]Indicates is calling [cn]正在呼叫 [ios:rename:Calling] */
    CONF_ATTENDEE_STATE_CALLING = 1,
	/**<[en]Indicates is joining conference [cn]正在加入会议 [ios:rename:Joining] */
    CONF_ATTENDEE_STATE_JOINING = 2,
	/**<[en]Indicates have leaved [cn]已经离开 [ios:rename:Leaved] */
    CONF_ATTENDEE_STATE_LEAVED = 3,
	/**<[en]Indicates not exist [cn]用户不存在 [ios:rename:NoExist] */
    CONF_ATTENDEE_STATE_NO_EXIST = 4,
	/**<[en]Indicates callee is busy [cn]被叫用户忙 [ios:rename:Busy] */
    CONF_ATTENDEE_STATE_BUSY = 5,
	/**<[en]Indicates no answer [cn]用户无应答 [ios:rename:NoAnswer] */
    CONF_ATTENDEE_STATE_NO_ANSWER = 6,
	/**<[en]Indicates user reject answer [cn]用户拒绝接听 [ios:rename:Reject] */
    CONF_ATTENDEE_STATE_REJECT = 7,
	/**<[en]Indicates call failed [cn]呼叫失败 [ios:rename:Failed] */
    CONF_ATTENDEE_STATE_CALL_FAILED = 8,
};

/**
* [en]user state [cn]用户状态枚举 用于判断当前用户是否处于忙碌状态
*/
export enum UserState{
	/**<[en]idle state [cn]空闲状态 */
    HWM_STATE_IDLE = 0,
	/**<[en]in conf state [cn]会中状态 */
    HWM_STATE_IN_CONF = 1,
	/**<[en]in call state [cn]呼叫中状态 */
    HWM_STATE_IN_CALL = 2,
};

/**
* [en]Conf end reason. [cn]会议结束原因
*/
export enum ConfEndReason{
	/**<[en]Leave conf [cn]离开会议。 */
    HWM_CONF_END_REASON_LEAVE_CONF_HANGUP = 0,
	/**<[en]Conf is end [cn]会议已结束。 */
    HWM_CONF_END_REASON_STOP_CONF_HANGUP = 1,
	/**<[en]Hang up by host [cn]被主持人移出会场。 */
    HWM_CONF_END_REASON_HOST_HANGUP = 2,
	/**<[en]Session timer timeout [cn]网络中断。 */
    HWM_CONF_END_REASON_SESSION_TIMER_TIMEOUT = 3,
	/**<[en]No stream [cn]网络异常。 */
    HWM_CONF_END_REASON_NOSTREAM_HANGUP = 4,
	/**<[en]Conf resource has been run out [cn]企业资源已达上限。 */
    HWM_CONF_END_REASON_CORP_CONFERENCE_RESOURCE_HAS_BEEN_RUN_OUT = 5,
	/**<[en]Only the same enterprise can join the conference. [cn]只允许企业内用户加入会议。 */
    HWM_CONF_END_REASON_CONF_ONLY_SAME_ENTERPRISE = 6,
	/**<[en]Only invited participants can join the conference. [cn]只允许被邀请者加入会议。 */
    HWM_CONF_END_REASON_CONF_ONLY_INVITED = 7,
	/**<[en]Conference is locked. [cn]会议被锁定。 */
    HWM_CONF_END_REASON_CONF_IS_LOCKED = 8,
	/**<[en]vmr has not been hold. [cn]VMR会议来宾不允许激活会议。 */
    HWM_CONF_END_ERR_VMR_NOT_BEEN_HOLD = 9,
	/**<[en]Vmr conf conflict [cn]VMR会议冲突。 */
    HWM_CONF_END_REASON_VMR_CONF_CONFLICT = 10,
	/**<[en]server error [cn]服务器异常。 */
    HWM_CONF_END_REASON_SERVER_ERROR = 11,
	/**<[en]num of par exceeds upper limit. [cn]与会方超出专用VMR套餐的最大与会人数 */
    HWM_CONF_END_REASON_NUM_OF_PAR_EXCEEDS_UPPER_LIMIT = 12,
	/**<[en]conf number over max allowed. [cn]超出最大在线会议数限制 */
    HWM_CONF_END_REASON_CONF_NUM_OVER_MAX_ALLOWED = 111071116,
	/**<[en]Max participants in a single meeting reached. [cn]达到系统单个会议人数上限 */
    HWM_CONF_END_REASON_PARTICIPANT_REACH_MAX_NUM = 111072504,
	/**<[en]Site meeting does not exist or is ended. [cn]会场所在会议不存在或已结束 */
    HWM_CONF_END_REASON_PARTICIPANT_CONF_NOT_EXIST = 111081002,
	/**<[en]hangup for joinconf conflict. [cn]多端入会冲突，导致离开会议 */
    HWM_CONF_END_REASON_CONF_CONFLICT = 111111008,
	/**<[en]End the meeting with no stream due to disconnection of network. [cn]无码流结束会议网络断开 */
    HWM_CONF_END_REASON_END_CONF_NET_BREAK = 411000100,
	/**<[en]Invalid user, enterprise or SP. [cn]用户，企业或SP失效 */
    HWM_CONF_END_REASON_END_EXPIRATION = 414100069,
	/**<[en]Chair end conf. [cn]主持人结束会议 */
    HWM_CONF_END_REASON_SDK_CHAIR_END_CONF = 414100074,
	/**<[en]Timeover end conf. [cn]会议到时间结束会议 */
    HWM_CONF_END_REASON_SDK_TIMEOVER_END_CONF = 414100075,
	/**<[en]network error. [cn]网络问题 */
    HWM_CONF_END_REASON_RTC_SDK_NETWORK_FAILED = 990000053,
	/**<[en]force open camera conf hangup. [cn]强制视频会议挂断 */
    HWM_CONF_END_FORCE_OPEN_CAMERA_HANGUP = 414100078,
	/**<[en]Share VMR not enough. [cn]无共享云会议室资源 */
    HWM_CONF_END_MANAGER_SHARE_VMR_NOT_ENOUGH = 111071151,
	/**<[en]No Upscale vmr. [cn]无高档可用的VMR资源 */
    HWM_CONF_END_MANAGER_NO_UPSCALE_VMR = 112030001,
	/**<[en]Max participant amount reached. [cn]超过设置的会议方数 */
    HWM_CONF_END_REASON_OVER_MAX_PARTICIPANT_NUMBER = 111072101,
	/**<[en]conf end for projection failed. [cn] 投屏失败导致会议结束 */
    HWM_CONF_END_REASON_PROJECTION_FAILED = 414100080,
	/**<[en]conf end for cancel. [cn] 投屏协商中大屏取消 */
    HWM_CONF_END_REASON_PROJECTION_CANCEL = 414100082,
	/**<[en]Indicates end projection by sender with two members. [cn] 两方投屏会议投屏端结束投屏 */
    HWM_CONF_END_REASON_PROJECTION_BY_SENDER_WITH_TWO_MEMBERS = 414100083,
	/**<[en]Indicates end projection by receiver. [cn] 大屏端结束投屏 */
    HWM_CONF_END_REASON_PROJECTION_BY_RECEIVER = 414100084,
	/**<[en]projection by sender with multi members. [cn] 多方投屏会议投屏端结束投屏 */
    HWM_CONF_END_REASON_PROJECTION_BY_SENDER_WITH_MULTI_MEMBERS = 414100085,
};

/**
* [en]This enum is used to describe timezone [cn]时区
*/
export enum Timezone{
	/**<[en]Indicates default [cn]Mediax默认时区值 [ios:rename:Default] */
    HWM_TIMEZONE_DEFAULT = 0,
	/**<[en]Indicates International Date Line West [cn]日界线西 [ios:rename:InteerdateLine] */
    HWM_TIMEZONE_INTERDATE_LINE = 1,
	/**<[en]Indicates Midway Island, Samoa [cn]中途岛，萨摩亚群岛 [ios:rename:MidwayIsland] */
    HWM_TIMEZONE_MIDWAY_ISLAND = 2,
	/**<[en]Indicates Hawaii [cn]夏威夷 [ios:rename:Hawii] */
    HWM_TIMEZONE_HAWAII = 3,
	/**<[en]Indicates Alaska [cn]阿拉斯加 [ios:rename:Alaska] */
    HWM_TIMEZONE_ALASKA = 4,
	/**<[en]Indicates Pacific Time(US&Canada);Tijuana [cn]太平洋时间(美国和加拿大);蒂华纳 [ios:rename:PacificTime] */
    HWM_TIMEZONE_PACIFIC_TIME = 5,
	/**<[en]Indicates Arizona [cn]亚利桑那 [ios:rename:Arizona] */
    HWM_TIMEZONE_ARIZONA = 6,
	/**<[en]Indicates Mountain Time(US&Canada) [cn]山地时间(美国和加拿大) [ios:rename:MountainTime] */
    HWM_TIMEZONE_MOUNTAIN_TIME = 7,
	/**<[en]Indicates Central America [cn]中美洲 [ios:rename:CentralAmerica] */
    HWM_TIMEZONE_CENTRAL_AMERICA = 8,
	/**<[en]Indicates Central Time(US&Canada) [cn]中间时间(美国和加拿大) [ios:rename:CentralTime] */
    HWM_TIMEZONE_CENTRAL_TIME = 9,
	/**<[en]Indicates Mexico City [cn]墨西哥城 [ios:rename:MexicoCity] */
    HWM_TIMEZONE_MEXICO_CITY = 10,
	/**<[en]Indicates Saskatchewan [cn]萨斯喀彻温 [ios:rename:Saskatchewan] */
    HWM_TIMEZONE_SASKATCHEWAN = 11,
	/**<[en]Indicates Bogota, Lima, Quito [cn]波哥大，利马，基多 [ios:rename:Bogota] */
    HWM_TIMEZONE_BOGOTA = 12,
	/**<[en]Indicates Eastern Time(US&Canada) [cn]东部时间(美国和加拿大) [ios:rename:EasternTime] */
    HWM_TIMEZONE_EASTERN_TIME = 13,
	/**<[en]Indicates Indiana(East) [cn]印第安纳(东部) [ios:rename:Indiana] */
    HWM_TIMEZONE_INDIANA = 14,
	/**<[en]Indicates Atlantic time(Canada) [cn]大西洋时间(加拿大) [ios:rename:AtlanticTime] */
    HWM_TIMEZONE_ATLANTIC_TIME = 15,
	/**<[en]Indicates Caracas, La Paz [cn]加拉加斯，拉巴斯 [ios:rename:Caracas] */
    HWM_TIMEZONE_CARACAS = 16,
	/**<[en]Indicates Santiago [cn]圣地亚哥 [ios:rename:Santiago] */
    HWM_TIMEZONE_SANTIAGO = 17,
	/**<[en]Indicates Newfoundland [cn]纽芬兰 [ios:rename:Newfoundland] */
    HWM_TIMEZONE_NEWFOUNDLAND = 18,
	/**<[en]Indicates Brasilia [cn]巴西利亚 [ios:rename:Brasilia] */
    HWM_TIMEZONE_BRASILIA = 19,
	/**<[en]Indicates Buenos Aires, Georgetown [cn]布宜诺斯艾利斯，乔治敦 [ios:rename:BuenosAires] */
    HWM_TIMEZONE_BUENOS_AIRES = 20,
	/**<[en]Indicates Greenland [cn]格陵兰 [ios:rename:GreenLand] */
    HWM_TIMEZONE_GREENLAND = 21,
	/**<[en]Indicates Mid-Atlantic [cn]中大西洋 [ios:rename:MidAtlantic] */
    HWM_TIMEZONE_MID_ATLANTIC = 22,
	/**<[en]Indicates Azores [cn]亚速尔群岛 [ios:rename:Azores] */
    HWM_TIMEZONE_AZORES = 23,
	/**<[en]Indicates Cape Verde Is [cn]佛得角群岛 [ios:rename:Capeverde] */
    HWM_TIMEZONE_CAPEVERDE = 24,
	/**<[en]Indicates Monrovia [cn]蒙罗维亚 [ios:rename:Monrovia] */
    HWM_TIMEZONE_MONROVIA = 25,
	/**<[en]Indicates Greenwich Mean Time:Dublin, Edinburgh, Lisbon, London [cn]格林威治标准时：都柏林，爱丁堡，里斯本，伦敦 [ios:rename:GreenwichMeantime] */
    HWM_TIMEZONE_GREENWICH_MEANTIME = 26,
	/**<[en]Indicates Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna [cn]阿姆斯特丹，柏林，伯尔尼，罗马，斯德哥尔摩，维也纳 [ios:rename:Amsterdam] */
    HWM_TIMEZONE_AMSTERDAM = 27,
	/**<[en]Indicates Belgrade, Bratislava, Budapest, Ljubljana, Prague [cn]贝尔格莱德，布拉迪斯拉发，布达佩斯，卢布尔亚纳，布拉格 [ios:rename:Belgrade] */
    HWM_TIMEZONE_BELGRADE = 28,
	/**<[en]Indicates Brussels, Copenhagen, Madrid, Paris [cn]布鲁塞尔，哥本哈根，马德里，巴黎 [ios:rename:Brussels] */
    HWM_TIMEZONE_BRUSSELS = 29,
	/**<[en]Indicates Sarajevo, Skopje, Sofija, Vilnius, Warsaw, Zagreb [cn]萨拉热窝，斯科普里，维尔纽斯，索非亚，华沙，萨格勒布 [ios:rename:Sarajevo] */
    HWM_TIMEZONE_SARAJEVO = 30,
	/**<[en]Indicates West Central Africa [cn]中非西部 [ios:rename:WestcentralAfrica] */
    HWM_TIMEZONE_WESTCENTRAL_AFRICA = 31,
	/**<[en]Indicates Athens, Istanbul, Minsk [cn]雅典，伊斯坦布尔，明斯克 [ios:rename:Athens] */
    HWM_TIMEZONE_ATHENS = 32,
	/**<[en]Indicates Bucharest [cn]布加勒斯特 [ios:rename:Bucharest] */
    HWM_TIMEZONE_BUCHAREST = 33,
	/**<[en]Indicates Cairo [cn]开罗 [ios:rename:Cairo] */
    HWM_TIMEZONE_CAIRO = 34,
	/**<[en]Indicates Harare, Pretoria [cn]哈拉雷，比勒陀利亚 [ios:rename:Harare] */
    HWM_TIMEZONE_HARARE = 35,
	/**<[en]Indicates Helsinki, Riga, Tallinn [cn]赫尔辛基，里加，塔林 [ios:rename:Helsinki] */
    HWM_TIMEZONE_HELSINKI = 36,
	/**<[en]Indicates Jerusalem [cn]耶路撒冷 [ios:rename:Jerusalem] */
    HWM_TIMEZONE_JERUSALEM = 37,
	/**<[en]Indicates Baghdad [cn]巴格达 [ios:rename:Baghdad] */
    HWM_TIMEZONE_BAGHDAD = 38,
	/**<[en]Indicates Kuwait, Riyadh [cn]科威特，利雅得 [ios:rename:Kuwait] */
    HWM_TIMEZONE_KUWAIT = 39,
	/**<[en]Indicates Moscow, St. Petersburg, Volgograd [cn]莫斯科，圣彼得堡，喀山，伏尔加格勒 [ios:rename:Moscow] */
    HWM_TIMEZONE_MOSCOW = 40,
	/**<[en]Indicates Nairobi [cn]内罗毕 [ios:rename:Nairobi] */
    HWM_TIMEZONE_NAIROBI = 41,
	/**<[en]Indicates Tehran [cn]德黑兰 [ios:rename:Tehran] */
    HWM_TIMEZONE_TEHRAN = 42,
	/**<[en]Indicates Abu Dhabi, Muscat [cn]阿布扎比，马斯喀特 [ios:rename:AbuDhabi] */
    HWM_TIMEZONE_ABU_DHABI = 43,
	/**<[en]Indicates Tbilisi, Yerevan [cn]第比利斯，埃里温 [ios:rename:Tbilisi] */
    HWM_TIMEZONE_TBILISI = 44,
	/**<[en]Indicates Kabul [cn]喀布尔 [ios:rename:Kabul] */
    HWM_TIMEZONE_KABUL = 45,
	/**<[en]Indicates Ekaterinburg [cn]叶卡捷琳堡 [ios:rename:Ekaterinburg] */
    HWM_TIMEZONE_EKATERINBURG = 46,
	/**<[en]Indicates Islamabad, Karachi, Tashkent [cn]伊斯兰堡，卡拉奇，塔什干 [ios:rename:Islamabad] */
    HWM_TIMEZONE_ISLAMABAD = 47,
	/**<[en]Indicates Calcutta, Chennai, Mumbai, New Delhi [cn]加尔各答，马德拉斯，孟买，新德里 [ios:rename:Calcutta] */
    HWM_TIMEZONE_CALCUTTA = 48,
	/**<[en]Indicates Kathmandu [cn]加德满都 [ios:rename:Kathmandu] */
    HWM_TIMEZONE_KATHMANDU = 49,
	/**<[en]Indicates Almaty [cn]阿拉木图 [ios:rename:Almaty] */
    HWM_TIMEZONE_ALMATY = 50,
	/**<[en]Indicates Astana, Dhaka [cn]阿斯塔纳，达卡 [ios:rename:Astana] */
    HWM_TIMEZONE_ASTANA = 51,
	/**<[en]Indicates Sri Jayawardenepura [cn]斯里哈亚华登尼普拉 [ios:rename:Srijaya] */
    HWM_TIMEZONE_SRIJAYA = 52,
	/**<[en]Indicates Rangoon [cn]仰光 [ios:rename:Rangoon] */
    HWM_TIMEZONE_RANGOON = 53,
	/**<[en]Indicates Bangkok, Hanoi, Jakarta [cn]曼谷，雅加达，河内 [ios:rename:Bangkok] */
    HWM_TIMEZONE_BANGKOK = 54,
	/**<[en]Indicates Novosibirsk [cn]新西伯利亚 [ios:rename:Novosibirsk] */
    HWM_TIMEZONE_NOVOSIBIRSK = 55,
	/**<[en]Indicates Beijing, Chongqing, Hong Kong, Urumqi, Taipei [cn]北京，重庆，香港，乌鲁木齐，台北 [ios:rename:Beijing] */
    HWM_TIMEZONE_BEIJING = 56,
	/**<[en]Indicates Krasnoyarsk, Ulaan Bataar [cn]克拉斯诺亚尔斯克，乌兰巴托 [ios:rename:Krasnoyarsk] */
    HWM_TIMEZONE_KRASNOYARSK = 57,
	/**<[en]Indicates Kuala Lumpur, Singapore [cn]吉隆坡，新加坡 [ios:rename:KualaLumpur] */
    HWM_TIMEZONE_KUALA_LUMPUR = 58,
	/**<[en]Indicates Perth [cn]珀斯 [ios:rename:Perth] */
    HWM_TIMEZONE_PERTH = 59,
	/**<[en]Indicates Osaka, Sapporo, Tokyo [cn]东京，大阪，札幌 [ios:rename:Osaka] */
    HWM_TIMEZONE_OSAKA = 60,
	/**<[en]Indicates Seoul [cn]汉城 [ios:rename:Seoul] */
    HWM_TIMEZONE_SEOUL = 61,
	/**<[en]Indicates Yakutsk [cn]雅库茨克 [ios:rename:Yakutsk] */
    HWM_TIMEZONE_YAKUTSK = 62,
	/**<[en]Indicates Adelaide [cn]阿德莱德 [ios:rename:Adelaide] */
    HWM_TIMEZONE_ADELAIDE = 63,
	/**<[en]Indicates Darwin [cn]达尔文 [ios:rename:Darwin] */
    HWM_TIMEZONE_DARWIN = 64,
	/**<[en]Indicates Brisbane [cn]布里斯班 [ios:rename:Brisbane] */
    HWM_TIMEZONE_BRISBANE = 65,
	/**<[en]Indicates Canberra, Melbourne, Sydney [cn]堪培拉，墨尔本，悉尼 [ios:rename:Canberra] */
    HWM_TIMEZONE_CANBERRA = 66,
	/**<[en]Indicates Guam, Port Moresby [cn]关岛，莫尔兹比港 [ios:rename:Guam] */
    HWM_TIMEZONE_GUAM = 67,
	/**<[en]Indicates Hobart [cn]霍巴特 [ios:rename:Hobart] */
    HWM_TIMEZONE_HOBART = 68,
	/**<[en]Indicates Vladivostok [cn]符拉迪沃斯托克 [ios:rename:Vladivostok] */
    HWM_TIMEZONE_VLADIVOSTOK = 69,
	/**<[en]Indicates Solomon Is., New Caledonia [cn]所罗门群岛，新喀里多尼亚 [ios:rename:Solomon] */
    HWM_TIMEZONE_SOLOMON = 70,
	/**<[en]Indicates Auckland, Welington [cn]奥克兰，惠灵顿 [ios:rename:Auckland] */
    HWM_TIMEZONE_AUCKLAND = 71,
	/**<[en]Indicates Fiji, Kamchatka, Marshall Is. [cn]富士，堪察加半岛，马绍尔群岛 [ios:rename:Fiji] */
    HWM_TIMEZONE_FIJI = 72,
	/**<[en]Indicates Nuku'alofa [cn]努库阿洛法 [ios:rename:Nukualofa] */
    HWM_TIMEZONE_NUKUALOFA = 73,
	/**<[en]Indicates Irkutsk [cn]伊尔库茨克 [ios:rename:Irkutsk] */
    HWM_TIMEZONE_IRKUTSK = 74,
	/**<[en]Indicates Casablanca [cn]卡萨布兰卡 [ios:rename:Casablanca] */
    HWM_TIMEZONE_CASABLANCA = 75,
	/**<[en]Indicates Baku [cn]巴库 [ios:rename:Baku] */
    HWM_TIMEZONE_BAKU = 76,
	/**<[en]Indicates Magadan [cn]马加丹 [ios:rename:Magadan] */
    HWM_TIMEZONE_MAGADAN = 77,
};

/**
* [en]This enum is used to describe conference state. [cn]会议状态
*/
export enum ConfState{
	/**<[en]Indicates schedule state [cn]预定状态。 */
    HWM_CONF_STATE_SCHEDULE = 0,
	/**<[en]Indicates be creating state [cn]正在创建状态。 */
    HWM_CONF_STATE_CREATING = 1,
	/**<[en]Indicates conf going state [cn]会议已经开始。 */
    HWM_CONF_STATE_GOING = 2,
	/**<[en]Indicates conf is destroyed [cn]会议已经关闭。 */
    HWM_CONF_STATE_DESTROYED = 3,
};

/**
* [en]Indicates conference type. [cn]会议类型
*/
export enum ConferenceType{
	/**<[en]Indicates common conference. [cn]普通会议 */
    HWM_CONF_TYPE_COMMON = 0,
	/**<[en]Indicates cycle conference. [cn]周期会议 */
    HWM_CONF_TYPE_CYCLE = 1,
};

/**
* [en]Record auth type. [cn]录播鉴权方式
*/
export enum RecordAuthType{
	/**<[en] [cn]可通过连接观看/下载（不拼接nonce） */
    REOCRD_AUTH_TYPE_ANYONE = 0,
	/**<[en] [cn]企业用户可观看/下载 */
    REOCRD_AUTH_TYPE_IN_COMPANY_USER = 1,
	/**<[en] [cn]与会者可观看/下载 */
    REOCRD_AUTH_TYPE_ATTENDEE = 2,
};

/**
* [en]cycle type. [cn]周期类型
*/
export enum CycleType{
	/**<[en]Indicates cycle by day. [cn]以天为周期 */
    CYCLE_TYPE_DAY = 0,
	/**<[en]Indicates cycle by week. [cn]以周为周期 */
    CYCLE_TYPE_WEEK = 1,
	/**<[en]Indicates cycle by month. [cn]以月为周期 */
    CYCLE_TYPE_MONTH = 2,
};

/**
* [en]vmr id type. [cn]vmr id类型
*/
export enum VmrIdType{
	/**<[en]random meeting id [cn]随机会议id */
    RANDOM_MEETING_ID = 0,
	/**<[en] personal meeting id [cn]个人会议id */
    PERSONAL_MEETING_ID = 1,
	/**<[en]vmr meeting id [cn]云会议室id */
    CLOUD_MEETING_ROOM_ID = 2,
};

/**
* [en]This structure is used to describe corp type [cn]企业类型
*/
export enum CorpType{
	/**<[en]Enterprise version, also known as flagship version. [cn]企业版，即旗舰版 */
    HWM_CORP_TYPE_ENTERPRISE = 0,
	/**<[en]Public enterprises, phone or email user. [cn]公共企业，手机、邮箱注册时会放到该企业内 */
    HWM_CORP_TYPE_PUBLIC_REGISTER = 1,
	/**<[en]Public enterprises, smart screens user. [cn]公共企业，智慧屏用户自动开户时会放到该企业内 */
    HWM_CORP_TYPE_PUBLIC_VISION = 2,
	/**<[en]Public enterprises, board user. [cn]公共企业，大屏用户自动开户时会放到该企业内 */
    HWM_CORP_TYPE_PUBLIC_WHITE_BOARD = 3,
	/**<[en]Public TOC Consumers. [cn]公共TOC消费者企业 */
    HWM_CORP_TYPE_PUBLIC_CONSUMER = 4,
	/**<[en]Free version. [cn]免费版 */
    HWM_CORP_TYPE_FREE = 5,
	/**<[en]Professional version, also known as Flexus version. [cn]专业版, 即Flexus版 */
    HWM_CORP_TYPE_PROFESSIONAL = 6,
};

/**
* [en]Conf coming state. [cn]来电状态类型
*/
export enum ConfComingState{
	/**<[en]Init state [cn]初始状态，来电振铃中。 */
    HWM_CONF_COMING_STATE_START = 1,
	/**<[en]Accept state [cn]接听状态，已接听来电。 */
    HWM_CONF_COMING_STATE_ACCEPT = 2,
	/**<[en]Reject state [cn]拒绝状态，已拒绝来电。 */
    HWM_CONF_COMING_STATE_REJECT = 3,
	/**<[en]Timeout state [cn]未响应状态，呼叫超时或者主叫已挂断。 */
    HWM_CONF_COMING_STATE_TIMEOUT = 4,
};

/**
* [en]This struct is used to describe the status of low net work [cn]网络状态
*/
export enum LowNetWorkStatus{
	/**<[en]Indicates staus normal [cn]网络正常 */
    LOW_NET_WORK_STATUS_NORMAL = 0,
	/**<[en]Indicates staus bad [cn]网络差 */
    LOW_NET_WORK_STATUS_BAD = 1,
	/**<[en]Indicates staus very bad [cn]网络非常差 */
    LOW_NET_WORK_STATUS_VERY_BAD = 2,
};

/**
* [en]watch item param [cn]选看入参
*/
export enum WndType{
	/**<[en]Normal window [cn]普通窗口 */
    HWM_WND_TYPE_NORMAL = 0,
	/**<[en]Main window [cn]主要窗口 */
    HWM_WND_TYPE_MAIN = 1,
};

/**
* [en]Stream type [cn]流类型
*/
export enum StreamType{
	/**<[en]No stream [cn]没有流 [ios:rename:none] */
    STREAM_TYPE_NONE = 0,
	/**<[en]Picture stream [cn]图片流 [ios:rename:picture] */
    STREAM_TYPE_PICTURE = 1,
	/**<[en]Video stream [cn]视频流 [ios:rename:video] */
    STREAM_TYPE_VIDEO = 2,
};

/**
* [en]This enum is used to describe share state [cn] 数据共享状态
*/
export enum ShareState{
	/**<[en]Indicates no one is sharingh [cn]非数据共享状态 */
    CONF_SHARE_STATE_CLOSE = 0,
	/**<[en]Indicates some one is sharing [cn]数据共享状态 */
    CONF_SHARE_STATE_OPEN = 1,
};

/**
* [en]This enum is used to describe conference recording mode. [cn]会议录制模式
*/
export enum ConfRecordMode{
	/**<[en]Indicates disable record [cn]禁止录制 */
    CONF_RECORD_DISABLE = 0,
	/**<[en]Indicates live [cn]直播模式 */
    CONF_RECORD_LIVE = 1,
	/**<[en]Indicates record broadcast [cn]录播模式 */
    CONF_RECORD_RECORD = 2,
	/**<[en]Indicates live broadcast and record broadcast [cn]直播 + 录播模式 */
    CONF_RECORD_LIVE_AND_RECORD = 3,
};

/**
* [en]This enum is used to describe conference IM mode. [cn]会中聊天模式
*/
export enum ConfIMType{
	/**<[en]Indicates use welink-rtm. [cn]使用welink-rtm实现会中聊天 */
    CONF_IM_TYPE_RTM = 0,
	/**<[en]Indicates use conf im. [cn]使用会控自带IM实现会中聊天 */
    CONF_IM_TYPE_CIM = 1,
};

/**
* [en]This enum is used to describe create conference model [cn] 创建会议model
*/
export enum ConfCreateMode{
	/**<[en]Indicates default [cn]默认 */
    CONF_CREATE_MODE_DEFAULT = 0,
	/**<[en]Indicates p2p transfer to conf [cn]点对点转会议 */
    CONF_CREATE_MODE_P2PTransToConf = 1,
	/**<[en]Indicates mmr p2p transfer to conf [cn]mmr点对点转会议 */
    CONF_CREATE_MODE_MmrP2PTransToConf = 2,
	/**<[en]Indicates mmr p2p. [cn]mmr点对点 */
    CONF_CREATE_MODE_MMR_P2P = 3,
	/**<[en]Indicates local project. [cn]本地投屏 */
    CONF_CREATE_MODE_LOCAL_PROJECT = 4,
};

/**
* [en]This enum is used to describe the status of local record. [cn]本地录制状态
*/
export enum LocalRecordStatus{
	/**<[en]Indicates start local record [cn]开始本地录制 */
    LOCAL_RECORD_STATUS_START = 0,
	/**<[en]Indicates stopped local record [cn]停止本地录制 */
    LOCAL_RECORD_STATUS_STOPPED = 1,
	/**<[en]Indicates paused local record [cn]暂停本地录制 */
    LOCAL_RECORD_STATUS_PAUSED = 2,
	/**<[en]Indicates resumed local record [cn]恢复本地录制 */
    LOCAL_RECORD_STATUS_RESUMED = 3,
};

/**
* [en]This enum is used to describe the operate of local record. [cn]本地录制操作类型
*/
export enum LocalRecordOperateType{
	/**<[en]Indicates start local record [cn]开始本地录制 */
    LOCAL_RECORD_OPERATE_TYPE_START = 0,
	/**<[en]Indicates stopped local record [cn]停止本地录制 */
    LOCAL_RECORD_OPERATE_TYPE_STOP = 1,
	/**<[en]Indicates paused local record [cn]暂停本地录制 */
    LOCAL_RECORD_OPERATE_TYPE_PAUSE = 2,
	/**<[en]Indicates resumed local record [cn]恢复本地录制 */
    LOCAL_RECORD_OPERATE_TYPE_RESUME = 3,
};

/**
* [en]This enumeration is used to describe the subtitle translation language type. [cn]字幕翻译语言类型
*/
export enum TargetLanguageType{
	/**<[en]Indicates is default lan. [cn]默认不翻译 */
    SUBTITLE_LANGUAGE_DEFAULT = 0,
	/**<[en]Indicates is Chinese lan. [cn]中文 */
    SUBTITLE_LANGUAGE_CN = 1,
	/**<[en]Indicates is English lan. [cn]英文 */
    SUBTITLE_LANGUAGE_EN = 2,
	/**<[en]Indicates is Germany lan. [cn]德文 */
    SUBTITLE_LANGUAGE_GE = 3,
	/**<[en]Indicates is French lan. [cn]法语 */
    SUBTITLE_LANGUAGE_FR = 4,
	/**<[en]Indicates is Russian lan. [cn]俄语 */
    SUBTITLE_LANGUAGE_RU = 5,
	/**<[en]Indicates is Japanese lan. [cn]日语 */
    SUBTITLE_LANGUAGE_JA = 6,
	/**<[en]Indicates is Korean lan. [cn]韩语 */
    SUBTITLE_LANGUAGE_KO = 7,
	/**<[en]Indicates is Spanish lan. [cn]西班牙语 */
    SUBTITLE_LANGUAGE_ES = 8,
	/**<[en]Indicates is Portuguese lan. [cn]葡萄牙语 */
    SUBTITLE_LANGUAGE_PT = 9,
	/**<[en]Indicates is Arabic lan. [cn]阿拉伯语 */
    SUBTITLE_LANGUAGE_AR = 10,
	/**<[en]Indicates is Italian lan. [cn]意大利语 */
    SUBTITLE_LANGUAGE_IT = 11,
	/**<[en]Indicates is Thai lan. [cn]泰语 */
    SUBTITLE_LANGUAGE_TH = 12,
	/**<[en]Indicates is Indonesian lan. [cn]印度尼西亚语 */
    SUBTITLE_LANGUAGE_ID = 13,
	/**<[en]Indicates is Malay lan. [cn]马来语 */
    SUBTITLE_LANGUAGE_MS = 14,
	/**<[en]Indicates is Turkish lan. [cn]土耳其语 */
    SUBTITLE_LANGUAGE_TR = 15,
};

/**
* [en]This enumeration is used to describe the interrupt type. [cn]中断类型
*/
export enum InterruptType{
	/**<[en]Indicates select save path [cn]选择录制文件存放地址 */
    SELECT_SAVE_PATH = 0,
	/**<[en]Indicates risk tip confirm [cn]开启安全录制提示 */
    RISK_TIP = 1,
	/**<[en]Indicates influence record for gallery [cn]画廊模式录制效果不佳，需切换到演讲者视图 */
    INFLUENCE_RECORD_FOR_GALLERY = 2,
	/**<[en]Indicates save path not writeable [cn]路径无写入权限 */
    SAVE_PATH_NOT_WRITEABLE = 3,
	/**<[en]Indicates save temp record file [cn]保留临时录制文件提示 */
    SAVE_TEMP_RECORD_FILE = 4,
	/**<[en]Indicates hdcloud performance consumption confirm [cn]云桌面会增加性能消耗 */
    HDCLOUD_PERFORMANCE_CONSUMPTION = 5,
	/**<[en]Indicates no speaker device [cn]无扬声器设备 */
    NO_SPEAKER_DEVICE = 6,
};

/**
* [en]This enum is used to describe forbidden screen shots type. [cn]禁止截屏类型
*/
export enum ForbiddenScreenShotsEnableType{
	/**<[en]Off [cn]关闭 */
    FORBIDDEN_SCREEN_SHOTS_ENABLE_TYPE_OFF = 0,
	/**<[en]On [cn]开启 */
    FORBIDDEN_SCREEN_SHOTS_ENABLE_TYPE_ON = 1,
	/**<[en]Forced on [cn]强制开启 */
    FORBIDDEN_SCREEN_SHOTS_ENABLE_TYPE_FORCED_ON = 2,
};

/**
* [en]Call state [cn]通话状态
*/
export enum CallState{
	/**<[en]Idle state [cn]空闲状态 */
    HWM_CALL_STATE_IDLE = 0,
	/**<[en]Busy state [cn]忙碌状态 */
    HWM_CALL_STATE_BUSY = 1,
};

/**
* [en]Call end reason. [cn]通话结束原因
*/
export enum CallEndReason{
	/**<[en]Hangup by caller(connected) [cn]主叫挂断（接通） */
    HWM_CALL_END_REASON_CONNECTED_HANGUP_BY_CALLER = 1,
	/**<[en]Hangup by callee(connected) [cn]被叫挂断（接通） */
    HWM_CALL_END_REASON_CONNECTED_HANGUP_BY_CALLEE = 2,
	/**<[en]Hangup by caller(unconnected) [cn]主叫挂断（未接通） */
    HWM_CALL_END_REASON_HANGUP_BY_CALLER = 3,
	/**<[en]Hangup by callee(unconnected) [cn]被叫挂断（未接通） */
    HWM_CALL_END_REASON_HANGUP_BY_CALLEE = 4,
	/**<[en]Callee is busy(unconnected) [cn]被叫通话中（未接通） */
    HWM_CALL_END_REASON_CALLEE_BUSY = 5,
	/**<[en]Callee no answer(unconnected) [cn]被叫超时未接听（未接通） */
    HWM_CALL_END_REASON_CALLEE_ANSWER_TIMEOUT = 6,
	/**<[en]Callee number error(unconnected) [cn]被叫号码错误（未接通） */
    HWM_CALL_END_REASON_CALLEE_NUMBER_ERROR = 7,
	/**<[en]Call fail [cn]通话失败 */
    HWM_CALL_END_REASON_FAILED = 8,
};

/**
* [en]Capability type. [cn]功能类型
*/
export enum CapabilityType{
	/**<[en]Show hangup attendee switch(only for windows) [cn]显示离会与会者开关(仅对win平台生效) */
    HWM_CAPABILITY_TYPE_SHOW_HANGUP_ATTENDEE = 0,
	/**<[en]Hide external label [cn]隐藏外部标签 */
    HWM_CAPABILITY_TYPE_HIDE_EXTERNAL_LABEL = 1,
	/**<[en]1080P resolution switch(only for windows) [cn]1080P开关(仅对win平台生效) [mac:disable] */
    HWM_CAPABILITY_TYPE_RESOLUTION_1080P = 2,
	/**<[en]720p resolution switch(only for mac) [cn]720p开关(仅对mac平台生效) [win:disable] */
    HWM_CAPABILITY_TYPE_RESOLUTION_720P = 3,
	/**<[en]Multi-monitor switch(only for windows) [cn]多显示器模式开关(仅对win平台生效) [mac:disable] */
    HWM_CAPABILITY_TYPE_MULTI_MONITOR = 4,
	/**<[en]Howling detection switch(only for windows) [cn]啸叫检测开关(仅对win平台生效) [mac:disable] */
    HWM_CAPABILITY_TYPE_HOWLING_DETECTION = 5,
	/**<[en]Automatic microphone volume adjustment switch(only for windows) [cn]自动调节麦克风音量开关(仅对win平台生效) [mac:disable] */
    HWM_CAPABILITY_AUTO_MIC_VOLUME = 6,
	/**<[en]Share audio switch [cn]共享音频开关 */
    HWM_CAPABILITY_SHARE_AUDIO = 7,
	/**<[en]hide no Camera view(only for mac) [cn]隐藏非视频与会者开关(仅对mac平台生效) [win:disable] */
    HWM_CAPABILITY_HIDE_NO_CAMERA_VIEW = 8,
	/**<[en]Breakout conf switch [cn]分组讨论开关 */
    HWM_CAPABILITY_BREAKOUT_CONF = 9,
	/**<[en]recording confirm [cn]录制确认 */
    HWM_CAPABILITY_CONFIRM_RECORD = 10,
	/**<[en]Voiceprint noise reduce [cn]声纹降噪(仅对win平台生效) [mac:disable] [doc:disable] */
    HWM_CAPABILITY_VOICEPRINT_NOISE_REDUCE = 11,
	/**<[en]Support Disconnect audio [cn]支持断开音频功能(仅对win平台生效) [mac:disable] */
    HWM_CAPABILITY_SUPPORT_DISCONNECT_AUDIO = 12,
	/**<[en]Disconnect audio to join conf [cn]是否断开音频入会(仅对win平台生效) [mac:disable] */
    HWM_CAPABILITY_DISCONNECT_AUDIO_TO_JOIN_CONF = 13,
	/**<[en]CPU frequency reduction detection [cn]是否启用CPU降频检测 [mac:disable] */
    HWM_CAPABILITY_CPU_REDUCTION_DETECT = 14,
	/**<[en]Config without main frame [cn]配置无主界面 [doc:disable] */
    HWM_CAPABILITY_WITHOUT_MAIN_FRAME = 15,
	/**<[en]Is support guest invite. [cn]是否支持与会者邀请 */
    HWM_CAPABILITY_SUPPORT_GUEST_INVITE = 16,
	/**<[en]Hide invite result toast. [cn]是否隐藏与会者邀请结果提示 */
    HWM_CAPABILITY_HIDE_INVITE_RESULT_TOAST = 17,
	/**<[en]Is support auto accept remote control. [cn]是否支持自动接受远程控制(仅对win平台生效) */
    HWM_CAPABILITY_SUPPORT_AUTO_ACCEPT_REMOTE_CONTROL = 18,
	/**<[en]Is support hide the unjoined conference tab in the participant list. [cn]是否支持隐藏与会者列表未入会标签 */
    HWM_CAPABILITY_SUPPORT_HIDE_OFFLINE_PARTICIPANT_LIST = 19,
	/**<[en]Hide virtual background risk tip. [cn]是否隐藏虚拟背景隐私风险提示 */
    HWM_CAPABILITY_HIDE_VB_RISK_TIP = 20,
	/**<[en]Is conf end show tips [cn]是否会议结束显示提示 */
    HWM_CAPABILITY_CONF_END_SHOW_TIPS = 21,
};

/**
* [en]Save path type [cn]用户文件保存路径枚举
*/
export enum SavePathType{
	/**<[en]record save path [cn]本地录制文件保存路径 */
    HWM_SAVE_PATH_LOCAL_RECORD = 0,
};

/**
* [en]share strategy type [cn]屏幕共享策略类型
*/
export enum ShareStrategyType{
	/**<[en]definition first [cn]清晰度优先 */
    HWM_SHARE_STRATEGY_DEFINITION_FIRST = 0,
	/**<[en]fluency first [cn]流畅度优先 */
    HWM_SHARE_STRATEGY_FLUENCY_FIRST = 1,
	/**<[en]definition and fluency [cn]清晰且流畅模式，注：有带宽压力，三方自行保证 [doc:disable] */
    HWM_SHARE_STRATEGY_DEFINITION_AND_FLUENCY = 2,
};

/**
* [en]Incoming answer type [cn]来电应答类型
*/
export enum InComingAnswerType{
	/**<[en]incoming answer normal [cn]默认，来电时弹出来电接听界面 */
    HWM_INCOMING_ANSWER_NORMAL = 0,
	/**<[en]incoming answer decline [cn]来电时拒接 */
    HWM_INCOMING_ANSWER_DECLINE = 1,
	/**<[en]incoming answer answer [cn]来电时接听 */
    HWM_INCOMING_ANSWER_ANSWER = 2,
	/**<[en]incoming answer custom [cn]来电时自定义弹框 */
    HWM_INCOMING_ANSWER_CUSTOM = 3,
};

/**
* [en]16-bit precision PCM. [cn]16位精度PCM
*/
export enum AudioFrameType{
	/**<[en]PCM16 frame type. [cn]PCM16音频帧类型 */
    HWM_AUDIO_FRAME_TYPE_PCM16 = 0,
};

/**
* [en]WaterMark font color. [cn]水印字体颜色
*/
export enum WaterMarkColorType{
	/**<[en]light color [cn]浅色 #CCCCCC */
    HWM_WATERMARK_COLOR_TYPE_LIGHT = 0,
	/**<[en]standard color [cn]标准色 #999999 */
    HWM_WATERMARK_COLOR_TYPE_STANDARD = 1,
	/**<[en]dark color [cn]深色 #666666 */
    HWM_WATERMARK_COLOR_TYPE_DARKER = 2,
};

/**
* [en]Window handle type [cn]窗口句柄的类型
*/
export enum HwndType{
	/**<[en]The handle type of window is video. [cn]窗口句柄的类型为视频 */
    VIDEO_WND_TYPE = 0,
	/**<[en]The handle type of window is screen's ID. [cn]窗口句柄的类型为屏幕ID */
    SCREEN_ID = 1,
	/**<[en]The handle type of window is share render. [cn]窗口句柄的类型为共享渲染类型 */
    SHARE_RENDER = 2,

    HWND_BUTT_TYPE = 3,
};

/**
* [en]Window handle type [cn]窗口句柄的类型
*/
export enum HandleType{
	/**<[en]The handle type is view. [cn]窗口句柄的类型为view */
    HWM_HANDLE_VIEW = 0,
	/**<[en]The handle type is windowID. [cn]窗口句柄的类型为屏幕ID */
    HWM_HANDLE_WINDOW = 1,
};

/**
* [en]Window view type [cn]窗口视图的类型
*/
export enum ViewType{
	/**<[en]The view type is video, the handle type is view. [cn]视图的类型为视频 句柄类型为view */
    HWM_VIEW_Video = 0,
	/**<[en]The view type is shared whiteboard, the handle type is view. [cn]视图的类型为共享白板 句柄类型为view */
    HWM_VIEW_SHARE_WHITE_BOARD = 1,
	/**<[en]The view type is screen share recv, the handle type is view. [cn]视图的类型为共享屏幕接收 句柄类型为view */
    HWM_VIEW_SHARE_SCREEN_RECV = 2,
	/**<[en]The view type is screen share send, the handle type is windowID. [cn]视图的类型为共享屏幕发送 句柄类型为windowID */
    HWM_VIEW_SHARE_SCREEN_SEND = 3,
};

/**
* [en]Click inject button type. [cn]点击注入按钮类型
*/
export enum ClickInjectBtn{
	/**<[en]Invite button [cn]邀请按钮 */
    HWM_CLICK_INJECT_BTN_INVITE = 0,
	/**<[en]Show attendees button [cn]与会者按钮 */
    HWM_CLICK_INJECT_BTN_ATTENDEE = 1,
	/**<[en]Show chat button [cn]聊天按钮 */
    HWM_CLICK_INJECT_BTN_CHAT = 2,
	/**<[en]Share button [cn]共享按钮 */
    HWM_CLICK_INJECT_BTN_SHARE = 3,
	/**<[en]Leave conf button [cn]离开会议按钮 */
    HWM_CLICK_INJECT_BTN_LEAVE = 4,
	/**<[en]User Custome button [cn]用户自定义按钮 */
    HWM_CLICK_INJECT_BTN_CUSTOM = 5,
	/**<[en]Guest Invite button [cn]来宾邀请按钮 */
    HWM_CLICK_INJECT_BTN_GUEST_INVITE = 6,
	/**<[en]Feedback button [cn]反馈按钮 */
    HWM_CLICK_INJECT_BTN_FEEDBACK = 7,
	/**<[en]Copy conf info button [cn]复制会议信息按钮 */
    HWM_CLICK_INJECT_BTN_COPY_CONF_INFO = 8,
	/**<[en]Copy Audience conf info button [cn]复制观众会议信息按钮 */
    HWM_CLICK_INJECT_BTN_COPY_AUDIENCE_CONF_INFO = 9,
	/**<[en]"Call All" Button at participant list [cn]与会者列表“全部呼叫”按钮 */
    HWM_CLICK_INJECT_BTN_CALL_ALL = 10,
};

/**
* [en]Click inject participant item button type. [cn]点击注入与会者列表子项按钮类型
*/
export enum ClickInjectParticipantItemBtn{
	/**<[en]Call other number button [cn]呼叫其他号码按钮 */
    HWM_CLICK_INJECT_PARTICIPANT_ITEM_BTN_CALL_OTHER_NUM = 0,
	/**<[en]Participant detail button [cn]查看与会者详情 */
    HWM_CLICK_INJECT_PARTICIPANT_ITEM_BTN_PARTICIPANT_DETAIL = 1,
	/**<[en]Recall button [cn]重新呼叫按钮 */
    HWM_CLICK_INJECT_PARTICIPANT_ITEM_BTN_RECALL = 2,
};

/**
* [en] Setting page [cn] 设置界面页签
*/
export enum SettingPage{
	/**<[en]Normal setting page. [cn]基本设置页 */
    SETTING_PAGE_NORMAL = 0,
	/**<[en]Video setting page. [cn]视频设置页 */
    SETTING_PAGE_VIDEO = 1,
	/**<[en]Audio setting page. [cn]音频设置页 */
    SETTING_PAGE_AUDIO = 2,
	/**<[en]Record setting page. [cn]录制设置页 */
    SETTING_PAGE_RECORD = 3,
	/**<[en]Hotkey setting page. [cn]快捷键设置页 */
    SETTING_PAGE_HOTKEY = 4,
	/**<[en]Screen setting page. [cn]屏幕设置页 */
    SETTING_PAGE_SCREEN = 5,
	/**<[en]Count of setting pages. [cn]设置页数量 */
    SETTING_PAGE_COUNT = 6,
};

/**
* [en]Entry of show voiceprint statement. [cn]打开声纹降噪功能声明的入口
*/
export enum VoiceprintStatementEntry{
	/**<[en]Indicates check statement [cn]点击"功能声明"打开 */
    VOICEPRINT_STATEMENT_ENTRY_CHECK_STATEMENT = 0,
	/**<[en]Indicates open voiceprint noise reduce [cn]点击"声纹降噪"打开 */
    VOICEPRINT_STATEMENT_ENTRY_OPEN_NOISE_REDUCE = 1,
};

/**
* [en]This structure is used to describe custom text scene. [cn]自定义文案场景
*/
export enum UICustomTextScene{
	/**<[en]Cloud Record Finished Alert [cn]会中主动结束云录制场景 */
    CLOUD_RECORD_FINISHED_ALERT_SCENE = 0,
	/**<[en]Cloud Record Finished Alert In Meeting(only for mac) [cn]以离会方式结束云录制场景(仅对mac平台生效) [win:disable] */
    CLOUD_RECORD_FINISHED_ALERT_IM_SCENE = 1,
	/**<[en]Cloud recording title in the recording pop-up menu [cn]录制弹框菜单中的云录制标题(仅对win平台生效) [mac:disable] */
    CLOUD_RECORD_MENU_TITLE_TEXT_SCENE = 2,
	/**<[en]Cloud recording description in the recording pop-up menu [cn]录制弹框菜单中的云录制描述(仅对win平台生效) [mac:disable] */
    CLOUD_RECORD_MENU_DES_TEXT_SCENE = 3,
	/**<[en]Cloud recording description in the main window [cn]主窗口中的云录制描述(仅对win平台生效) [mac:disable] */
    MAIN_WINDOW_CLOUD_RECORD_DES_TEXT_SCENE = 4,
};

/**
* [en]Custom image scene. [cn]自定义图标场景
*/
export enum UICustomImageScene{
	/**<[en]Cloud record image [cn]会中云录制主图标（云录制菜单弹框、与会者列表、共享工具条） */
    CLOUD_RECORD_ICON_IMAGE_SCENE = 0,
	/**<[en]Main window cloud record icon [cn]主窗口云录制ICON小图标 */
    MAIN_WINDOW_CLOUD_RECORD_ICON_SCENE = 1,
	/**<[en]Main window cloud record logo [cn]主窗口云录制LOGO大图标 */
    MAIN_WINDOW_CLOUD_RECORD_LOGO_SCENE = 2,
};

/**
* [en]Name show type. [cn]姓名显示风格
*/
export enum NameShowType{
	/**<[en]First letter [cn]显示拼音首字母 */
    FIRST_LETTER = 0,
	/**<[en]Family name [cn]显示姓氏 */
    FAMILY_NAME = 1,
};

/**
* [en]Avatar shape. [cn]头像形状
*/
export enum AvatarShape{
	/**<[en]Circle [cn]圆形头像 */
    CIRCLE = 0,
};

/**
* [en]Setting vrbk default image mode [cn]设置自定义虚拟背景默认图模式
*/
export enum SettingVrbkDefaultImageMode{
	/**<[en]Replace all [cn]全部替换, 覆盖内置的默认图片 */
    HWM_SETTING_VRBK_DEFAULT_IMAGE_MODE_REPLACE_ALL = 0,
	/**<[en]Append [cn]基于内置的默认图片追加 */
    HWM_SETTING_VRBK_DEFAULT_IMAGE_MODE_APPEND = 1,
};

/**
* [en]server site type. [cn]服务站点类型
*/
export enum SiteType{
	/**<[en]site of China [cn]国内站点 */
    HWM_SITE_TYPE_CHINA = 0,
	/**<[en]site of Asia [cn]亚太站点 */
    HWM_SITE_TYPE_AP = 1,
};

/**
* [en]Log level. [cn]日志级别
*/
export enum LogLevel{
	/**<[en]Info level [cn]信息（一般）级别 */
    HWM_LOG_LEVEL_INFO = 0,
	/**<[en]Warning level [cn]警告级别 */
    HWM_LOG_LEVEL_WARNING = 1,
	/**<[en]Info level [cn]错误级别 */
    HWM_LOG_LEVEL_ERROR = 2,
};

