import { SavePathType, SDKERR } from './enum';
import { AudioFrameData, AudioRawDataConfigInfo, CapabilityInfo, CustomSceneImageInfoList, CustomSceneTextInfoList, DeviceConfig, DeviceCtrlInfo, DeviceStateInfo, ErrorMessageInfo, InComingAnswerTypeInfo, LanguageInfo, LogPathInfo, PstnAccessNumberInfo, SharePermission, ShareStrategyInfo, ShowVoiceprintStatementInfo, TransparentWndInfo, UserSavePathInfo, VirtualBackgroundInfo, VoicePromptsInfo } from './model';
export declare class IConfig {
    addOn: IConfig;
    _onAVDeviceCtrlStateChangedCallback: (info: DeviceStateInfo) => void;
    _onAudioFrameNotifyCallback: (audioFrameData: AudioFrameData) => void;
    _onShowVoiceprintStatementCallback: (info: ShowVoiceprintStatementInfo) => void;
    _onUserSavePathChangedCallback: (userSavePathInfo: UserSavePathInfo) => void;
    _enableCapabilityCallback: (ret: SDKERR, reason: string) => void;
    _setLanguageCallback: (ret: SDKERR, reason: string) => void;
    _setUserSavePathCallback: (ret: SDKERR, reason: string) => void;
    _getUserSavePathCallback: (ret: SDKERR, reason: string, pathInfo: UserSavePathInfo) => void;
    _setShareStrategyCallback: (ret: SDKERR, reason: string) => void;
    _setAudioRawDataOutputConfigCallback: (ret: SDKERR, reason: string) => void;
    _setAnswerTypeCallback: (ret: SDKERR, reason: string) => void;
    _setDeviceConfigForConfIncomingCallback: (ret: SDKERR, reason: string) => void;
    _getConfPstnAccessNumberCallback: (ret: SDKERR, reason: string, pstnAccessNumberInfo: PstnAccessNumberInfo) => void;
    _aVDeviceCtrlCallback: (ret: SDKERR, reason: string, deviceCtrlInfo: DeviceCtrlInfo) => void;
    _disableVoicePromptsCallback: (ret: SDKERR, reason: string) => void;
    _setShareScreenPermissionCallback: (ret: SDKERR, reason: string) => void;
    _agreeVoiceprintStatementCallback: (ret: SDKERR, reason: string) => void;
    _showVoiceprintRecordWindowCallback: (ret: SDKERR, reason: string) => void;
    _setLogPathCallback: (ret: SDKERR, reason: string) => void;
    _setTransparentWndCallback: (ret: SDKERR, reason: string) => void;
    _setCustomUITextCallback: (ret: SDKERR, reason: string) => void;
    _setCustomUIImageCallback: (ret: SDKERR, reason: string) => void;
    _setVirtualBackgroundDefaultImagesCallback: (ret: SDKERR, reason: string) => void;
    _inProcessCallbackSet: Set<string>;
    callWithIPC: boolean;
    constructor(addOn: IConfig);
    init(): void;
    /**
    * [en] Notify of AVDevice control state [cn] 音视频设备控制状态变化通知
    */
    setOnAVDeviceCtrlStateChangedCB(onAVDeviceCtrlStateChanged: (info: DeviceStateInfo) => void): void;
    /**
    * [en] Notify of audio famme [cn] 上报音频码流帧数据通知
    */
    setOnAudioFrameNotifyCB(onAudioFrameNotify: (audioFrameData: AudioFrameData) => void): void;
    /**
    * [en] Notify of show voiceprint statement [cn] 声纹降噪功能声明显示通知
    */
    setOnShowVoiceprintStatementCB(onShowVoiceprintStatement: (info: ShowVoiceprintStatementInfo) => void): void;
    /**
    * [en] User data path change notification [cn] 用户数据路径变化通知
    */
    setOnUserSavePathChangedCB(onUserSavePathChanged: (userSavePathInfo: UserSavePathInfo) => void): void;
    /**
    * [en] This interface is used to enable capability [cn] 功能配置开关
    */
    enableCapability(capabilityInfo: CapabilityInfo, onEnableCapabilityResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set language. [cn] 设置语言
    */
    setLanguage(languageInfo: LanguageInfo, onSetLanguageResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set file save path. [cn] 设置用户保存路径
    */
    setUserSavePath(userSavePathInfo: UserSavePathInfo, onSetUserSavePathResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to get file save path. [cn] 获取用户保存路径
    */
    getUserSavePath(pathType: SavePathType, onGetUserSavePathResult?: (ret: SDKERR, reason: string, pathInfo: UserSavePathInfo) => void): void;
    /**
    * [en] This interface is used to set share strategy. [cn] 设置共享策略
    */
    setShareStrategy(shareStrategyInfo: ShareStrategyInfo, onSetShareStrategyResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set audio raw data output config. [cn] 设置开启或关闭音频码流
    */
    setAudioRawDataOutputConfig(audioRawDataConfigInfo: AudioRawDataConfigInfo, onSetAudioRawDataOutputConfigResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set call incoming answer type. [cn] 设置来电应答方式
    */
    setAnswerType(inComingAnswerTypeInfo: InComingAnswerTypeInfo, onSetAnswerTypeResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set device config for conf incoming. [cn] 会议来电时设备开关配置
    */
    setDeviceConfigForConfIncoming(deviceConfig: DeviceConfig, onSetDeviceConfigForConfIncomingResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to get conf pstn access number. [cn] 获取会议pstn接入号码
    */
    getConfPstnAccessNumber(onGetConfPstnAccessNumberResult?: (ret: SDKERR, reason: string, pstnAccessNumberInfo: PstnAccessNumberInfo) => void): void;
    /**
    * [en] This interface is used to AVDeviceCtrl. [cn] 音视频设备控制功能
    */
    aVDeviceCtrl(deviceStateInfo: DeviceStateInfo, onAVDeviceCtrlResult?: (ret: SDKERR, reason: string, deviceCtrlInfo: DeviceCtrlInfo) => void): void;
    /**
    * [en] This interface is used to disable voice prompts. [cn] 禁用提示音
    */
    disableVoicePrompts(voicePromptsInfo: VoicePromptsInfo, onDisableVoicePromptsResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set share permission. [cn] 设置共享权限
    */
    setShareScreenPermission(permission: SharePermission, onSetShareScreenPermissionResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set voiceprint statement agreement. [cn] 签署声纹功能声明
    */
    agreeVoiceprintStatement(isAgreed: boolean, onAgreeVoiceprintStatementResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to show voiceprint record window. [cn] 显示声纹录入窗口接口
    */
    showVoiceprintRecordWindow(isShow: boolean, onShowVoiceprintRecordWindowResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set log save path. [cn] 设置日志保存路径
    */
    setLogPath(logPathInfo: LogPathInfo, onSetLogPathResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to get error message. [cn] 获取错误提示
    */
    getErrorMessage(errorCode: number): ErrorMessageInfo;
    /**
    * [en] This interface is used to set need transparent windows in share [cn] 设置屏幕共享中需透明的窗口
    */
    setTransparentWnd(wndInfo: TransparentWndInfo, onSetTransparentWndResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to customize the text of the specified scene [cn] 自定义指定场景文案
    */
    setCustomUIText(customSceneTextInfoList: CustomSceneTextInfoList, onSetCustomUITextResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to customize the image of the specified scene [cn] 自定义指定场景图标
    */
    setCustomUIImage(customSceneImageInfoList: CustomSceneImageInfoList, onSetCustomUIImageResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en]set virtual background default images [cn]设置虚拟背景默认图片
    */
    setVirtualBackgroundDefaultImages(defaultImagesInfo: VirtualBackgroundInfo, onSetVirtualBackgroundDefaultImagesResult?: (ret: SDKERR, reason: string) => void): void;
}
