//
//  HWMConfDetail.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/14.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMConfListItemInfo.h"
#import "HWMAttendeeInfo.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMConfDetail : HWMConfListItemInfo
/// VMR会议ID
@property (nonatomic, copy) NSString *vmrId;

/// 可选，是否是VMR会议
@property (nonatomic, assign) BOOL vmrFlag;

/// 是否来宾免密
@property (nonatomic, assign) BOOL guestFreePwd;

/// 是否发送邮件通知
@property (nonatomic, assign) BOOL sendEmailNotify;

/// 是否发送短信通知
@property (nonatomic, assign) BOOL sendSms;

/// 是否发送日历通知
@property (nonatomic, assign) BOOL sendCalendarNotify;

/// 呼入限制
@property (nonatomic, assign) HWMJoinConfRestrictionType callInRestriction;

/// 与会者
@property (nonatomic, strong) NSArray<HWMAttendeeInfo *> *attendee;

/// 是否允许来宾提前进入会议
@property (nonatomic, assign) BOOL allowGuestStartConf;

/// 允许来宾提前入会时间范围(单位：分钟)
/// 0-随时，n-提前n分钟启动会议 n可取值:0,5,10,15,30
@property (nonatomic, assign) NSInteger allowGuestStartConfTime;
/// 云会议室的会议ID类型
@property (nonatomic, assign) HWMVmrConfIdType vmrConfIdType;
/// 是否开启等候室
@property (nonatomic, assign) BOOL isOpenWaitingRoom;

/// 是否开启录制
@property (nonatomic, assign) BOOL isRecordOn;

/// 是否开启直播
@property (nonatomic, assign) BOOL isLiveOn;

/// 是否会议开启自动录制
@property (nonatomic, assign) BOOL isAutoRecord;

/// 可选，是否是VMR预约记录：0.普通会议记录；1.VMR预约记录
@property (nonatomic, assign) BOOL scheduleVmr;

/// 自定义信息
@property (nonatomic, copy) NSString *customInfo;

/// 会议最大与会人数，默认0
@property (nonatomic, assign) NSUInteger concurrentParticipants;

/// 个人客户端入会是否自动静音
@property (nonatomic, assign) HWMAutoMuteType autoMuteMode;

/// 会议室设备入会是否自动静音
@property (nonatomic, assign) HWMAutoMuteType hardTerminalAutoMuteMode;

/// 是否支持水印
@property (nonatomic, assign) BOOL supportWatermark;

/// 录制时，智能会议纪要的默认状态，仅支持会议纪要时生效
@property (nonatomic, assign) HWMSummaryState defaultSummaryState;

/// 是否免审核自动发布纪要
@property (nonatomic, assign) BOOL autoPublishSummary;

@end

NS_ASSUME_NONNULL_END
