//
//  HWMLocalRecordEventDelegate.h
//  HWMNativeSDK
//
//  Created by y00450113 on 2022/3/16.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol HWMLocalRecordEventDelegate <NSObject>

/// 录制报错中断，且无法恢复
/// @param error 错误信息
- (void)onLocalRecordInterruptWithError:(NSError *)error;

/// 录制事件上报
/// @param code 事件code
/// @param msg 事件描述
/// @param args  参数
- (void)onLocalRecordEventWithCode:(NSUInteger)code msg:(NSString *)msg args:( NSDictionary * _Nullable )args;
@end

NS_ASSUME_NONNULL_END
