//
//  HWMOpenSDKConfig.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/9.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"
#import "HWMBizNotificationHandler.h"
#import "HWMNotifyHandler.h"
#import "HWMConfSettingHandler.h"
#import "HWMContactApiHandler.h"
#import "HWMContactUIHandler.h"
#import "HWMConfUIHandler.h"
#import "HWMHeadPortraitApiHandler.h"
#import "HWMSocialShareHandler.h"
#import "HWMShowSocialShareHandler.h"
#import "HWMCallNotifyHandler.h"
#import "HWMIncomingAnswerHandler.h"
#import "HWMConfCtrlItemHandler.h"
#import "HWMOpenSettingHandler.h"
#import "HWMParticipantListHandler.h"
#import "HWMStatusBarMenuHandler.h"
#import "HWMConfIMHandler.h"
#import "HWMParticipantListItemCallOtherNumberHandler.h"
#import "HWMShareInterceptHandler.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMOpenSDKConfig : NSObject
#pragma mark - require
/// 必填，appid认证方式的必须填入从华为云console申请的appid； 若用户名密码方式的，填入企业的标识  比如 Huawei
@property (nonatomic, copy) NSString *appId;

#pragma mark - options
/// SDK 版本号，只读
@property (nonatomic, copy, readonly) NSString *sdkVersion;

/// 日志路径 默认为程序的Application Support/App名  路径
@property (nonatomic, copy) NSString *logPath;

/// 日志级别
@property (nonatomic, assign) HWMUISDKLogLevel logLevel;

/// 登录站点类型，默认为中国站点。根据站点来默认获取登录华为云会议的国内以及国际站点
/// 初始化接口携带。后面只能在已初始化后并且在登录前可以支持更改  未初始化或者已经登录状态不支持更改
@property (nonatomic, assign) HWMSiteType siteType;
@property (nonatomic, assign) NSInteger logKeepDays; /// 配置项-日志保存天数，0为使用SDK内部策略，非0情况范围3-30
/// 会场列表是否隐藏不在线的联系人，默认不开启
@property (nonatomic, assign) BOOL hideOfflineParticipant;

/// 关闭聊天模块，默认不关闭。只支持初始化config的时候一起设置，不支持后续动态修改
@property (nonatomic, assign) BOOL closeMeetingChatFunction DEPRECATED_MSG_ATTRIBUTE("可以通过自定义会中菜单实现，该接口即将废弃");

/// 是否显示与会者列表中外部标签，默认显示
@property (nonatomic, assign) BOOL hideExternalLabel;

/// 是否隐藏隐藏安全中的允许入会菜单， 默认不隐藏
@property (nonatomic, assign) BOOL hideAllowJoinConfMenu;

/// 是否支持同终端多应用登录
@property (nonatomic, assign) BOOL isSupportMultiAppLogin;

/// 官网下载渠道链接
@property (nonatomic, copy) NSString *appUrl;

/// 会议窗口中分享的会议链接前缀
@property (nonatomic, copy) NSString *linkPrefix;

@property (nonatomic, weak, nullable) id <HWMConfSettingHandler> confSettingHandler; // 可选，会议设置
@property (nonatomic, weak, nullable) id <HWMCallSettingHandler> callSettingHandler; // 可选，点对点设置
@property (nonatomic, weak, nullable) id <HWMContactApiHandler> contactApiHandler; // 可选，通讯录详情代理
@property (nonatomic, weak, nullable) id <HWMContactUIHandler> contactUIHandler; // 可选，邀请联系人UI 定制代理
@property (nonatomic, weak, nullable) id <HWMConfUIHandler> confUIHandler; // 可选，会议UI定制代理
@property (nonatomic, weak, nullable) id <HWMHeadPortraitApiHandler> headPortraitApiHandler; // 可选，头像接口 定制代理
@property (nonatomic, weak, nullable) id <HWMSocialShareHandler> socialShareHandler DEPRECATED_MSG_ATTRIBUTE("可通过HWMShowSocialShareHandler实现，该接口已废弃"); // 可选，社交分享定制代理，用于定制会中分享能力
@property (nonatomic, weak, nullable) id <HWMShowSocialShareHandler> showSocialShareHandler; // 可选，社交分享定制代理，用于定制会中分享能力
@property (nonatomic, weak, nullable) id <HWMIncomingAnswerHandler> incomingAnswerHandler; // 可选，来电接听策略设置
@property (nonatomic, weak, nullable) id <HWMConfCtrlItemHandler> toolbarItemHandler; // 可选，底部工具栏配置
@property (nonatomic, weak, nullable) id <HWMOpenSettingHandler> settingHandler; // 可选，会议设置配置
@property (nonatomic, weak, nullable) id <HWMParticipantListHandler> participantListHandler; // 可选，与会者列表代理
@property (nonatomic, weak, nullable) id <HWMStatusBarMenuHandler> statusBarMenuHandler; // 可选，会议设置配置
@property (nonatomic, weak, nullable) id <HWMParticipantListItemCallOtherNumberHandler> callOtherNumberHandler; // 可选，呼叫其他号码定制代理
@property (nonatomic, weak, nullable) id <HWMShareInterceptHandler> shareInterceptHandler; // 可选，拦截共享定制代理

// 可选， 若多个对象订阅，每个对象都会收到消息通知回调
- (void)subscribeGlobalNotificationHandler:(id<HWMNotifyHandler>)handler;

// 可选， 取消订阅消息通知回调 优选不调用。内部为弱引用，当对象不存在就会自动取消
- (void)unsubscribeGlobalNotificationHandler:(id<HWMNotifyHandler>)handler;

// 可选， 若多个对象订阅，每个对象都会收到业务消息通知回调
- (void)subscribeBizNotificationHandler:(id<HWMBizNotificationHandler>)handler;

// 可选， 取消订阅业务消息通知回调 优选不调用。内部为弱引用，当对象不存在就会自动取消
- (void)unsubscribeBizNotificationHandler:(id<HWMBizNotificationHandler>)handler;

// 可选， 若多个对象订阅，每个对象都会收到业务消息通知回调
- (void)subscribeCallNotificationHandler:(id<HWMCallNotifyHandler>)handler;

// 可选， 取消订阅业务消息通知回调 优选不调用。内部为弱引用，当对象不存在就会自动取消
- (void)unsubscribeCallNotificationHandler:(id<HWMCallNotifyHandler>)handler;


@end

NS_ASSUME_NONNULL_END
