//
//  HWMOpenApiWeLink.h
//  HWMUISDK_WeLink
//
//  Created by HuLinjie on 2021/1/7.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMOpenApi.h"
#import "HWMStartCTDCallParam.h"
#import "HWMProxyInfo.h"
#import "HWMCtdConfig.h"
#import "HWMVirtualBackgroundParam.h"
#import "HWMSDKCommonDefine.h"
#import "HWMSDKDeployInfoModel.h"
#import "HWMAnonymousJoinConfBySignatureInfo.h"
#import "HWMUISDKExternalInviteeModel.h"
#import "HWMUISDKStartPlayAudioFileParamModel.h"
#import "HWMUISDKInnerHttpProxyInfoModel.h"
#import "HWMUISDKMeetingCustomInfoModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMPrivateApi : NSObject

/// token登录接口
/// @param account 账号
/// @param token 鉴权token
/// @param callback 结果回调，返回登录用户的UUID
- (void)login:(NSString *_Nonnull)account token:(NSString *_Nonnull)token callback:(_Nonnull HWMSDKLoginCompleteHandler)callback;

/// 当前sip是否已经注册
- (BOOL)isCallEnable;

/// 是否可以创建RTC会议
- (BOOL)isRtcEnable;

/// 发起回呼
/// @param param 呼叫参数
/// @param callback 结果回调
- (void)startCTDCall:(HWMStartCTDCallParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 链接入会方式加入会议
/// 链接地址其实是HWMLinkConfParam的三个参数（siteUrl，random,idPrefix）组成的链接地址,
/// 类似：https://119.3.230.210:443/conferences&random=151134170336896&idprefix=9
/// @param param 入会参数，详见 HWMLinkConfInfo
/// @param callback 结果回调
- (void)joinConfByLink:(HWMLinkConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 快速匿名安全入会
- (void)anonymousJoinConfBySignatureInfo:(HWMAnonymousJoinConfBySignatureInfo *)anonymousJoinConfBySignatureInfo callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 设置代理
- (void)setProxyWithProxyInfo:(HWMProxyInfo *)proxyInfo API_AVAILABLE(macos(10.13));

/// 设置是否隐藏邀请提示气泡, 在初始化后，会议前设置 (默认隐藏)
- (void)setHideInviteBubbleTips:(BOOL)isHide;

/// 开放性私有接口设置回呼号码接口
- (void)saveCtdConfig:(HWMCtdConfig *)config complete:(void(^)(NSError * error))completeHandler;

/// 开放性私有接口获取回呼号码接口
- (void)queryCtdConfig:(void(^)(HWMCtdConfig *config, NSError *error))completeHandler;

/// 设置虚拟背景默认图片(图片格式: jpg/jpeg, 图片尺寸: 最大4096*4096, 最小160*160, 图片路径: 读权限)
/// @param defaultImagesParam 默认图片参数
- (void)setVirtualBackgroundDefaultImages:(HWMVirtualBackgroundParam *)defaultImagesParam DEPRECATED_ATTRIBUTE;

/// 设置证书校验模式
- (HWMSDKERR)enableCAVerification:(BOOL)isVerify;

/// 设置部署模式及对应地址和端口
- (HWMSDKERR)setDeployInfo:(HWMSDKDeployInfoModel *)deployInfo;

/// 设置内部Http代理信息
- (HWMSDKERR)setInnerHttpProxyInfo:(HWMUISDKInnerHttpProxyInfoModel *)info;

/// 更新外部邀请者
- (HWMSDKERR)updateExternalInviteesList:(NSArray<HWMUISDKExternalInviteeModel *> *)list;

/// 开始播放音频文件（文件仅支持wav格式）
/// @param param loopTimes:循环次数，0代表无限循环。filePath:文件路径，绝对路径。
/// @param callback 结果回调
- (void)startPlayAudioFileWithParam:(HWMUISDKStartPlayAudioFileParamModel *)param callback:(HWMSDKCompleteHandler)callback;

/// 停止播放音频文件
- (HWMSDKERR)stopPlayAudioFile;

/// 设置会议自定义信息
- (void)setMeetingCustomInfo:(HWMUISDKMeetingCustomInfoModel *)info callback:(HWMSDKCompleteHandler)callback;

/// 获取本地鉴权token信息
- (NSString *)getJwtToken;

@end

NS_ASSUME_NONNULL_END
