//
//  HWMSdkDefine.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/9.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#ifndef HWMSdkDefine_h
#define HWMSdkDefine_h
#import "HWMOpenSDKConfigDefine.h"
#import "HWMUISDKStartProjectionResultModel.h"

@class HWMLoginResult;
@class HWMCreateConfResult;
@class HWMVmrInfoModel;
@class HWMVmrInfoListModel;
@class HWMConfDetail;
@class HWMLogoutResult;

// 通用回调，error为nil表示调用成功，否则调用失败，result 为预留扩展参数，请忽略
typedef void (^HWMSDKCompleteHandler)(NSError *_Nullable error, id _Nullable result);

// 登录回调，error为nil表示调用成功，否则调用失败，result 返回登录用户的信息
typedef void (^HWMSDKLoginCompleteHandler)(NSError *_Nullable error, HWMLoginResult *_Nullable result);

typedef void (^HWMSDKLogoutCompletehandler)(NSError *_Nullable error, HWMLogoutResult *_Nullable result);

// 创建会议回调，error为nil表示调用成功，否则调用失败，result会议信息
typedef void (^HWMSDKCreateConfCompleteHandler)(NSError *_Nullable error, HWMCreateConfResult *_Nullable result);

// 会议详情回调
typedef void (^HWMSDKConfInfoCompleteHandler)(NSError *_Nullable error, HWMConfDetail *_Nullable result);

// 云会议室列表回调， error为nil表示调用成功，否则调用失败，result云会议室列表信息
typedef void (^HWMSDKVmrListCompleteHandler)(NSError *_Nullable error, NSArray<HWMVmrInfoModel *> *_Nullable result);

// VMR列表回调，error为nil表示调用成功，否则调用失败，result VMR列表信息
typedef void (^HWMSDKVmrInfoListCompleteHandler)(NSError *_Nullable error, HWMVmrInfoListModel *_Nullable result);

// 发起投屏回调
typedef void (^HWMSDKStartProjectionCompleteHandler)(NSError *_Nullable error, HWMUISDKStartProjectionResultModel *_Nullable startProjectionResult);

/// 聊天权限
typedef NS_ENUM (NSInteger, HWMChatPermissionType) {
    HWMChatPermissionTypeForbiddenAll = 1,        /**<[en]Indicates forbidden all[cn]全员禁止 */
    HWMChatPermissionTypeFreeTalk = 4,        /**<[en]Indicates free talk[cn]允许自由聊天 */
};

// 聊天权限回调
typedef void (^HWMSDKConfChatPermissionCompleteHandler)(NSError *_Nullable error, HWMChatPermissionType chatPermission);

/// 会议状态
typedef NS_ENUM (NSUInteger, HWMConfStatus) {
    /// 空闲状态 （会议结束）
    HWMConfStatusIdle = 0,
    /// 正在来电
    HWMConfStatusIncoming,
    /// 正在呼出
    HWMConfStatusCallingOut,
    /// 已接通
    HWMConfStatusConnected,
};

/// 点对点呼叫状态
typedef NS_ENUM (NSInteger, HWMCallStatus) {
    HWMCallStatusIdle = 0,
    HWMCallStatusIncoming,
    HWMCallStatusStart,
    HWMCallStatusConnected
};

/// 站点类型
typedef NS_ENUM (NSUInteger, HWMSiteType) {
    /// 中国站点 （默认）
    HWMSiteTypeChina = 0,
    /// 亚太站点
    HWMSiteTypeAP,
};

/// 会议限制
typedef NS_ENUM (NSInteger, HWMJoinConfRestrictionType) {
    /// 所有用户
    HWMJoinConfRestrictionAll     = 0,
    /// 企业内用户
    HWMJoinConfRestrictionCompany = 2,
    /// 被邀请用户
    HWMJoinConfRestrictionInvited
};

/// 自动外邀
typedef NS_ENUM(NSInteger, HWMAutoInviteType) {
    /// 不设置（默认自动邀请）
    HWMAutoInviteNone = 0,
    /// 自动邀请开启
    HWMAutoInviteOpen = 1,
    /// 自动邀请关闭
    HWMAutoInviteClose = 2,       
};

/// 会议ID类型
typedef NS_ENUM (NSInteger, HWMConfIdType) {
    /// 个人会议ID
    HWMConfIdPersonal,
    /// 云会议室会议ID
    HWMConfIdMeetingRoom,
    /// 随机会议ID
    HWMConfIdRandom
};

/// 会议成员角色
typedef NS_ENUM (NSInteger, HWMConfRoleType) {
    HWMConfRoleTypeInvalid  = -1,
    /// 普通与会者
    HWMConfRoleTypeAttendee = 0,
    /// 主席
    HWMConfRoleTypeChairman,
    /// 观众
    HWMConfRoleTypeAudience,
    /// 联席主持人
    HWMConfRoleTypeCohost,
    /// 等候室成员
    HWMConfRoleTypeWaiting
};

/// 成员类型
typedef NS_ENUM (NSUInteger, HWMConfAttendeeType) {
    /// 会议软终端用户
    HWMConfAttendeeTypeNormal = 0,
    /// 用户手机号码
    HWMConfAttendeeTypeMobile = 5,
};

/// ACCESS状态
typedef NS_ENUM (NSUInteger, HWMLoginStatus) {
    HWMLoginStatusUnLogin = 0,
    HWMLoginStatusLoginIng,
    HWMLoginStatusLoginEnd,
    HWMLoginStatusLogoutIng
};

// 语言类型
typedef NS_ENUM(NSUInteger, HWMSdkLanguageType){
    HWMSdkLanguageTypeZH, // 中文
    HWMSdkLanguageTypeEN, // 英文
    HWMSdkLanguageTypeCustomized, // 自定义语言
};

typedef NS_ENUM (NSInteger, HWMIncomingAnswerType) {
    /// 原体验，弹出来电界面
    HWMIncomingAnswerNormal = 0,
    /// 自动拒接
    HWMIncomingAnswerAutoDecline,
    /// 自动接听
    HWMIncomingAnswerAutoAnswer,
    /// 来电时自定义弹框
    HWMIncomingAnswerCustom,
};

typedef NS_ENUM (NSUInteger, HWMCallMediaType) {
    HWMCallMediaTypeAudio = 0,
    HWMCallMediaTypeVideo
};

typedef NS_ENUM (NSUInteger, HWMSDKConfMediaType) {
    HWMSDKConfMediaTypeAudio = 0,
    HWMSDKConfMediaTypeVideo
};

typedef NS_ENUM (NSUInteger, HWMUserState) {
    HWMUserStateIdle = 0, // 空闲
    HWMUserStateInConf, // 会议中
    HWMUserStateInCall, // 呼叫中
};

// 会议场景
typedef NS_ENUM (NSInteger, HWMConfToolBarScene) {
    /// 音频会议
    HWMConfToolBarSceneAudioConf = 0,
    /// 视频会议
    HWMConfToolBarSceneVideoConf = 1,
    /// 音频通话
    HWMConfToolBarSceneAudioCall = 2,
    /// 视频通话
    HWMConfToolBarSceneVideoCall = 3,
};

typedef NS_ENUM (NSInteger, HWMAttendeeState) {
    HWMAttendeeStateInConf   = 0, /**< 会议中 */
    HWMAttendeeStateCalling  = 1, /**< 正在呼叫 */
    HWMAttendeeStateJoining  = 2, /**< 正在加入会议 */
    HWMAttendeeStateLeaved   = 3, /**< 已经离开 */
    HWMAttendeeStateNoExist  = 4, /**< 用户不存在 */
    HWMAttendeeStateBusy     = 5, /**< 被叫用户忙 */
    HWMAttendeeStateNoAnswer = 6, /**< 用户无应答 */
    HWMAttendeeStateReject   = 7, /**< 用户拒绝接听 */
    HWMAttendeeStateFailed   = 8, /**< 呼叫失败 */
};

typedef NS_ENUM (NSInteger, HWMAudioRowDataFrameType) {
    HWMAudioRowDataFrameTypePcm16 = 0,
};

typedef NS_ENUM (NSInteger, HWMOpenAuthServerType) {
    HWMOpenAuthServerTypeOauth2 = 0, /**<[en]Indicates user has not binded. [cn]单点登录 */
};

/// 支持自定义页面的业务场景
typedef NS_ENUM (NSInteger, HWMCustomUIScene) {
    HWMCustomUISceneToolBar = 0, // 会控菜单栏定制场景
};

/// 会议来电状态
typedef NS_ENUM (NSUInteger, HWMConfIncomingState) {
    HWMConfIncomingStateStart = 0, /**< 初始状态，来电振铃中 */
    HWMConfIncomingStateAccept,    /**< 接听状态，已接听来电 */
    HWMConfIncomingStateReject,    /**< 拒绝状态，已拒接来电 */
    HWMConfIncomingStateTimeout,   /**< 未响应状态，呼叫超时或者主叫已挂断 */
};

/// 云会议室的会议ID类型
typedef NS_ENUM (NSUInteger, HWMVmrConfIdType) {
    HWMVmrConfIdTypeFixed  = 0, // 云会议室的会议ID类型是固定类型
    HWMVmrConfIdTypeRandom = 1, // 云会议室的会议ID类型是随机类型
};

typedef NS_ENUM(NSInteger, HWMAccessType) {
    HWMAccessTypeAuto = 0,        /**<[en]Indicates auto [cn]默认值 */
    HWMAccessTypeInner = 1,        /**<[en]Indicates inner [cn]公司内网接入, 用于媒体和信令下沉场景，app从内网接入，信令/媒体消息走代理服务器才能访问云会议服务端 */
    HWMAccessTypeOuter = 2,        /**<[en]Indicates outter [cn]公司外网接入, 用于非媒体和信令下沉场景，互联网接入，信令/媒体消息可以直接访问云会议服务端 */
};

/// 周期模式
typedef NS_ENUM(NSInteger, HWMCycleMode) {
    HWMCycleModeDay = 0,       //!<  按天
    HWMCycleModeWeek = 1,      //!<  按周
    HWMCycleModeMonth = 2      //!<  按月
};

typedef NS_ENUM(NSInteger, HWMConfType) {
    HWMConfTypeCommon = 0,
    HWMConfTypeCycle = 1, // 周期会议
};
#endif /* HWMSdkDefine_h */
