//
//  HWMShowSocialShareHandler.h
//  HWMUISDK
//
//  Created by linweiqiang on 2024/6/29.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// 两个接口只需要实现一个，若两个都实现，只会取 showSocialShareView: meetingInfo:
@protocol HWMShowSocialShareHandler <NSObject>
@optional

/// 会中鼠标移至标题栏出现的分享View  外部控制：大小；内部控制：显示位置、显示隐藏时机等
/// 注入过一次后，此次会议中内部会保留此对象，外部可以结合onMeetingInfoChanged数据驱动在此NSView对象上进行view的视图改变（原生实现使用此接口 方便简单）
/// @param meetingInfo 会议基本信息
- (NSView *)socialShareView:(HWMSDKMeetingInfoModel *)meetingInfo;

/// 会中鼠标移至标题栏出现的分享View  外部控制：大小、显示位置、显示隐藏时机等（JS显示可以使用此接口）
/// @param point 鼠标位置
/// @param meetingInfo 会议基本信息
- (void)showSocialShareView:(NSPoint)point meetingInfo:(HWMSDKMeetingInfoModel *)meetingInfo;

@end

NS_ASSUME_NONNULL_END
