//
//  HWMUISDKJsonConfigInfo.h
//  HWMUISDK
//
//  Created by p00576758 on 2021/12/20.
//

#import <Foundation/Foundation.h>
#import "HWMToolBarItemModel.h"
#import "HWMMenuItemModel.h"
#import "HWMStatusBarItemModel.h"
#import "HWMConfCtrlItemHandler.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM (NSUInteger, HWMJsonCustomButtonPos) {
    HWMJsonCustomButtonPosMore,     /**< 更多菜单*/
    HWMJsonCustomButtonPosTool,        /**<底部工具栏菜单*/
    HWMJsonCustomButtonPosShareTool,      /**<共享工具了菜单*/
};

@interface HWMJsonCustomButtonConfigItem: NSObject
@property (nonatomic, copy) NSString *buttonId;
@property (nonatomic, copy) NSString *title;
@property (nonatomic, copy) NSString *buttonImg;
@property (nonatomic, assign) HWMJsonCustomButtonPos buttonPos;
@end

@interface HWMJsonButtonConfigItem: NSObject
@property (nonatomic, copy) NSString *buttonId;
@property (nonatomic, copy) NSString *showAsAction;
@end

@interface HWMJsonDefaultButtonConfigItem: NSObject
@property (nonatomic, copy) NSString *buttonId;
@property (nonatomic, copy) NSString *showAsAction;
@property (nonatomic, assign) BOOL isCustomizedClick;
@end

@interface HWMJsonConfDetailConfig: NSObject
@property (nonatomic, strong) NSArray<HWMJsonDefaultButtonConfigItem *> *button;
@end

@interface HWMJsonStatusBarConfig: NSObject
@property (nonatomic, strong) NSArray<HWMJsonButtonConfigItem *> *button;
@end

@interface HWMJsonToolBarConfig: NSObject
@property (nonatomic, strong) NSArray<HWMJsonCustomButtonConfigItem *> *customButton;
@property (nonatomic, strong) NSArray<HWMJsonDefaultButtonConfigItem *> *button;
@end

@interface HWMJsonTitleBarConfig: NSObject
@property (nonatomic, strong) HWMJsonConfDetailConfig *confDetail;
@end

@interface HWMJsonConfMenuConfig: NSObject
@property (nonatomic, strong) HWMJsonTitleBarConfig *titleBar;
@property (nonatomic, strong) HWMJsonStatusBarConfig *statusBar;
@property (nonatomic, strong) HWMJsonToolBarConfig *toolBar;
@end

@interface HWMJsonSimultaneousRingingConfig: NSObject
@property (nonatomic, assign) BOOL isShow;
@end

@interface HWMJsonConfigurationInfo: NSObject
@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *linkPrefix;
@property (nonatomic, assign) BOOL isUseExternalConfInfoWnd;
@property (nonatomic, assign) BOOL isUseExternalAddressBook;
@property (nonatomic, strong) HWMJsonConfMenuConfig *confMenu;
@property (nonatomic, strong) HWMJsonSimultaneousRingingConfig *SimultaneousRinging;
@end

@interface HWMUISDKJsonConfigInfo: NSObject
@property (nonatomic, strong) HWMJsonConfigurationInfo *frame;
- (NSArray <NSArray <HWMToolBarItemModel *> *> *)configInfoConvertToToolBarItemModel:(HWMUISDKJsonConfigInfo *)configInfo;
- (NSArray<HWMToolBarItemModel *> *)configInfoConvertToScreenShareToolBarItemModel:(HWMUISDKJsonConfigInfo *)configInfo;
- (NSArray<HWMMenuItemModel *> *)configInfoConvertToMoreMenuItemModel:(HWMUISDKJsonConfigInfo *)configInfo;
- (NSArray<HWMMenuItemModel *> *)configInfoConvertToScreenShareMoreMenuItemModel:(HWMUISDKJsonConfigInfo *)configInfo;
- (NSArray <HWMStatusBarItemModel *> *)configInfoConvertToBuildRecordMenuItems;
- (void)configConfDetail:(HWMUISDKJsonConfigInfo *)configInfo;
- (void)configSimultaneousRinging:(HWMUISDKJsonConfigInfo *)configInfo;
- (void)configLinkPrefix:(HWMUISDKJsonConfigInfo *)configInfo;
@end

NS_ASSUME_NONNULL_END
