//
//  HWMCallRecordInfo.h
//  HWMBaseUI
//
//  Created by yaolili/ywx577644 on 2020/6/5.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"

typedef NS_ENUM (NSUInteger, HWMCallEndReason) {
    HWM_CALL_END_REASON_INVALID                    = 0,
    HWM_CALL_END_REASON_CONNECTED_HANGUP_BY_CALLER = 1,   // 主叫挂断（接通）
    HWM_CALL_END_REASON_CONNECTED_HANGUP_BY_CALLEE = 2,   //被叫挂断（接通）
    HWM_CALL_END_REASON_HANDGUP_BY_CALLER          = 3,   //主角挂断（未接通）
    HWM_CALL_END_REASON_HANDGUP_BY_CALLEE          = 4,   //被叫挂断（未接通）
    HWM_CALL_END_REASON_CALLEE_BUSY                = 5,   //被叫通话中（未接通）
    HWM_CALL_END_REASON_CALLEE_ANSWER_TIMEOUT      = 6,   //被叫超时未接听（未接通）
    HWM_CALL_END_REASON_CALLEE_NUMBER_ERROR        = 7,   //被叫号码错误（未接通）
    HWM_CALL_END_REASON_FAILED                     = 8   //通话失败
};

@interface HWMCallRecordInfo : NSObject
/// 呼叫类型
@property (nonatomic, assign) HWMCallMediaType callType;

/// 是否加密
@property (nonatomic, assign) BOOL srtp;

/// 来电者姓名
@property (nonatomic,  copy) NSString *displayName;

/// 来电号码或作为主叫时的呼出号码
@property (nonatomic, copy) NSString *telNum;

/// 呼叫开始时间
@property (nonatomic, copy) NSString *startTime;

/// 呼叫是否建立
@property (nonatomic, assign) BOOL callSuccess;

/// 失败原因码
@property (nonatomic, assign) NSUInteger reasonCode;

/// 结束通话原因描述
@property (nonatomic, copy) NSString *reasonText;

@property (nonatomic, assign) BOOL callRingBack;

/// 是否为主动呼出
@property (nonatomic, assign) BOOL callOut;

@property (nonatomic, assign) NSTimeInterval duration;

//呼叫结束或者错误 对应state
@property (nonatomic, assign) HWMCallEndReason state;

@end

