//
//  HWMSDKFileManager.h
//  HWMNativeSDK
//
//  Created by guomeng on 2021/5/19.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface HWMSDKFileManager : NSObject

+ (instancetype)shareInstance;

- (BOOL)isExist:(NSString *)path;
- (BOOL)mkFile:(NSString *)path;
- (NSDictionary *)writeFile:(NSString *)filePath data:(NSString *)data encoding:(NSStringEncoding)encoding isAppend:(BOOL)isAppend;
- (NSDictionary *)readFile:(NSString *)filePath encoding:(NSStringEncoding)encoding;
- (BOOL)copyFile:(NSString *)srcPath destPath:(NSString *)destPath;
- (NSDictionary *)mkDir:(NSString *)dirPath recursive:(BOOL)recursive;
- (NSDictionary *)listDir:(NSString *)dirPath;
- (NSDictionary *)recursiveListDir:(NSString *)dirPath;
- (NSDictionary *)rmFile:(NSString *)filePath;
- (NSDictionary *)rmDir:(NSString *)dirPath;
- (NSDictionary *)getFileInfo:(NSString *)filePath;

+ (NSString *)applicationSupportDir;
+ (NSString *)applicationCacheDir;

///获取当前app可使用的存储空间,单位：字节
+ (long)getAvailableDiskCapacity;
@end

NS_ASSUME_NONNULL_END
