//
//  HWMSDKLoginService.h
//  HWMSDKSDK
//
//  Automatically generated file. DO NOT MODIFY!!!
//

#import <Foundation/Foundation.h>
#import "HWMSDKCommonDefine.h"
#import "HWMSDKAllModelIndex.h"

NS_ASSUME_NONNULL_BEGIN

typedef void(^HWMSDKLoginByAppIdSuccessBlock) (HWMSDKLoginByAppIdResultInfoModel * loginResultInfo);
typedef void(^HWMSDKLoginByAppIdFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKLogoutSuccessBlock) (void);
typedef void(^HWMSDKLogoutFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKQueryNonceSuccessBlock) (NSString * nonce, NSString * url);
typedef void(^HWMSDKQueryNonceFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKQueryNonceInfoByTypeSuccessBlock) (HWMSDKQueryNonceInfoResultModel * queryNonceInfoResult);
typedef void(^HWMSDKQueryNonceInfoByTypeFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKQueryUserInfoSuccessBlock) (HWMSDKQueryUserResultInfoModel * queryUserInfoResult);
typedef void(^HWMSDKQueryUserInfoFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKCancelDownloadUpgradeSuccessBlock) (void);
typedef void(^HWMSDKCancelDownloadUpgradeFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKDownloadUpgradeFileSuccessBlock) (void);
typedef void(^HWMSDKDownloadUpgradeFileFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKFirewallDetectSuccessBlock) (NSUInteger sn);
typedef void(^HWMSDKFirewallDetectFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKQueryVersionInfoSuccessBlock) (HWMSDKQueryVersionInfoResultModel * queryResultInfo);
typedef void(^HWMSDKQueryVersionInfoFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKRequestUploadInfoSuccessBlock) (HWMSDKRequestUploadInfoResultModel * requestResultInfo);
typedef void(^HWMSDKRequestUploadInfoFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKGetDeviceInfoSuccessBlock) (HWMSDKDeviceInfoModel * deviceInfo);
typedef void(^HWMSDKGetDeviceInfoFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKCompressAndUploadFileSuccessBlock) (void);
typedef void(^HWMSDKCompressAndUploadFileFailedBlock) (NSError * _Nullable error);


@protocol HWMSDKLoginNotify <NSObject>

@optional
/// [en]This class is about the login status information notification.The synchronized method is GetLoginStateInfo. [cn]登录信息变更通知
- (void)onLoginStateInfoChanged:(HWMSDKLoginStateInfoModel *)loginStateInfo;
/// [en] xxxxxx [cn] 被踢通知
- (void)onKickoutNotify:(HWMKickoutReason)reason reasonDesc:(NSString *)reasonDesc;
/// [en]xxxx [cn]客户企业信息变更通知
- (void)onUserCorpInfoNotify:(HWMSDKERR)result userCorpInfoNotifyType:(HWMUserCorpInfoNotifyType)userCorpInfoNotifyType;
/// [en]This is about login error notify. [cn]登录无效通知
- (void)onLoginInvalidNotify:(HWMSDKERR)result reasonDesc:(NSString *)reasonDesc;
/// [en]This class is about a synchronous method to get support waiting room change. [cn]是否支持等候室的变更通知
- (void)onSupportWaitingRoomChanged:(BOOL)supportWaitingRoom;
/// [en]This class is about the upload file trans progress notify. [cn]上传文件进度通知 :disable
- (void)onUploadFileTransProgressNotify:(NSUInteger)handle ulTotal:(NSUInteger)ulTotal ulNow:(NSUInteger)ulNow;
/// [en]This class is about the download upgrade file progress notify. [cn]下载升级文件进度通知 :disable
- (void)onDownloadUpgradeFileProgressNotify:(HWMSDKERR)result progressInfo:(HWMSDKDownloadProgressInfoModel *)progressInfo;
/// [en]This class is about the stun notify. [cn]stun消息通知 :disable
- (void)onStunNotify:(HWMSDKERR)result type:(NSUInteger)type;
/// [en]This class is about the net dial detect progress notify. [cn]网络拨测进度通知
- (void)onNetDialTestProgressNotify:(HWMSDKERR)result progressInfo:(HWMSDKNetDialProgressInfoModel *)progressInfo;
/// [en]This interface is used to describe the notify of version check info. [cn]SDK版本过期检查通知
- (void)onDeprecatedSDKCheckNotify:(HWMSDKERR)result pDeprecatedSDKCheckResult:(HWMSDKDeprecatedSDKCheckResultModel *)pDeprecatedSDKCheckResult;

@end

@interface HWMSDKLoginService : NSObject

+ (instancetype)shareInstance;
+ (void)releaseInstance;
- (void)addLoginNotifyCallback:(id<HWMSDKLoginNotify>)callback;
- (void)removeLoginNotifyCallback:(id<HWMSDKLoginNotify>)callback;
/// [en]This class is about login. [cn]AppId登录
- (void)loginWithAppIdAuthInfo:(HWMSDKAppIdAuthInfoModel *)appIdAuthInfo successCallback:(HWMSDKLoginByAppIdSuccessBlock)successCallback failedCallback:(HWMSDKLoginByAppIdFailedBlock)failedCallback;

/// [en]This class is about logout. [cn]注销 :imLogout
- (void)logoutWithSuccessCallback:(HWMSDKLogoutSuccessBlock)successCallback failedCallback:(HWMSDKLogoutFailedBlock)failedCallback;

/// [en]This class is about querying personal Portal login authentication credentials, which is used for application to access to Personal Portal (PC link to personal Portal page). [cn]查询个人Portal登录鉴权凭证，用于应用程序访问个人portal(PC链接跳转至个人Portal页面)
- (void)queryNonceWithSuccessCallback:(HWMSDKQueryNonceSuccessBlock)successCallback failedCallback:(HWMSDKQueryNonceFailedBlock)failedCallback;

/// [en]This class is about querying personal Portal login authentication credentials, which is used for application to access to Personal Portal (PC link to personal Portal page). [cn]查询个人Portal登录鉴权凭证，用于应用程序访问个人portal(PC链接跳转至个人Portal页面)
- (void)queryNonceInfoByType:(HWMQueryNonceType)type successCallback:(HWMSDKQueryNonceInfoByTypeSuccessBlock)successCallback failedCallback:(HWMSDKQueryNonceInfoByTypeFailedBlock)failedCallback;

/// [en]This class is about switching to foreground. [cn]切前台
- (HWMSDKERR)switchToForeground;

/// [en]This class is about switching to background. [cn]切后台
- (HWMSDKERR)switchToBackground;

/// [en]This class is about apply obs json config. [cn]应用OBS配置
- (HWMSDKERR)applyObsJsonConfigFromDB;

/// [en]This class is about a synchronous method to get login information. [cn]获取登录信息
- (HWMSDKLoginStateInfoModel *)getLoginStateInfo;

/// [en]This class is about a synchronous method to get enterprise configuration information. [cn]获取企业配置信息
- (HWMSDKCorpConfigParamModel *)getCorpConfigInfo;

/// [en]This class is about querying user information. [cn]查询用户信息 :disable
- (void)queryUserInfoWithParam:(HWMSDKQueryUserInfoParamModel *)param successCallback:(HWMSDKQueryUserInfoSuccessBlock)successCallback failedCallback:(HWMSDKQueryUserInfoFailedBlock)failedCallback;

/// [en]This class is about a synchronous method to get enterprise configuration support waiting room information. [cn]获取企业配置是否支持等候室信息
- (BOOL)getSupportWaitingRoom:(BOOL)isSupportTerminal;

/// [en]This interface is used to cancel download upgrade file. [cn]取消下载升级文件 :disable
- (void)cancelDownloadUpgradeWithSuccessCallback:(HWMSDKCancelDownloadUpgradeSuccessBlock)successCallback failedCallback:(HWMSDKCancelDownloadUpgradeFailedBlock)failedCallback;

/// [en]This interface is used to download upgrade file. [cn]下载升级文件 :disable
- (void)downloadUpgradeFileWithUpgradeInfo:(HWMSDKDownloadUpgradeInfoModel *)upgradeInfo successCallback:(HWMSDKDownloadUpgradeFileSuccessBlock)successCallback failedCallback:(HWMSDKDownloadUpgradeFileFailedBlock)failedCallback;

/// [en]This interface is used to network dial test. [cn]网络拨测
- (HWMSDKERR)netDialTestWithSn:(NSUInteger)sn;

/// [en]This interface is used for network firewall detection. User can judge whether STG traversal is needed. [cn]组网防火墙探测,用户以此判断是否需要使用STG穿越 :disable
- (void)firewallDetectWithSn:(NSUInteger)sn detectServer:(HWMSDKLoginDetectServerModel *)detectServer successCallback:(HWMSDKFirewallDetectSuccessBlock)successCallback failedCallback:(HWMSDKFirewallDetectFailedBlock)failedCallback;

/// [en]This interface is used to query version info. [cn]查询版本信息
- (void)queryVersionInfo:(HWMSDKVersionInfoModel *)versionInfo successCallback:(HWMSDKQueryVersionInfoSuccessBlock)successCallback failedCallback:(HWMSDKQueryVersionInfoFailedBlock)failedCallback;

/// [en]This interface is used to request upload info. [cn]请求上传文件信息 :disable
- (void)requestUploadInfo:(HWMSDKUploadInfoModel *)uploadInfo successCallback:(HWMSDKRequestUploadInfoSuccessBlock)successCallback failedCallback:(HWMSDKRequestUploadInfoFailedBlock)failedCallback;

/// [en]This interface is used to get local device info. [cn]获取本地设备信息 :disable
- (void)getDeviceInfoWithSuccessCallback:(HWMSDKGetDeviceInfoSuccessBlock)successCallback failedCallback:(HWMSDKGetDeviceInfoFailedBlock)failedCallback;

/// [en]This interface is used to maxhub request pair code. [cn]maxhub获取配对码 :disable
- (HWMSDKERR)requestPairCodeWithCodeMode:(NSUInteger)codeMode;

/// [en]This interface is used to close pair. [cn]关闭配对 :disable
- (HWMSDKERR)closePair;

/// [en]This interface is used to handler access token. [cn]处理accessToken :disable
- (HWMSDKERR)handlerAccessToken;

/// [en]This interface is used to set has im in conf. [cn]设置会议是否有im :disable
- (HWMSDKERR)setHasImInConf:(BOOL)hasImInConf;

/// [en]This interface is used to compress and upload file. [cn]压缩并上传文件 :disable
- (void)compressAndUploadFileWithUploadInfo:(HWMSDKCompressAndUploadInfoModel *)uploadInfo successCallback:(HWMSDKCompressAndUploadFileSuccessBlock)successCallback failedCallback:(HWMSDKCompressAndUploadFileFailedBlock)failedCallback;

/// [en]This interface is used to clear cache. [cn]处理accessToken
- (void)clearLoginCache;

/// [en]This interface is get deprecated SDK check info. [cn]获取sdk过期检查信息
- (HWMSDKDeprecatedSDKCheckResultModel *)getDeprecatedSDKCheckInfo;

- (void)cleanLoginByAppIdCallbacks;
- (void)cleanLogoutCallbacks;
- (void)cleanQueryNonceCallbacks;
- (void)cleanQueryNonceInfoByTypeCallbacks;
- (void)cleanQueryUserInfoCallbacks;
- (void)cleanCancelDownloadUpgradeCallbacks;
- (void)cleanDownloadUpgradeFileCallbacks;
- (void)cleanFirewallDetectCallbacks;
- (void)cleanQueryVersionInfoCallbacks;
- (void)cleanRequestUploadInfoCallbacks;
- (void)cleanGetDeviceInfoCallbacks;
- (void)cleanCompressAndUploadFileCallbacks;
@end



NS_ASSUME_NONNULL_END

