//
//  HWMVmrInfoModel.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/14.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMVmrInfoModel : NSObject
/// 会议ID
@property (nonatomic, copy) NSString *confId;

/// vmrID
@property (nonatomic, copy) NSString *vmrId;

/// 主席密码
@property (nonatomic, copy) NSString *chairmanPwd;

/// 来宾密码
@property (nonatomic, copy) NSString *guestPwd;

/// vmr类型
@property (nonatomic, assign) HWMConfIdType type;

/// 专用云会议室最大方数
@property (nonatomic, assign) NSUInteger maxParties;

/// 专用会议室是否可用
@property (nonatomic, assign) BOOL usable;

/// VMR会议名称
@property (nonatomic, copy) NSString *name;

/// 是否允许来宾提前启动会议
@property (nonatomic, assign) BOOL allowGuestStartConf;

/// 允许入会范围
@property (nonatomic, assign) HWMJoinConfRestrictionType confAllowJoinUser;

/// 是否启用等候室
@property (nonatomic, assign) BOOL isOpenWaitingRoom;

@end

NS_ASSUME_NONNULL_END
