﻿/**
 * @file HwmBaseMacroDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] macro define file.
 *        [cn] 通用宏定义文件
 */


#ifndef __HWM_BASE_MACRO_DEF_H__
#define __HWM_BASE_MACRO_DEF_H__

#define HWM_AGENT_NAMESPACE hwmsdkagent
#define BEGIN_HWM_AGENT_NAMESPACE namespace hwmsdkagent {
#define END_HWM_AGENT_NAMESPACE };

#define HWM_MAX_FILE_PATH_LEN                       (512)       /**< [en]Indicates the maximum length of the log path.
                                                                     [cn]文件路径最大长度 */

#define HWM_MAX_DEVICE_NUM                          (32)        /**< [en]Indicates the maximum num of device.
                                                                     [cn]最大设备数 */

#define HWM_INVALID_DEVICE_INDEX                    (0xFFFF)    /**< [en]Indicates the invalid index of device.
                                                                     [cn]无效设备索引 */

#define HWM_MAX_ACCOUNT_LEN                         (128)       /**< [en]Indicates the maximum length of the account.
                                                                     [cn]最大账号长度 */

#define HWM_MAX_PASSWORD_LEN                        (192)       /**< [en]Indicates the maximum length of the password.
                                                                     [cn]最大密码长度 */

#define MAX_TIME_ZONE_LEN                           (32)        /**< [en]Indicates the maximum length of the Indicates time zone.
                                                                     [cn]最大时区字符串长度 */

#define HWM_MAX_CLIENT_VERSION_LEN                  (128)       /**< [en]Indicates the maximum length of the client version.
                                                                     [cn]最大客户端版本长度 */

#define HWM_MAX_APPID_LEN                           (64 + 1)        /**< [en]Indicates the maximum length of app ID.
                                                                     [cn]最大APP ID长度 */

#define HWM_MAX_APPKEY_LEN                          (128)       /**< [en]Indicates the maximum length of app key.
                                                                     [cn]最大APP Key值长度 */

#define HWM_MAX_APPNAME_LEN                         (128)       /**< [en]Indicates the maximum length of app name.
                                                                     [cn]最大APP name长度 */

#define HWM_MAX_APPVERSION_LEN                      (32)        /**< [en]Indicates the maximum length of app version.
                                                                     [cn]最大APP version长度 */

#define HWM_MAX_TICKET_LEN                          (2048)      /**< [en]Indicates the maximum length of ticket.
                                                                     [cn]最大ticket字串长度 */

#define HWM_MAX_TOKEN_LEN                           (256)       /**< [en]Indicates the maximum length of token
                                                                     [cn]最大token长度  */

#define HWM_MAX_JWT_TOKEN_LEN                       (2048)      /**< [en]Indicates the maximum length of jwt token
                                                                     [cn]最大jwt token长度  */

#define HWM_MAX_TENANT_ID_LEN                       (256)       /**< [en]Indicates the maximum length of tenant Id
                                                                     [cn]最大中台租户ID长度  */

#define HWM_MAX_SUBJECT_LEN                         (385)       /**< [en]Indicates the maximum length of conf subject
                                                                     [cn]会议主题最大长度  */

#define HWM_MAX_CONF_PASSWORD_LEN                   (64)        /**< [en]Indicates the maximum length of conf password
                                                                     [cn]最大会议密码长度  */

#define HWM_MAX_CONF_ID_LEN                         (16)        /**< [en]Indicates the maximum length of conference id
                                                                     [cn]最大会议ID长度  */

#define HWM_MAX_CONF_LINK_PREFIX_LEN                (256)       /**< [en]Indicates the maximum length of conference link prefix
                                                                     [cn]最大会议链接前缀长度  */

#define HWM_MAX_CONF_ACCESS_LEN                     (64)        /**< [en]Indicates the maximum length of conference access code
                                                                     [cn]最大会议接入码长度*/

#define HWM_MAX_NUMBER_LEN                          (128)       /**< [en]Indicates the maximum length of the number
                                                                     [cn]最大号码长度  */

#define HWM_MAX_TIME_FORMATE_LEN                    (32)        /**< [en]Indicates the maximum length of format time
                                                                     [cn]最大时间格式长度  */

#define HWM_MAX_GROUP_URI_LEN                       (128)       /**< [en]Indicates the maximum length of uri
                                                                     [cn]最大群组URI长度  */

#define HWM_MAX_EMAIL_LEN                           (255 + 1)   /**< [en]Indicates the maximum length of email
                                                                     [cn]最大email长度  */

#define HWM_MAX_DISPLAY_NAME_LEN                    (256)       /**< [en]Indicates the maximum length of dispaly name
                                                                     [cn]最大显示名称长度  */

#define HWM_MAX_URL_LEN                             (256)       /**< [en]Indicates the maximum length of the common URL.
                                                                     [cn]最大URL长度 */

#define HWM_MAX_NONCE_LEN                           (1024)      /**< [en]Indicates the maximum length of the nonce.
                                                                     [cn]最大Nonce长度 */

#define HWM_MAX_SPEAKER_NUM                         (5)         /**< [en]Indicates the maximum number of speaker
                                                                     [cn]最大发言方数  */

#define HWM_MAX_IP_ADDRESS_LEN                      (64)        /**< [en]Indicates the maximum length of the common URL.
                                                                     [cn]最大IP地址长度 */

#define HWM_MAX_VER_CODE_LEN                        (256)       /**< [en]Indicates the maximum length of the verification code.
                                                                     [cn]最大验证码长度 */

#define HWM_MAX_CORP_ID_LEN                         (64)        /**< [en]Indicates the maximum length of the corp id.
                                                                     [cn]最大企业ID长度 */

#define HWM_MAX_CODEC_DESCRPTION_LEN                (128)       /**< [en]Indicates the maximum length of the codec description.
                                                                     [cn]最大编解码描述长度 */

#define HWM_MAX_FRAME_SIZE_DESCRPTION_LEN           (31)        /**< [en]Indicates the maximum length of the codec description.
                                                                     [cn]最大分辨率描述长度 */

#define HWM_MAX_RECV_SVC_STREAM_NUM                 (24)        /**< [en]Maximum number of xxxxx
                                                                     [cn]最大并发接收SVC流数 */

#define HWM_MAX_SEND_SVC_STREAM_NUM                 (4)         /**< [en]Maximum number of xxxxx
                                                                     [cn]最大并发发送SVC流数 */

#define HWM_MAX_RANDOM_LEN                          (128)       /**< [en]Indicates the maximum length of random
                                                                     [cn]最大随机数字串长度*/

#define HWM_MAX_USERAGENT_LEN                       (256)       /**< [en]Indicates the maximum length of user-agent
                                                                     [cn]最大user-agent字串长度*/

#define HWM_MAX_PROFILE_LEN                         (8)         /**< [en]Indicates the maximum length of profile description
                                                                     [cn]最大profile描述长度*/

#define HWM_MAX_REASON_LEN                          (256)       /**< [en]Indicates the maximum length of reason description
                                                                     [cn]最大原因描述长度*/

#define HWM_MAX_VIEW_MODE_NUM                       (16)        /**< [en]Indicates the maximum num of view mode
                                                                     [cn]最大视图模式数 */

#define HWM_MAX_WND_NUM                             (32)        /**< [en]Indicates the maximum num of window
                                                                     [cn]最大窗口数 */

#define HWM_MAX_SENSITIVE_WORD_LEN                  (2048)      /**< [en]Indicates the maximum length of sensitive word
                                                                     [cn]最大敏感词长度 */

#define HWM_MAX_VMR_ID_LEN                          (128)       /**< [en]Indicates the maximum length of VMR ID
                                                                     [cn]最大VMR ID长度 */

#define HWM_MAX_DEVICE_UUID_LEN                     (256)       /**< [en]Indicates the maximum length of device uuid
                                                                     [cn]最大设备UUID长度 */

#define HWM_MAX_CONF_NUM                            (128)       /**< [en]Indicates the maximum number of conference
                                                                     [cn]最大会议数 */

#define HWM_MAX_SPECIFY_VMR_NUM                     (16)        /**< [en]Indicates the maximum number of specify VMR
                                                                     [cn]最大专用VMR数 */

#define HWM_MAX_ATTENDEE_NUM                        (200)       /**< [en]Indicates the maximum number of attendee, xxxxx
                                                                     [cn]会议中的最大与会者数，当前实际支持最大400，2000为预留扩展 */

#define HWM_MAX_APP_WND_TITLE_LEN                   (512)       /**< [en]Indicates the maximum length of app window title
                                                                     [cn]最大应用程序窗口标题长度  */

#define HWM_MAX_APP_WND_NUM                         (64)        /**< [en]Indicates the maximum number of app window
                                                                     [cn]最大应用程序窗口数 */

#define HWM_MAX_ANNOTATION_NUM                      (1024)      /**< [en]Indicates the maximum number of annotation
                                                                     [cn]最大标注数 */

#define HWM_MAX_PRIVACY_VERSION_LEN                 (256)       /**< [en]Indicates the maximum length of privacy version
                                                                     [cn]隐私申明版本号最大长度 */

#define HWM_MAX_CONFIG_LEN                          (16384)     /**< [en]Indicates the maximum length of the config info.
                                                                     [cn]最大配置信息长度 */

#define HWM_MAX_USER_ID_LEN                         (129)       /**< [en]Indicates the maximum length of the user id.
                                                                     [cn]最大UserId长度 */

#define HWM_MAX_USER_NAME_LEN                       (256)       /**< [en]Indicates the maximum length of the user name.
                                                                     [cn]最大用户名称长度 */

#define HWM_MAX_SIGNATURE_LEN                       (256)       /**< [en]Indicates the maximum length of the signature.
                                                                     [cn]最大签名信息长度 */

#define HWM_APPID_NONCE_LEN                         (64 + 1)    /**< [en]Indicates the length of the nonce.
                                                                     [cn]随机数长度 */

#define HWM_MAX_PHONE_NUM_LEN                       (128)       /**< [en]Indicates the maximum length of the phone.
                                                                     [cn]最大手机号码长度 */

#define HWM_MAX_TIME_ZONE_LEN                       (32)        /**< [en]Indicates the maximum length of time zone.
                                                                     [cn]最大时区长度 */

#define HWM_MAX_VMR_CONF_ID_LEN                     (128)       /**< [en]Indicates the maximum length of vmr conf id.
                                                                     [cn]最大vmr会议id长度 */

#define HWM_MAX_VMR_NAME_LEN                        (384 + 1)   /**< [en]Indicates the maximum length of vmr name.
                                                                     [cn]最大vmr名称长度 */

#define HWM_MAX_ACCESS_NUM_LEN                      (128)       /**< [en]Indicates the maximum length of conf access number.
                                                                     [cn]最大接入码长度 */

#define HWM_MAX_DEPARTMENT_INFO_LEN                 (256)       /**< [en]Indicates the maximum length of department info
                                                                     [cn]部门信息最大长度 */

#define HWM_MAX_CONFID_PREFIX_LEN                   (32)        /**< [en]Indicates the maximum length of prefix of site that belongs to conf id
                                                                     [cn]会议id所属站点的前缀的长度 */

#define HWM_MAX_COUNTRY_CODE_LEN                    (16)        /**< [en]Indicates the maximum length of country code
                                                                     [cn]国家码带+号的最大长度 */

#define HWM_MAX_WATERMARK_CONTENT_LEN               (64)        /**< [en]Indicates the maximum length of watermark content.
                                                                     [cn]最大水印注入内容长度*/

#define MAX_DISPLAY_NAME                            (256)       /**< [en]Indicates the maximum length of device name.
                                                                     [cn]最大设备名称内容长度*/
#define HWM_MAX_HWND_INFO_LIST_LEN                  (128)       /**< [en]Indicates the maximum length of the HwndInfoList.
                                                                     [cn]最大窗口句柄长度 */
#define HWM_MAX_ORG_ID_LENGTH                       (32)        /**< [en]Indicates the maximum length of org
                                                                     [cn]最大企业id长度  */

#define MAX_ACCOUNT_ID_LEN                          (129)       /**< [en]Indicates the maximum number of account id<br>
                                                                     [cn]与会者account id最大长度 */
#define HWM_SSO_URL_LENGTH                          (1024)      /**< [en]Indicates the maximum number of SSO url<br>
                                                                     [cn]SSO鉴权url最大长度 */
#define HWM_MAX_SSO_CODE_LEN                        (1024)      /**< [en]Indicates the maximum number of SSO code<br>
                                                                     [cn]SSO鉴权code最大长度 */
#define HWM_MAX_SSO_DOMAIN_LEN                      (1024)      /**< [en]Indicates the maximum number of SSO domain<br>
                                                                     [cn]SSO鉴权企业域名最大长度 */
#define HWM_MAX_SSO_AUTHSERVERTYPE_LEN              (256)       /**< [en]Indicates the maximum number of SSO auth server type<br>
                                                                     [cn]SSO 鉴权服务类型最大长度 */
#define HWM_MAX_CONF_POINTS_LENGTH                  (128)       /**< [en]Indicates conference points max length.
                                                                     [cn]周期内的会议召开点最大长度。*/
#define HWM_MAX_ACCOUNT_ID_LEN                      (129)       /**< [en]Indicates the maximum number of account id<br>
                                                                     [cn]与会者account id最大长度 */
#define HWM_MAX_CONF_UUID_LEN                       (256)      /**<  [en]Indicates conference uuid.
                                                                     [cn]会议uuid */
#define HWM_MAX_PREFERRED_CAMERA_LEN                (256)      /**<  [en]Indicates the maximum number of preferred camera<br>
                                                                     [cn]优选摄像头列表参数最大长度 */
#define HWM_MAX_CORPID_LEN                          (32)        /**< [en]Indicates the maximum length of corp id.
                                                                     [cn]最大企业ID长度 */
#define HWM_MAX_APP_URL_LEN                         (256)      /**<  [en]Indicates the maximum length of app url
                                                                     [cn]官网下载渠道链接最大长度 */
#define HWM_MAX_BTN_ID_LEN                          (128)       /**< [en]Indicates the maximum length of button id.
                                                                     [cn]最大按钮id长度 */
#define HWM_MAX_MAC_LEN                             (32)        /**< [en]Indicates the maximum length of the MAC address.
                                                                     <br>[cn]MAC地址长度 */
#define HWM_MAX_RAW_DATA_LIBRARY_PATH_LEN           (512)       /**< [en]Indicates the maximum length of raw data library path.
                                                                     [cn]最大端到端加解密函数库目录长度 */
#define HWM_MAX_ENCRYPT_FUNC_NAME_LEN               (128)       /**< [en]Indicates the maximum length of encrypt func name.
                                                                     [cn]最大端到端加解密函数名长度 */
#define HWM_MAX_COUNTRY_LEN                         (256)       /**< [en]Indicates the maximum length of country
                                                                     [cn]国家最大长度 */
#define HWM_MAX_CFG_CLIENT_TYPE_LEN                 (256)       /**< [en]Indicates the maximum length of the client type.
                                                                     [cn]最大客户端类型长度 */
#define HWM_MAX_NAME_LEN                            (256)       /**< [en]Indicates the maximum length of the file or dic name.
                                                                     [cn]最大 文件/文件夹名字 长度 */
#define HWM_MAX_APP_ATTRIBUTE_LEN                   (2048)      /**< [en]Indicates the maximum length of the appServer attribute.
                                                                     [cn]最大 第三方应用信息 长度 */
#define HWM_MAX_EXPIRE_DATE_LEN                     (64)        /**< [en]Indicates the maximum length of the expire date.
                                                                     [cn]最大截止时间长度 */
#define HWM_MAX_CUSTOM_INFO_LEN                     (64)        /**< [en]Indicates the maximum length of User-defined data.
                                                                     [cn]最大自定义数据长度 */
#define HWM_MAX_USERNAME_LEN                        (256)       /**< [en]Indicates the maximum length of the username.
                                                                     [cn]最大用户名长度 */
#define HWM_MAX_VERSION_LEN                         (16)        /**< [en]Indicates the maximum length of the version.
                                                                     [cn]最大版本号长度 */
#define HWM_MAX_DEVICE_ID_LEN                       (128)       /**< [en]Indicates the maximum length of the device id.
                                                                     [cn]最大设备ID长度 */
#define HWM_MAX_OPERATE_SYSTEM_NAME_LEN             (16)        /**< [en]Indicates the maximum length of the operate system name.
                                                                     [cn]最大系统平台名称长度 */
#define HWM_MAX_EVENT_ID_LEN                        (16)        /**< [en]Indicates the maximum length of the event id len.
                                                                     [cn]最大事件id长度 */
#define HWM_MAX_ARG1_LEN                            (256)       /**< [en]Indicates the maximum length of the first argument.
                                                                     [cn]最大第一个字段长度 */
#define HWM_MAX_ARG2_LEN                            (256)       /**< [en]Indicates the maximum length of the second argument.
                                                                     [cn]最大第二个字段长度 */
#define HWM_MAX_ARG3_LEN                            (256)       /**< [en]Indicates the maximum length of the third argument.
                                                                     [cn]最大第三个字段长度 */
#define HWM_MAX_ARG_LEN                             (8192)      /**< [en]Indicates the maximum length of the other argument.
                                                                     [cn]最大其他字段长度 */
#define HWM_MAX_EVENT_NAME_LEN                      (256)       /**< [en]Indicates the maximum length of the event name.
                                                                     [cn]最大事件名称长度 */
#define HWM_MAX_LOCATION_LEN                        (16)        /**< [en]Indicates the maximum location-name length.
                                                                     [cn]最大区域长度，用于自定义语言 */
#define HWM_MAX_READING_TEXT_TITLE_LEN              (32)        /**< [en]Indicates the maximum length of the reading text of voiceprint recording.
                                                                     [cn]最大声纹录入朗读文本标题长度 */
#define HWM_MAX_READING_TEXT_CONTENT_LEN            (256)       /**< [en]Indicates the maximum length of the reading text of voiceprint recording.
                                                                     [cn]最大声纹录入朗读文本内容长度 */
#define HWM_MAX_DOMAIN_LEN                          (256)       /**< [en]Indicates the maximum length of domain
                                                                     [cn]最大域名长度  */
#define HWM_MAX_SUBNAME_LEN                         (128)       /**< [en]Indicates the maximum length of subname
                                                                     [cn]最大问题描述长度  */
#define HWM_MAX_SUBREMARK_LEN                       (256)       /**< [en]Indicates the maximum length of subremark
                                                                     [cn]最大备注长度  */
#define HWM_MAX_PHONE_LEN                           (32)        /**< [en]Indicates the maximum length of the phone.
                                                                     [cn]appID用户手机号码长度 */
#define HWM_MAX_ERROR_MESSAGE_LEN                   (512)       /**< [en]Indicates the maximum length of the error msg.
                                                                     [cn]错误提示语长度 */
#define HWM_MAX_TOAST_CONTENT_LEN                   (128)        /**< [en]Indicates the maximum length of the toast content
                                                                     [cn]最大提示内容长度 */
#define HWM_MAX_PRODUCT_NAME_LEN                    (256)       /**< [en]Indicates the maximum length of the product name.
                                                                     [cn]最大产品名称长度 */
#define HWM_MAX_SOFTWARE_VER_LEN                    (128)       /**< [en]Indicates the maximum length of the software version.
                                                                     [cn]最大软件版本长度 */
#define HWM_MAX_VERSION_DESCRIPTION_LEN             (2048)      /**< [en]Indicates the maximum number of verdion description information length.
                                                                     [cn]版本描述信息最大长度*/
#define HWM_MAX_DOMAIN_LENGTH                       (256)       /**< [en]Indicates the maximum length of domain.
                                                                     [cn]最大域名长度 */
#define HWM_MAX_UPGRADE_VERSION_LEN                 (512)       /**< [en]Indicates the maximum length of upgrade version.
                                                                     [cn]最大可升级版本长度 */
#define HWM_MAX_PAIR_CODE_LEN                       (128)       /**< [en]Indicates the maximum length of pair code
                                                                     [cn]最大配对码长度 */
#define HWM_MAX_VERIFY_CODE_LEN                     (32)        /**< [en]Indicates the maximum length of verify code.
                                                                     [cn]最大验证码长度 */
#define HWM_MAX_ORG_NAME_LEN                        (512)       /**< [en]Indicates the maximum length of the org name.
                                                                     [cn]组织名最大长度 */
#define HWM_MAX_THIRD_USER_INFO_KEY_LENGTH          (64)        /**< [en]Indicates the maximum length of the third user info key.
                                                                     [cn]最大第三方用户信息key长度 */
#define HWM_MAX_OPEN_CUSTOM_PARA_LEN                (2048)      /**< [en]Indicates the maximum length of User-defined extended information.
                                                                     [cn]最大自定义扩展信息长度 */
#define HWM_MAX_RECORD_LIVE_TYPE_LEN                (10)        /**< [en]Indicates the maximum length of record live type len
                                                                     [cn]最大录制类型长度  */
#define HWM_MAX_CIM_GROUP_ID_LEN                    (188)       /**< [en]Indicates the maximum length of group id len
                                                                     [cn]最大聊天群组id最大长度  */
#define HWM_MAX_EXTENDED_FIELD_LEN                  (2048)      /**< [en]Indicates the maximum length of extended field.
                                                                     [cn]最大扩展字段长度 */
#define HWM_MAX_CORP_TRUST_APP_ID_LEN               (512)       /**< [en]Indicates the maximum length of corp trust app id.
                                                                     [cn]企业互信应用ID最大长度 */
#define HWM_MAX_CUSTOM_CONTENT_LEN                  (512)       /**< [en]Indicates the maximum length of custom content.
                                                                     [cn]最大自定义内容长度 */
#define HWM_MAX_GURARTEENED_IP_ADDRESS_LEN          (512)       /**< [en]Indicates the maximum length of the guarateened IP address.
                                                                     [cn]最大保底IP地址长度 */
#define HWM_MAX_COLOR_LEN                           (64)        /**< [en]Indicates the maximum length of color.
                                                                     [cn]最大颜色长度 */
#define HWM_MAX_SUBTITLE_LEN                        (2048)      /**< [en]Indicates the maximum length of subtitle.
                                                                     [cn]最大字幕长度 */
#define HWM_MAX_MSG_ID_LEN                          (64)        /**< [en]Indicates the maximum length of message id.
                                                                     [cn]消息ID最大长度 */
#endif /* __HWM_BASE_MACRO_DEF_H__ */


