﻿/**
 * @file HwmPrivateUISdkDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] define file.
 *        [cn] 结构体、枚举定义文件
 */

#ifndef _HWM_PRIVATE_UISDK_DEF_H_
#define _HWM_PRIVATE_UISDK_DEF_H_

#include "HwmUISdkDef.h"

BEGIN_HWM_UISDK_NAMESPACE

/**
* [en]Init info.
* [cn]初始化信息
* @win:disable
*/
typedef struct tagHwmInitPrivateInfo
{
    HWM_CHAR exePath[HWM_MAX_FILE_PATH_LEN];                   /**< [en]The path of the exe file
                                                                    [cn]执行文件路径 
                                                                    [mac:disable] */
    HWM_CHAR logPath[HWM_MAX_FILE_PATH_LEN];                   /**< [en]The path of the log file
                                                                    [cn]日志文件路径 */
    HWM_CHAR userDataPath[HWM_MAX_FILE_PATH_LEN];              /**< [en]The path of the user data file
                                                                    [cn]用户数据文件路径 
                                                                    [mac:todo] */
    HWM_CHAR appId[HWM_MAX_APPID_LEN];                         /**< [en]The app identity
                                                                    [cn]应用程序的唯一标识 */
    HwmSiteType siteType;                                      /**< [en]The site type
                                                                    [cn]站点类型 */
    HWM_UINT32 logKeepDays;                                    /**< [en]Indicates the log keeping days.
                                                                    [cn]配置项-日志保存天数，0为不按天数删除日志，非0情况范围3-30 */
    HWM_CHAR preferredCamera[HWM_MAX_PREFERRED_CAMERA_LEN];    /**< [en]preferred camera
                                                                    [cn]优选摄像头列表，填写后，初次打开摄像头按列表中的顺序选择第一个可用的摄像头。
                                                                        可以不填，不填按照默认顺序打开可用的摄像头
                                                                    [mac:disable] */
    HWM_CHAR appUrl[HWM_MAX_APP_URL_LEN];                      /**< [en]todo
                                                                    [cn]官网下载渠道链接
                                                                    [win:disable] */
    HWM_BOOL showMeetingAssistant;                             /**< [en]Indicates whether show meeting assistant
                                                                    [cn]是否显示会议助手*/
	HWM_BOOL enableFeedback;                                   /**< [en]Indicates whether show feedBack
                                                                    [cn]是否显示反馈*/	
	HWM_BOOL showNewFeatureLabel;                              /**< [en]Indicates whether show new feature label
                                                                    [cn]是否显示新特性”new“标签*/
    HWM_BOOL enableViewContactDetail;                          /**< [en]Indicates whether show contact detail
                                                                    [cn]会场列表等地方是否显示查看详情*/	
	HWM_BOOL showChangeNameForFutureUse;                       /**< [en]Indicates whether show change name for future use
                                                                    [cn]是否显示 "会中改名，在以后的会与中使用此名字"*/	
    HWM_CHAR cfgClientType[HWM_MAX_CFG_CLIENT_TYPE_LEN];       /**< [en]Indicates type of client.
                                                                    [cn]客户端类型, 上层传入的客户端类型字符串 
                                                                    [win:disable]*/
    HWM_BOOL isHUDWindowStyle;                                 /**< [en]Indicates window style is HUD.
                                                                    [cn]窗口是否为HUD模式 
                                                                    [win:disable]*/
}HwmInitPrivateInfo;

END_HWM_UISDK_NAMESPACE

#endif /* _HWM_PRIVATE_UISDK_DEF_H_ */
