﻿/**
 * @file HwmUISDKCallServiceDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] define file.
 *        [cn] 结构体、枚举定义文件
 */

#ifndef _HWM_UISDK_CALL_SERVICE_DEF_H_
#define _HWM_UISDK_CALL_SERVICE_DEF_H_

#include "HwmUISdkCommonDef.h"
#include "HwmBaseMacroDef.h"
#include "HwmUISdkConfServiceDef.h"

BEGIN_HWM_UISDK_NAMESPACE

/**
* [en]Call state
* [cn]通话状态
*/
typedef enum tagHwmCallState
{
    HWM_CALL_STATE_IDLE,                /**< [en]Idle state
                                             [cn]空闲状态 */
    HWM_CALL_STATE_BUSY,                /**< [en]Busy state
                                             [cn]忙碌状态 */
} HwmCallState;

/**
* [en]Call state info.
* [cn]通话状态信息
*/
typedef struct tagHwmCallStateInfo
{
    HwmCallState state;             /**< [en]Call state
                                         [cn]通话状态 */
}HwmCallStateInfo;

/**
* [en]Caller info
* [cn]主叫信息
*/
typedef struct tagHwmCallerInfo
{
    HWM_CHAR nickName[HWM_MAX_DISPLAY_NAME_LEN];                    /**< [en]Caller nickName
                                                                         [cn]主叫姓名
                                                                         [cs_allowNull:Y] */
    HWM_CHAR aliasCN[HWM_MAX_DISPLAY_NAME_LEN];                     /**< [en]Indicates chinese alias.
                                                                         [cn]中文别名（获取会中与会者信息使用）
                                                                         [cs_allowNull:Y][doc:disable] */
    HWM_CHAR aliasEN[HWM_MAX_DISPLAY_NAME_LEN];                     /**< [en]Indicates english alias.
                                                                         [cn]英文别名（获取会中与会者信息使用）
                                                                         [cs_allowNull:Y][doc:disable] */
    HWM_CHAR extendedField[HWM_MAX_EXTENDED_FIELD_LEN];             /**< [en]Indicates extended field.
                                                                         [cn]扩展字段
                                                                         [cs_allowNull:Y][doc:disable] */
} HwmCallerInfo;

/**
* [en]Callee info
* [cn]被叫信息
*/
typedef struct tagHwmCalleeInfo
{
    HWM_CHAR nickName[HWM_MAX_DISPLAY_NAME_LEN];                    /**< [en]Callee nickName
                                                                         [cn]被叫姓名
                                                                         [cs_allowNull:Y] */
    HWM_CHAR aliasCN[HWM_MAX_DISPLAY_NAME_LEN];                     /**< [en]Indicates chinese alias.
                                                                         [cn]中文别名（获取会中与会者信息使用）
                                                                         [cs_allowNull:Y][doc:disable] */
    HWM_CHAR aliasEN[HWM_MAX_DISPLAY_NAME_LEN];                     /**< [en]Indicates english alias.
                                                                         [cn]英文别名（获取会中与会者信息使用）
                                                                         [cs_allowNull:Y][doc:disable] */
    HWM_CHAR extendedField[HWM_MAX_EXTENDED_FIELD_LEN];             /**< [en]Indicates extended field.
                                                                         [cn]扩展字段
                                                                         [cs_allowNull:Y][doc:disable] */
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];                            /**< [en]Callee number
                                                                         [cn]被叫号码，如果填分配给账号的sip号码（如+99111244216210249）则呼叫该账号的App；
                                                                             如果填PSTN号码（如18700000000），则通过VoIP网关呼叫该号码，前提是该企业已开通PSTN呼叫权限。
                                                                             与thirdUserId二选一（优先级 : number>thirdUserId），账号密码鉴权时使用。
                                                                         [cs_allowNull:N] */
    HWM_CHAR thirdUserId[HWM_MAX_USER_ID_LEN];                      /**< [en]Callee third account
                                                                         [cn]被叫三方账号，与number二选一（优先级 : number>thirdUserId），appId鉴权时使用
                                                                         [cs_allowNull:N] */
    HWM_CHAR userUuid[HWM_MAX_ACCOUNT_ID_LEN];                      /**< [en]Indicates the uuid.
                                                                         [cn]与会者uuid
                                                                         [cs_allowNull:Y] */
    HwmAttendeeType type;                                           /**< [en]Indicates the attendee type(只有Normal和Mobile有效)
                                                                         [cn]成员类型 
                                                                         [cs_allowNull:Y] */
    HWM_CHAR corpId[HWM_MAX_ORG_ID_LENGTH];                         /**< [en]Indicates corp id.
                                                                         [cn]企业id */
} HwmCalleeInfo;

/**
* [en]Start call info
* [cn]发起呼叫信息
*/
typedef struct tagHwmStartCallInfo
{
    HwmCallerInfo callerInfo;                               /**< [en]caller info
                                                                 [cn]主叫信息
                                                                 [cs_allowNull:N] */
    HwmCalleeInfo calleeInfo;                               /**< [en]callee info
                                                                 [cn]被叫信息
                                                                 [cs_allowNull:N] */
    HwmMediaType mediaType;                                 /**< [en]Media type
                                                                 [cn]媒体类型
                                                                 [cs_allowNull:N] */
    HWM_BOOL isGuestJoinConfWithoutPwd;                     /**< [en]Indicates whether the guest joins the conference without password
                                                                 [cn]是否来宾免密
                                                                 [cs_allowNull:Y] */
    HwmConfAllowJoinUserType confAllowJoinUser;             /**< [en]Indicates the user type allowed to join the conference.
                                                                 [cn]允许入会范围限制。默认所有用户。
                                                                 [cs_allowNull:Y] */
    HWM_CHAR customInfo[HWM_MAX_CUSTOM_INFO_LEN];           /**< [en]Indicates User-defined data on the device side attribute.
                                                                 [cn]可选，端侧自定义数据，服务器不感知业务
                                                                 [cs_allowNull:Y] */
} HwmStartCallInfo;

/**
* [en]Call information
* [cn]通话信息
*/
typedef struct tagHwmCallInfo
{
    HwmMediaType mediaType;                              /**< [en]Media type
                                                              [cn]媒体类型 */
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];                 /**< [en]Other party number
                                                              [cn]对方号码 */
    HWM_CHAR nickName[HWM_MAX_USER_NAME_LEN];            /**< [en]Other party nickName
                                                              [cn]对方名称 */
    HWM_CHAR startTime[HWM_MAX_TIME_FORMATE_LEN];        /**< [en]Start call time
                                                              [cn]呼叫开始时间 */
    HWM_CHAR endTime[HWM_MAX_TIME_FORMATE_LEN];          /**< [en]End call time(is null before call end)
                                                              [cn]呼叫结束时间（通话结束前为空）*/
    HWM_BOOL isCallOut;                                  /**< [en]Is initiative call out
                                                              [cn]是否为主动呼出 */
}HwmCallInfo;

/**
* [en]Call coming information.
* [cn]呼叫来电信息
*/
typedef struct tagHwmCallIncomingInfo
{
    HwmMediaType mediaType;                              /**< [en]Media type
                                                              [cn]媒体类型 */
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];                 /**< [en]caller number
                                                              [cn]来电者号码 */
    HWM_CHAR nickName[HWM_MAX_USER_NAME_LEN];            /**< [en]caller name
                                                              [cn]来电者姓名 */
} HwmCallIncomingInfo;

/**
* [en]Call end reason.
* [cn]通话结束原因
*/
typedef enum tagHwmCallEndReason
{
    HWM_CALL_END_REASON_CONNECTED_HANGUP_BY_CALLER = 1,      /**< [en]Hangup by caller(connected)
                                                                  [cn]主叫挂断（接通）*/
    HWM_CALL_END_REASON_CONNECTED_HANGUP_BY_CALLEE,          /**< [en]Hangup by callee(connected)
                                                                  [cn]被叫挂断（接通）*/
    HWM_CALL_END_REASON_HANGUP_BY_CALLER,                    /**< [en]Hangup by caller(unconnected)
                                                                  [cn]主叫挂断（未接通） */
    HWM_CALL_END_REASON_HANGUP_BY_CALLEE,                    /**< [en]Hangup by callee(unconnected)
                                                                  [cn]被叫挂断（未接通） */
    HWM_CALL_END_REASON_CALLEE_BUSY,                         /**< [en]Callee is busy(unconnected)
                                                                  [cn]被叫通话中（未接通） */
    HWM_CALL_END_REASON_CALLEE_ANSWER_TIMEOUT,               /**< [en]Callee no answer(unconnected)
                                                                  [cn]被叫超时未接听（未接通） */
    HWM_CALL_END_REASON_CALLEE_NUMBER_ERROR,                 /**< [en]Callee number error(unconnected)
                                                                  [cn]被叫号码错误（未接通） */
    HWM_CALL_END_REASON_FAILED,                              /**< [en]Call fail
                                                                  [cn]通话失败 */
} HwmCallEndReason;

/**
* [en]Call record information(after call end)
* [cn]通话记录信息(通话结束后上报)
*/
typedef struct tagHwmCallRecordInfo
{
    HwmCallInfo callInfo;                            /**< [en]Call information
                                                          [cn]呼叫信息 */
    HwmCallEndReason reason;                         /**< [en]Call end reason
                                                          [cn]呼叫结束原因 */
} HwmCallRecordInfo;

END_HWM_UISDK_NAMESPACE

#endif /* _HWM_UISDK_CALL_SERVICE_DEF_H_ */
