﻿/**
 * @file HwmUISDKCommonDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] common define file.
 *        [cn] 通用定义文件
 */


#ifndef __HWM_UISDK_COMMON_DEF_H__
#define __HWM_UISDK_COMMON_DEF_H__

#define HWM_UISDK_NAMESPACE hwmuisdk
#define BEGIN_HWM_UISDK_NAMESPACE namespace hwmuisdk {
#define END_HWM_UISDK_NAMESPACE };

#include <stdint.h>
#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

#ifdef HWM_API
#undef HWM_API
#endif

#ifdef HWM_EXPORT
#define HWM_API __declspec(dllexport)
#else
#define HWM_API __declspec(dllimport)
#endif

#ifdef __LP64__
    typedef long long HWM_PTR;
    typedef uint64_t HWM_UPTR;
    typedef unsigned long HWM_SIZE;
#else
    typedef int HWM_PTR;
    typedef unsigned int HWM_UPTR;
    typedef unsigned int HWM_SIZE;
#endif

#ifndef HWM_TRUE
#define HWM_TRUE 1
#endif

#ifndef HWM_FALSE
#define HWM_FALSE 0
#endif

    typedef void                    HWM_VOID;
    typedef unsigned char           HWM_UCHAR;
    typedef char                    HWM_CHAR;
    typedef unsigned char           HWM_UINT8;
    typedef char                    HWM_INT8;

    typedef unsigned short          HWM_UINT16;
    typedef signed short            HWM_INT16;

    typedef unsigned int            HWM_UINT32;
    typedef signed int              HWM_INT32;
    //typedef unsigned int            HWM_UINT;     

    typedef uint64_t                HWM_UINT64;
    typedef int64_t                 HWM_INT64;
    typedef unsigned long           HWM_ULONG;
    typedef signed long             HWM_LONG;

    typedef float                   HWM_FLOAT;

    typedef HWM_UINT32              HWM_BOOL;

    typedef HWM_UPTR                HWM_HWND;
    typedef HWM_INT32               HWM_RESULT;

#if defined (OS_WIN32) || (WIN32)
    typedef wchar_t                 HWM_WCHAR;
#else 
    typedef char                    HWM_WCHAR;
#endif

#ifndef IN
#define IN
#endif

#ifndef OUT
#define OUT
#endif

#ifndef IO
#define IO
#endif


#ifndef FALSE
#define FALSE           false
#endif

#ifndef TRUE
#define TRUE            true
#endif


#define HWM_NULL_PTR   (0)
#define HWM_SUCCESS    (0)
#define HWM_FAIL       (1)

#ifndef HWM_UINT32_MAX
#define HWM_UINT32_MAX (0xFFFFFFFF)
#endif


#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

BEGIN_HWM_UISDK_NAMESPACE

/**
* [en]Media type.
* [cn]媒体类型
*/
typedef enum tagHwmMediaType
{
    HWM_MEDIA_TYPE_AUDIO,           /**< [en]Audio type
                                         [cn]音频类型 */
    HWM_MEDIA_TYPE_VIDEO,           /**< [en]Video type
                                         [cn]视频类型 */

    HWM_MEDIA_TYPE_BUTT
} HwmMediaType;

/**
* [en]Device type.
* [cn]设备类型
*/
typedef enum tagHwmDeviceType
{
    HWM_DEVICE_TYPE_MIC,                                    /**< [en]Indicates microphone device
                                                                 [cn]麦克风设备 */
    HWM_DEVICE_TYPE_SPEAKER,                                /**< [en]Indicates Speaker device
                                                                 [cn]扬声器设备 */
    HWM_DEVICE_TYPE_CAMERA,                                 /**< [en]Indicates Camera device
                                                                 [cn]视频设备 */
} HwmDeviceType;

/**
* [en]Language type.
* [cn]语言类型
*/
typedef enum tagHwmLanguage
{
    HWM_LANGUAGE_ZH_CN,             /**< [en]zh-CN
                                         [cn]中文 */
    HWM_LANGUAGE_EN_GB,             /**< [en]en-GB
                                         [cn]英文 */
    HWM_LANGUAGE_CUSTOMIZED,        /**< [en]Customized
                                         [cn]自定义语言 */

    HWM_LANGUAGE_BUTT

} HwmLanguage;

/**
* [en]State.
* [cn]状态类型
*/
typedef enum tagHwmState
{
    HWM_STATE_OFF,         /**< [en]Off state
                           [cn]关闭状态 */
    HWM_STATE_ON,          /**< [en]On state
                           [cn]开启状态 */

    HWM_STATE_BUTT
} HwmState;

/**
* [en]Stop share reason.
* [cn]停止共享原因
*/
typedef enum tagHwmStopShareReason
{
    HWM_STOP_SHARE_BY_NORMAL,           /**< [en]Stop sharing normally
                                             [cn]正常停止共享 */
    HWM_STOP_SHARE_BY_REJOIN_CONF       /**< [en]MMR transfer
                                             [cn]MMR迁移 */
} HwmStopShareReason;

END_HWM_UISDK_NAMESPACE

#endif /* __HWM_UISDK_COMMON_DEF_H__ */


