import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class AddAttendee extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      attendees: '',
      attendeesExample: '[{"nickName":"店小二","aliasCN":"汤姆","aliasEN":"tom","number":"15211111111","thirdUserId":"","accountId":"","corpId":"","type":0}]',
    }
  }

  componentDidMount () {
    const { attendeesExample } = this.state

    this.setState({
      attendees: attendeesExample,
    })
  }

  changeAttendees (e) {
    this.setState({
      attendees: e.target.value,
    })
  }

  async goToAddAttendee () {
    const { attendees } = this.state
    const _attendees = attendees ? JSON.parse(attendees) : ''
    const param = {
      attendees: _attendees,
    }
    const apiService = new ApiService()
    const setResult = await apiService.addAttendee(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
            <div className="addAttendee">
                <div className="input-box-long">
                    <div className="input-box-title-long">Attendees:</div>
                    <div className="input-box-text"><textarea className='attendees-textarea' value={this.state.attendees} onChange={this.changeAttendees.bind(this)} placeholder={this.state.attendeesExample} /></div>
                </div>
                <button onClick={this.goToAddAttendee.bind(this)}>Submit</button>
                <button onClick={this.goBack.bind(this)}>Back</button>
            </div>
    )
  }
}

export default AddAttendee
