import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class OpenWaitingRoom extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      isOpen: false,
    }
  }

  changeisOpen (e) {
    this.setState({
      isOpen: e.target.checked,
    })
  }

  async goOpenWaitingRoom () {
    const { isOpen } = this.state
    const apiService = new ApiService()
    const setResult = await apiService.openWaitingRoom(isOpen)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
            <div className="area">
                 <div className="input-box">
                    <div className="input-box-title-check">Is Open:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={this.state.isOpen} onChange={this.changeisOpen.bind(this)} /></div>
                </div>
                <button onClick={this.goOpenWaitingRoom.bind(this)}>Submit</button>
                <button onClick={this.goBack.bind(this)}>Back</button>
            </div>
    )
  }
}

export default OpenWaitingRoom
