import React from 'react'
import './index.css'
import ApiService from '../../../AppService/ApiService'
import { SiteType } from '../../../Constants/enum'
import { DEMOCONFIG } from '../../../demoConfig.js'

const SiteTypeOptions = [
  {
    value: SiteType.HWM_SITE_TYPE_CHINA,
    label: 'Chinese mainland',
  },
  {
    value: SiteType.HWM_SITE_TYPE_AP,
    label: 'International',
  },
]

class Init extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      appId: DEMOCONFIG.DEFAULT_APPID, // 请替换成真实申请的App ID，申请步骤请参考“https://support.huaweicloud.com/devg-meeting/meeting_20_0011.html”
      exePath: '',
      logPath: '',
      userDataPath: '',
      siteType: SiteType.HWM_SITE_TYPE_CHINA,
      logKeepDays: 0,
      preferredCamera: '',
      appUrl: '',
      appVersion: '',
      isSupportMultiAppLogin: false,
    }
  }

  componentDidMount () {
    const _siteType = window.sessionStorage.getItem('site_type')
    if (_siteType) {
      this.setState({
        siteType: Number(_siteType),
      })
    }
  }

  changeAppId (e) {
    this.setState({
      appId: e.target.value,
    })
  }

  changePreferredCamera (e) {
    this.setState({
      preferredCamera: e.target.value,
    })
  }

  changeAppVersion (e) {
    this.setState({
      appVersion: e.target.value,
    })
  }

  changeSupportMultiAppLogin (e) {
    this.setState({
      isSupportMultiAppLogin: e.target.checked,
    })
  }

  changeExePath (e) {
    this.setState({
      exePath: e.target.value,
    })
  }

  changeLogPath (e) {
    this.setState({
      logPath: e.target.value,
    })
  }

  changeUserDataPath (e) {
    this.setState({
      userDataPath: e.target.value,
    })
  }

  changeSiteType (e) {
    this.setState({
      siteType: Number(e.target.value),
    })
  }

  changeLogKeepDays (e) {
    this.setState({
      logKeepDays: Number(e.target.value),
    })
  }

  changeAppUrl (e) {
    this.setState({
      appUrl: e.target.value,
    })
  }

  async goToInit () {
    const { appId, exePath, logPath, userDataPath, siteType, preferredCamera, appUrl, logKeepDays, appVersion, isSupportMultiAppLogin } = this.state
    const param = {
      exePath,
      logPath,
      userDataPath,
      appId,
      siteType,
      logKeepDays,
      preferredCamera,
      appUrl,
      appVersion,
      isSupportMultiAppLogin,
    }
    const apiService = new ApiService()
    const setResult = await apiService.init(param)
    window.sessionStorage.setItem('site_type', this.state.siteType)
    if (setResult !== 0) {
      window.electron.ipcRenderer.send('show-error-alert', 'init error = ' + setResult)
    } else {
      this.goBack()
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="init">
        {
          (window.process.platform === 'win32' && window.process.arch === 'x64')
            ? <div className="input-box">
              <div className="input-box-title">ExePath:</div>
              <div className="input-box-text"><input value={this.state.exePath} onChange={this.changeExePath.bind(this)} /></div>
            </div>
            : null
        }
        <div className="input-box">
          <div className="input-box-title">SiteType:</div>
          <div className="input-box-text">
            <select value={this.state.siteType} onChange={this.changeSiteType.bind(this)}>
              {SiteTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">AppId:</div>
          <div className="input-box-text"><input value={this.state.appId} onChange={this.changeAppId.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">LogPath:</div>
          <div className="input-box-text"><input value={this.state.logPath} onChange={this.changeLogPath.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">UserDataPath:</div>
          <div className="input-box-text"><input value={this.state.userDataPath} onChange={this.changeUserDataPath.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">LogKeepDays:</div>
          <div className="input-box-text"><input value={this.state.logKeepDays} onChange={this.changeLogKeepDays.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">AppUrl:</div>
          <div className="input-box-text"><input value={this.state.appUrl} onChange={this.changeAppUrl.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">AppVersion:</div>
          <div className="input-box-text"><input value={this.state.appVersion} onChange={this.changeAppVersion.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Preferred Camera:</div>
          <div className="input-box-text"><input value={this.state.preferredCamera} onChange={this.changePreferredCamera.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">Support Multi App Login:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.isSupportMultiAppLogin} onChange={this.changeSupportMultiAppLogin.bind(this)} /></div>
        </div>
        <button onClick={this.goToInit.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default Init
