import React from 'react'
import './index.less'
import ApiService from '../../../AppService/ApiService'
import { showErrorTips } from '../../../utils'
import { UICustomTextScene, Language } from '../../../Constants/enum'

const SceneTypeOptions = [
  {
    value: UICustomTextScene.CLOUD_RECORD_FINISHED_ALERT_SCENE,
    label: 'END CLOUD RECORD',
  },
]

class SetCustomUIText extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      sceneType: UICustomTextScene.CLOUD_RECORD_FINISHED_ALERT_SCENE,
      textCN: '',
      isUsedCN: false,
      textEN: '',
      isUsedEN: false,
      textCU: '',
      textCUCode: '',
      isUsedCU: false,
    }
  }

  changeSceneType (e) {
    this.setState({
      sceneType: e.target.value,
    })
  }

  changeUsedChinese (e) {
    this.setState({
      isUsedCN: e.target.checked,
    })
  }

  changeChinese (e) {
    this.setState({
      textCN: e.target.value,
    })
  }

  changeEnglish (e) {
    this.setState({
      textEN: e.target.value,
    })
  }

  changeUsedEnglish (e) {
    this.setState({
      isUsedEN: e.target.checked,
    })
  }

  changeCustomized (e) {
    this.setState({
      textCU: e.target.value,
    })
  }

  changeCustomizedCode (e) {
    this.setState({
      textCUCode: e.target.value,
    })
  }

  changeUsedCustomized (e) {
    this.setState({
      isUsedCU: e.target.checked,
    })
  }

  async setCustomUIText () {
    const { sceneType, isUsedCN, textCN, isUsedEN, textEN, isUsedCU, textCU, textCUCode } = this.state
    const sceneTextList = []
    if (isUsedCN) {
      sceneTextList.push({
        languageType: Language.HWM_LANGUAGE_ZH_CN,
        languageCode: '',
        customText: textCN,
      })
    }
    if (isUsedEN) {
      sceneTextList.push({
        languageType: Language.HWM_LANGUAGE_EN_GB,
        languageCode: '',
        customText: textEN,
      })
    }
    if (isUsedCU) {
      sceneTextList.push({
        languageType: Language.HWM_LANGUAGE_CUSTOMIZED,
        languageCode: textCUCode,
        customText: textCU,
      })
    }
    const apiService = new ApiService()
    const setResult = await apiService.setCustomUIText({
      customSceneTextInfoList: [
        { scene: sceneType, sceneTextList },
      ],
    })
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reson)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="setCustomUIText">
        <div className="input-box-scene">
          <div className="input-box-title">SceneType:</div>
          <div className="input-box-text">
            <select value={this.state.sceneType} onChange={this.changeSceneType.bind(this)}>
              {SceneTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-text-check">
            <input className="input-box-text-checkbox" type="checkbox" checked={this.state.isUsedCN} onChange={this.changeUsedChinese.bind(this)} />
          </div>
          <div className="input-box-title">ChineseText:</div>
          <div className="input-box-text"><input value={this.state.textCN} onChange={this.changeChinese.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-text-check">
            <input className="input-box-text-checkbox" type="checkbox" checked={this.state.isUsedEN} onChange={this.changeUsedEnglish.bind(this)} />
          </div>
          <div className="input-box-title">EnglishText:</div>
          <div className="input-box-text"><input value={this.state.textEN} onChange={this.changeEnglish.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">CustomizedCode:</div>
          <div className="input-box-text"><input value={this.state.textCUCode} onChange={this.changeCustomizedCode.bind(this)} /></div>
          <div className="input-box-text-check">
            <input className="input-box-text-checkbox" type="checkbox" checked={this.state.isUsedCU} onChange={this.changeUsedCustomized.bind(this)} />
          </div>
          <div className="input-box-title">CustomizedText:</div>
          <div className="input-box-text"><input value={this.state.textCU} onChange={this.changeCustomized.bind(this)} /></div>
        </div>
        <button onClick={this.setCustomUIText.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetCustomUIText
